/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.util;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.util.Util;

public class CompilerUtils {
    public static final int IsGrails = 1;
    public static final int InvokeDynamic = 2;
    private static final Map<IClasspathEntry[], String> CLASSPATH_CACHE = new WeakHashMap<IClasspathEntry[], String>();

    public static void configureOptionsBasedOnNature(CompilerOptions compilerOptions, IJavaProject javaProject) {
        if (javaProject == null) {
            compilerOptions.buildGroovyFiles = 1;
            compilerOptions.groovyFlags = 0;
            return;
        }
        IProject project = javaProject.getProject();
        try {
            if (CompilerUtils.isGroovyNaturedProject(project)) {
                compilerOptions.storeAnnotations = true;
                compilerOptions.buildGroovyFiles = 2;
                CompilerUtils.setGroovyClasspath(compilerOptions, javaProject);
                compilerOptions.groovyFlags = CompilerUtils.isProbablyGrailsProject(project) ? 1 : 0;
            } else {
                compilerOptions.buildGroovyFiles = 1;
                compilerOptions.groovyFlags = 0;
            }
        }
        catch (CoreException e) {
            compilerOptions.buildGroovyFiles = 1;
            compilerOptions.groovyFlags = 0;
        }
    }

    public static void configureOptionsBasedOnNature(Map<String, String> optionMap, IJavaProject javaProject) {
        try {
            IProject project = javaProject.getProject();
            if (CompilerUtils.isGroovyNaturedProject(project)) {
                optionMap.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "enabled");
                CompilerUtils.setGroovyClasspath(optionMap, javaProject);
                if (CompilerUtils.isProbablyGrailsProject(project)) {
                    optionMap.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", Integer.toString(1));
                } else {
                    optionMap.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", "0");
                }
            } else {
                optionMap.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "disabled");
                optionMap.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", "0");
            }
        }
        catch (CoreException e) {
            Util.log(e, "configureOptionsBasedOnNature failed");
            optionMap.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "disabled");
            optionMap.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", "0");
        }
    }

    private static boolean isProbablyGrailsProject(IProject project) {
        try {
            IFolder folder = project.getFolder("grails-app");
            return folder.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setGroovyClasspath(CompilerOptions compilerOptions, IJavaProject javaProject) {
        HashMap<String, String> newOptions = new HashMap<String, String>();
        CompilerUtils.setGroovyClasspath(newOptions, javaProject);
        compilerOptions.groovyProjectName = javaProject.getProject().getName();
        if (!newOptions.isEmpty()) {
            compilerOptions.set(newOptions);
        }
    }

    public static void setGroovyClasspath(Map<String, String> optionMap, IJavaProject javaProject) {
        IFile file = javaProject.getProject().getFile("groovy.properties");
        if (file.exists()) {
            try {
                PropertyResourceBundle prb = new PropertyResourceBundle(file.getContents());
                for (String k : prb.keySet()) {
                    String v = CompilerUtils.fixup(prb.getString(k), javaProject);
                    if (!k.equals("org.eclipse.jdt.core.compiler.groovy.groovyClassLoaderPath")) continue;
                    optionMap.put("org.eclipse.jdt.core.compiler.groovy.groovyClassLoaderPath", v);
                }
            }
            catch (Throwable t) {
                Util.log(t, "configuring groovy classloader classpath failed");
            }
        } else {
            try {
                String classpath = CompilerUtils.calculateClasspath(javaProject);
                optionMap.put("org.eclipse.jdt.core.compiler.groovy.groovyClassLoaderPath", classpath);
            }
            catch (Throwable t) {
                Util.log(t, "configuring groovy classloader classpath (not using groovy.properties) failed");
            }
        }
        IProject project = javaProject.getProject();
        try {
            IPath defaultOutputPath = javaProject.getOutputLocation();
            String defaultOutputLocation = CompilerUtils.pathToString(defaultOutputPath, project);
            optionMap.put("org.eclipse.jdt.core.compiler.groovy.groovyServiceScanExclude", defaultOutputLocation);
        }
        catch (Throwable t) {
            Util.log(t, "configuring exclude global AST scan failed");
        }
        optionMap.put("org.eclipse.jdt.core.compiler.groovy.groovyProjectName", project.getName());
    }

    private static String fixup(String someString, IJavaProject javaProject) {
        if (someString.startsWith("%projhome%")) {
            someString = String.valueOf(javaProject.getProject().getLocation().toOSString()) + File.separator + someString.substring("%projhome%".length());
        }
        if (someString.equals("%projclasspath%")) {
            someString = CompilerUtils.calculateClasspath(javaProject);
        }
        return someString;
    }

    private static boolean isGroovyNaturedProject(IProject project) throws CoreException {
        return project.hasNature("org.eclipse.jdt.groovy.core.groovyNature");
    }

    public static String calculateClasspath(IJavaProject javaProject) {
        String classpath;
        block20: {
            classpath = null;
            IProject project = javaProject.getProject();
            String projectName = project.getName();
            try {
                IClasspathEntry[] cpes = javaProject.getResolvedClasspath(true);
                if (cpes == null || (classpath = CLASSPATH_CACHE.get(cpes)) != null) break block20;
                LinkedHashSet<String> accumulatedPathEntries = new LinkedHashSet<String>();
                IClasspathEntry[] iClasspathEntryArray = cpes;
                int n = cpes.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry cpe = iClasspathEntryArray[n2];
                    if (cpe.getEntryKind() != 3) {
                        IPath cpePath = cpe.getPath();
                        String pathElement = null;
                        String segmentZero = cpePath.segment(0);
                        if (segmentZero.equals(projectName)) {
                            pathElement = project.getFile(cpePath.removeFirstSegments(1)).getRawLocation().toOSString();
                        } else {
                            if (cpe.getEntryKind() == 1) {
                                try {
                                    IProject iproject = project.getWorkspace().getRoot().getProject(segmentZero);
                                    if (iproject != null) {
                                        IFile ifile = iproject.getFile(cpePath.removeFirstSegments(1));
                                        IPath ipath = ifile == null ? null : ifile.getRawLocation();
                                        pathElement = ipath == null ? null : ipath.toOSString();
                                    }
                                }
                                catch (Throwable t) {
                                    Util.log(t, "getting library path failed");
                                }
                            }
                            if (cpe.getEntryKind() == 2) {
                                CompilerUtils.computeDependenciesFromProject(project, segmentZero, accumulatedPathEntries);
                            } else if (pathElement == null) {
                                pathElement = cpe.getPath().toOSString();
                            }
                        }
                        if (pathElement != null) {
                            accumulatedPathEntries.add(pathElement);
                        }
                    }
                    ++n2;
                }
                String defaultOutputLocation = CompilerUtils.pathToString(javaProject.getOutputLocation(), project);
                accumulatedPathEntries.add(defaultOutputLocation);
                try {
                    if (CompilerUtils.isGroovyNaturedProject(project)) {
                        IClasspathEntry[] iClasspathEntryArray2 = javaProject.getRawClasspath();
                        int n3 = iClasspathEntryArray2.length;
                        n = 0;
                        while (n < n3) {
                            String location;
                            IClasspathEntry entry = iClasspathEntryArray2[n];
                            if (entry.getOutputLocation() != null && !defaultOutputLocation.equals(location = CompilerUtils.pathToString(entry.getOutputLocation(), project))) {
                                accumulatedPathEntries.add(location);
                            }
                            ++n;
                        }
                    }
                }
                catch (CoreException e) {
                    Util.log(e, "checking Groovy Nature failed");
                }
                StringBuilder sb = new StringBuilder();
                for (String entry : accumulatedPathEntries) {
                    sb.append(entry).append(File.pathSeparator);
                }
                classpath = sb.toString();
                CLASSPATH_CACHE.put(cpes, classpath);
            }
            catch (JavaModelException e) {
                Util.log(e, "determining classpath of project " + projectName + " failed");
            }
        }
        return classpath != null ? classpath : "";
    }

    private static void computeDependenciesFromProject(IProject baseProject, String otherProject, Set<String> accumulatedPathEntries) throws JavaModelException {
        IProject iproject = baseProject.getWorkspace().getRoot().getProject(otherProject);
        IJavaProject iJavaProject = JavaCore.create(iproject);
        accumulatedPathEntries.add(CompilerUtils.pathToString(iJavaProject.getOutputLocation(), iproject));
        IClasspathEntry[] cpes = iJavaProject.getResolvedClasspath(true);
        if (cpes != null) {
            IClasspathEntry[] iClasspathEntryArray = cpes;
            int n = cpes.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 3 && cpe.getOutputLocation() != null) {
                    accumulatedPathEntries.add(CompilerUtils.pathToString(cpe.getOutputLocation(), iproject));
                } else if (cpe.isExported()) {
                    IPath cpePath = cpe.getPath();
                    String segmentZero = cpePath.segment(0);
                    if (segmentZero != null && segmentZero.equals(otherProject)) {
                        accumulatedPathEntries.add(iproject.getFile(cpePath.removeFirstSegments(1)).getRawLocation().toOSString());
                    } else if (cpe.getEntryKind() == 2) {
                        CompilerUtils.computeDependenciesFromProject(baseProject, segmentZero, accumulatedPathEntries);
                    } else {
                        String otherPathElement = null;
                        otherPathElement = segmentZero != null && segmentZero.equals(iproject.getName()) ? iproject.getFile(cpePath.removeFirstSegments(1)).getRawLocation().toOSString() : cpePath.toOSString();
                        accumulatedPathEntries.add(otherPathElement);
                    }
                }
                ++n2;
            }
        }
    }

    private static String pathToString(IPath path, IProject project) {
        String realLocation = null;
        if (path != null) {
            String prefix = path.segment(0);
            if (prefix.equals(project.getName())) {
                if (path.segmentCount() == 1) {
                    IPath rawPath = project.getRawLocation();
                    if (rawPath == null) {
                        Util.log(null, "getRawLocation() against the project: " + project + " failed");
                    } else {
                        realLocation = project.getRawLocation().toOSString();
                    }
                } else {
                    IPath rawLocation = project.getFile(path.removeFirstSegments(1)).getRawLocation();
                    if (rawLocation != null) {
                        realLocation = rawLocation.toOSString();
                    }
                }
            } else {
                realLocation = path.toOSString();
            }
        }
        return realLocation;
    }
}

