/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.Lazy;
import groovy.transform.Field;
import groovyjarjarasm.asm.Opcodes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;
import org.codehaus.groovy.transform.LazyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class FieldASTTransformation
extends ClassCodeExpressionTransformer
implements ASTTransformation,
Opcodes {
    private static final Class MY_CLASS = Field.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final ClassNode LAZY_TYPE = ClassHelper.make(Lazy.class);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode ASTTRANSFORMCLASS_TYPE = ClassHelper.make(GroovyASTTransformationClass.class);
    private SourceUnit sourceUnit;
    private DeclarationExpression candidate;
    private boolean insideScriptBody;
    private String variableName;
    private FieldNode fieldNode;
    private ClosureExpression currentClosure;

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.sourceUnit = source;
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        if (parent instanceof DeclarationExpression) {
            DeclarationExpression de = (DeclarationExpression)parent;
            ClassNode cNode = de.getDeclaringClass();
            if (!cNode.isScript()) {
                this.addError("Annotation " + MY_TYPE_NAME + " can only be used within a Script.", parent);
                return;
            }
            this.candidate = de;
            if (de.isMultipleAssignmentDeclaration()) {
                this.addError("Annotation " + MY_TYPE_NAME + " not supported with multiple assignment notation.", parent);
                return;
            }
            VariableExpression ve = de.getVariableExpression();
            this.variableName = ve.getName();
            this.fieldNode = new FieldNode(this.variableName, ve.getModifiers(), ve.getType(), null, de.getRightExpression());
            this.fieldNode.setSourcePosition(de);
            this.fieldNode.setNameStart(ve.getStart());
            this.fieldNode.setNameEnd(ve.getEnd() - 1);
            cNode.addField(this.fieldNode);
            List<AnnotationNode> annotations = de.getAnnotations();
            for (AnnotationNode annotation : annotations) {
                ClassNode annotationClassNode;
                if (annotation.getClassNode().equals(LAZY_TYPE)) {
                    LazyASTTransformation.visitField(annotation, this.fieldNode);
                }
                if (!this.notTransform(annotationClassNode = annotation.getClassNode()) && !this.acceptableTransform(annotation)) continue;
                this.fieldNode.addAnnotation(annotation);
            }
            super.visitClass(cNode);
            VariableScopeVisitor scopeVisitor = new VariableScopeVisitor(source);
            scopeVisitor.visitClass(cNode);
        }
    }

    private boolean acceptableTransform(AnnotationNode annotation) {
        return !annotation.getClassNode().equals(MY_TYPE);
    }

    private boolean notTransform(ClassNode annotationClassNode) {
        return annotationClassNode.getAnnotations(ASTTRANSFORMCLASS_TYPE).isEmpty();
    }

    @Override
    public Expression transform(Expression expr) {
        VariableExpression ve;
        if (expr == null) {
            return null;
        }
        if (expr instanceof DeclarationExpression) {
            DeclarationExpression de = (DeclarationExpression)expr;
            if (de.getLeftExpression() == this.candidate.getLeftExpression()) {
                if (this.insideScriptBody) {
                    return new ConstantExpression(null);
                }
                this.addError("Annotation " + MY_TYPE_NAME + " can only be used within a Script body.", expr);
                return expr;
            }
        } else if (this.insideScriptBody && expr instanceof VariableExpression && this.currentClosure != null && (ve = (VariableExpression)expr).getName().equals(this.variableName)) {
            ve.setAccessedVariable(this.fieldNode);
            VariableScope variableScope = this.currentClosure.getVariableScope();
            Iterator<Variable> iterator = variableScope.getReferencedLocalVariablesIterator();
            while (iterator.hasNext()) {
                Variable next = iterator.next();
                if (!next.getName().equals(this.variableName)) continue;
                iterator.remove();
            }
            variableScope.putReferencedClassVariable(this.fieldNode);
            return ve;
        }
        return expr.transformExpression(this);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        ClosureExpression old = this.currentClosure;
        this.currentClosure = expression;
        super.visitClosureExpression(expression);
        this.currentClosure = old;
    }

    @Override
    public void visitMethod(MethodNode node) {
        Boolean oldInsideScriptBody = this.insideScriptBody;
        if (node.isScriptBody()) {
            this.insideScriptBody = true;
        }
        super.visitMethod(node);
        this.insideScriptBody = oldInsideScriptBody;
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement es) {
        Expression exp = es.getExpression();
        if (exp instanceof BinaryExpression) {
            exp.visit(this);
        }
        super.visitExpressionStatement(es);
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }
}

