/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.compiler.lookup.LazilyResolvedMethodBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeLookup
implements ITypeLookupExtension {
    protected GroovyCompilationUnit unit;
    protected static final AccessorSupport[] READER = new AccessorSupport[]{AccessorSupport.GETTER, AccessorSupport.ISSER};
    protected static final AccessorSupport[] WRITER = new AccessorSupport[]{AccessorSupport.SETTER};

    @Override
    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
        this.unit = unit;
    }

    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        return this.lookupType(node, scope, objectExpressionType, false);
    }

    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType, boolean isStaticObjectExpression) {
        TypeLookupResult.TypeConfidence[] confidence = new TypeLookupResult.TypeConfidence[]{TypeLookupResult.TypeConfidence.EXACT};
        if (ClassHelper.isPrimitiveType(objectExpressionType)) {
            objectExpressionType = ClassHelper.getWrapper(objectExpressionType);
        }
        ClassNode declaringType = objectExpressionType != null ? objectExpressionType : this.findDeclaringType(node, scope, confidence);
        TypeLookupResult result = this.findType(node, declaringType, scope, confidence[0], isStaticObjectExpression || objectExpressionType == null && scope.isStatic(), objectExpressionType == null);
        return result;
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return new TypeLookupResult(node.getType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return new TypeLookupResult(node.getReturnType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        ClassNode baseType = node.getClassNode();
        return new TypeLookupResult(baseType, baseType, baseType, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        ClassNode baseType = node.getType();
        if (baseType != null) {
            return new TypeLookupResult(baseType, baseType, baseType, TypeLookupResult.TypeConfidence.EXACT, scope);
        }
        return new TypeLookupResult(VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, TypeLookupResult.TypeConfidence.INFERRED, scope);
    }

    @Override
    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        ClassNode resultType;
        if (node instanceof InnerClassNode && !node.isRedirectNode()) {
            resultType = node.getSuperClass();
            if (resultType.getName().equals(VariableScope.OBJECT_CLASS_NODE.getName()) && node.getInterfaces().length > 0) {
                resultType = node.getInterfaces()[0];
            }
        } else {
            resultType = node;
        }
        return new TypeLookupResult(resultType, resultType, node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        VariableScope.VariableInfo info = scope.lookupNameInCurrentScope(node.getName());
        ClassNode type = info != null ? info.type : node.getType();
        return new TypeLookupResult(type, scope.getEnclosingTypeDeclaration(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public void lookupInBlock(BlockStatement node, VariableScope scope) {
    }

    protected ClassNode findDeclaringType(Expression node, VariableScope scope, TypeLookupResult.TypeConfidence[] confidence) {
        if (node instanceof ClassExpression || node instanceof ConstructorCallExpression) {
            return node.getType();
        }
        if (node instanceof FieldExpression) {
            return ((FieldExpression)node).getField().getDeclaringClass();
        }
        if (node instanceof StaticMethodCallExpression) {
            return ((StaticMethodCallExpression)node).getOwnerType();
        }
        if (node instanceof ConstantExpression) {
            if (scope.isMethodCall()) {
                return scope.getDelegateOrThis();
            }
        } else if (node instanceof VariableExpression) {
            Variable var = ((VariableExpression)node).getAccessedVariable();
            if (var instanceof DynamicVariable) {
                ASTNode declaration = null;
                ClassNode delegate = scope.getDelegate();
                if (delegate != null) {
                    declaration = this.findDeclaration(var.getName(), delegate, scope.getWormhole().get("lhs") == node, false, scope.getMethodCallArgumentTypes());
                }
                ClassNode thiz = scope.getThis();
                if (!(declaration != null || thiz == null || delegate != null && thiz.equals(delegate))) {
                    declaration = this.findDeclaration(var.getName(), thiz, scope.getWormhole().get("lhs") == node, false, scope.getMethodCallArgumentTypes());
                }
                ClassNode type = declaration == null ? (thiz != null ? thiz : VariableScope.OBJECT_CLASS_NODE) : SimpleTypeLookup.getDeclaringTypeFromDeclaration(declaration, var.getType());
                confidence[0] = TypeLookupResult.TypeConfidence.findLessPrecise(confidence[0], TypeLookupResult.TypeConfidence.INFERRED);
                return type;
            }
            if (var instanceof FieldNode) {
                return ((FieldNode)var).getDeclaringClass();
            }
            if (var instanceof PropertyNode) {
                return ((PropertyNode)var).getDeclaringClass();
            }
            if (VariableScope.isThisOrSuper((VariableExpression)node)) {
                return scope.lookupName((String)((VariableExpression)node).getName()).declaringType;
            }
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }

    protected TypeLookupResult findType(Expression node, ClassNode declaringType, VariableScope scope, TypeLookupResult.TypeConfidence confidence, boolean isStaticObjectExpression, boolean isPrimaryExpression) {
        MethodNode target;
        if (scope.isMethodCall() && (target = SimpleTypeLookup.getMethodTarget(node)) != null) {
            return new TypeLookupResult(target.getReturnType(), target.getDeclaringClass(), target, confidence, scope);
        }
        if (node instanceof VariableExpression) {
            return this.findTypeForVariable((VariableExpression)node, scope, confidence, declaringType);
        }
        ClassNode nodeType = node.getType();
        if ((!isPrimaryExpression || scope.isMethodCall()) && node instanceof ConstantExpression) {
            return this.findTypeForNameWithKnownObjectExpression(node.getText(), nodeType, declaringType, scope, confidence, isStaticObjectExpression, isPrimaryExpression, scope.getWormhole().remove("lhs") == node);
        }
        if (node instanceof ConstantExpression) {
            ConstantExpression cexp = (ConstantExpression)node;
            if (cexp.isNullExpression()) {
                return new TypeLookupResult(VariableScope.VOID_CLASS_NODE, null, null, confidence, scope);
            }
            if (cexp.isTrueExpression() || cexp.isFalseExpression()) {
                return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
            }
            if (cexp.isEmptyStringExpression() || VariableScope.STRING_CLASS_NODE.equals(nodeType)) {
                return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, node, confidence, scope);
            }
            if (ClassHelper.isNumberType(nodeType) || ClassHelper.BigDecimal_TYPE.equals(nodeType) || ClassHelper.BigInteger_TYPE.equals(nodeType)) {
                return new TypeLookupResult(ClassHelper.isPrimitiveType(nodeType) ? ClassHelper.getWrapper(nodeType) : nodeType, null, null, confidence, scope);
            }
            return new TypeLookupResult(nodeType, null, null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
        }
        if (node instanceof BooleanExpression || node instanceof NotExpression) {
            return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof GStringExpression) {
            return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof BitwiseNegationExpression) {
            ClassNode type = ((BitwiseNegationExpression)node).getExpression().getType();
            if (VariableScope.STRING_CLASS_NODE.equals(type)) {
                return new TypeLookupResult(VariableScope.PATTERN_CLASS_NODE, null, null, confidence, scope);
            }
            return new TypeLookupResult(type, null, null, confidence, scope);
        }
        if (node instanceof ClosureExpression && VariableScope.isPlainClosure(nodeType)) {
            ClassNode returnType = (ClassNode)node.getNodeMetaData("returnType");
            if (returnType != null && !VariableScope.isVoidOrObject(returnType)) {
                GroovyUtils.updateClosureWithInferredTypes(nodeType, returnType, ((ClosureExpression)node).getParameters());
            }
        } else {
            if (node instanceof ClassExpression) {
                if (this.isClassLiteralExpression((ClassExpression)node, scope)) {
                    ClassNode classType = ClassHelper.makeWithoutCaching(ClassHelper.CLASS_Type.getName());
                    classType.setGenericsTypes(new GenericsType[]{new GenericsType(node.getType())});
                    classType.setRedirect(ClassHelper.CLASS_Type);
                    classType.setSourcePosition(node);
                    return new TypeLookupResult(classType, null, node.getType(), TypeLookupResult.TypeConfidence.EXACT, scope);
                }
                return new TypeLookupResult(nodeType, declaringType, nodeType, confidence, scope);
            }
            if (node instanceof ConstructorCallExpression) {
                ConstructorCallExpression constructorCall = (ConstructorCallExpression)node;
                MethodNode constructorDecl = scope.getEnclosingMethodDeclaration();
                if (constructorCall.isThisCall()) {
                    declaringType = constructorDecl != null ? constructorDecl.getDeclaringClass() : scope.getEnclosingTypeDeclaration();
                } else if (constructorCall.isSuperCall()) {
                    declaringType = constructorDecl != null ? constructorDecl.getDeclaringClass().getUnresolvedSuperClass() : scope.getEnclosingTypeDeclaration();
                }
                List<ConstructorNode> declaredConstructors = declaringType.getDeclaredConstructors();
                if (constructorCall.getArguments() instanceof ArgumentListExpression && declaredConstructors.size() > 1) {
                    ArrayList<ConstructorNode> looseMatches = new ArrayList<ConstructorNode>();
                    List<ClassNode> callTypes = scope.getMethodCallArgumentTypes();
                    for (ConstructorNode ctor : declaredConstructors) {
                        if (callTypes.size() != ctor.getParameters().length) continue;
                        if (Boolean.TRUE.equals(SimpleTypeLookup.isTypeCompatible(callTypes, ctor.getParameters()))) {
                            return new TypeLookupResult(nodeType, declaringType, ctor, confidence, scope);
                        }
                        looseMatches.add(ctor);
                    }
                    if (!looseMatches.isEmpty()) {
                        declaredConstructors = looseMatches;
                    }
                }
                ClassNode declaration = !declaredConstructors.isEmpty() ? (AnnotatedNode)declaredConstructors.get(0) : declaringType;
                return new TypeLookupResult(nodeType, declaringType, declaration, confidence, scope);
            }
            if (node instanceof StaticMethodCallExpression) {
                String methodName = ((StaticMethodCallExpression)node).getMethod();
                ClassNode ownerType = ((StaticMethodCallExpression)node).getOwnerType();
                LinkedList<MethodNode> candidates = new LinkedList<MethodNode>();
                if (!ownerType.isInterface()) {
                    candidates.addAll(ownerType.getMethods(methodName));
                } else {
                    LinkedHashSet<ClassNode> faces = new LinkedHashSet<ClassNode>();
                    VariableScope.findAllInterfaces(ownerType, faces, false);
                    for (ClassNode face : faces) {
                        candidates.addAll(face.getMethods(methodName));
                    }
                }
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    if (((MethodNode)it.next()).isStatic()) continue;
                    it.remove();
                }
                if (!candidates.isEmpty()) {
                    MethodNode closestMatch;
                    if (scope.isMethodCall()) {
                        closestMatch = this.findMethodDeclaration0(candidates, scope.getMethodCallArgumentTypes());
                        confidence = TypeLookupResult.TypeConfidence.INFERRED;
                    } else {
                        closestMatch = (MethodNode)candidates.get(0);
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                    return new TypeLookupResult(closestMatch.getReturnType(), closestMatch.getDeclaringClass(), closestMatch, confidence, scope);
                }
            }
        }
        if (!(node instanceof TupleExpression) && nodeType.equals(VariableScope.OBJECT_CLASS_NODE)) {
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        return new TypeLookupResult(nodeType, declaringType, null, confidence, scope);
    }

    protected TypeLookupResult findTypeForNameWithKnownObjectExpression(String name, ClassNode type, ClassNode declaringType, VariableScope scope, TypeLookupResult.TypeConfidence confidence, boolean isStaticObjectExpression, boolean isPrimaryExpression, boolean isLhsExpression) {
        VariableScope.VariableInfo varInfo;
        ClassNode realDeclaringType;
        ClassNode thiz;
        TypeLookupResult.TypeConfidence origConfidence = confidence;
        ASTNode declaration = this.findDeclaration(name, declaringType, isLhsExpression, isStaticObjectExpression, scope.getMethodCallArgumentTypes());
        if (declaration == null && isPrimaryExpression && (thiz = scope.getThis()) != null && !thiz.equals(declaringType)) {
            declaration = this.findDeclaration(name, thiz, isLhsExpression, isStaticObjectExpression, scope.getMethodCallArgumentTypes());
        }
        if (declaration == null && isStaticObjectExpression) {
            declaration = this.findDeclaration(name, VariableScope.CLASS_CLASS_NODE, isLhsExpression, isStaticObjectExpression, scope.getMethodCallArgumentTypes());
        }
        if (declaration != null) {
            type = SimpleTypeLookup.getTypeFromDeclaration(declaration, declaringType);
            realDeclaringType = SimpleTypeLookup.getDeclaringTypeFromDeclaration(declaration, declaringType);
        } else if ("this".equals(name)) {
            declaration = declaringType;
            type = declaringType;
            realDeclaringType = declaringType;
        } else if (isPrimaryExpression && (varInfo = scope.lookupName(name)) != null) {
            type = varInfo.type;
            realDeclaringType = varInfo.declaringType;
            declaration = this.findDeclaration(name, realDeclaringType, isLhsExpression, isStaticObjectExpression, scope.getMethodCallArgumentTypes());
            if (declaration == null) {
                declaration = varInfo.declaringType;
            }
        } else if (name.equals("call")) {
            realDeclaringType = VariableScope.CLOSURE_CLASS_NODE;
            declaration = realDeclaringType.getMethods("call").get(0);
        } else {
            realDeclaringType = declaringType;
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        if (declaration != null && !realDeclaringType.equals(VariableScope.CLASS_CLASS_NODE)) {
            if (declaration instanceof FieldNode) {
                if (isStaticObjectExpression && !((FieldNode)declaration).isStatic()) {
                    confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                }
            } else if (declaration instanceof PropertyNode) {
                FieldNode underlyingField = ((PropertyNode)declaration).getField();
                if (underlyingField != null) {
                    if (isStaticObjectExpression && !underlyingField.isStatic()) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                } else if (isStaticObjectExpression && !((PropertyNode)declaration).isStatic()) {
                    confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                }
            } else if (declaration instanceof MethodNode) {
                if (isStaticObjectExpression && !((MethodNode)declaration).isStatic()) {
                    confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                } else if (((MethodNode)declaration).getParameters().length != scope.getMethodCallNumberOfArguments()) {
                    confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                }
            }
        }
        if (confidence == TypeLookupResult.TypeConfidence.UNKNOWN && realDeclaringType.getName().equals(VariableScope.CLASS_CLASS_NODE.getName())) {
            ClassNode typeParam;
            GenericsType[] classTypeParams = realDeclaringType.getGenericsTypes();
            ClassNode classNode = typeParam = classTypeParams != null && classTypeParams.length == 1 ? classTypeParams[0].getType() : null;
            if (typeParam != null && !typeParam.getName().equals(VariableScope.CLASS_CLASS_NODE.getName()) && !typeParam.getName().equals(VariableScope.OBJECT_CLASS_NODE.getName())) {
                return this.findTypeForNameWithKnownObjectExpression(name, type, typeParam, scope, origConfidence, isStaticObjectExpression, isPrimaryExpression, isLhsExpression);
            }
        }
        return new TypeLookupResult(type, realDeclaringType, declaration, confidence, scope);
    }

    protected TypeLookupResult findTypeForVariable(VariableExpression var, VariableScope scope, TypeLookupResult.TypeConfidence confidence, ClassNode declaringType) {
        ASTNode decl = var;
        ClassNode type = var.getType();
        TypeLookupResult.TypeConfidence newConfidence = confidence;
        Variable accessedVar = var.getAccessedVariable();
        VariableScope.VariableInfo variableInfo = scope.lookupName(var.getName());
        if (accessedVar instanceof ASTNode) {
            decl = (ASTNode)((Object)accessedVar);
            if (decl instanceof FieldNode || decl instanceof MethodNode || decl instanceof PropertyNode) {
                variableInfo = null;
                type = SimpleTypeLookup.getTypeFromDeclaration(decl, ((AnnotatedNode)decl).getDeclaringClass());
            }
        } else if (accessedVar instanceof DynamicVariable) {
            ASTNode candidate = this.findDeclaration(accessedVar.getName(), SimpleTypeLookup.getMorePreciseType(declaringType, variableInfo), scope.getWormhole().remove("lhs") == var, false, scope.getMethodCallArgumentTypes());
            if (candidate != null) {
                decl = candidate;
                declaringType = SimpleTypeLookup.getDeclaringTypeFromDeclaration(decl, variableInfo != null ? variableInfo.declaringType : VariableScope.OBJECT_CLASS_NODE);
            } else {
                newConfidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                if (variableInfo != null && !scope.inScriptRunMethod()) {
                    variableInfo = null;
                }
            }
            type = SimpleTypeLookup.getTypeFromDeclaration(decl, declaringType);
        }
        if (variableInfo != null && !(decl instanceof MethodNode)) {
            type = variableInfo.type;
            if (VariableScope.isThisOrSuper(var)) {
                decl = type;
            }
            declaringType = SimpleTypeLookup.getMorePreciseType(declaringType, variableInfo);
            newConfidence = TypeLookupResult.TypeConfidence.findLessPrecise(confidence, TypeLookupResult.TypeConfidence.INFERRED);
        }
        return new TypeLookupResult(type, declaringType, decl, newConfidence, scope);
    }

    protected ASTNode findDeclaration(String name, ClassNode declaringType, boolean isLhsExpression, boolean isStaticExpression, List<ClassNode> methodCallArgumentTypes) {
        MethodNode method;
        if (declaringType.isArray()) {
            if (name.equals("length")) {
                return SimpleTypeLookup.createLengthField(declaringType);
            }
            return this.findDeclaration(name, VariableScope.OBJECT_CLASS_NODE, isLhsExpression, isStaticExpression, methodCallArgumentTypes);
        }
        if (methodCallArgumentTypes != null && (method = this.findMethodDeclaration(name, declaringType, methodCallArgumentTypes)) != null) {
            return method;
        }
        MethodNode accessor = AccessorSupport.findAccessorMethodForPropertyName(name, declaringType, false, !isLhsExpression ? READER : WRITER);
        if (accessor != null && !SimpleTypeLookup.isSynthetic(accessor) && accessor.isStatic() == isStaticExpression) {
            return accessor;
        }
        LinkedHashSet<ClassNode> typeHierarchy = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(declaringType, typeHierarchy, true);
        for (ClassNode type : typeHierarchy) {
            PropertyNode property = type.getProperty(name);
            if (property == null) continue;
            return property;
        }
        FieldNode field = declaringType.getField(name);
        if (field != null) {
            return field;
        }
        typeHierarchy.clear();
        VariableScope.findAllInterfaces(declaringType, typeHierarchy, true);
        for (ClassNode type : typeHierarchy) {
            if (type == declaringType || (field = type.getField(name)) == null || !field.isFinal() || !field.isStatic()) continue;
            return field;
        }
        if (accessor != null) {
            return accessor;
        }
        if (methodCallArgumentTypes == null) {
            return this.findMethodDeclaration(name, declaringType, null);
        }
        return null;
    }

    protected MethodNode findMethodDeclaration(String name, ClassNode declaringType, List<ClassNode> methodCallArgumentTypes) {
        if (!declaringType.isInterface() && !declaringType.isAbstract()) {
            List<MethodNode> candidates = declaringType.getMethods(name);
            if (!candidates.isEmpty()) {
                return this.findMethodDeclaration0(candidates, methodCallArgumentTypes);
            }
            return null;
        }
        LinkedHashSet<ClassNode> types = new LinkedHashSet<ClassNode>();
        if (!declaringType.isInterface()) {
            types.add(declaringType);
        }
        VariableScope.findAllInterfaces(declaringType, types, true);
        types.add(ClassHelper.OBJECT_TYPE);
        MethodNode outerCandidate = null;
        for (ClassNode type : types) {
            MethodNode innerCandidate = null;
            List<MethodNode> candidates = type.getMethods(name);
            if (!candidates.isEmpty()) {
                innerCandidate = this.findMethodDeclaration0(candidates, methodCallArgumentTypes);
                if (outerCandidate == null) {
                    outerCandidate = innerCandidate;
                }
            }
            if (innerCandidate == null || methodCallArgumentTypes == null) continue;
            Parameter[] methodParameters = innerCandidate.getParameters();
            if (methodCallArgumentTypes.isEmpty() && methodParameters.length == 0) {
                return innerCandidate;
            }
            if (methodCallArgumentTypes.size() != methodParameters.length) continue;
            outerCandidate = innerCandidate;
            Boolean suitable = SimpleTypeLookup.isTypeCompatible(methodCallArgumentTypes, methodParameters);
            if (Boolean.FALSE.equals(suitable) || !Boolean.TRUE.equals(suitable)) continue;
            return innerCandidate;
        }
        return outerCandidate;
    }

    protected MethodNode findMethodDeclaration0(List<MethodNode> candidates, List<ClassNode> arguments) {
        MethodNode closestMatch = candidates.get(0);
        if (arguments == null) {
            return closestMatch;
        }
        Iterator<MethodNode> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            MethodNode maybeMethod = iterator.next();
            Parameter[] parameters = maybeMethod.getParameters();
            if (parameters.length == 0 && arguments.isEmpty()) {
                return maybeMethod.getOriginal();
            }
            if (parameters.length == arguments.size()) {
                Boolean suitable = SimpleTypeLookup.isTypeCompatible(arguments, parameters);
                if (Boolean.TRUE.equals(suitable)) {
                    return maybeMethod.getOriginal();
                }
                if (!Boolean.FALSE.equals(suitable)) {
                    closestMatch = maybeMethod.getOriginal();
                    continue;
                }
            }
            iterator.remove();
        }
        return closestMatch;
    }

    protected static ASTNode createLengthField(ClassNode declaringType) {
        FieldNode lengthField = new FieldNode("length", 1, VariableScope.INTEGER_CLASS_NODE, declaringType, null);
        lengthField.setType(VariableScope.INTEGER_CLASS_NODE);
        lengthField.setDeclaringClass(declaringType);
        return lengthField;
    }

    protected static MethodNode getMethodTarget(Expression expr) {
        if (expr instanceof MethodCallExpression) {
            MethodNode target = ((MethodCallExpression)expr).getMethodTarget();
            return target;
        }
        OptimizingStatementWriter.StatementMeta meta = (OptimizingStatementWriter.StatementMeta)expr.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
        if (meta != null) {
            MethodNode target = (MethodNode)ReflectionUtils.getPrivateField(OptimizingStatementWriter.StatementMeta.class, "target", meta);
            return target;
        }
        return null;
    }

    protected static ClassNode getMorePreciseType(ClassNode declaringType, VariableScope.VariableInfo info) {
        ClassNode maybeDeclaringType;
        ClassNode classNode = maybeDeclaringType = info != null ? info.declaringType : VariableScope.OBJECT_CLASS_NODE;
        if (maybeDeclaringType.equals(VariableScope.OBJECT_CLASS_NODE) && !VariableScope.OBJECT_CLASS_NODE.equals(declaringType)) {
            return declaringType;
        }
        return maybeDeclaringType;
    }

    protected static ClassNode getTypeFromDeclaration(ASTNode declaration, ClassNode resolvedType) {
        ClassNode typeOfDeclaration;
        FieldNode field;
        if (declaration instanceof PropertyNode && (field = ((PropertyNode)declaration).getField()) != null) {
            declaration = field;
        }
        if (declaration instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)declaration;
            typeOfDeclaration = fieldNode.getType();
            if (VariableScope.OBJECT_CLASS_NODE.equals(typeOfDeclaration) && fieldNode.hasInitialExpression()) {
                typeOfDeclaration = fieldNode.getInitialExpression().getType();
            }
        } else {
            typeOfDeclaration = declaration instanceof MethodNode ? ((MethodNode)declaration).getReturnType() : (declaration instanceof Expression ? ((Expression)declaration).getType() : VariableScope.OBJECT_CLASS_NODE);
        }
        return typeOfDeclaration;
    }

    protected static ClassNode getDeclaringTypeFromDeclaration(ASTNode declaration, ClassNode resolvedTypeOfDeclaration) {
        ClassNode typeOfDeclaration = declaration instanceof FieldNode ? ((FieldNode)declaration).getDeclaringClass() : (declaration instanceof MethodNode ? ((MethodNode)declaration).getDeclaringClass() : (declaration instanceof PropertyNode ? ((PropertyNode)declaration).getDeclaringClass() : VariableScope.OBJECT_CLASS_NODE));
        if (typeOfDeclaration.getName().equals(resolvedTypeOfDeclaration.getName())) {
            return resolvedTypeOfDeclaration;
        }
        return typeOfDeclaration;
    }

    protected boolean isClassLiteralExpression(ClassExpression classExpr, VariableScope scope) {
        boolean probablyClassLiteral;
        ASTNode scopeNode = scope.getCurrentNode();
        if (scopeNode == null) {
            probablyClassLiteral = true;
        } else if (scopeNode instanceof ListExpression) {
            probablyClassLiteral = true;
        } else if (scopeNode instanceof MapEntryExpression) {
            probablyClassLiteral = true;
        } else if (scopeNode instanceof ConstantExpression) {
            probablyClassLiteral = true;
        } else if (scopeNode instanceof MethodCallExpression) {
            probablyClassLiteral = classExpr != ((MethodCallExpression)scopeNode).getObjectExpression();
        } else if (scopeNode instanceof PropertyExpression && classExpr.getEnd() > 0) {
            try {
                probablyClassLiteral = String.valueOf(this.unit.getContents(), classExpr.getStart(), classExpr.getLength()).endsWith(".class");
            }
            catch (StringIndexOutOfBoundsException ex) {
                probablyClassLiteral = false;
            }
        } else {
            probablyClassLiteral = false;
        }
        return probablyClassLiteral;
    }

    protected static boolean isSynthetic(MethodNode method) {
        return method.isSynthetic() || method.getDeclaringClass().equals(ClassHelper.CLOSURE_TYPE) || method instanceof JDTMethodNode && ((JDTMethodNode)method).getJdtBinding() instanceof LazilyResolvedMethodBinding;
    }

    protected static Boolean isTypeCompatible(List<ClassNode> arguments, Parameter[] parameters) {
        Boolean result = Boolean.TRUE;
        int i = 0;
        int n = parameters.length;
        while (i < n) {
            ClassNode parameter = parameters[i].getType();
            ClassNode argument = arguments.get(i);
            Boolean partialResult = SimpleTypeLookup.isTypeCompatible(argument, parameter);
            if (partialResult == null) {
                result = null;
            } else if (!partialResult.booleanValue()) {
                result = Boolean.FALSE;
                break;
            }
            ++i;
        }
        return result;
    }

    protected static Boolean isTypeCompatible(ClassNode source, ClassNode target) {
        Boolean result = Boolean.TRUE;
        if (!(target.equals(source) || source == VariableScope.NULL_TYPE && !target.isPrimitive() || source.equals(ClassHelper.CLOSURE_TYPE) && ClassHelper.isSAMType(target))) {
            result = !GroovyUtils.isAssignable(source, target) ? Boolean.FALSE : null;
        }
        return result;
    }
}

