/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import org.apache.xbean.classloader.NonLockingJarFileClassLoader;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.Grails20TestSupport;
import org.codehaus.jdt.groovy.internal.compiler.ast.GrailsGlobalPluginAwareEntityInjector;
import org.codehaus.jdt.groovy.internal.compiler.ast.GrailsInjector;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyErrorCollectorForJDT;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.IGroovyDebugRequestor;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyParser {
    public static IGroovyDebugRequestor debugRequestor;
    public Object requestor;
    public ProblemReporter problemReporter;
    private JDTResolver resolver;
    private String projectName;
    private String gclClasspath;
    private org.codehaus.groovy.control.CompilationUnit compilationUnit;
    private CompilerOptions compilerOptions;
    private static Map<String, PathLoaderPair> projectToLoaderCache;
    private static Map<String, ScriptFolderSelector> scriptFolderSelectorCache;
    private GroovyClassLoader gclForBatch = null;
    private static final boolean NONLOCKING;

    static {
        projectToLoaderCache = new ConcurrentHashMap<String, PathLoaderPair>();
        scriptFolderSelectorCache = new ConcurrentHashMap<String, ScriptFolderSelector>();
        NONLOCKING = Boolean.getBoolean("greclipse.nonlocking");
        if (NONLOCKING) {
            System.out.println("property set: greclipse.nonlocking: will try to avoid locking jars");
        }
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public static void close(GroovyClassLoader groovyClassLoader) {
        try {
            Object[] jarLoaders;
            Object urlClasspath = ReflectionUtils.getPrivateField(URLClassLoader.class, "ucp", groovyClassLoader);
            Object[] objectArray = jarLoaders = ((Collection)ReflectionUtils.getPrivateField(urlClasspath.getClass(), "loaders", urlClasspath)).toArray();
            int n = jarLoaders.length;
            int n2 = 0;
            while (n2 < n) {
                Object jarLoader = objectArray[n2];
                try {
                    JarFile jarFile = (JarFile)ReflectionUtils.getPrivateField(jarLoader.getClass(), "jar", jarLoader);
                    String jarFileName = jarFile.getName();
                    if (jarFileName.indexOf("cache") != -1 || jarFileName.indexOf("plugins") != -1) {
                        jarFile.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void tidyCache(String projectName) {
        projectToLoaderCache.remove(projectName);
        scriptFolderSelectorCache.remove(projectName);
    }

    public static void closeClassLoader(String projectName) {
        PathLoaderPair pathLoaderPair = projectToLoaderCache.get(projectName);
        if (pathLoaderPair != null) {
            GroovyParser.close(pathLoaderPair.groovyClassLoader);
        }
    }

    static void tidyCache() {
        projectToLoaderCache.clear();
    }

    private GroovyClassLoader getLoaderFor(String path) {
        GroovyClassLoader gcl = null;
        if (this.projectName == null && path == null) {
            if (this.gclForBatch == null) {
                try {
                    FileSystem fileSystem;
                    INameEnvironment nameEnvironment;
                    LookupEnvironment lookupEnvironment;
                    if (this.requestor instanceof Compiler && (lookupEnvironment = ((Compiler)this.requestor).lookupEnvironment) != null && (nameEnvironment = lookupEnvironment.nameEnvironment) instanceof FileSystem && (fileSystem = (FileSystem)nameEnvironment) != null) {
                        FileSystem.Classpath[] classpaths = (FileSystem.Classpath[])ReflectionUtils.getPrivateField(FileSystem.class, "classpaths", fileSystem);
                        if (classpaths != null) {
                            this.gclForBatch = new GroovyClassLoader();
                            FileSystem.Classpath[] classpathArray = classpaths;
                            int n = classpaths.length;
                            int n2 = 0;
                            while (n2 < n) {
                                FileSystem.Classpath classpath = classpathArray[n2];
                                this.gclForBatch.addClasspath(classpath.getPath());
                                ++n2;
                            }
                        } else {
                            System.err.println("Cannot find classpaths field on FileSystem class");
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Unexpected problem computing classpath for ast transform loader:");
                    e.printStackTrace(System.err);
                }
            }
            return this.gclForBatch;
        }
        if (path != null && this.projectName != null) {
            PathLoaderPair pathAndLoader = projectToLoaderCache.get(this.projectName);
            if (pathAndLoader == null) {
                if (GroovyLogManager.manager.hasLoggers()) {
                    GroovyLogManager.manager.log(TraceCategory.AST_TRANSFORM, "Classpath for GroovyClassLoader (used to discover transforms): " + path);
                }
                pathAndLoader = new PathLoaderPair(path);
                projectToLoaderCache.put(this.projectName, pathAndLoader);
            } else if (!path.equals(pathAndLoader.classpath)) {
                pathAndLoader = new PathLoaderPair(path);
                projectToLoaderCache.put(this.projectName, pathAndLoader);
            }
            gcl = pathAndLoader.groovyClassLoader;
        }
        return gcl;
    }

    public GroovyParser(CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this(null, compilerOptions, problemReporter, allowTransforms, isReconcile);
    }

    public GroovyParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this.requestor = requestor;
        this.compilerOptions = compilerOptions;
        this.problemReporter = problemReporter;
        this.projectName = compilerOptions.groovyProjectName;
        this.gclClasspath = compilerOptions.groovyClassLoaderPath;
        GroovyClassLoader gcl = this.getLoaderFor(this.gclClasspath);
        GrapeAwareGroovyClassLoader grabbyLoader = new GrapeAwareGroovyClassLoader((ClassLoader)gcl);
        this.compilationUnit = this.makeCompilationUnit(grabbyLoader, gcl, isReconcile, allowTransforms);
        this.compilationUnit.removeOutputPhaseOperation();
    }

    public void reset() {
        GroovyClassLoader gcl = this.getLoaderFor(this.gclClasspath);
        this.compilationUnit = this.makeCompilationUnit(new GrapeAwareGroovyClassLoader((ClassLoader)gcl), gcl, this.compilationUnit.isReconcile, this.compilationUnit.allowTransforms);
    }

    private static URLClassLoader createLoader(URL[] urls, ClassLoader parent) {
        if (NONLOCKING) {
            return new NonLockingJarFileClassLoader("AST Transform loader", urls, parent);
        }
        return new URLClassLoader(urls, parent);
    }

    private static URLClassLoader createConfigureLoader(String path) {
        ClassLoader pcl = GroovyParser.class.getClassLoader();
        if (path == null) {
            return GroovyParser.createLoader(null, pcl);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (path.indexOf(File.pathSeparator) != -1) {
            int pos = 0;
            while (pos != -1) {
                int nextSep = path.indexOf(File.pathSeparator, pos);
                if (nextSep == -1) {
                    GroovyParser.addNewURL(path.substring(pos), urls);
                    pos = -1;
                    continue;
                }
                GroovyParser.addNewURL(path.substring(pos, nextSep), urls);
                pos = nextSep + 1;
            }
        } else {
            GroovyParser.addNewURL(path, urls);
        }
        return GroovyParser.createLoader(urls.toArray(new URL[urls.size()]), pcl);
    }

    private static void addNewURL(String path, List<URL> existingURLs) {
        try {
            File f = new File(path);
            URL newURL = f.toURI().toURL();
            for (URL url : existingURLs) {
                if (!url.equals(newURL)) continue;
                return;
            }
            existingURLs.add(newURL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public CompilationUnitDeclaration dietParse(ICompilationUnit sourceUnit, CompilationResult compilationResult) {
        BuildNotifier notifier;
        IPath location;
        char[] sourceCode = sourceUnit.getContents();
        if (sourceCode == null) {
            sourceCode = CharOperation.NO_CHAR;
        }
        GroovyErrorCollectorForJDT errorCollector = new GroovyErrorCollectorForJDT(this.compilationUnit.getConfiguration());
        String filepath = null;
        char[] fileName = sourceUnit.getFileName();
        filepath = sourceUnit instanceof CompilationUnit ? String.valueOf(((CompilationUnit)sourceUnit).fileName) : String.valueOf(fileName);
        Path path = new Path(filepath);
        IFile eclipseFile = null;
        if (ResourcesPlugin.getPlugin() != null && path.segmentCount() >= 2 && (location = (eclipseFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).getLocation()) != null) {
            filepath = location.toFile().getAbsolutePath();
        }
        EclipseSourceUnit groovySourceUnit = new EclipseSourceUnit(eclipseFile, filepath, String.valueOf(sourceCode), this.compilationUnit.getConfiguration(), this.compilationUnit.getClassLoader(), errorCollector, this.resolver);
        groovySourceUnit.isReconcile = this.compilationUnit.isReconcile;
        GroovyCompilationUnitDeclaration gcuDeclaration = new GroovyCompilationUnitDeclaration(this.problemReporter, compilationResult, sourceCode.length, this.compilationUnit, groovySourceUnit, this.compilerOptions);
        compilationResult.lineSeparatorPositions = GroovyUtils.getSourceLineSeparatorsIn(sourceCode);
        this.compilationUnit.addSource(groovySourceUnit);
        if (this.requestor instanceof Compiler && ((Compiler)this.requestor).requestor instanceof BatchImageBuilder && (notifier = ((BatchImageBuilder)((Compiler)this.requestor).requestor).notifier) != null) {
            this.compilationUnit.setProgressListener(new ProgressListenerImpl(notifier));
        }
        gcuDeclaration.processToPhase(3);
        if (gcuDeclaration.getModuleNode() != null) {
            gcuDeclaration.populateCompilationUnitDeclaration();
            TypeDeclaration[] typeDeclarationArray = gcuDeclaration.types;
            int n = gcuDeclaration.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration decl = typeDeclarationArray[n2];
                this.resolver.record((GroovyTypeDeclaration)decl);
                ++n2;
            }
        }
        if (this.projectName != null && eclipseFile != null) {
            ScriptFolderSelector scriptFolderSelector = scriptFolderSelectorCache.get(this.projectName);
            if (scriptFolderSelector == null) {
                scriptFolderSelector = new ScriptFolderSelector(ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName));
                scriptFolderSelectorCache.put(this.projectName, scriptFolderSelector);
            }
            if (scriptFolderSelector.isScript(eclipseFile)) {
                gcuDeclaration.tagAsScript();
            }
        }
        if (debugRequestor != null) {
            debugRequestor.acceptCompilationUnitDeclaration(gcuDeclaration);
        }
        return gcuDeclaration;
    }

    private org.codehaus.groovy.control.CompilationUnit makeCompilationUnit(GroovyClassLoader loader, GroovyClassLoader transformLoader, boolean isReconcile, boolean allowTransforms) {
        org.codehaus.groovy.control.CompilationUnit cu;
        block15: {
            ClassLoader savedLoader;
            CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
            if (this.compilerOptions.groovyCustomizerClassesList != null && transformLoader != null) {
                ArrayList<CompilationCustomizer> customizers = new ArrayList<CompilationCustomizer>();
                if (loader != null) {
                    StringTokenizer tokenizer = new StringTokenizer(this.compilerOptions.groovyCustomizerClassesList, ",");
                    savedLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(transformLoader);
                        while (tokenizer.hasMoreTokens()) {
                            String classname = tokenizer.nextToken();
                            try {
                                Class<?> clazz = transformLoader.loadClass(classname);
                                CompilationCustomizer cc = (CompilationCustomizer)clazz.newInstance();
                                customizers.add(cc);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(savedLoader);
                    }
                    compilerConfiguration.addCompilationCustomizers(customizers.toArray(new CompilationCustomizer[customizers.size()]));
                }
            }
            cu = new org.codehaus.groovy.control.CompilationUnit(compilerConfiguration, null, loader, transformLoader, allowTransforms, this.compilerOptions.groovyTransformsToRunOnReconcile, this.compilerOptions.groovyExcludeGlobalASTScan);
            this.resolver = new JDTResolver(cu);
            cu.setResolveVisitor(this.resolver);
            cu.tweak(isReconcile);
            if (allowTransforms && transformLoader != null && this.compilerOptions != null && (this.compilerOptions.groovyFlags & 1) != 0) {
                cu.addPhaseOperation(new GrailsInjector(transformLoader), 5);
                new Grails20TestSupport(this.compilerOptions, transformLoader).addGrailsTestCompilerCustomizers(cu);
                cu.addPhaseOperation(new GrailsGlobalPluginAwareEntityInjector(transformLoader), 5);
                try {
                    Class<?> klass = Class.forName("org.codehaus.groovy.grails.compiler.injection.GrailsAwareInjectionOperation", true, transformLoader);
                    if (klass == null) break block15;
                    savedLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(transformLoader);
                        CompilationUnit.PrimaryClassNodeOperation op = (CompilationUnit.PrimaryClassNodeOperation)klass.newInstance();
                        cu.addPhaseOperation(op, 5);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(savedLoader);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return cu;
    }

    static class GrapeAwareGroovyClassLoader
    extends GroovyClassLoader {
        public boolean grabbed = false;

        public GrapeAwareGroovyClassLoader(ClassLoader parent) {
            super(parent != null ? parent : Thread.currentThread().getContextClassLoader());
        }

        public void addURL(URL url) {
            this.grabbed = true;
            super.addURL(url);
        }
    }

    static class PathLoaderPair {
        String classpath;
        GroovyClassLoader groovyClassLoader;

        PathLoaderPair(String classpath) {
            this.classpath = classpath;
            this.groovyClassLoader = new GroovyClassLoader(GroovyParser.createConfigureLoader(classpath));
        }
    }

    static class ProgressListenerImpl
    implements CompilationUnit.ProgressListener {
        private BuildNotifier notifier;

        public ProgressListenerImpl(BuildNotifier notifier) {
            this.notifier = notifier;
        }

        public void parseComplete(int phase, String sourceUnitName) {
            try {
                int lastSlash = sourceUnitName.lastIndexOf("/");
                if (lastSlash == -1) {
                    lastSlash = sourceUnitName.lastIndexOf("\\");
                }
                if (lastSlash != -1) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Parsing groovy source in ");
                    msg.append(sourceUnitName, 0, lastSlash);
                    this.notifier.subTask(msg.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifier.checkCancel();
        }

        public void generateComplete(int phase, ClassNode classNode) {
            try {
                String pkgName = classNode.getPackageName();
                if (pkgName != null && pkgName.length() > 0) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Generating groovy classes in ");
                    msg.append(pkgName);
                    this.notifier.subTask(msg.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifier.checkCancel();
        }
    }
}

