/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class TypeReferenceSearchRequestor
implements ITypeRequestor {
    private static final String DOT = ".";
    private final SearchRequestor requestor;
    private final SearchParticipant participant;
    private final char[] qualificationPattern;
    private final char[] namePattern;
    private final boolean isCaseSensitive;
    private final boolean isCamelCase;
    private final boolean findDeclaration;
    private final Set<Position> acceptedPositions = new HashSet<Position>();
    private char[] cachedContents;

    public TypeReferenceSearchRequestor(TypeReferencePattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        this.isCaseSensitive = (Boolean)ReflectionUtils.getPrivateField(JavaSearchPattern.class, "isCaseSensitive", pattern);
        this.namePattern = this.extractArray(pattern, "simpleName");
        this.qualificationPattern = this.extractArray(pattern, "qualification");
        this.isCamelCase = (Boolean)ReflectionUtils.getPrivateField(JavaSearchPattern.class, "isCamelCase", pattern);
        this.findDeclaration = pattern instanceof DeclarationOfReferencedTypesPattern;
    }

    protected char[] extractArray(TypeReferencePattern pattern, String fieldName) {
        char[] arr = (char[])ReflectionUtils.getPrivateField(TypeReferencePattern.class, fieldName, pattern);
        if (!this.isCaseSensitive) {
            arr = CharOperation.toLowerCase(arr);
        }
        return arr;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (node instanceof ClassExpression || node instanceof ClassNode || node instanceof ImportNode || node instanceof AnnotationNode) {
            ClassNode type = node instanceof ConstructorNode ? ((ConstructorNode)node).getDeclaringClass() : (node instanceof AnnotationNode ? ((AnnotationNode)node).getClassNode() : result.type);
            if (node instanceof ClassExpression && type.equals(VariableScope.CLASS_CLASS_NODE)) {
                type = ((ClassExpression)node).getType();
            }
            if (type != null && this.qualifiedNameMatches(type = GroovyUtils.getBaseType(type)) && this.hasValidSourceLocation(node)) {
                Position position;
                int start = -1;
                int end = -1;
                boolean startEndFound = false;
                if (node instanceof ImportNode) {
                    if (((ImportNode)node).getType() == null) {
                        end = node.getEnd();
                        start = node.getStart();
                    }
                } else if (node instanceof ClassExpression) {
                    end = node.getEnd();
                    start = node.getStart();
                } else if (node instanceof ClassNode) {
                    ClassNode classNode = (ClassNode)node;
                    if (classNode.getNameEnd() <= 0) {
                        if (classNode.redirect() == classNode) {
                            end = -1;
                            start = -1;
                            startEndFound = true;
                        } else {
                            classNode = this.maybeGetComponentType(classNode);
                            end = classNode.getEnd();
                            start = classNode.getStart();
                        }
                    }
                } else if (node instanceof ConstructorNode) {
                    start = ((ConstructorNode)node).getNameStart();
                    end = ((ConstructorNode)node).getNameEnd() + 1;
                    if (start == 0 && end == 1) {
                        end = -1;
                        start = -1;
                        startEndFound = true;
                    }
                } else if (node instanceof AnnotationNode) {
                    type = ((AnnotationNode)node).getClassNode();
                    end = type.getEnd();
                    start = type.getStart();
                }
                if (!startEndFound) {
                    StartEnd startEnd = this.getMatchLocation(type, enclosingElement, start, end);
                    if (startEnd != null) {
                        start = startEnd.start;
                        end = startEnd.end;
                    } else {
                        end = -1;
                        start = -1;
                    }
                }
                if (start >= 0 && end >= 0 && !this.acceptedPositions.contains(position = new Position(start, end - start))) {
                    IJavaElement realElement = enclosingElement.getOpenable() instanceof GroovyClassFileWorkingCopy ? ((GroovyClassFileWorkingCopy)enclosingElement.getOpenable()).convertToBinary(enclosingElement) : enclosingElement;
                    try {
                        this.requestor.acceptSearchMatch(this.createMatch(result, realElement, start, end));
                        this.acceptedPositions.add(position);
                    }
                    catch (CoreException e) {
                        Util.log(e, "Error accepting search match for " + realElement);
                    }
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    protected TypeReferenceMatch createMatch(TypeLookupResult result, IJavaElement enclosingElement, int start, int end) {
        IJavaElement element;
        if (this.findDeclaration) {
            try {
                ClassNode type = result.type;
                while (type.getComponentType() != null) {
                    type = type.getComponentType();
                }
                element = enclosingElement.getJavaProject().findType(type.getName().replace('$', '.'), new NullProgressMonitor());
                if (element == null) {
                    element = enclosingElement;
                }
            }
            catch (JavaModelException e) {
                Util.log(e);
                element = enclosingElement;
            }
        } else {
            element = enclosingElement;
        }
        return new TypeReferenceMatch(element, this.getAccuracy(result.confidence), start, end - start, false, this.participant, element.getResource());
    }

    private boolean hasValidSourceLocation(ASTNode node) {
        ASTNode astNodeWithSourceLocation = node instanceof ClassNode ? this.maybeGetComponentType((ClassNode)node) : node;
        return astNodeWithSourceLocation.getEnd() > 0;
    }

    private ClassNode maybeGetComponentType(ClassNode orig) {
        ClassNode componentType;
        if (orig.getComponentType() != null && (componentType = orig.getComponentType()).getColumnNumber() != -1) {
            return componentType;
        }
        return orig;
    }

    private String[] extractNameAndQualification(ClassNode type) {
        String simple;
        String semiQualified;
        int lastDollar;
        String qualification = type.getPackageName();
        if (qualification == null) {
            qualification = "";
        }
        if ((lastDollar = (semiQualified = type.getNameWithoutPackage()).lastIndexOf(36)) > 0) {
            simple = semiQualified.substring(lastDollar + 1);
            semiQualified = semiQualified.replace('$', '.').substring(0, lastDollar);
            qualification = qualification.length() == 0 ? semiQualified : String.valueOf(qualification) + DOT + semiQualified;
        } else {
            simple = semiQualified;
        }
        return new String[]{qualification, simple};
    }

    private boolean qualifiedNameMatches(ClassNode type) {
        String[] nameAndQualification = this.extractNameAndQualification(type);
        String qualification = nameAndQualification[0];
        String name = nameAndQualification[1];
        if (!this.isCaseSensitive) {
            name = name.toLowerCase();
            qualification = qualification.toLowerCase();
        }
        boolean match = true;
        if (this.namePattern != null) {
            match = this.isCamelCase ? CharOperation.camelCaseMatch(this.namePattern, name.toCharArray()) : CharOperation.equals(this.namePattern, name.toCharArray());
        }
        if (match && this.qualificationPattern != null) {
            match = this.isCamelCase ? CharOperation.camelCaseMatch(this.qualificationPattern, qualification.toCharArray()) : CharOperation.equals(this.qualificationPattern, qualification.toCharArray());
        }
        return match;
    }

    private StartEnd getMatchLocation(ClassNode node, IJavaElement elt, int maybeStart, int maybeEnd) {
        CompilationUnit unit = (CompilationUnit)elt.getAncestor(5);
        if (unit != null && this.cachedContents == null) {
            this.cachedContents = unit.getContents();
        }
        if (this.cachedContents != null) {
            int nameLength = maybeEnd - maybeStart;
            int start = -1;
            int end = -1;
            String name = node.getName();
            int dollarIndex = name.lastIndexOf(36);
            if ((name = name.substring(dollarIndex + 1)).length() <= nameLength) {
                start = CharOperation.indexOf(name.toCharArray(), this.cachedContents, true, maybeStart, maybeEnd + 1);
                end = start + name.length();
            }
            if (start == -1) {
                String nameWithoutPackage = node.getNameWithoutPackage();
                start = CharOperation.indexOf(nameWithoutPackage.toCharArray(), this.cachedContents, true, maybeStart, maybeEnd + 1);
                end = start + nameWithoutPackage.length();
            }
            if (start == -1) {
                return null;
            }
            return new StartEnd(start, end);
        }
        return new StartEnd(node.getStart(), node.getEnd());
    }

    private boolean shouldAlwaysBeAccurate() {
        return this.requestor.getClass().getPackage().getName().indexOf("refactoring") != -1;
    }

    private int getAccuracy(TypeLookupResult.TypeConfidence confidence) {
        if (this.shouldAlwaysBeAccurate()) {
            return 0;
        }
        switch (confidence) {
            case EXACT: {
                return 0;
            }
        }
        return 1;
    }

    private class StartEnd {
        final int start;
        final int end;

        StartEnd(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

