/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.DefaultGroovyLogger;
import org.codehaus.groovy.eclipse.IGroovyLogger;
import org.codehaus.groovy.eclipse.TraceCategory;

public class GroovyLogManager {
    public static final GroovyLogManager manager = new GroovyLogManager();
    private IGroovyLogger[] loggers;
    private final IGroovyLogger defaultLogger = new DefaultGroovyLogger();
    private final Map<String, Long> timers = new HashMap<String, Long>();
    private boolean useDefaultLogger;

    private GroovyLogManager() {
    }

    public boolean addLogger(IGroovyLogger logger) {
        int newIndex;
        if (this.loggers == null) {
            this.loggers = new IGroovyLogger[1];
            newIndex = 0;
        } else {
            IGroovyLogger[] iGroovyLoggerArray = this.loggers;
            int n = this.loggers.length;
            int n2 = 0;
            while (n2 < n) {
                IGroovyLogger igl = iGroovyLoggerArray[n2];
                if (igl == logger) {
                    return false;
                }
                ++n2;
            }
            newIndex = this.loggers.length;
            IGroovyLogger[] newLoggers = new IGroovyLogger[newIndex + 1];
            System.arraycopy(this.loggers, 0, newLoggers, 0, newIndex);
            this.loggers = newLoggers;
        }
        this.loggers[newIndex] = logger;
        return true;
    }

    public boolean removeLogger(IGroovyLogger logger) {
        if (logger != null && this.loggers != null) {
            int foundIndex = -1;
            int i = 0;
            int n = this.loggers.length;
            while (i < n) {
                if (this.loggers[i] == logger) {
                    foundIndex = i;
                }
                ++i;
            }
            if (foundIndex >= 0) {
                if (this.loggers.length > 1) {
                    IGroovyLogger[] newLoggers = new IGroovyLogger[this.loggers.length - 1];
                    if (foundIndex > 0) {
                        System.arraycopy(this.loggers, 0, newLoggers, 0, foundIndex);
                    }
                    System.arraycopy(this.loggers, foundIndex + 1, newLoggers, foundIndex, this.loggers.length - foundIndex - 1);
                    this.loggers = newLoggers;
                } else {
                    this.loggers = null;
                }
                return true;
            }
        }
        return false;
    }

    public void logStart(String event) {
        this.timers.put(event, System.currentTimeMillis());
    }

    public void logEnd(String event, TraceCategory category) {
        this.logEnd(event, category, null);
    }

    public void logEnd(String event, TraceCategory category, String message) {
        Long then = this.timers.get(event);
        if (then != null) {
            if (this.hasLoggers()) {
                long now = System.currentTimeMillis();
                long elapsed = now - then;
                if (message != null && message.length() > 0) {
                    this.log(category, "Event complete: " + elapsed + "ms: " + event + " (" + message + ")");
                } else {
                    this.log(category, "Event complete: " + elapsed + "ms: " + event);
                }
            }
            this.timers.remove(event);
        }
    }

    public void log(String message) {
        this.log(TraceCategory.DEFAULT, message);
    }

    public void log(TraceCategory category, String message) {
        if (!this.hasLoggers()) {
            return;
        }
        if (this.loggers != null) {
            IGroovyLogger[] iGroovyLoggerArray = this.loggers;
            int n = this.loggers.length;
            int n2 = 0;
            while (n2 < n) {
                IGroovyLogger logger = iGroovyLoggerArray[n2];
                if (logger.isCategoryEnabled(category)) {
                    logger.log(category, message);
                }
                ++n2;
            }
        }
        if (this.useDefaultLogger) {
            this.defaultLogger.log(category, message);
        }
    }

    public boolean hasLoggers() {
        return this.loggers != null || this.useDefaultLogger;
    }

    public void setUseDefaultLogger(boolean useDefaultLogger) {
        this.useDefaultLogger = useDefaultLogger;
    }

    public void logException(TraceCategory cat, Throwable t) {
        if (this.hasLoggers()) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            this.log(cat, "Exception caught.\n" + writer.getBuffer());
        }
    }
}

