/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyIndexingVisitor
extends ClassCodeVisitorSupport {
    private ISourceElementRequestor requestor;
    private ModuleNode module;

    public GroovyIndexingVisitor(ISourceElementRequestor requestor) {
        this.requestor = requestor;
    }

    void doVisit(ModuleNode node, ImportReference pkg) {
        if (node == null) {
            return;
        }
        this.module = node;
        try {
            this.visitImports(node);
            for (ClassNode clazz : node.getClasses()) {
                this.visitClass(clazz);
            }
        }
        catch (RuntimeException e) {
            Util.log(e);
        }
    }

    public void visitImports(ModuleNode node) {
        if (node != null) {
            for (ImportNode importNode : GroovyUtils.getAllImportNodes(node)) {
                String importFieldName;
                this.visitAnnotations(importNode);
                if (importNode.getType() != null) {
                    this.handleType(importNode.getType(), false, true);
                }
                if ((importFieldName = importNode.getFieldName()) == null) continue;
                this.requestor.acceptUnknownReference(importFieldName.toCharArray(), 0);
            }
        }
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        super.visitMethodCallExpression(call);
        String methodStr = call.getMethodAsString();
        if (methodStr == null) {
            return;
        }
        char[] methodName = methodStr.toCharArray();
        int start = call.getStart();
        this.requestor.acceptFieldReference(methodName, start);
        int i = 0;
        while (i < 7) {
            this.requestor.acceptMethodReference(methodName, i, start);
            ++i;
        }
    }

    public void visitFieldExpression(FieldExpression expression) {
        super.visitFieldExpression(expression);
        this.requestor.acceptFieldReference(expression.getFieldName().toCharArray(), expression.getStart());
    }

    public void visitConstantExpression(ConstantExpression expression) {
        if (!(expression.isTrueExpression() || expression.isFalseExpression() || expression.isNullExpression() || expression.isEmptyStringExpression())) {
            char[] constName = expression.getValue().toString().toCharArray();
            int start = expression.getStart();
            this.requestor.acceptFieldReference(constName, start);
            int i = 0;
            while (i < 7) {
                this.requestor.acceptMethodReference(constName, i, start);
                ++i;
            }
        }
        super.visitConstantExpression(expression);
    }

    public void visitCastExpression(CastExpression expression) {
        this.handleType(expression.getType(), false, true);
    }

    public void visitClassExpression(ClassExpression expression) {
        this.handleType(expression.getType(), false, true);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        super.visitConstructorCallExpression(call);
        int i = 0;
        while (i < 10) {
            this.requestor.acceptConstructorReference(call.getType().getName().toCharArray(), i, call.getStart());
            ++i;
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.handleType(expression.getLeftExpression().getType(), false, true);
        expression.getRightExpression().visit(this);
    }

    public void visitVariableExpression(VariableExpression expression) {
        this.requestor.acceptUnknownReference(expression.getName().toCharArray(), expression.getStart());
    }

    public void visitField(FieldNode node) {
        super.visitField(node);
    }

    public void visitMethod(MethodNode node) {
        if (!node.isSynthetic()) {
            this.handleType(node.getReturnType(), false, true);
            Parameter[] parameterArray = node.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter param = parameterArray[n2];
                this.handleType(param.getType(), false, true);
                ++n2;
            }
        }
        super.visitMethod(node);
    }

    public void visitClass(ClassNode node) {
        if (!node.isSynthetic()) {
            this.handleType(node, false, false);
            this.handleType(node.getSuperClass(), false, true);
            ClassNode[] classNodeArray = node.getInterfaces();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode impls = classNodeArray[n2];
                this.handleType(impls, false, true);
                ++n2;
            }
        }
        this.visitAnnotations(node);
        node.visitContents(this);
        for (Statement element : node.getObjectInitializerStatements()) {
            element.visit(this);
        }
    }

    public void visitClosureExpression(ClosureExpression node) {
        if (node.getParameters() != null) {
            Parameter[] parameterArray = node.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter param = parameterArray[n2];
                this.handleType(param.getType(), false, true);
                ++n2;
            }
        }
        super.visitClosureExpression(node);
    }

    protected void visitAnnotation(AnnotationNode node) {
        this.handleType(node.getClassNode(), true, true);
        super.visitAnnotation(node);
    }

    private void handleType(ClassNode node, boolean isAnnotation, boolean useQualifiedName) {
        if (node == null) {
            Util.log(new Status(2, "org.eclipse.jdt.groovy.core", "GRECLIPSE-741: module: " + this.module.getDescription(), new RuntimeException()));
            return;
        }
        if (isAnnotation) {
            this.requestor.acceptAnnotationTypeReference(this.splitName(node, useQualifiedName), node.getStart(), node.getEnd());
        } else {
            ClassNode componentType = node.getComponentType();
            this.requestor.acceptTypeReference(this.splitName(componentType != null ? componentType : node, useQualifiedName), node.getStart(), node.getEnd());
        }
        if (node.isUsingGenerics() && node.getGenericsTypes() != null) {
            GenericsType[] genericsTypeArray = node.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode genType;
                GenericsType gen = genericsTypeArray[n2];
                ClassNode lowerBound = gen.getLowerBound();
                if (lowerBound != null) {
                    this.handleType(lowerBound, lowerBound.isAnnotationDefinition(), true);
                }
                if (gen.getUpperBounds() != null) {
                    ClassNode[] classNodeArray = gen.getUpperBounds();
                    int n3 = classNodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassNode upper = classNodeArray[n4];
                        if (!upper.getName().equals(node.getName())) {
                            this.handleType(upper, upper.isAnnotationDefinition(), true);
                        }
                        ++n4;
                    }
                }
                if ((genType = gen.getType()) != null && gen.getName().charAt(0) != '?') {
                    this.handleType(genType, genType.isAnnotationDefinition(), true);
                }
                ++n2;
            }
        }
    }

    private char[][] splitName(ClassNode node, boolean useQualifiedName) {
        String name = useQualifiedName ? node.getName() : node.getNameWithoutPackage();
        String[] nameArr = name.split("\\.");
        char[][] nameCharArr = new char[nameArr.length][];
        int i = 0;
        while (i < nameArr.length) {
            nameCharArr[i] = nameArr[i].toCharArray();
            ++i;
        }
        return nameCharArr;
    }
}

