/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.IntRange;
import groovy.lang.ObjectRange;
import groovy.transform.TypeChecked;
import groovy.transform.TypeCheckingMode;
import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.ReturnAdder;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.SecondPassExpression;
import org.codehaus.groovy.transform.stc.SharedVariableCollector;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.groovy.transform.stc.TypeCheckerPlugin;
import org.codehaus.groovy.transform.stc.TypeCheckerPluginFactory;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;
import org.codehaus.groovy.util.ListHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticTypeCheckingVisitor
extends ClassCodeVisitorSupport {
    private static final Object ERROR_COLLECTOR = ErrorCollector.class;
    private static final ClassNode ITERABLE_TYPE = ClassHelper.make(Iterable.class);
    private static final List<MethodNode> EMPTY_METHODNODE_LIST = Collections.emptyList();
    private static final ClassNode TYPECHECKED_CLASSNODE = ClassHelper.make(TypeChecked.class);
    private static final ClassNode[] TYPECHECKING_ANNOTATIONS = new ClassNode[]{TYPECHECKED_CLASSNODE};
    private static final ClassNode TYPECHECKING_INFO_NODE = ClassHelper.make(TypeChecked.TypeCheckingInfo.class);
    private static final ClassNode DGM_CLASSNODE = ClassHelper.make(DefaultGroovyMethods.class);
    private static final int CURRENT_SIGNATURE_PROTOCOL_VERSION = 1;
    private static final Expression CURRENT_SIGNATURE_PROTOCOL = new ConstantExpression(1, true);
    private static final MethodNode GET_DELEGATE = ClassHelper.CLOSURE_TYPE.getGetterMethod("getDelegate");
    private static final MethodNode GET_OWNER = ClassHelper.CLOSURE_TYPE.getGetterMethod("getOwner");
    private static final MethodNode GET_THISOBJECT = ClassHelper.CLOSURE_TYPE.getGetterMethod("getThisObject");
    public static final MethodNode CLOSURE_CALL_NO_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", Parameter.EMPTY_ARRAY);
    public static final MethodNode CLOSURE_CALL_ONE_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "arg")});
    public static final MethodNode CLOSURE_CALL_VARGS = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "args")});
    private SourceUnit source;
    private ClassNode classNode;
    private MethodNode methodNode;
    private Set<MethodNode> methodsToBeVisited = Collections.emptySet();
    private ErrorCollector errorCollector;
    private boolean isInStaticContext = false;
    private ClosureExpression closureExpression;
    private List<ClassNode> closureReturnTypes;
    private LinkedList<ClassNode> withReceiverList = new LinkedList();
    private ClassNode lastImplicitItType;
    private Map<VariableExpression, List<ClassNode>> ifElseForWhileAssignmentTracker = null;
    private Stack<Map<Object, List<ClassNode>>> temporaryIfBranchTypeInformation;
    private Set<MethodNode> alreadyVisitedMethods = new HashSet<MethodNode>();
    private final LinkedHashSet<SecondPassExpression> secondPassExpressions = new LinkedHashSet();
    private final Map<VariableExpression, List<ClassNode>> closureSharedVariablesAssignmentTypes = new HashMap<VariableExpression, List<ClassNode>>();
    private final TypeCheckerPluginFactory pluginFactory;
    private Map<Parameter, ClassNode> controlStructureVariables = new HashMap<Parameter, ClassNode>();
    private final Set<Long> reportedErrors = new TreeSet<Long>();
    private BinaryExpression currentBinaryExpression;
    private final ReturnAdder returnAdder = new ReturnAdder(new ReturnAdder.ReturnStatementListener(){

        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (returnStatement.getExpression().equals(ConstantExpression.NULL)) {
                return;
            }
            ClassNode returnType = StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
            if (StaticTypeCheckingVisitor.this.methodNode != null && StaticTypeCheckingVisitor.this.closureExpression == null) {
                ClassNode previousType;
                ClassNode mrt = StaticTypeCheckingVisitor.this.methodNode.getReturnType();
                if (!returnType.implementsInterface(mrt) && !returnType.isDerivedFrom(mrt)) {
                    returnType = mrt;
                }
                ClassNode inferred = (previousType = (ClassNode)StaticTypeCheckingVisitor.this.methodNode.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) == null ? returnType : WideningCategories.lowestUpperBound(returnType, previousType);
                StaticTypeCheckingVisitor.this.methodNode.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferred);
            }
        }
    });
    private final ReturnAdder closureReturnAdder = new ReturnAdder(new ReturnAdder.ReturnStatementListener(){

        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (returnStatement.getExpression().equals(ConstantExpression.NULL)) {
                return;
            }
            MethodNode currentNode = StaticTypeCheckingVisitor.this.methodNode;
            StaticTypeCheckingVisitor.this.methodNode = null;
            try {
                StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
                if (StaticTypeCheckingVisitor.this.closureExpression != null) {
                    StaticTypeCheckingVisitor.this.addClosureReturnType(StaticTypeCheckingVisitor.this.getType(returnStatement.getExpression()));
                }
            }
            finally {
                StaticTypeCheckingVisitor.this.methodNode = currentNode;
            }
        }
    });

    public StaticTypeCheckingVisitor(SourceUnit source, ClassNode cn, TypeCheckerPluginFactory pluginFactory) {
        this.source = source;
        this.classNode = cn;
        this.temporaryIfBranchTypeInformation = new Stack();
        this.pluginFactory = pluginFactory;
        this.errorCollector = source.getErrorCollector();
        this.pushTemporaryTypeInfo();
    }

    public StaticTypeCheckingVisitor(SourceUnit source, ClassNode cn) {
        this(source, cn, null);
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void setErrorCollector(ErrorCollector errorCollector) {
        this.errorCollector = errorCollector;
    }

    @Override
    public void visitClass(ClassNode node) {
        if (this.shouldSkipClassNode(node)) {
            return;
        }
        Object type = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (type != null) {
            this.errorCollector = new ErrorCollector(this.errorCollector.getConfiguration());
        }
        ClassNode oldCN = this.classNode;
        this.classNode = node;
        Set<MethodNode> oldVisitedMethod = this.alreadyVisitedMethods;
        this.alreadyVisitedMethods = new LinkedHashSet<MethodNode>();
        super.visitClass(node);
        Iterator<InnerClassNode> innerClasses = this.classNode.getInnerClasses();
        while (innerClasses.hasNext()) {
            InnerClassNode innerClassNode = innerClasses.next();
            this.visitClass(innerClassNode);
        }
        this.alreadyVisitedMethods = oldVisitedMethod;
        this.classNode = oldCN;
        node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, node);
        for (MethodNode methodNode : node.getMethods()) {
            methodNode.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
        }
        for (ConstructorNode constructorNode : node.getDeclaredConstructors()) {
            constructorNode.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
        }
    }

    protected boolean shouldSkipClassNode(ClassNode node) {
        return this.isSkipMode(node);
    }

    protected ClassNode[] getTypeCheckingAnnotations() {
        return TYPECHECKING_ANNOTATIONS;
    }

    public boolean isSkipMode(AnnotatedNode node) {
        if (node == null) {
            return false;
        }
        ClassNode[] classNodeArray = this.getTypeCheckingAnnotations();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode tca = classNodeArray[n2];
            List<AnnotationNode> annotations = node.getAnnotations(tca);
            if (annotations != null) {
                for (AnnotationNode annotation : annotations) {
                    Expression value = annotation.getMember("value");
                    if (value == null) continue;
                    if (value instanceof ConstantExpression) {
                        ConstantExpression ce = (ConstantExpression)value;
                        if (!TypeCheckingMode.SKIP.toString().equals(ce.getValue().toString())) continue;
                        return true;
                    }
                    if (!(value instanceof PropertyExpression)) continue;
                    PropertyExpression pe = (PropertyExpression)value;
                    if (!TypeCheckingMode.SKIP.toString().equals(pe.getPropertyAsString())) continue;
                    return true;
                }
            }
            ++n2;
        }
        if (node instanceof MethodNode) {
            return this.isSkipMode(node.getDeclaringClass());
        }
        return this.isSkippedInnerClass(node);
    }

    private boolean isSkippedInnerClass(AnnotatedNode node) {
        if (!(node instanceof InnerClassNode)) {
            return false;
        }
        MethodNode enclosingMethod = ((InnerClassNode)node).getEnclosingMethod();
        return enclosingMethod != null && this.isSkipMode(enclosingMethod);
    }

    @Override
    public void visitClassExpression(ClassExpression expression) {
        super.visitClassExpression(expression);
        ClassNode cn = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn == null) {
            this.storeType(expression, this.getType(expression));
        }
    }

    @Override
    public void visitVariableExpression(VariableExpression vexp) {
        super.visitVariableExpression(vexp);
        if (vexp != VariableExpression.THIS_EXPRESSION && vexp != VariableExpression.SUPER_EXPRESSION) {
            if (vexp.getName().equals("this")) {
                this.storeType(vexp, this.classNode);
            }
            if (vexp.getName().equals("super")) {
                this.storeType(vexp, this.classNode.getSuperClass());
            }
            if (this.closureExpression != null && (vexp.getName().equals("owner") || vexp.getName().equals("delegate") || vexp.getName().equals("thisObject"))) {
                this.storeType(vexp, this.classNode);
                return;
            }
        }
        if (vexp.getAccessedVariable() instanceof DynamicVariable) {
            ClassNode type;
            TypeCheckerPlugin plugin;
            DynamicVariable dyn = (DynamicVariable)vexp.getAccessedVariable();
            String dynName = dyn.getName();
            LinkedList<ClassNode> checkList = new LinkedList<ClassNode>(this.withReceiverList);
            checkList.add(this.classNode);
            for (ClassNode node : checkList) {
                if (node.getProperty(dynName) != null) {
                    this.storeType(vexp, node.getProperty(dynName).getType());
                    return;
                }
                if (node.getField(dynName) != null) {
                    this.storeType(vexp, node.getField(dynName).getType());
                    return;
                }
                Set<ClassNode> allInterfaces = node.getAllInterfaces();
                for (ClassNode intf : allInterfaces) {
                    FieldNode field = intf.getField(dynName);
                    if (field == null || !field.isStatic() || !field.isFinal()) continue;
                    this.storeType(vexp, field.getOriginType());
                    return;
                }
            }
            if (this.pluginFactory != null && (plugin = this.pluginFactory.getTypeCheckerPlugin(this.classNode)) != null && (type = plugin.resolveDynamicVariableType(dyn)) != null) {
                this.storeType(vexp, type);
                return;
            }
            this.addStaticTypeError("The variable [" + vexp.getName() + "] is undeclared.", vexp);
        }
    }

    @Override
    public void visitPropertyExpression(PropertyExpression pexp) {
        super.visitPropertyExpression(pexp);
        if (!this.existsProperty(pexp, true)) {
            if (this.currentBinaryExpression != null && this.currentBinaryExpression.getLeftExpression() == pexp && StaticTypeCheckingSupport.isAssignment(this.currentBinaryExpression.getOperation().getType()) && this.hasSetter(pexp)) {
                return;
            }
            Expression objectExpression = pexp.getObjectExpression();
            this.addStaticTypeError("No such property: " + pexp.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, this.getType(objectExpression)).toString(false), pexp);
        }
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression) {
        super.visitAttributeExpression(expression);
        if (!this.existsProperty(expression, true)) {
            Expression objectExpression = expression.getObjectExpression();
            this.addStaticTypeError("No such property: " + expression.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, objectExpression.getType()), expression);
        }
    }

    @Override
    public void visitRangeExpression(RangeExpression expression) {
        super.visitRangeExpression(expression);
        ClassNode fromType = ClassHelper.getWrapper(this.getType(expression.getFrom()));
        ClassNode toType = ClassHelper.getWrapper(this.getType(expression.getTo()));
        if (ClassHelper.Integer_TYPE.equals(fromType) && ClassHelper.Integer_TYPE.equals(toType)) {
            this.storeType(expression, ClassHelper.make(IntRange.class));
        } else {
            this.storeType(expression, ClassHelper.make(ObjectRange.class));
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        BinaryExpression oldBinaryExpression = this.currentBinaryExpression;
        this.currentBinaryExpression = expression;
        try {
            boolean isEmptyDeclaration;
            VariableExpression leftVar;
            ClassNode resultType;
            super.visitBinaryExpression(expression);
            Expression leftExpression = expression.getLeftExpression();
            ClassNode lType = this.getType(leftExpression);
            Expression rightExpression = expression.getRightExpression();
            ClassNode rType = this.getType(rightExpression);
            if (StaticTypeCheckingVisitor.isNullConstant(rightExpression) && !ClassHelper.isPrimitiveType(lType)) {
                rType = StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE;
            }
            int op = expression.getOperation().getType();
            BinaryExpression reversedBinaryExpression = new BinaryExpression(rightExpression, expression.getOperation(), leftExpression);
            ClassNode classNode = resultType = op == 573 ? this.getResultType(rType, op, lType, reversedBinaryExpression) : this.getResultType(lType, op, rType, expression);
            if (op == 573) {
                this.storeTargetMethod(expression, (MethodNode)reversedBinaryExpression.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            }
            if (resultType == null) {
                resultType = lType;
            }
            if (leftExpression instanceof VariableExpression && (leftVar = (VariableExpression)leftExpression).isClosureSharedVariable()) {
                this.secondPassExpressions.add(new SecondPassExpression(expression));
            }
            if (lType.isUsingGenerics() && StaticTypeCheckingSupport.missesGenericsTypes(resultType) && StaticTypeCheckingSupport.isAssignment(op)) {
                ClassNode completedType;
                resultType = completedType = GenericsUtils.parameterizeType(lType, resultType.getPlainNodeReference());
            }
            if (StaticTypeCheckingSupport.isArrayOp(op) && oldBinaryExpression != null && oldBinaryExpression.getLeftExpression() == expression && StaticTypeCheckingSupport.isAssignment(oldBinaryExpression.getOperation().getType()) && !lType.isArray()) {
                ClassNode[] arguments = new ClassNode[]{rType, this.getType(oldBinaryExpression.getRightExpression())};
                List<MethodNode> nodes = this.findMethod(lType.redirect(), "putAt", arguments);
                if (nodes.size() == 1) {
                    this.typeCheckMethodsWithGenerics(lType, arguments, nodes.get(0), expression);
                }
            }
            boolean bl = isEmptyDeclaration = expression instanceof DeclarationExpression && rightExpression instanceof EmptyExpression;
            if (!isEmptyDeclaration) {
                this.storeType(expression, resultType);
            }
            if (!isEmptyDeclaration && StaticTypeCheckingSupport.isAssignment(op)) {
                Variable accessedVariable;
                if (rightExpression instanceof ConstructorCallExpression) {
                    this.inferDiamondType((ConstructorCallExpression)rightExpression, lType);
                }
                ClassNode originType = this.getOriginalDeclarationType(leftExpression);
                this.typeCheckAssignment(expression, leftExpression, originType, rightExpression, resultType);
                if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.getWrapper(resultType), ClassHelper.getWrapper(originType))) {
                    resultType = originType;
                } else if (lType.isUsingGenerics() && !lType.isEnum() && this.hasRHSIncompleteGenericTypeInfo(resultType)) {
                    resultType = lType;
                }
                if (this.ifElseForWhileAssignmentTracker != null && leftExpression instanceof VariableExpression && !StaticTypeCheckingVisitor.isNullConstant(rightExpression) && (accessedVariable = ((VariableExpression)leftExpression).getAccessedVariable()) instanceof VariableExpression) {
                    VariableExpression var = (VariableExpression)accessedVariable;
                    List<ClassNode> types = this.ifElseForWhileAssignmentTracker.get(var);
                    if (types == null) {
                        types = new LinkedList<ClassNode>();
                        ClassNode type = (ClassNode)var.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        if (type != null) {
                            types.add(type);
                        }
                        this.ifElseForWhileAssignmentTracker.put(var, types);
                    }
                    types.add(resultType);
                }
                this.storeType(leftExpression, resultType);
                if (leftExpression instanceof VariableExpression) {
                    Variable targetVariable;
                    if (rightExpression instanceof ClosureExpression) {
                        Parameter[] parameters = ((ClosureExpression)rightExpression).getParameters();
                        leftExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, parameters);
                    } else if (rightExpression instanceof VariableExpression && ((VariableExpression)rightExpression).getAccessedVariable() instanceof Expression && ((Expression)((Object)((VariableExpression)rightExpression).getAccessedVariable())).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS) != null && (targetVariable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)leftExpression)) instanceof ASTNode) {
                        ((ASTNode)((Object)targetVariable)).putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, ((Expression)((Object)((VariableExpression)rightExpression).getAccessedVariable())).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS));
                    }
                }
            } else if (op == 544) {
                this.pushInstanceOfTypeInfo(leftExpression, rightExpression);
            }
        }
        finally {
            this.currentBinaryExpression = oldBinaryExpression;
        }
    }

    private ClassNode getOriginalDeclarationType(Expression lhs) {
        if (lhs instanceof VariableExpression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)lhs);
            if (var instanceof DynamicVariable) {
                return this.getType(lhs);
            }
            return var.getOriginType();
        }
        if (lhs instanceof FieldExpression) {
            return ((FieldExpression)lhs).getField().getOriginType();
        }
        return this.getType(lhs);
    }

    private void inferDiamondType(ConstructorCallExpression cce, ClassNode lType) {
        ClassNode node = cce.getType();
        if (node.isUsingGenerics() && node instanceof InnerClassNode && ((InnerClassNode)node).isAnonymous() && (node.getGenericsTypes() == null || node.getGenericsTypes().length == 0) && lType.isUsingGenerics()) {
            this.addStaticTypeError("Cannot use diamond <> with anonymous inner classes", cce);
        } else if (node.isUsingGenerics() && node.getGenericsTypes() != null && node.getGenericsTypes().length == 0) {
            ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(cce.getArguments());
            if (argumentListExpression.getExpressions().isEmpty()) {
                GenericsType[] genericsTypes = lType.getGenericsTypes();
                GenericsType[] copy = new GenericsType[genericsTypes.length];
                int i = 0;
                while (i < genericsTypes.length) {
                    GenericsType genericsType = genericsTypes[i];
                    copy[i] = new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(genericsType.getType()), genericsType.getUpperBounds(), genericsType.getLowerBound());
                    ++i;
                }
                node.setGenericsTypes(copy);
            } else {
                ClassNode type = this.getType(argumentListExpression.getExpression(0));
                if (type.isUsingGenerics()) {
                    GenericsType[] genericsTypes = type.getGenericsTypes();
                    GenericsType[] copy = new GenericsType[genericsTypes.length];
                    int i = 0;
                    while (i < genericsTypes.length) {
                        GenericsType genericsType = genericsTypes[i];
                        copy[i] = new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(genericsType.getType()), genericsType.getUpperBounds(), genericsType.getLowerBound());
                        ++i;
                    }
                    node.setGenericsTypes(copy);
                }
            }
            this.storeType(cce, node);
        }
    }

    private void pushInstanceOfTypeInfo(Expression objectOfInstanceOf, Expression typeExpression) {
        Object key;
        Map<Object, List<ClassNode>> tempo = this.temporaryIfBranchTypeInformation.peek();
        List<ClassNode> potentialTypes = tempo.get(key = this.extractTemporaryTypeInfoKey(objectOfInstanceOf));
        if (potentialTypes == null) {
            potentialTypes = new LinkedList<ClassNode>();
            tempo.put(key, potentialTypes);
        }
        potentialTypes.add(typeExpression.getType());
    }

    private void typeCheckAssignment(BinaryExpression assignmentExpression, Expression leftExpression, ClassNode leftExpressionType, Expression rightExpression, ClassNode inferredRightExpressionType) {
        ClassNode leftRedirect = StaticTypeCheckingSupport.isArrayAccessExpression(leftExpression) || leftExpression instanceof PropertyExpression || leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).getAccessedVariable() instanceof DynamicVariable ? leftExpressionType : (leftExpression instanceof VariableExpression && ClassHelper.isPrimitiveType(((VariableExpression)leftExpression).getOriginType()) ? leftExpressionType : leftExpression.getType().redirect());
        if (leftExpression instanceof TupleExpression) {
            if (!(rightExpression instanceof ListExpression)) {
                this.addStaticTypeError("Multiple assignments without list expressions on the right hand side are unsupported in static type checking mode", rightExpression);
                return;
            }
            TupleExpression tuple = (TupleExpression)leftExpression;
            ListExpression list = (ListExpression)rightExpression;
            List<Expression> listExpressions = list.getExpressions();
            List<Expression> tupleExpressions = tuple.getExpressions();
            if (listExpressions.size() < tupleExpressions.size()) {
                this.addStaticTypeError("Incorrect number of values. Expected:" + tupleExpressions.size() + " Was:" + listExpressions.size(), list);
                return;
            }
            int i = 0;
            int tupleExpressionsSize = tupleExpressions.size();
            while (i < tupleExpressionsSize) {
                ClassNode tupleType;
                Expression tupleExpression = tupleExpressions.get(i);
                Expression listExpression = listExpressions.get(i);
                ClassNode elemType = this.getType(listExpression);
                if (!StaticTypeCheckingSupport.isAssignableTo(elemType, tupleType = this.getType(tupleExpression))) {
                    this.addStaticTypeError("Cannot assign value of type " + elemType.toString(false) + " to variable of type " + tupleType.toString(false), rightExpression);
                    break;
                }
                ++i;
            }
            return;
        }
        ClassNode wrappedRHS = inferredRightExpressionType;
        if (leftExpression instanceof PropertyExpression && ((PropertyExpression)leftExpression).isSpreadSafe()) {
            wrappedRHS = ClassHelper.LIST_TYPE.getPlainNodeReference();
            wrappedRHS.setGenericsTypes(new GenericsType[]{new GenericsType(ClassHelper.getWrapper(inferredRightExpressionType))});
        }
        boolean compatible = StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect, wrappedRHS, rightExpression);
        if (leftExpression.getNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY) != null && leftExpression instanceof PropertyExpression) {
            this.addStaticTypeError("Cannot set read-only property: " + ((PropertyExpression)leftExpression).getPropertyAsString(), leftExpression);
        }
        if (!compatible) {
            this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression.getRightExpression());
        } else {
            boolean incomplete;
            ClassNode[] args;
            ArgumentListExpression argList;
            Object type;
            if (rightExpression instanceof ClosureExpression && (type = rightExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) != null) {
                leftExpression.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, type);
            }
            boolean possibleLooseOfPrecision = false;
            if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(inferredRightExpressionType) && (possibleLooseOfPrecision = StaticTypeCheckingSupport.checkPossibleLooseOfPrecision(leftRedirect, inferredRightExpressionType, rightExpression))) {
                this.addStaticTypeError("Possible loose of precision from " + inferredRightExpressionType + " to " + leftRedirect, rightExpression);
            }
            if (!possibleLooseOfPrecision && leftExpressionType.isArray()) {
                ClassNode leftComponentType = leftExpressionType.getComponentType();
                ClassNode rightRedirect = rightExpression.getType().redirect();
                if (rightRedirect.isArray()) {
                    ClassNode rightComponentType = rightRedirect.getComponentType();
                    if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType, rightComponentType)) {
                        this.addStaticTypeError("Cannot assign value of type " + rightComponentType.toString(false) + " into array of type " + leftExpressionType.toString(false), assignmentExpression.getRightExpression());
                    }
                } else if (rightExpression instanceof ListExpression) {
                    for (Expression element : ((ListExpression)rightExpression).getExpressions()) {
                        ClassNode rightComponentType = element.getType().redirect();
                        if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType, rightComponentType) || StaticTypeCheckingVisitor.isNullConstant(element) && !ClassHelper.isPrimitiveType(leftComponentType)) continue;
                        this.addStaticTypeError("Cannot assign value of type " + rightComponentType.toString(false) + " into array of type " + leftExpressionType.toString(false), assignmentExpression.getRightExpression());
                    }
                }
            }
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(leftRedirect, ClassHelper.LIST_TYPE) && rightExpression instanceof ListExpression) {
                argList = new ArgumentListExpression(((ListExpression)rightExpression).getExpressions());
                args = this.getArgumentTypes(argList);
                this.checkGroovyStyleConstructor(leftRedirect, args);
            } else if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, leftRedirect) && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, ClassHelper.LIST_TYPE) && !StaticTypeCheckingSupport.isWildcardLeftHandSide(leftExpressionType)) {
                this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression);
            }
            if (!(StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(leftRedirect, ClassHelper.MAP_TYPE) || !(rightExpression instanceof MapExpression) || leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).isDynamicTyped())) {
                argList = new ArgumentListExpression(rightExpression);
                args = this.getArgumentTypes(argList);
                this.checkGroovyStyleConstructor(leftRedirect, args);
                MapExpression mapExpression = (MapExpression)rightExpression;
                this.checkGroovyConstructorMap(leftExpression, leftRedirect, mapExpression);
            }
            if (leftExpressionType.isUsingGenerics() && !leftExpressionType.isEnum() && !(incomplete = this.hasRHSIncompleteGenericTypeInfo(wrappedRHS))) {
                GenericsType gt = GenericsUtils.buildWildcardType(leftExpressionType);
                if (!(StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE.equals(wrappedRHS) || gt.isCompatibleWith(wrappedRHS) || StaticTypeCheckingVisitor.isNullConstant(rightExpression))) {
                    if (StaticTypeCheckingSupport.isParameterizedWithString(leftExpressionType) && StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(wrappedRHS)) {
                        this.addStaticTypeError("You are trying to use a GString in place of a String in a type which explicitly declares accepting String. Make sure to call toString() on all GString values.", assignmentExpression.getRightExpression());
                    } else {
                        this.addStaticTypeError("Incompatible generic argument types. Cannot assign " + wrappedRHS.toString(false) + " to: " + leftExpressionType.toString(false), assignmentExpression.getRightExpression());
                    }
                }
            }
        }
    }

    private void checkGroovyConstructorMap(Expression receiver, ClassNode receiverType, MapExpression mapExpression) {
        for (MapEntryExpression entryExpression : mapExpression.getMapEntryExpressions()) {
            Expression keyExpr = entryExpression.getKeyExpression();
            if (!(keyExpr instanceof ConstantExpression)) {
                this.addStaticTypeError("Dynamic keys in map-style constructors are unsupported in static type checking", keyExpr);
                continue;
            }
            AtomicReference<ClassNode> lookup = new AtomicReference<ClassNode>();
            boolean hasProperty = this.existsProperty(new PropertyExpression((Expression)new VariableExpression("_", receiverType), keyExpr.getText()), false, new PropertyLookupVisitor(lookup));
            if (!hasProperty) {
                this.addStaticTypeError("No such property: " + keyExpr.getText() + " for class: " + receiverType.getName(), receiver);
                continue;
            }
            ClassNode valueType = this.getType(entryExpression.getValueExpression());
            if (StaticTypeCheckingSupport.isAssignableTo(valueType, lookup.get())) continue;
            this.addAssignmentError(lookup.get(), valueType, entryExpression);
        }
    }

    private boolean hasRHSIncompleteGenericTypeInfo(ClassNode inferredRightExpressionType) {
        boolean replaceType = false;
        GenericsType[] genericsTypes = inferredRightExpressionType.getGenericsTypes();
        if (genericsTypes != null) {
            GenericsType[] genericsTypeArray = genericsTypes;
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (genericsType.isPlaceholder()) {
                    replaceType = true;
                    break;
                }
                ++n2;
            }
        }
        return replaceType;
    }

    private void checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments) {
        if (node.equals(ClassHelper.OBJECT_TYPE) || node.equals(ClassHelper.DYNAMIC_TYPE)) {
            return;
        }
        List<ConstructorNode> constructors = node.getDeclaredConstructors();
        if (constructors.isEmpty() && arguments.length == 0) {
            return;
        }
        List<MethodNode> constructorList = this.findMethod(node, "<init>", arguments);
        if (constructorList.isEmpty()) {
            this.addStaticTypeError("No matching constructor found: " + node + StaticTypeCheckingSupport.toMethodParametersString("<init>", arguments), this.classNode);
        }
    }

    private Object extractTemporaryTypeInfoKey(Expression expression) {
        return expression instanceof VariableExpression ? StaticTypeCheckingSupport.findTargetVariable((VariableExpression)expression) : expression.getText();
    }

    private ClassNode findCurrentInstanceOfClass(Expression expr, ClassNode type) {
        List<ClassNode> nodes;
        if (!this.temporaryIfBranchTypeInformation.empty() && (nodes = this.getTemporaryTypesForExpression(expr)) != null && nodes.size() == 1) {
            return nodes.get(0);
        }
        return type;
    }

    private boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly) {
        return this.existsProperty(pexp, checkForReadOnly, null);
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly, ClassCodeVisitorSupport visitor) {
        String propertyName;
        List<ClassNode> classNodes;
        Expression objectExpression = pexp.getObjectExpression();
        ClassNode objectExpressionType = this.getType(objectExpression);
        boolean staticProperty = false;
        if (objectExpressionType.isArray() && "length".equals(pexp.getPropertyAsString())) {
            if (visitor != null) {
                PropertyNode node = new PropertyNode("length", 17, ClassHelper.int_TYPE, objectExpressionType, null, null, null);
                this.storeType(pexp, ClassHelper.int_TYPE);
                visitor.visitProperty(node);
            }
            return true;
        }
        LinkedList<ClassNode> tests = new LinkedList<ClassNode>();
        tests.add(objectExpressionType);
        if (objectExpressionType.equals(ClassHelper.CLASS_Type) && objectExpressionType.getGenericsTypes() != null) {
            tests.add(0, objectExpressionType.getGenericsTypes()[0].getType());
            staticProperty = true;
        }
        if (!this.temporaryIfBranchTypeInformation.empty() && (classNodes = this.getTemporaryTypesForExpression(objectExpression)) != null) {
            tests.addAll(classNodes);
        }
        if (this.lastImplicitItType != null && pexp.getObjectExpression() instanceof VariableExpression && ((VariableExpression)pexp.getObjectExpression()).getName().equals("it")) {
            tests.add(this.lastImplicitItType);
        }
        if ((propertyName = pexp.getPropertyAsString()) == null) {
            return false;
        }
        String capName = MetaClassHelper.capitalize(propertyName);
        boolean isAttributeExpression = pexp instanceof AttributeExpression;
        if (objectExpressionType.isInterface()) {
            tests.add(ClassHelper.OBJECT_TYPE);
        }
        for (ClassNode testClass : tests) {
            List<MethodNode> methodNodes;
            List<MethodNode> methods;
            ClassNode cn;
            FieldNode field;
            Object getter;
            Set<ClassNode> allInterfaces;
            LinkedList<ClassNode> queue = new LinkedList<ClassNode>();
            queue.add(testClass);
            if (testClass.isInterface()) {
                allInterfaces = testClass.getAllInterfaces();
                for (ClassNode intf : allInterfaces) {
                    queue.add(GenericsUtils.parameterizeType(testClass, intf));
                }
            }
            while (!queue.isEmpty()) {
                MethodNode setterMethod;
                FieldNode field2;
                ClassNode current = (ClassNode)queue.removeFirst();
                PropertyNode propertyNode = (current = current.redirect()).getProperty(propertyName);
                if (propertyNode != null) {
                    if (visitor != null) {
                        visitor.visitProperty(propertyNode);
                    }
                    this.storeType(pexp, propertyNode.getOriginType());
                    return true;
                }
                if (objectExpression instanceof VariableExpression && ((VariableExpression)objectExpression).isThisExpression() && (field2 = current.getDeclaredField(propertyName)) != null) {
                    if (visitor != null) {
                        visitor.visitField(field2);
                    }
                    this.storeInferredTypeForPropertyExpression(pexp, field2.getOriginType());
                    this.storeType(pexp, field2.getOriginType());
                    return true;
                }
                getter = current.getGetterMethod("get" + capName);
                if (getter == null) {
                    getter = current.getGetterMethod("is" + capName);
                }
                if (getter != null && (!staticProperty || ClassHelper.CLASS_Type.equals(current) || ((MethodNode)getter).isStatic()) && (setterMethod = current.getSetterMethod("set" + capName)) != null) {
                    if (visitor != null) {
                        visitor.visitMethod((MethodNode)getter);
                    }
                    ClassNode cn2 = this.inferReturnTypeGenerics(current, (MethodNode)getter, ArgumentListExpression.EMPTY_ARGUMENTS);
                    this.storeInferredTypeForPropertyExpression(pexp, cn2);
                    return true;
                }
                if (getter == null && checkForReadOnly && (field = current.getDeclaredField(propertyName)) != null) {
                    if (visitor != null) {
                        visitor.visitField(field);
                    }
                    this.storeInferredTypeForPropertyExpression(pexp, field.getOriginType());
                    this.storeType(pexp, field.getOriginType());
                    return true;
                }
                if (current.getSuperClass() == null) continue;
                queue.add(current.getSuperClass());
            }
            if (checkForReadOnly) {
                queue = new LinkedList();
                queue.add(testClass);
                allInterfaces = testClass.getAllInterfaces();
                for (ClassNode intf : allInterfaces) {
                    queue.add(GenericsUtils.parameterizeType(testClass, intf));
                }
                while (!queue.isEmpty()) {
                    PropertyNode result;
                    TypeCheckerPlugin plugin;
                    ClassNode current = (ClassNode)queue.removeFirst();
                    getter = current.getGetterMethod("get" + capName);
                    if (getter == null) {
                        getter = current.getGetterMethod("is" + capName);
                    }
                    if (getter != null && (!staticProperty || ClassHelper.CLASS_Type.equals(current) || ((MethodNode)getter).isStatic())) {
                        if (visitor != null) {
                            visitor.visitMethod((MethodNode)getter);
                        }
                        pexp.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, Boolean.TRUE);
                        cn = this.inferReturnTypeGenerics(current, (MethodNode)getter, ArgumentListExpression.EMPTY_ARGUMENTS);
                        this.storeInferredTypeForPropertyExpression(pexp, cn);
                        return true;
                    }
                    if (getter != null && (field = current.getDeclaredField(propertyName)) != null) {
                        if (visitor != null) {
                            visitor.visitField(field);
                        }
                        this.storeInferredTypeForPropertyExpression(pexp, field.getOriginType());
                        this.storeType(pexp, field.getOriginType());
                        return true;
                    }
                    if (this.pluginFactory != null && (plugin = this.pluginFactory.getTypeCheckerPlugin(this.classNode)) != null && (result = plugin.resolveProperty(current, propertyName)) != null) {
                        if (visitor != null) {
                            visitor.visitProperty(result);
                        }
                        this.storeInferredTypeForPropertyExpression(pexp, result.getType());
                        return true;
                    }
                    if (isAttributeExpression || current.getSuperClass() == null) continue;
                    queue.add(current.getSuperClass());
                }
            }
            if ((methods = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(testClass, "get" + capName, ClassNode.EMPTY_ARRAY)).isEmpty() || (methodNodes = StaticTypeCheckingSupport.chooseBestMethod(testClass, methods, ClassNode.EMPTY_ARRAY)).size() != 1) continue;
            getter = methodNodes.get(0);
            if (visitor != null) {
                visitor.visitMethod((MethodNode)getter);
            }
            cn = this.inferReturnTypeGenerics(testClass, (MethodNode)getter, ArgumentListExpression.EMPTY_ARGUMENTS);
            this.storeInferredTypeForPropertyExpression(pexp, cn);
            return true;
        }
        for (ClassNode testClass : tests) {
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.MAP_TYPE) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.LIST_TYPE)) continue;
            if (visitor != null) {
                ClassNode intf;
                ClassNode propertyType = ClassHelper.OBJECT_TYPE;
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(objectExpressionType, ClassHelper.MAP_TYPE)) {
                    intf = GenericsUtils.parameterizeType(objectExpressionType, ClassHelper.MAP_TYPE.getPlainNodeReference());
                    if (intf.isUsingGenerics() && intf.getGenericsTypes() != null && intf.getGenericsTypes().length == 2) {
                        propertyType = intf.getGenericsTypes()[1].getType();
                    }
                } else {
                    AtomicReference<ClassNode> result;
                    PropertyExpression subExp;
                    intf = GenericsUtils.parameterizeType(objectExpressionType, ClassHelper.LIST_TYPE.getPlainNodeReference());
                    if (intf.isUsingGenerics() && intf.getGenericsTypes() != null && intf.getGenericsTypes().length == 1 && this.existsProperty(subExp = new PropertyExpression((Expression)new VariableExpression("{}", intf.getGenericsTypes()[0].getType()), pexp.getPropertyAsString()), checkForReadOnly, new PropertyLookupVisitor(result = new AtomicReference<ClassNode>()))) {
                        intf = ClassHelper.LIST_TYPE.getPlainNodeReference();
                        intf.setGenericsTypes(new GenericsType[]{new GenericsType(ClassHelper.getWrapper(result.get()))});
                        propertyType = intf;
                    }
                }
                PropertyNode node = new PropertyNode(propertyName, 1, propertyType, objectExpressionType, null, null, null);
                visitor.visitProperty(node);
            }
            return true;
        }
        return false;
    }

    private void storeInferredTypeForPropertyExpression(PropertyExpression pexp, ClassNode flatInferredType) {
        if (pexp.isSpreadSafe()) {
            ClassNode list = ClassHelper.LIST_TYPE.getPlainNodeReference();
            list.setGenericsTypes(new GenericsType[]{new GenericsType(flatInferredType)});
            this.storeType(pexp, list);
        } else {
            this.storeType(pexp, flatInferredType);
        }
    }

    protected boolean hasSetter(PropertyExpression pexp) {
        String propertyName;
        List<ClassNode> classNodes;
        Expression objectExpression = pexp.getObjectExpression();
        ClassNode clazz = this.getType(objectExpression);
        LinkedList<ClassNode> tests = new LinkedList<ClassNode>();
        tests.add(clazz);
        if (clazz.equals(ClassHelper.CLASS_Type) && clazz.getGenericsTypes() != null) {
            tests.add(0, clazz.getGenericsTypes()[0].getType());
        }
        if (!this.temporaryIfBranchTypeInformation.empty() && (classNodes = this.getTemporaryTypesForExpression(objectExpression)) != null) {
            tests.addAll(classNodes);
        }
        if (this.lastImplicitItType != null && pexp.getObjectExpression() instanceof VariableExpression && ((VariableExpression)pexp.getObjectExpression()).getName().equals("it")) {
            tests.add(this.lastImplicitItType);
        }
        if ((propertyName = pexp.getPropertyAsString()) == null) {
            return false;
        }
        String capName = MetaClassHelper.capitalize(propertyName);
        boolean isAttributeExpression = pexp instanceof AttributeExpression;
        if (clazz.isInterface()) {
            tests.add(ClassHelper.OBJECT_TYPE);
        }
        for (ClassNode testClass : tests) {
            LinkedList<ClassNode> queue = new LinkedList<ClassNode>();
            queue.add(testClass);
            if (testClass.isInterface()) {
                queue.addAll(testClass.getAllInterfaces());
            }
            while (!queue.isEmpty()) {
                ClassNode current = (ClassNode)queue.removeFirst();
                MethodNode setterMethod = (current = current.redirect()).getSetterMethod("set" + capName, false);
                if (setterMethod != null) {
                    this.storeType(pexp, setterMethod.getParameters()[0].getType());
                    return true;
                }
                if (isAttributeExpression || current.getSuperClass() == null) continue;
                queue.add(current.getSuperClass());
            }
        }
        return false;
    }

    @Override
    public void visitField(FieldNode node) {
        boolean osc = this.isInStaticContext;
        try {
            this.isInStaticContext = node.isInStaticContext();
            super.visitField(node);
            Expression init = node.getInitialExpression();
            if (init != null) {
                FieldExpression left = new FieldExpression(node);
                BinaryExpression bexp = new BinaryExpression(left, Token.newSymbol("=", node.getLineNumber(), node.getColumnNumber()), init);
                bexp.setSourcePosition(init);
                this.typeCheckAssignment(bexp, left, node.getOriginType(), init, this.getType(init));
                if (init instanceof ConstructorCallExpression) {
                    this.inferDiamondType((ConstructorCallExpression)init, node.getOriginType());
                }
            }
        }
        finally {
            this.isInStaticContext = osc;
        }
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        HashMap<VariableExpression, ClassNode> varOrigType = new HashMap<VariableExpression, ClassNode>();
        forLoop.getLoopBlock().visit(new VariableExpressionTypeMemoizer(varOrigType));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        Expression collectionExpression = forLoop.getCollectionExpression();
        if (collectionExpression instanceof ClosureListExpression) {
            super.visitForLoop(forLoop);
        } else {
            collectionExpression.visit(this);
            ClassNode collectionType = this.getType(collectionExpression);
            ClassNode componentType = StaticTypeCheckingVisitor.inferLoopElementType(collectionType);
            ClassNode forLoopVariableType = forLoop.getVariableType();
            if (ClassHelper.getUnwrapper(componentType) == forLoopVariableType) {
                componentType = forLoopVariableType;
            }
            if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(forLoopVariableType, componentType)) {
                this.addStaticTypeError("Cannot loop with element of type " + forLoopVariableType.toString(false) + " with collection of type " + collectionType.toString(false), forLoop);
            }
            if (forLoopVariableType != ClassHelper.DYNAMIC_TYPE) {
                componentType = forLoopVariableType;
            }
            this.controlStructureVariables.put(forLoop.getVariable(), componentType);
            try {
                super.visitForLoop(forLoop);
            }
            finally {
                this.controlStructureVariables.remove(forLoop.getVariable());
            }
        }
        boolean typeChanged = this.isSecondPassNeededForControlStructure(varOrigType, oldTracker);
        if (typeChanged) {
            this.visitForLoop(forLoop);
        }
    }

    public static ClassNode inferLoopElementType(ClassNode collectionType) {
        ClassNode componentType = collectionType.getComponentType();
        if (componentType == null) {
            if (collectionType.implementsInterface(ITERABLE_TYPE)) {
                ClassNode intf = GenericsUtils.parameterizeType(collectionType, ITERABLE_TYPE);
                GenericsType[] genericsTypes = intf.getGenericsTypes();
                componentType = genericsTypes[0].getType();
            } else {
                componentType = collectionType == ClassHelper.STRING_TYPE ? ClassHelper.Character_TYPE : ClassHelper.OBJECT_TYPE;
            }
        }
        return componentType;
    }

    private boolean isSecondPassNeededForControlStructure(Map<VariableExpression, ClassNode> varOrigType, Map<VariableExpression, List<ClassNode>> oldTracker) {
        Map<VariableExpression, ClassNode> assignedVars = this.popAssignmentTracking(oldTracker);
        for (Map.Entry<VariableExpression, ClassNode> entry : assignedVars.entrySet()) {
            Variable key = StaticTypeCheckingSupport.findTargetVariable(entry.getKey());
            if (!(key instanceof VariableExpression)) continue;
            ClassNode origType = varOrigType.get((VariableExpression)key);
            ClassNode newType = entry.getValue();
            if (!varOrigType.containsKey(key) || origType != null && newType.equals(origType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        super.visitWhileLoop(loop);
        this.popAssignmentTracking(oldTracker);
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        MethodNode mn;
        super.visitBitwiseNegationExpression(expression);
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isBigIntCategory(typeRe) ? type : (typeRe == ClassHelper.STRING_TYPE || typeRe == ClassHelper.GSTRING_TYPE ? ClassHelper.PATTERN_TYPE : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : (typeRe.equals(ClassHelper.PATTERN_TYPE) ? ClassHelper.PATTERN_TYPE : ((mn = this.findMethodOrFail(expression, type, "bitwiseNegate", new ClassNode[0])) != null ? mn.getReturnType() : ClassHelper.OBJECT_TYPE))));
        this.storeType(expression, resultType);
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        super.visitUnaryPlusExpression(expression);
        this.negativeOrPositiveUnary(expression, "positive");
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        super.visitUnaryMinusExpression(expression);
        this.negativeOrPositiveUnary(expression, "negative");
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression) {
        String name;
        super.visitPostfixExpression(expression);
        Expression inner = expression.getExpression();
        ClassNode exprType = this.getType(inner);
        int type = expression.getOperation().getType();
        String string = type == 250 ? "next" : (name = type == 260 ? "previous" : null);
        if (ClassHelper.isPrimitiveType(exprType) || ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(exprType))) {
            if (type == 250 || type == 260) {
                MethodNode node;
                if (!ClassHelper.isPrimitiveType(exprType) && (node = this.findMethodOrFail(inner, exprType, name, new ClassNode[0])) != null) {
                    this.storeTargetMethod(expression, node);
                }
                return;
            }
            this.addStaticTypeError("Unsupported postfix operation type [" + expression.getOperation() + "]", expression);
            return;
        }
        if (name == null) {
            this.addStaticTypeError("Unsupported postfix operation type [" + expression.getOperation() + "]", expression);
            return;
        }
        MethodNode node = this.findMethodOrFail(inner, exprType, name, new ClassNode[0]);
        if (node != null) {
            this.storeTargetMethod(expression, node);
        }
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression) {
        String name;
        super.visitPrefixExpression(expression);
        Expression inner = expression.getExpression();
        ClassNode exprType = this.getType(inner);
        int type = expression.getOperation().getType();
        String string = type == 250 ? "next" : (name = type == 260 ? "previous" : null);
        if (ClassHelper.isPrimitiveType(exprType) || ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(exprType))) {
            if (type == 250 || type == 260) {
                MethodNode node;
                if (!ClassHelper.isPrimitiveType(exprType) && (node = this.findMethodOrFail(inner, exprType, name, new ClassNode[0])) != null) {
                    this.storeTargetMethod(expression, node);
                }
                return;
            }
            this.addStaticTypeError("Unsupported prefix operation type [" + expression.getOperation() + "]", expression);
            return;
        }
        if (name == null) {
            this.addStaticTypeError("Unsupported prefix operation type [" + expression.getOperation() + "]", expression);
            return;
        }
        MethodNode node = this.findMethodOrFail(inner, exprType, name, new ClassNode[0]);
        if (node != null) {
            this.storeTargetMethod(expression, node);
        }
    }

    private void negativeOrPositiveUnary(Expression expression, String name) {
        MethodNode mn;
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isDoubleCategory(ClassHelper.getUnwrapper(typeRe)) ? type : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : ((mn = this.findMethodOrFail(expression, type, name, new ClassNode[0])) != null ? mn.getReturnType() : type));
        this.storeType(expression, resultType);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        MethodNode old = this.methodNode;
        this.methodNode = node;
        if (!this.isSkipMode(node) && !this.shouldSkipMethodNode(node)) {
            super.visitConstructorOrMethod(node, isConstructor);
        }
        if (!isConstructor) {
            this.returnAdder.visitMethod(node);
        }
        this.methodNode = old;
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        super.visitReturnStatement(statement);
        this.checkReturnType(statement);
        if (this.closureExpression != null && statement.getExpression() != ConstantExpression.NULL) {
            this.addClosureReturnType(this.getType(statement.getExpression()));
        }
    }

    private ClassNode checkReturnType(ReturnStatement statement) {
        Expression expression = statement.getExpression();
        ClassNode type = this.getType(expression);
        if (this.methodNode != null && this.closureExpression == null) {
            if (!(this.methodNode.isVoidMethod() || type.equals(ClassHelper.void_WRAPPER_TYPE) || type.equals(ClassHelper.VOID_TYPE) || StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(this.methodNode.getReturnType(), type) || StaticTypeCheckingVisitor.isNullConstant(expression))) {
                this.addStaticTypeError("Cannot return value of type " + type.toString(false) + " on method returning type " + this.methodNode.getReturnType().toString(false), expression);
            } else if (!this.methodNode.isVoidMethod()) {
                ClassNode inferred;
                ClassNode previousType = (ClassNode)this.methodNode.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
                ClassNode classNode = inferred = previousType == null ? type : WideningCategories.lowestUpperBound(type, previousType);
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferred, this.methodNode.getReturnType())) {
                    if (StaticTypeCheckingSupport.missesGenericsTypes(inferred)) {
                        DeclarationExpression virtualDecl = new DeclarationExpression(new VariableExpression("{target}", this.methodNode.getReturnType()), Token.newSymbol(100, -1, -1), (Expression)new VariableExpression("{source}", inferred));
                        virtualDecl.setSourcePosition(statement);
                        virtualDecl.visit(this);
                        ClassNode newlyInferred = (ClassNode)virtualDecl.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        if (!StaticTypeCheckingSupport.missesGenericsTypes(newlyInferred)) {
                            inferred = newlyInferred;
                        }
                    }
                    this.methodNode.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferred);
                    return inferred;
                }
                this.methodNode.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, this.methodNode.getReturnType());
                return this.methodNode.getReturnType();
            }
        }
        return type;
    }

    private void addClosureReturnType(ClassNode returnType) {
        if (this.closureReturnTypes == null) {
            this.closureReturnTypes = new LinkedList<ClassNode>();
        }
        this.closureReturnTypes.add(returnType);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        super.visitConstructorCallExpression(call);
        ClassNode receiver = call.isThisCall() ? this.classNode : (call.isSuperCall() ? this.classNode.getSuperClass() : call.getType());
        Expression arguments = call.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(arguments);
        this.checkForbiddenSpreadArgument(argumentList);
        ClassNode[] args = this.getArgumentTypes(argumentList);
        MethodNode node = null;
        if (args.length == 1 && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(args[0], ClassHelper.MAP_TYPE) && this.findMethod(receiver, "<init>", ClassNode.EMPTY_ARRAY).size() == 1 && (node = this.typeCheckMapConstructor(call, receiver, arguments)) != null) {
            this.storeTargetMethod(call, node);
            return;
        }
        node = this.findMethodOrFail(call, receiver, "<init>", args);
        if (node != null) {
            if (node.getParameters().length == 0 && args.length == 1 && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(args[0], ClassHelper.MAP_TYPE)) {
                node = this.typeCheckMapConstructor(call, receiver, arguments);
            }
            if (node != null) {
                this.storeTargetMethod(call, node);
            }
        }
    }

    private MethodNode typeCheckMapConstructor(ConstructorCallExpression call, ClassNode receiver, Expression arguments) {
        Expression expression;
        TupleExpression texp;
        List<Expression> expressions;
        ConstructorNode node = null;
        if (arguments instanceof TupleExpression && (expressions = (texp = (TupleExpression)arguments).getExpressions()).size() == 1 && (expression = expressions.get(0)) instanceof MapExpression) {
            MapExpression argList = (MapExpression)expression;
            this.checkGroovyConstructorMap(call, receiver, argList);
            node = new ConstructorNode(1, new Parameter[]{new Parameter(ClassHelper.MAP_TYPE, "map")}, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
            node.setDeclaringClass(receiver);
        }
        return node;
    }

    private ClassNode[] getArgumentTypes(ArgumentListExpression args) {
        List<Expression> arglist = args.getExpressions();
        ClassNode[] ret = new ClassNode[arglist.size()];
        int i = 0;
        Map<Object, List<ClassNode>> info = this.temporaryIfBranchTypeInformation.empty() ? null : this.temporaryIfBranchTypeInformation.peek();
        for (Expression exp : arglist) {
            if (StaticTypeCheckingVisitor.isNullConstant(exp)) {
                ret[i] = StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE;
            } else {
                List<ClassNode> classNodes;
                ret[i] = this.getType(exp);
                if (exp instanceof VariableExpression && info != null && (classNodes = this.getTemporaryTypesForExpression(exp)) != null && !classNodes.isEmpty()) {
                    ArrayList<ClassNode> arr = new ArrayList<ClassNode>(classNodes.size() + 1);
                    arr.add(ret[i]);
                    arr.addAll(classNodes);
                    ret[i] = new UnionTypeClassNode(arr.toArray(new ClassNode[arr.size()]));
                }
            }
            ++i;
        }
        return ret;
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        HashMap<VariableExpression, ClassNode> varOrigType = new HashMap<VariableExpression, ClassNode>();
        Statement code = expression.getCode();
        code.visit(new VariableExpressionTypeMemoizer(varOrigType));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        SharedVariableCollector collector = new SharedVariableCollector(this.getSourceUnit());
        collector.visitClosureExpression(expression);
        Set<VariableExpression> closureSharedExpressions = collector.getClosureSharedExpressions();
        HashMap<VariableExpression, ListHashMap> typesBeforeVisit = null;
        if (!closureSharedExpressions.isEmpty()) {
            typesBeforeVisit = new HashMap<VariableExpression, ListHashMap>();
            this.saveVariableExpressionMetadata(closureSharedExpressions, typesBeforeVisit);
        }
        ClosureExpression oldClosureExpr = this.closureExpression;
        List<ClassNode> oldClosureReturnTypes = this.closureReturnTypes;
        this.closureExpression = expression;
        super.visitClosureExpression(expression);
        MethodNode node = new MethodNode("dummy", 0, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, code);
        this.closureReturnAdder.visitMethod(node);
        if (this.closureReturnTypes != null) {
            expression.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, WideningCategories.lowestUpperBound(this.closureReturnTypes));
        }
        this.closureExpression = oldClosureExpr;
        this.closureReturnTypes = oldClosureReturnTypes;
        boolean typeChanged = this.isSecondPassNeededForControlStructure(varOrigType, oldTracker);
        if (typeChanged) {
            this.visitClosureExpression(expression);
        }
        this.restoreVariableExpressionMetadata(typesBeforeVisit);
    }

    private void restoreVariableExpressionMetadata(Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        if (typesBeforeVisit != null) {
            for (Map.Entry<VariableExpression, ListHashMap> entry : typesBeforeVisit.entrySet()) {
                VariableExpression ve = entry.getKey();
                ListHashMap metadata = entry.getValue();
                StaticTypesMarker[] staticTypesMarkerArray = StaticTypesMarker.values();
                int n = staticTypesMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StaticTypesMarker marker = staticTypesMarkerArray[n2];
                    ve.removeNodeMetaData((Object)marker);
                    Object value = metadata.get((Object)marker);
                    if (value != null) {
                        ve.setNodeMetaData((Object)marker, value);
                    }
                    ++n2;
                }
            }
        }
    }

    private void saveVariableExpressionMetadata(Set<VariableExpression> closureSharedExpressions, Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        for (VariableExpression ve : closureSharedExpressions) {
            ListHashMap<StaticTypesMarker, Object> metadata = new ListHashMap<StaticTypesMarker, Object>();
            StaticTypesMarker[] staticTypesMarkerArray = StaticTypesMarker.values();
            int n = staticTypesMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                StaticTypesMarker marker = staticTypesMarkerArray[n2];
                Object value = ve.getNodeMetaData((Object)marker);
                if (value != null) {
                    metadata.put(marker, value);
                }
                ++n2;
            }
            typesBeforeVisit.put(ve, metadata);
            Variable accessedVariable = ve.getAccessedVariable();
            if (accessedVariable == ve || !(accessedVariable instanceof VariableExpression)) continue;
            this.saveVariableExpressionMetadata(Collections.singleton((VariableExpression)accessedVariable), typesBeforeVisit);
        }
    }

    protected boolean shouldSkipMethodNode(MethodNode node) {
        Object type = node.getNodeMetaData(StaticTypeCheckingVisitor.class);
        return Boolean.TRUE.equals(type);
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (this.shouldSkipMethodNode(node)) {
            return;
        }
        ErrorCollector collector = (ErrorCollector)node.getNodeMetaData(ERROR_COLLECTOR);
        if (collector != null) {
            this.errorCollector.addCollectorContents(collector);
        } else {
            this.startMethodInference(node, this.errorCollector);
        }
        node.removeNodeMetaData(ERROR_COLLECTOR);
    }

    private void startMethodInference(MethodNode node, ErrorCollector collector) {
        if (this.isSkipMode(node)) {
            return;
        }
        if (!this.methodsToBeVisited.isEmpty() && !this.methodsToBeVisited.contains(node)) {
            return;
        }
        if (this.alreadyVisitedMethods.contains(node)) {
            return;
        }
        this.alreadyVisitedMethods.add(node);
        ErrorCollector oldCollector = this.errorCollector;
        this.errorCollector = collector;
        boolean osc = this.isInStaticContext;
        try {
            this.isInStaticContext = node.isStatic();
            super.visitMethod(node);
            Parameter[] parameterArray = node.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                if (parameter.getInitialExpression() != null) {
                    parameter.getInitialExpression().visit(this);
                }
                ++n2;
            }
            ClassNode rtype = (ClassNode)node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
            if (rtype == null) {
                node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, node.getReturnType());
            }
            this.addTypeCheckingInfoAnnotation(node);
        }
        finally {
            this.isInStaticContext = osc;
        }
        this.errorCollector = oldCollector;
        node.putNodeMetaData(ERROR_COLLECTOR, collector);
    }

    protected void addTypeCheckingInfoAnnotation(MethodNode node) {
        if (node instanceof ConstructorNode) {
            return;
        }
        ClassNode rtype = (ClassNode)node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        if (rtype != null && node.getAnnotations(TYPECHECKING_INFO_NODE).isEmpty()) {
            AnnotationNode anno = new AnnotationNode(TYPECHECKING_INFO_NODE);
            anno.setMember("version", CURRENT_SIGNATURE_PROTOCOL);
            SignatureCodec codec = SignatureCodecFactory.getCodec(1);
            String genericsSignature = codec.encode(rtype);
            if (genericsSignature != null) {
                ConstantExpression signature = new ConstantExpression(genericsSignature);
                signature.setType(ClassHelper.STRING_TYPE);
                anno.setMember("inferredType", signature);
                node.addAnnotation(anno);
            }
        }
    }

    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        String name = call.getMethod();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call);
            return;
        }
        ClassNode rememberLastItType = this.lastImplicitItType;
        Expression callArguments = call.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
        this.checkForbiddenSpreadArgument(argumentList);
        boolean isWithCall = StaticTypeCheckingSupport.isWithCall(name, callArguments);
        if (!isWithCall) {
            callArguments.visit(this);
        }
        ClassNode[] args = this.getArgumentTypes(argumentList);
        ClassNode receiver = call.getOwnerType();
        if (isWithCall) {
            this.withReceiverList.add(0, receiver);
            this.lastImplicitItType = receiver;
            if (callArguments instanceof ArgumentListExpression) {
                Parameter param;
                ArgumentListExpression argList = (ArgumentListExpression)callArguments;
                ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
                Parameter[] parameters = closure.getParameters();
                if (parameters.length > 1) {
                    this.addStaticTypeError("Unexpected number of parameters for a with call", argList);
                } else if (parameters.length == 1 && !(param = parameters[0]).isDynamicTyped() && !StaticTypeCheckingSupport.isAssignableTo(receiver, param.getType().redirect())) {
                    this.addStaticTypeError("Expected parameter type: " + receiver.toString(false) + " but was: " + param.getType().redirect().toString(false), param);
                }
            }
        }
        try {
            if (isWithCall) {
                callArguments.visit(this);
            }
            LinkedList<ClassNode> receivers = new LinkedList<ClassNode>();
            if (!this.withReceiverList.isEmpty()) {
                receivers.addAll(this.withReceiverList);
            }
            receivers.add(receiver);
            List<MethodNode> mn = null;
            ClassNode chosenReceiver = null;
            for (ClassNode currentReceiver : receivers) {
                mn = this.findMethod(currentReceiver, name, args);
                if (mn.isEmpty()) continue;
                if (mn.size() == 1) {
                    this.typeCheckMethodsWithGenerics(currentReceiver, args, mn.get(0), call);
                }
                chosenReceiver = currentReceiver;
                break;
            }
            if (mn.isEmpty()) {
                this.addNoMatchingMethodError(receiver, name, args, call);
            } else if (mn.size() == 1) {
                MethodNode directMethodCallCandidate = (MethodNode)mn.get(0);
                ClassNode currentClassNode = this.classNode;
                this.classNode = directMethodCallCandidate.getDeclaringClass();
                for (ClassNode node : this.source.getAST().getClasses()) {
                    if (!StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(this.classNode, node)) continue;
                    this.silentlyVisitMethodNode(directMethodCallCandidate);
                    break;
                }
                this.pickInferredTypeFromMethodAnnotation(directMethodCallCandidate);
                this.classNode = currentClassNode;
                ClassNode returnType = this.getType(directMethodCallCandidate);
                if (returnType.isUsingGenerics() && !returnType.isEnum()) {
                    ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver, directMethodCallCandidate, callArguments);
                    returnType = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, returnType) ? irtg : returnType;
                }
                this.storeType(call, returnType);
                this.storeTargetMethod(call, directMethodCallCandidate);
            } else {
                this.addAmbiguousErrorMessage(mn, name, args, call);
            }
        }
        finally {
            if (isWithCall) {
                this.lastImplicitItType = rememberLastItType;
                this.withReceiverList.removeFirst();
            }
        }
    }

    private void pickInferredTypeFromMethodAnnotation(MethodNode node) {
        if (node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE) == null && !node.getAnnotations(TYPECHECKING_INFO_NODE).isEmpty()) {
            List<AnnotationNode> annotations = node.getAnnotations(TYPECHECKING_INFO_NODE);
            AnnotationNode head = annotations.get(0);
            int version = Integer.valueOf(head.getMember("version").getText());
            String signature = head.getMember("inferredType").getText();
            SignatureCodec codec = SignatureCodecFactory.getCodec(version);
            ClassNode result = codec.decode(signature);
            node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, result);
        }
    }

    private void silentlyVisitMethodNode(MethodNode directMethodCallCandidate) {
        ErrorCollector collector = new ErrorCollector(this.errorCollector.getConfiguration());
        this.startMethodInference(directMethodCallCandidate, collector);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        Parameter[] parameters;
        String name = call.getMethodAsString();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call.getMethod());
            return;
        }
        Expression objectExpression = call.getObjectExpression();
        objectExpression.visit(this);
        call.getMethod().visit(this);
        if (call.isSpreadSafe()) {
            ClassNode expressionType = this.getType(objectExpression);
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, StaticTypeCheckingSupport.Collection_TYPE) && !expressionType.isArray()) {
                this.addStaticTypeError("Spread operator can only be used on collection types", objectExpression);
                return;
            }
            ClassNode componentType = this.inferComponentType(expressionType, ClassHelper.int_TYPE);
            MethodCallExpression subcall = new MethodCallExpression((Expression)new CastExpression(componentType, EmptyExpression.INSTANCE), name, call.getArguments());
            subcall.setLineNumber(call.getLineNumber());
            subcall.setColumnNumber(call.getColumnNumber());
            subcall.setImplicitThis(call.isImplicitThis());
            this.visitMethodCallExpression(subcall);
            ClassNode subcallReturnType = this.getType(subcall);
            ClassNode listNode = ClassHelper.LIST_TYPE.getPlainNodeReference();
            listNode.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(subcallReturnType))});
            this.storeType(call, listNode);
            this.storeTargetMethod(call, (MethodNode)subcall.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            return;
        }
        ClassNode rememberLastItType = this.lastImplicitItType;
        Expression callArguments = call.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
        this.checkForbiddenSpreadArgument(argumentList);
        boolean isWithCall = StaticTypeCheckingSupport.isWithCall(name, callArguments);
        if (!isWithCall) {
            callArguments.visit(this);
        }
        ClassNode[] args = this.getArgumentTypes(argumentList);
        boolean isCallOnClosure = this.isClosureCall(name, objectExpression, callArguments);
        ClassNode receiver = this.getType(objectExpression);
        if (isWithCall) {
            this.withReceiverList.add(0, receiver);
            this.lastImplicitItType = receiver;
            if (callArguments instanceof ArgumentListExpression) {
                Parameter param;
                ArgumentListExpression argList = (ArgumentListExpression)callArguments;
                ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
                parameters = closure.getParameters();
                if (parameters.length > 1) {
                    this.addStaticTypeError("Unexpected number of parameters for a with call", argList);
                } else if (parameters.length == 1 && !(param = parameters[0]).isDynamicTyped() && !StaticTypeCheckingSupport.isAssignableTo(receiver, param.getType().redirect())) {
                    this.addStaticTypeError("Expected parameter type: " + receiver.toString(false) + " but was: " + param.getType().redirect().toString(false), param);
                }
            }
        }
        try {
            if (isWithCall) {
                callArguments.visit(this);
            }
            if (isCallOnClosure) {
                Object data;
                if (objectExpression == VariableExpression.THIS_EXPRESSION) {
                    FieldNode field = this.classNode.getDeclaredField(name);
                    GenericsType[] genericsTypes = field.getType().getGenericsTypes();
                    if (genericsTypes != null) {
                        ClassNode closureReturnType = genericsTypes[0].getType();
                        Object data2 = field.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (data2 != null) {
                            Parameter[] parameters2 = (Parameter[])data2;
                            this.typeCheckClosureCall(callArguments, args, parameters2);
                        }
                        this.storeType(call, closureReturnType);
                    }
                } else if (objectExpression instanceof VariableExpression) {
                    Variable variable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression);
                    if (variable instanceof ASTNode) {
                        Object type;
                        data = ((ASTNode)((Object)variable)).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (data != null) {
                            parameters = (Parameter[])data;
                            this.typeCheckClosureCall(callArguments, args, parameters);
                        }
                        if ((type = ((ASTNode)((Object)variable)).getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) == null && variable.getType().equals(ClassHelper.CLOSURE_TYPE)) {
                            GenericsType[] genericsTypes = variable.getType().getGenericsTypes();
                            type = genericsTypes != null && !genericsTypes[0].isPlaceholder() ? genericsTypes[0].getType() : ClassHelper.OBJECT_TYPE;
                        }
                        if (type != null) {
                            this.storeType(call, (ClassNode)type);
                        }
                    }
                } else if (objectExpression instanceof ClosureExpression) {
                    Parameter[] parameters3 = ((ClosureExpression)objectExpression).getParameters();
                    this.typeCheckClosureCall(callArguments, args, parameters3);
                    data = objectExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
                    if (data != null) {
                        this.storeType(call, (ClassNode)data);
                    }
                }
                int nbOfArgs = 0;
                if (callArguments instanceof ArgumentListExpression) {
                    ArgumentListExpression list = (ArgumentListExpression)callArguments;
                    nbOfArgs = list.getExpressions().size();
                } else {
                    nbOfArgs = 0;
                }
                this.storeTargetMethod(call, nbOfArgs == 0 ? CLOSURE_CALL_NO_ARG : (nbOfArgs == 1 ? CLOSURE_CALL_ONE_ARG : CLOSURE_CALL_VARGS));
            } else {
                List<ClassNode> potentialReceiverType;
                LinkedList<ClassNode> receivers = new LinkedList<ClassNode>();
                if (!this.withReceiverList.isEmpty()) {
                    receivers.addAll(this.withReceiverList);
                }
                receivers.add(receiver);
                if (receiver.equals(ClassHelper.CLASS_Type) && receiver.getGenericsTypes() != null) {
                    GenericsType clazzGT = receiver.getGenericsTypes()[0];
                    receivers.add(receivers.size() - 1, clazzGT.getType());
                }
                if (receiver.isInterface()) {
                    receivers.add(ClassHelper.OBJECT_TYPE);
                }
                if (!this.temporaryIfBranchTypeInformation.empty() && (potentialReceiverType = this.getTemporaryTypesForExpression(objectExpression)) != null) {
                    receivers.addAll(potentialReceiverType);
                }
                List<MethodNode> mn = null;
                ClassNode chosenReceiver = null;
                for (ClassNode currentReceiver : receivers) {
                    mn = this.findMethod(currentReceiver, name, args);
                    if (!mn.isEmpty() && this.isInStaticContext && (call.isImplicitThis() || objectExpression instanceof VariableExpression && ((VariableExpression)objectExpression).isThisExpression())) {
                        LinkedList<MethodNode> staticMethods = new LinkedList<MethodNode>();
                        LinkedList nonStaticMethods = new LinkedList();
                        for (MethodNode node : mn) {
                            if (node.isStatic()) {
                                staticMethods.add(node);
                                continue;
                            }
                            nonStaticMethods.add(node);
                        }
                        mn = staticMethods;
                        if (staticMethods.isEmpty()) {
                            MethodNode node;
                            node = (MethodNode)nonStaticMethods.get(0);
                            ClassNode owner = node.getDeclaringClass();
                            this.addStaticTypeError("Non static method " + owner.getName() + "#" + node.getName() + " cannot be called from static context", call);
                        }
                    }
                    if (mn.isEmpty()) continue;
                    if (mn.size() == 1) {
                        this.typeCheckMethodsWithGenerics(currentReceiver, args, mn.get(0), call);
                    }
                    chosenReceiver = currentReceiver;
                    break;
                }
                if (mn.isEmpty() && this.closureExpression != null && args.length == 0) {
                    if ("getDelegate".equals(name)) {
                        mn = Collections.singletonList(GET_DELEGATE);
                    } else if ("getOwner".equals(name)) {
                        mn = Collections.singletonList(GET_OWNER);
                    } else if ("getThisObject".equals(name)) {
                        mn = Collections.singletonList(GET_THISOBJECT);
                    }
                }
                if (mn.isEmpty()) {
                    this.addNoMatchingMethodError(receiver, name, args, call);
                } else {
                    if (this.areCategoryMethodCalls(mn, name, args)) {
                        this.addCategoryMethodCallError(call);
                    }
                    if (mn.size() == 1) {
                        VariableExpression var;
                        MethodNode directMethodCallCandidate = mn.get(0);
                        ClassNode currentClassNode = this.classNode;
                        this.classNode = directMethodCallCandidate.getDeclaringClass();
                        for (ClassNode node : this.source.getAST().getClasses()) {
                            if (!StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(this.classNode, node)) continue;
                            this.silentlyVisitMethodNode(directMethodCallCandidate);
                            break;
                        }
                        this.pickInferredTypeFromMethodAnnotation(directMethodCallCandidate);
                        this.classNode = currentClassNode;
                        ClassNode returnType = null;
                        if (isWithCall) {
                            returnType = this.getInferredReturnTypeFromWithClosureArgument(callArguments);
                        }
                        if (returnType == null) {
                            returnType = this.getType(directMethodCallCandidate);
                        }
                        if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(returnType)) {
                            ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver, directMethodCallCandidate, callArguments);
                            returnType = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, returnType) ? irtg : returnType;
                        }
                        this.storeType(call, returnType);
                        this.storeTargetMethod(call, directMethodCallCandidate);
                        if (objectExpression instanceof VariableExpression && (var = (VariableExpression)objectExpression).isClosureSharedVariable()) {
                            SecondPassExpression<ClassNode[]> wrapper = new SecondPassExpression<ClassNode[]>(call, args);
                            this.secondPassExpressions.add(wrapper);
                        }
                    } else {
                        this.addAmbiguousErrorMessage(mn, name, args, call);
                    }
                }
            }
        }
        finally {
            if (isWithCall) {
                this.lastImplicitItType = rememberLastItType;
                this.withReceiverList.removeFirst();
            }
        }
    }

    protected ClassNode getInferredReturnTypeFromWithClosureArgument(Expression callArguments) {
        if (!(callArguments instanceof ArgumentListExpression)) {
            return null;
        }
        ArgumentListExpression argList = (ArgumentListExpression)callArguments;
        ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
        this.visitClosureExpression(closure);
        if (closure.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE) != null) {
            return (ClassNode)closure.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        }
        return null;
    }

    protected void checkForbiddenSpreadArgument(ArgumentListExpression argumentList) {
        for (Expression arg : argumentList.getExpressions()) {
            if (!(arg instanceof SpreadExpression)) continue;
            this.addStaticTypeError("The spread operator cannot be used as argument of method or closure calls with static type checking because the number of arguments cannot be determined at compile time", arg);
        }
    }

    private List<ClassNode> getTemporaryTypesForExpression(Expression objectExpression) {
        List classNodes = null;
        int depth = this.temporaryIfBranchTypeInformation.size();
        while (classNodes == null && depth > 0) {
            Map tempo = (Map)this.temporaryIfBranchTypeInformation.get(--depth);
            Object key = this.extractTemporaryTypeInfoKey(objectExpression);
            classNodes = (List)tempo.get(key);
        }
        return classNodes;
    }

    private void storeTargetMethod(Expression call, MethodNode directMethodCallCandidate) {
        call.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, directMethodCallCandidate);
    }

    private boolean isClosureCall(String name, Expression objectExpression, Expression arguments) {
        if (objectExpression instanceof ClosureExpression) {
            return true;
        }
        if (objectExpression == VariableExpression.THIS_EXPRESSION) {
            ClassNode type;
            FieldNode fieldNode = this.classNode.getDeclaredField(name);
            if (fieldNode != null && ClassHelper.CLOSURE_TYPE.equals(type = fieldNode.getType()) && !this.classNode.hasPossibleMethod(name, arguments)) {
                return true;
            }
        } else if (!"call".equals(name) && !"doCall".equals(name)) {
            return false;
        }
        return this.getType(objectExpression).equals(ClassHelper.CLOSURE_TYPE);
    }

    private void typeCheckClosureCall(Expression callArguments, ClassNode[] args, Parameter[] parameters) {
        if (StaticTypeCheckingSupport.allParametersAndArgumentsMatch(parameters, args) < 0 && StaticTypeCheckingSupport.lastArgMatchesVarg(parameters, args) < 0) {
            StringBuilder sb = new StringBuilder("[");
            int i = 0;
            int parametersLength = parameters.length;
            while (i < parametersLength) {
                Parameter parameter = parameters[i];
                sb.append(parameter.getType().getName());
                if (i < parametersLength - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append("]");
            this.addStaticTypeError("Closure argument types: " + sb + " do not match with parameter types: " + StaticTypeCheckingVisitor.formatArgumentList(args), callArguments);
        }
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        try {
            this.pushTemporaryTypeInfo();
            this.visitStatement(ifElse);
            ifElse.getBooleanExpression().visit(this);
            ifElse.getIfBlock().visit(this);
            this.temporaryIfBranchTypeInformation.pop();
            Statement elseBlock = ifElse.getElseBlock();
            if (elseBlock instanceof EmptyStatement) {
                this.visitEmptyStatement((EmptyStatement)elseBlock);
            } else {
                elseBlock.visit(this);
            }
        }
        finally {
            this.popAssignmentTracking(oldTracker);
        }
    }

    private Map<VariableExpression, ClassNode> popAssignmentTracking(Map<VariableExpression, List<ClassNode>> oldTracker) {
        HashMap<VariableExpression, ClassNode> assignments = new HashMap<VariableExpression, ClassNode>();
        if (!this.ifElseForWhileAssignmentTracker.isEmpty()) {
            for (Map.Entry<VariableExpression, List<ClassNode>> entry : this.ifElseForWhileAssignmentTracker.entrySet()) {
                VariableExpression key = entry.getKey();
                ClassNode cn = WideningCategories.lowestUpperBound(entry.getValue());
                this.storeType(key, cn);
                assignments.put(key, cn);
            }
        }
        this.ifElseForWhileAssignmentTracker = oldTracker;
        return assignments;
    }

    private Map<VariableExpression, List<ClassNode>> pushAssignmentTracking() {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.ifElseForWhileAssignmentTracker;
        this.ifElseForWhileAssignmentTracker = new HashMap<VariableExpression, List<ClassNode>>();
        return oldTracker;
    }

    @Override
    public void visitCastExpression(CastExpression expression) {
        super.visitCastExpression(expression);
        if (!expression.isCoerce()) {
            ClassNode targetType = expression.getType();
            Expression source = expression.getExpression();
            ClassNode expressionType = this.getType(source);
            if (!this.checkCast(targetType, source)) {
                this.addStaticTypeError("Inconvertible types: cannot cast " + expressionType.toString(false) + " to " + targetType.toString(false), expression);
            }
        }
        this.storeType(expression, expression.getType());
    }

    private boolean checkCast(ClassNode targetType, Expression source) {
        boolean sourceIsNull = StaticTypeCheckingVisitor.isNullConstant(source);
        ClassNode expressionType = this.getType(source);
        if (targetType.isArray() && expressionType.isArray()) {
            return this.checkCast(targetType.getComponentType(), new VariableExpression("foo", expressionType.getComponentType()));
        }
        if (!(targetType.equals(ClassHelper.char_TYPE) && expressionType == ClassHelper.STRING_TYPE && source instanceof ConstantExpression && source.getText().length() == 1 || targetType.equals(ClassHelper.Character_TYPE) && (expressionType == ClassHelper.STRING_TYPE || sourceIsNull) && (sourceIsNull || source instanceof ConstantExpression && source.getText().length() == 1) || WideningCategories.isNumberCategory(ClassHelper.getWrapper(targetType)) && (WideningCategories.isNumberCategory(ClassHelper.getWrapper(expressionType)) || ClassHelper.char_TYPE == expressionType) || sourceIsNull && !ClassHelper.isPrimitiveType(targetType) || ClassHelper.char_TYPE == targetType && ClassHelper.isPrimitiveType(expressionType) && ClassHelper.isNumberType(expressionType))) {
            if (sourceIsNull && ClassHelper.isPrimitiveType(targetType)) {
                return false;
            }
            if (expressionType.isInterface() && targetType.isInterface()) {
                return true;
            }
            if (!StaticTypeCheckingSupport.isAssignableTo(targetType, expressionType) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, targetType)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression) {
        ClassNode resultType;
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        this.pushTemporaryTypeInfo();
        expression.getBooleanExpression().visit(this);
        Expression trueExpression = expression.getTrueExpression();
        Expression falseExpression = expression.getFalseExpression();
        trueExpression.visit(this);
        this.temporaryIfBranchTypeInformation.pop();
        falseExpression.visit(this);
        if (StaticTypeCheckingVisitor.isNullConstant(trueExpression) || StaticTypeCheckingVisitor.isNullConstant(falseExpression)) {
            resultType = this.currentBinaryExpression != null && this.currentBinaryExpression.getRightExpression() == expression ? this.getType(this.currentBinaryExpression.getLeftExpression()) : (StaticTypeCheckingVisitor.isNullConstant(trueExpression) && StaticTypeCheckingVisitor.isNullConstant(falseExpression) ? ClassHelper.OBJECT_TYPE : (StaticTypeCheckingVisitor.isNullConstant(trueExpression) ? StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.getType(falseExpression)) : StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.getType(trueExpression))));
        } else {
            ClassNode typeOfTrue = this.getType(trueExpression);
            ClassNode typeOfFalse = this.getType(falseExpression);
            resultType = WideningCategories.lowestUpperBound(typeOfTrue, typeOfFalse);
        }
        this.storeType(expression, resultType);
        this.popAssignmentTracking(oldTracker);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitTryCatchFinally(TryCatchStatement statement) {
        catchStatements = statement.getCatchStatements();
        for (CatchStatement catchStatement : catchStatements) {
            exceptionType = catchStatement.getExceptionType();
            this.controlStructureVariables.put(catchStatement.getVariable(), exceptionType);
        }
        try {
            super.visitTryCatchFinally(statement);
        }
        finally {
            ** for (catchStatement : catchStatements)
        }
lbl-1000:
        // 1 sources

        {
            this.controlStructureVariables.remove(catchStatement.getVariable());
            continue;
        }
lbl15:
        // 1 sources

    }

    private void pushTemporaryTypeInfo() {
        HashMap potentialTypes = new HashMap();
        this.temporaryIfBranchTypeInformation.push(potentialTypes);
    }

    private void storeType(Expression exp, ClassNode cn) {
        if (exp instanceof VariableExpression && ((VariableExpression)exp).isClosureSharedVariable() && ClassHelper.isPrimitiveType(cn)) {
            cn = ClassHelper.getWrapper(cn);
        }
        if (cn == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE) {
            this.storeType(exp, this.getOriginalDeclarationType(exp));
            return;
        }
        ClassNode oldValue = (ClassNode)exp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, cn);
        if (oldValue != null) {
            ClassNode oldDIT = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            if (oldDIT != null) {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, WideningCategories.lowestUpperBound(oldDIT, cn));
            } else {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, WideningCategories.lowestUpperBound(oldValue, cn));
            }
        }
        if (exp instanceof VariableExpression) {
            List<ClassNode> temporaryTypesForExpression;
            VariableExpression var = (VariableExpression)exp;
            Variable accessedVariable = var.getAccessedVariable();
            if (accessedVariable != null && accessedVariable != exp && accessedVariable instanceof VariableExpression) {
                this.storeType((Expression)((Object)accessedVariable), cn);
            }
            if (var.isClosureSharedVariable()) {
                List<ClassNode> assignedTypes = this.closureSharedVariablesAssignmentTypes.get(var);
                if (assignedTypes == null) {
                    assignedTypes = new LinkedList<ClassNode>();
                    this.closureSharedVariablesAssignmentTypes.put(var, assignedTypes);
                }
                assignedTypes.add(cn);
            }
            if (!this.temporaryIfBranchTypeInformation.empty() && (temporaryTypesForExpression = this.getTemporaryTypesForExpression(exp)) != null && !temporaryTypesForExpression.isEmpty()) {
                temporaryTypesForExpression.clear();
            }
        }
    }

    private ClassNode getResultType(ClassNode left, int op, ClassNode right, BinaryExpression expr) {
        MethodNode method;
        String operationName;
        ClassNode leftRedirect = left.redirect();
        ClassNode rightRedirect = right.redirect();
        Expression leftExpression = expr.getLeftExpression();
        if (op == 100 || op == 1100) {
            if (leftRedirect.isArray() && !rightRedirect.isArray()) {
                return leftRedirect;
            }
            if (leftRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE)) {
                List<Expression> list;
                if (expr.getRightExpression() instanceof ListExpression && (list = ((ListExpression)expr.getRightExpression()).getExpressions()).isEmpty()) {
                    return left;
                }
                return right;
            }
            if (rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.isDerivedFrom(leftRedirect)) {
                return right;
            }
            if (leftExpression instanceof VariableExpression) {
                ClassNode initialType = this.getOriginalDeclarationType(leftExpression).redirect();
                if (ClassHelper.isPrimitiveType(right) && initialType.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getWrapper(right);
                }
                if (ClassHelper.isPrimitiveType(initialType) && rightRedirect.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getUnwrapper(right);
                }
                if (ClassHelper.STRING_TYPE.equals(initialType) || ClassHelper.CLASS_Type.equals(initialType) || ClassHelper.Boolean_TYPE.equals(initialType)) {
                    return initialType;
                }
            }
            return right;
        }
        if (StaticTypeCheckingSupport.isBoolIntrinsicOp(op)) {
            return ClassHelper.boolean_TYPE;
        }
        if (StaticTypeCheckingSupport.isArrayOp(op)) {
            BinaryExpression newExpr = new BinaryExpression(expr.getLeftExpression(), expr.getOperation(), expr.getRightExpression());
            newExpr.setSourcePosition(expr);
            MethodNode method2 = this.findMethodOrFail(newExpr, left.getPlainNodeReference(), "getAt", right.getPlainNodeReference());
            return method2 != null ? this.inferComponentType(left, right) : null;
        }
        if (op == 90) {
            return StaticTypeCheckingSupport.Matcher_TYPE;
        }
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            if (StaticTypeCheckingSupport.isOperationInGroup(op)) {
                if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                    return ClassHelper.int_TYPE;
                }
                if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                    return ClassHelper.long_TYPE;
                }
                if (WideningCategories.isFloat(leftRedirect) && WideningCategories.isFloat(rightRedirect)) {
                    return ClassHelper.float_TYPE;
                }
                if (WideningCategories.isDouble(leftRedirect) && WideningCategories.isDouble(rightRedirect)) {
                    return ClassHelper.double_TYPE;
                }
            } else {
                if (StaticTypeCheckingSupport.isPowerOperator(op)) {
                    return ClassHelper.Number_TYPE;
                }
                if (StaticTypeCheckingSupport.isBitOperator(op)) {
                    if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                        return ClassHelper.int_TYPE;
                    }
                    if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                        return ClassHelper.Long_TYPE;
                    }
                    if (WideningCategories.isBigIntCategory(leftRedirect) && WideningCategories.isBigIntCategory(rightRedirect)) {
                        return ClassHelper.BigInteger_TYPE;
                    }
                } else if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123) {
                    return ClassHelper.boolean_TYPE;
                }
            }
        }
        if (StaticTypeCheckingSupport.isShiftOperation(operationName = StaticTypeCheckingSupport.getOperationName(op)) && WideningCategories.isNumberCategory(leftRedirect) && (WideningCategories.isIntCategory(rightRedirect) || WideningCategories.isLongCategory(rightRedirect))) {
            return leftRedirect;
        }
        if (WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && (203 == op || 213 == op)) {
            if (WideningCategories.isFloatingCategory(leftRedirect) || WideningCategories.isFloatingCategory(rightRedirect)) {
                if (!ClassHelper.isPrimitiveType(leftRedirect) || !ClassHelper.isPrimitiveType(rightRedirect)) {
                    return ClassHelper.Double_TYPE;
                }
                return ClassHelper.double_TYPE;
            }
            if (203 == op) {
                return ClassHelper.BigDecimal_TYPE;
            }
            return leftRedirect;
        }
        if (StaticTypeCheckingSupport.isOperationInGroup(op) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect))) {
            return StaticTypeCheckingVisitor.getGroupOperationResultType(leftRedirect, rightRedirect);
        }
        if (WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && (205 == op || 215 == op)) {
            return leftRedirect;
        }
        if (leftExpression instanceof ClassExpression) {
            left = ClassHelper.CLASS_Type.getPlainNodeReference();
        }
        if ((method = this.findMethodOrFail(expr, left, operationName, right)) != null) {
            this.storeTargetMethod(expr, method);
            this.typeCheckMethodsWithGenerics(left, new ClassNode[]{right}, method, expr);
            if (StaticTypeCheckingSupport.isAssignment(op)) {
                return left;
            }
            if (StaticTypeCheckingSupport.isCompareToBoolean(op)) {
                return ClassHelper.boolean_TYPE;
            }
            if (op == 128) {
                return ClassHelper.int_TYPE;
            }
            return this.inferReturnTypeGenerics(left, method, new ArgumentListExpression(expr.getRightExpression()));
        }
        return null;
    }

    private static ClassNode getGroupOperationResultType(ClassNode a, ClassNode b) {
        if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
            return ClassHelper.BigInteger_TYPE;
        }
        if (WideningCategories.isBigDecCategory(a) && WideningCategories.isBigDecCategory(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigDecimal_TYPE.equals(a) || ClassHelper.BigDecimal_TYPE.equals(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigInteger_TYPE.equals(a) || ClassHelper.BigInteger_TYPE.equals(b)) {
            if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
                return ClassHelper.BigInteger_TYPE;
            }
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.double_TYPE.equals(a) || ClassHelper.double_TYPE.equals(b)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Double_TYPE.equals(a) || ClassHelper.Double_TYPE.equals(b)) {
            return ClassHelper.Double_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(a) || ClassHelper.float_TYPE.equals(b)) {
            return ClassHelper.float_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(a) || ClassHelper.Float_TYPE.equals(b)) {
            return ClassHelper.Float_TYPE;
        }
        if (ClassHelper.long_TYPE.equals(a) || ClassHelper.long_TYPE.equals(b)) {
            return ClassHelper.long_TYPE;
        }
        if (ClassHelper.Long_TYPE.equals(a) || ClassHelper.Long_TYPE.equals(b)) {
            return ClassHelper.Long_TYPE;
        }
        if (ClassHelper.int_TYPE.equals(a) || ClassHelper.int_TYPE.equals(b)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Integer_TYPE.equals(a) || ClassHelper.Integer_TYPE.equals(b)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.short_TYPE.equals(a) || ClassHelper.short_TYPE.equals(b)) {
            return ClassHelper.short_TYPE;
        }
        if (ClassHelper.Short_TYPE.equals(a) || ClassHelper.Short_TYPE.equals(b)) {
            return ClassHelper.Short_TYPE;
        }
        if (ClassHelper.byte_TYPE.equals(a) || ClassHelper.byte_TYPE.equals(b)) {
            return ClassHelper.byte_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(a) || ClassHelper.Byte_TYPE.equals(b)) {
            return ClassHelper.Byte_TYPE;
        }
        if (ClassHelper.char_TYPE.equals(a) || ClassHelper.char_TYPE.equals(b)) {
            return ClassHelper.char_TYPE;
        }
        if (ClassHelper.Character_TYPE.equals(a) || ClassHelper.Character_TYPE.equals(b)) {
            return ClassHelper.Character_TYPE;
        }
        return ClassHelper.Number_TYPE;
    }

    protected ClassNode inferComponentType(ClassNode containerType, ClassNode indexType) {
        ClassNode componentType = containerType.getComponentType();
        if (componentType == null) {
            ErrorCollector oldCollector = this.errorCollector;
            this.errorCollector = new ErrorCollector(new CompilerConfiguration());
            MethodCallExpression vcall = new MethodCallExpression((Expression)new VariableExpression("_hash_", containerType), "getAt", (Expression)new VariableExpression("_index_", indexType));
            try {
                this.visitMethodCallExpression(vcall);
            }
            finally {
                this.errorCollector = oldCollector;
            }
            return this.getType(vcall);
        }
        return componentType;
    }

    protected MethodNode findMethodOrFail(Expression expr, ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> methods = this.findMethod(receiver, name, args);
        if (methods.isEmpty()) {
            this.addNoMatchingMethodError(receiver, name, args, expr);
        } else {
            if (this.areCategoryMethodCalls(methods, name, args)) {
                this.addCategoryMethodCallError(expr);
            }
            if (methods.size() == 1) {
                return methods.get(0);
            }
            this.addAmbiguousErrorMessage(methods, name, args, expr);
        }
        return null;
    }

    private void addNoMatchingMethodError(ClassNode receiver, String name, ClassNode[] args, Expression call) {
        this.addStaticTypeError("Cannot find matching method " + receiver.getText() + "#" + StaticTypeCheckingSupport.toMethodParametersString(name, args) + ". Please check if the declared type is right and if the method exists.", call);
    }

    private void addAmbiguousErrorMessage(List<MethodNode> foundMethods, String name, ClassNode[] args, Expression expr) {
        this.addStaticTypeError("Reference to method is ambiguous. Cannot choose between " + StaticTypeCheckingVisitor.prettyPrintMethodList(foundMethods), expr);
    }

    private static String prettyPrintMethodList(List<MethodNode> nodes) {
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        int nodesSize = nodes.size();
        while (i < nodesSize) {
            MethodNode node = nodes.get(i);
            sb.append(node.getReturnType().toString(false));
            sb.append(" ");
            sb.append(node.getDeclaringClass().toString(false));
            sb.append("#");
            sb.append(StaticTypeCheckingSupport.toMethodParametersString(node.getName(), StaticTypeCheckingVisitor.extractTypesFromParameters(node.getParameters())));
            if (i < nodesSize - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private void addCategoryMethodCallError(Expression call) {
        this.addStaticTypeError("Due to their dynamic nature, usage of categories is not possible with static type checking active", call);
    }

    private void addAssignmentError(ClassNode leftType, ClassNode rightType, Expression assignmentExpression) {
        this.addStaticTypeError("Cannot assign value of type " + rightType.getText() + " to variable of type " + leftType.getText(), assignmentExpression);
    }

    private boolean areCategoryMethodCalls(List<MethodNode> foundMethods, String name, ClassNode[] args) {
        boolean category = false;
        if ("use".equals(name) && args != null && args.length == 2 && args[1].equals(ClassHelper.CLOSURE_TYPE)) {
            category = true;
            for (MethodNode method : foundMethods) {
                if (method instanceof ExtensionMethodNode && ((ExtensionMethodNode)method).getExtensionMethodNode().getDeclaringClass().equals(DGM_CLASSNODE)) continue;
                category = false;
                break;
            }
        }
        return category;
    }

    protected List<MethodNode> findMethodsWithGenerated(ClassNode receiver, String name) {
        List<MethodNode> methods = receiver.getMethods(name);
        if (methods.isEmpty() || receiver.isResolved()) {
            return methods;
        }
        List<MethodNode> result = this.addGeneratedMethods(receiver, methods);
        return result;
    }

    private List<MethodNode> addGeneratedMethods(ClassNode receiver, List<MethodNode> methods) {
        LinkedList<MethodNode> result = new LinkedList<MethodNode>();
        for (MethodNode method : methods) {
            result.add(method);
            Parameter[] parameters = method.getParameters();
            int counter = 0;
            int size = parameters.length;
            int i = size - 1;
            while (i >= 0) {
                Parameter parameter = parameters[i];
                if (parameter != null && parameter.hasInitialExpression()) {
                    ++counter;
                }
                --i;
            }
            int j = 1;
            while (j <= counter) {
                Parameter[] newParams = new Parameter[parameters.length - j];
                int index = 0;
                int k = 1;
                int i2 = 0;
                while (i2 < parameters.length) {
                    if (k > counter - j && parameters[i2] != null && parameters[i2].hasInitialExpression()) {
                        ++k;
                    } else if (parameters[i2] != null && parameters[i2].hasInitialExpression()) {
                        newParams[index++] = parameters[i2];
                        ++k;
                    } else {
                        newParams[index++] = parameters[i2];
                    }
                    ++i2;
                }
                MethodNode stubbed = "<init>".equals(method.getName()) ? new ConstructorNode(method.getModifiers(), newParams, method.getExceptions(), EmptyStatement.INSTANCE) : new MethodNode(method.getName(), method.getModifiers(), method.getReturnType(), newParams, method.getExceptions(), EmptyStatement.INSTANCE);
                stubbed.setDeclaringClass(receiver);
                result.add(stubbed);
                ++j;
            }
        }
        return result;
    }

    protected List<MethodNode> findMethod(ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> methodNodes;
        TypeCheckerPlugin plugin;
        List<MethodNode> result;
        MethodNode constructor;
        List<MethodNode> chosen;
        List<MethodNode> methods;
        if (ClassHelper.isPrimitiveType(receiver)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        if ("<init>".equals(name)) {
            methods = this.addGeneratedMethods(receiver, new ArrayList<MethodNode>(receiver.getDeclaredConstructors()));
            if (methods.isEmpty()) {
                ConstructorNode node = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                node.setDeclaringClass(receiver);
                return Collections.singletonList(node);
            }
        } else {
            String pname;
            methods = this.findMethodsWithGenerated(receiver, name);
            if (receiver.isInterface()) {
                this.collectAllInterfaceMethodsByName(receiver, name, methods);
                methods.addAll(ClassHelper.OBJECT_TYPE.getMethods(name));
            }
            if (this.closureExpression == null) {
                ClassNode parent = receiver;
                while (parent instanceof InnerClassNode && !parent.isStaticClass()) {
                    parent = parent.getOuterClass();
                    methods.addAll(this.findMethodsWithGenerated(parent, name));
                }
            }
            if (methods.isEmpty() && (args == null || args.length == 0)) {
                pname = null;
                if (name.startsWith("get")) {
                    pname = Introspector.decapitalize(name.substring(3));
                } else if (name.startsWith("is")) {
                    pname = Introspector.decapitalize(name.substring(2));
                }
                if (pname != null) {
                    PropertyNode property = null;
                    ClassNode curNode = receiver;
                    while (property == null && curNode != null) {
                        property = curNode.getProperty(pname);
                        curNode = curNode.getSuperClass();
                    }
                    if (property != null) {
                        MethodNode node = new MethodNode(name, 1, property.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                        if (property.isStatic()) {
                            node.setModifiers(9);
                        }
                        node.setDeclaringClass(receiver);
                        return Collections.singletonList(node);
                    }
                }
            } else if (methods.isEmpty() && args != null && args.length == 1 && name.startsWith("set")) {
                ClassNode type;
                pname = Introspector.decapitalize(name.substring(3));
                ClassNode curNode = receiver;
                PropertyNode property = null;
                while (property == null && curNode != null) {
                    property = curNode.getProperty(pname);
                    curNode = curNode.getSuperClass();
                }
                if (property != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(args[0], type = property.getOriginType())) {
                    MethodNode node = new MethodNode(name, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(type, "arg")}, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                    if (property.isStatic()) {
                        node.setModifiers(9);
                    }
                    node.setDeclaringClass(receiver);
                    return Collections.singletonList(node);
                }
            }
        }
        if (methods.isEmpty()) {
            this.collectAllInterfaceMethodsByName(receiver, name, methods);
        }
        if (!(chosen = StaticTypeCheckingSupport.chooseBestMethod(receiver, methods, args)).isEmpty()) {
            return chosen;
        }
        if (receiver instanceof InnerClassNode && ((InnerClassNode)receiver).isAnonymous() && methods.size() == 1 && args != null && "<init>".equals(name) && (constructor = methods.get(0)).getParameters().length == args.length) {
            return methods;
        }
        if (receiver.equals(ClassHelper.CLASS_Type) && receiver.getGenericsTypes() != null && !(result = this.findMethod(receiver.getGenericsTypes()[0].getType(), name, args)).isEmpty()) {
            return result;
        }
        methods.clear();
        chosen = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(receiver, name, args, methods);
        if (!chosen.isEmpty()) {
            return chosen;
        }
        if (ClassHelper.GSTRING_TYPE.equals(receiver)) {
            return this.findMethod(ClassHelper.STRING_TYPE, name, args);
        }
        if (this.pluginFactory != null && (plugin = this.pluginFactory.getTypeCheckerPlugin(this.classNode)) != null && (methodNodes = plugin.findMethod(receiver, name, args)) != null && !methodNodes.isEmpty()) {
            return methodNodes;
        }
        if (StaticTypeCheckingSupport.isBeingCompiled(receiver) && !(chosen = this.findMethod(ClassHelper.GROOVY_OBJECT_TYPE, name, args)).isEmpty()) {
            return chosen;
        }
        return EMPTY_METHODNODE_LIST;
    }

    private void collectAllInterfaceMethodsByName(ClassNode receiver, String name, List<MethodNode> methods) {
        ClassNode[] interfaces = receiver.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            ClassNode[] classNodeArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode node = classNodeArray[n2];
                List<MethodNode> intfMethods = node.getMethods(name);
                methods.addAll(intfMethods);
                this.collectAllInterfaceMethodsByName(node, name, methods);
                ++n2;
            }
        }
    }

    protected ClassNode getType(ASTNode exp) {
        ClassNode irt;
        ClassNode cn = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn != null) {
            return cn;
        }
        if (exp instanceof ClassExpression) {
            ClassNode node = ClassHelper.CLASS_Type.getPlainNodeReference();
            node.setGenericsTypes(new GenericsType[]{new GenericsType(((ClassExpression)exp).getType())});
            return node;
        }
        if (exp instanceof VariableExpression) {
            Parameter parameter;
            ClassNode type;
            VariableExpression vexp = (VariableExpression)exp;
            if (vexp == VariableExpression.THIS_EXPRESSION) {
                return this.classNode;
            }
            if (vexp == VariableExpression.SUPER_EXPRESSION) {
                return this.classNode.getSuperClass();
            }
            Variable variable = vexp.getAccessedVariable();
            if (variable != null && variable != vexp && variable instanceof VariableExpression) {
                return this.getType((Expression)((Object)variable));
            }
            if (variable instanceof Parameter && (type = this.controlStructureVariables.get(parameter = (Parameter)variable)) != null) {
                this.storeType((VariableExpression)exp, type);
                return type;
            }
        } else if (exp instanceof PropertyExpression) {
            PropertyExpression pexp = (PropertyExpression)exp;
            ClassNode objectExpType = this.getType(pexp.getObjectExpression());
            if ((ClassHelper.LIST_TYPE.equals(objectExpType) || objectExpType.implementsInterface(ClassHelper.LIST_TYPE)) && pexp.isSpreadSafe()) {
                return ClassHelper.LIST_TYPE;
            }
            if ((objectExpType.equals(ClassHelper.MAP_TYPE) || objectExpType.implementsInterface(ClassHelper.MAP_TYPE)) && pexp.isSpreadSafe()) {
                String propertyName = pexp.getPropertyAsString();
                GenericsType[] types = objectExpType.getGenericsTypes();
                if ("key".equals(propertyName)) {
                    if (types.length == 2) {
                        ClassNode listKey = ClassHelper.LIST_TYPE.getPlainNodeReference();
                        listKey.setGenericsTypes(new GenericsType[]{types[0]});
                        return listKey;
                    }
                } else if ("value".equals(propertyName)) {
                    if (types.length == 2) {
                        ClassNode listValue = ClassHelper.LIST_TYPE.getPlainNodeReference();
                        listValue.setGenericsTypes(new GenericsType[]{types[1]});
                        return listValue;
                    }
                } else {
                    this.addStaticTypeError("Spread operator on map only allows one of [key,value]", pexp);
                }
                return ClassHelper.LIST_TYPE;
            }
            if (objectExpType.isEnum()) {
                return objectExpType;
            }
            AtomicReference<ClassNode> result = new AtomicReference<ClassNode>(ClassHelper.VOID_TYPE);
            this.existsProperty(pexp, false, new PropertyLookupVisitor(result));
            return result.get();
        }
        if (exp instanceof ListExpression) {
            return this.inferListExpressionType((ListExpression)exp);
        }
        if (exp instanceof MapExpression) {
            return this.inferMapExpressionType((MapExpression)exp);
        }
        if (exp instanceof MethodNode) {
            if ((exp == GET_DELEGATE || exp == GET_OWNER || exp == GET_THISOBJECT) && this.closureExpression != null) {
                return this.classNode;
            }
            ClassNode ret = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
            return ret != null ? ret : ((MethodNode)exp).getReturnType();
        }
        if (exp instanceof ClosureExpression && (irt = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) != null) {
            irt = StaticTypeCheckingVisitor.wrapTypeIfNecessary(irt);
            ClassNode result = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
            result.setGenericsTypes(new GenericsType[]{new GenericsType(irt)});
            return result;
        }
        if (exp instanceof RangeExpression) {
            ClassNode toType;
            ClassNode plain = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            RangeExpression re = (RangeExpression)exp;
            ClassNode fromType = this.getType(re.getFrom());
            if (fromType.equals(toType = this.getType(re.getTo()))) {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(fromType))});
            } else {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(WideningCategories.lowestUpperBound(fromType, toType)))});
            }
            return plain;
        }
        if (exp instanceof UnaryPlusExpression) {
            return this.getType(((UnaryPlusExpression)exp).getExpression());
        }
        if (exp instanceof UnaryMinusExpression) {
            return this.getType(((UnaryMinusExpression)exp).getExpression());
        }
        if (exp instanceof BitwiseNegationExpression) {
            return this.getType(((BitwiseNegationExpression)exp).getExpression());
        }
        return exp instanceof VariableExpression ? ((VariableExpression)exp).getOriginType() : ((Expression)exp).getType();
    }

    private ClassNode inferListExpressionType(ListExpression list) {
        List<Expression> expressions = list.getExpressions();
        if (expressions.isEmpty()) {
            return list.getType();
        }
        ClassNode listType = list.getType();
        GenericsType[] genericsTypes = listType.getGenericsTypes();
        if ((genericsTypes == null || genericsTypes.length == 0 || genericsTypes.length == 1 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType())) && !expressions.isEmpty()) {
            LinkedList<ClassNode> nodes = new LinkedList<ClassNode>();
            for (Expression expression : expressions) {
                if (StaticTypeCheckingVisitor.isNullConstant(expression)) continue;
                nodes.add(this.getType(expression));
            }
            if (nodes.isEmpty()) {
                return listType;
            }
            ClassNode superType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(nodes));
            ClassNode inferred = listType.getPlainNodeReference();
            inferred.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(superType))});
            return inferred;
        }
        return listType;
    }

    private static boolean isNullConstant(Expression expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).getValue() == null;
    }

    private ClassNode inferMapExpressionType(MapExpression map) {
        ClassNode mapType = map.getType();
        List<MapEntryExpression> entryExpressions = map.getMapEntryExpressions();
        if (entryExpressions.isEmpty()) {
            return mapType;
        }
        GenericsType[] genericsTypes = mapType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length < 2 || genericsTypes.length == 2 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType()) && ClassHelper.OBJECT_TYPE.equals(genericsTypes[1].getType())) {
            LinkedList<ClassNode> keyTypes = new LinkedList<ClassNode>();
            LinkedList<ClassNode> valueTypes = new LinkedList<ClassNode>();
            for (MapEntryExpression entryExpression : entryExpressions) {
                keyTypes.add(this.getType(entryExpression.getKeyExpression()));
                valueTypes.add(this.getType(entryExpression.getValueExpression()));
            }
            ClassNode keyType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(keyTypes));
            ClassNode valueType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(valueTypes));
            if (!ClassHelper.OBJECT_TYPE.equals(keyType) || !ClassHelper.OBJECT_TYPE.equals(valueType)) {
                ClassNode inferred = mapType.getPlainNodeReference();
                inferred.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(keyType)), new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(valueType))});
                return inferred;
            }
        }
        return mapType;
    }

    /*
     * Unable to fully structure code
     */
    protected ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments) {
        block32: {
            returnType = method.getReturnType();
            if (method instanceof ExtensionMethodNode && StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(returnType)) {
                emn = (ExtensionMethodNode)method;
                dgmMethod = emn.getExtensionMethodNode();
                dc = emn.getDeclaringClass();
                argList = new ArgumentListExpression();
                vexp = new VariableExpression("$foo", receiver);
                argList.addExpression(vexp);
                if (arguments instanceof ArgumentListExpression) {
                    expressions = ((ArgumentListExpression)arguments).getExpressions();
                    for (Expression arg : expressions) {
                        argList.addExpression(arg);
                    }
                } else {
                    argList.addExpression(arguments);
                }
                return this.inferReturnTypeGenerics(dc, dgmMethod, argList);
            }
            if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(returnType)) {
                return returnType;
            }
            v0 = returnTypeGenerics = returnType.isArray() != false ? returnType.getComponentType().getGenericsTypes() : returnType.getGenericsTypes();
            if (returnTypeGenerics == null) {
                return returnType;
            }
            resolvedPlaceholders = new HashMap<String, GenericsType>();
            if (method.isStatic() && ClassHelper.CLASS_Type.equals(receiver) && receiver.isUsingGenerics() && receiver.getGenericsTypes().length > 0) {
                GenericsUtils.extractPlaceholders(receiver.getGenericsTypes()[0].getType(), resolvedPlaceholders);
            } else {
                current = receiver;
                while (current != null) {
                    GenericsUtils.extractPlaceholders(current, resolvedPlaceholders);
                    current = current.getUnresolvedSuperClass();
                }
            }
            GenericsUtils.extractPlaceholders(method.getReturnType(), resolvedPlaceholders);
            if (resolvedPlaceholders.isEmpty()) {
                return returnType;
            }
            parameters = method.getParameters();
            isVargs = StaticTypeCheckingSupport.isVargs(parameters);
            argList = InvocationWriter.makeArgumentList(arguments);
            expressions = argList.getExpressions();
            paramLength = parameters.length;
            if (expressions.size() < paramLength) break block32;
            i = 0;
            while (i < paramLength) {
                block33: {
                    lastArg = i == paramLength - 1;
                    type = parameters[i].getType();
                    if (!type.isUsingGenerics() && type.isArray()) {
                        type = type.getComponentType();
                    }
                    if (!type.isUsingGenerics()) break block33;
                    actualType = this.getType(expressions.get(i));
                    if (isVargs && lastArg && actualType.isArray()) {
                        actualType = actualType.getComponentType();
                    }
                    actualType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(actualType);
                    typePlaceholders = GenericsUtils.extractPlaceholders(type);
                    if (!ClassHelper.OBJECT_TYPE.equals(type)) ** GOTO lbl70
                    for (String key : typePlaceholders.keySet()) {
                        resolvedPlaceholders.put(key, new GenericsType(actualType.isArray() != false ? actualType.getComponentType() : actualType));
                    }
                    break block33;
lbl-1000:
                    // 1 sources

                    {
                        interfaces = actualType.getAllInterfaces();
                        intf = false;
                        for (ClassNode anInterface : interfaces) {
                            if (!anInterface.equals(type)) continue;
                            intf = true;
                            actualType = GenericsUtils.parameterizeType(actualType, anInterface);
                        }
                        if (intf) continue;
                        actualType = actualType.getUnresolvedSuperClass();
lbl70:
                        // 3 sources

                        ** while (!actualType.equals((Object)type))
                    }
lbl71:
                    // 1 sources

                    actualTypePlaceholders = GenericsUtils.extractPlaceholders(actualType);
                    for (Map.Entry<String, GenericsType> typeEntry : actualTypePlaceholders.entrySet()) {
                        key = typeEntry.getKey();
                        value = typeEntry.getValue();
                        alias = typePlaceholders.get(key);
                        if (alias == null || !alias.isPlaceholder()) continue;
                        resolvedPlaceholders.put(alias.getName(), value);
                    }
                }
                ++i;
            }
        }
        if (returnType.isGenericsPlaceHolder() && (resolved = (GenericsType)resolvedPlaceholders.get(returnType.getUnresolvedName())) != null && !resolved.isPlaceholder() && !resolved.isWildcard()) {
            return resolved.getType();
        }
        copy = new GenericsType[returnTypeGenerics.length];
        i = 0;
        while (i < copy.length) {
            returnTypeGeneric = returnTypeGenerics[i];
            if (returnTypeGeneric.isPlaceholder() || returnTypeGeneric.isWildcard()) {
                resolved = (GenericsType)resolvedPlaceholders.get(returnTypeGeneric.getName());
                if (resolved == null) {
                    resolved = returnTypeGeneric;
                }
                copy[i] = StaticTypeCheckingVisitor.fullyResolve(resolved, resolvedPlaceholders);
            } else {
                copy[i] = StaticTypeCheckingVisitor.fullyResolve(returnTypeGeneric, resolvedPlaceholders);
            }
            ++i;
        }
        firstGenericsType = copy[0];
        if (returnType.equals(ClassHelper.OBJECT_TYPE)) {
            if (firstGenericsType.getType().isGenericsPlaceHolder()) {
                return ClassHelper.OBJECT_TYPE;
            }
            if (firstGenericsType.isWildcard()) {
                if (firstGenericsType.getLowerBound() != null) {
                    return firstGenericsType.getLowerBound();
                }
                upperBounds = firstGenericsType.getUpperBounds();
                if (upperBounds == null) {
                    return ClassHelper.OBJECT_TYPE;
                }
                if (upperBounds.length == 1) {
                    return upperBounds[0];
                }
                return new UnionTypeClassNode(upperBounds);
            }
            return firstGenericsType.getType();
        }
        if (returnType.isArray()) {
            returnType = returnType.getComponentType().getPlainNodeReference();
            returnType.setGenericsTypes(copy);
            if (ClassHelper.OBJECT_TYPE.equals(returnType)) {
                returnType = firstGenericsType.getType();
            }
            returnType = returnType.makeArray();
        } else {
            returnType = returnType.getPlainNodeReference();
            returnType.setGenericsTypes(copy);
        }
        if (returnType.equals(ClassHelper.Annotation_TYPE) && returnType.getGenericsTypes() != null && !returnType.getGenericsTypes()[0].isPlaceholder()) {
            return returnType.getGenericsTypes()[0].getType();
        }
        return returnType;
    }

    private static GenericsType fullyResolve(GenericsType gt, Map<String, GenericsType> placeholders) {
        ClassNode[] upperBounds;
        if (gt.isPlaceholder() && placeholders.containsKey(gt.getName()) && !placeholders.get(gt.getName()).isPlaceholder()) {
            gt = placeholders.get(gt.getName());
        }
        ClassNode type = StaticTypeCheckingVisitor.fullyResolveType(gt.getType(), placeholders);
        ClassNode lowerBound = gt.getLowerBound();
        if (lowerBound != null) {
            lowerBound = StaticTypeCheckingVisitor.fullyResolveType(lowerBound, placeholders);
        }
        if ((upperBounds = gt.getUpperBounds()) != null) {
            ClassNode[] copy = new ClassNode[upperBounds.length];
            int i = 0;
            int upperBoundsLength = upperBounds.length;
            while (i < upperBoundsLength) {
                ClassNode upperBound = upperBounds[i];
                copy[i] = StaticTypeCheckingVisitor.fullyResolveType(upperBound, placeholders);
                ++i;
            }
            upperBounds = copy;
        }
        GenericsType genericsType = new GenericsType(type, upperBounds, lowerBound);
        genericsType.setWildcard(gt.isWildcard());
        return genericsType;
    }

    private static ClassNode fullyResolveType(ClassNode type, Map<String, GenericsType> placeholders) {
        if (type.isUsingGenerics() && !type.isGenericsPlaceHolder()) {
            GenericsType[] gts = type.getGenericsTypes();
            if (gts != null) {
                GenericsType[] copy = new GenericsType[gts.length];
                int i = 0;
                while (i < gts.length) {
                    GenericsType genericsType = gts[i];
                    copy[i] = genericsType.isPlaceholder() && placeholders.containsKey(genericsType.getName()) ? placeholders.get(genericsType.getName()) : StaticTypeCheckingVisitor.fullyResolve(genericsType, placeholders);
                    ++i;
                }
                gts = copy;
            }
            ClassNode result = type.getPlainNodeReference();
            result.setGenericsTypes(gts);
            return result;
        }
        if (type.isUsingGenerics() && ClassHelper.OBJECT_TYPE.equals(type) && type.getGenericsTypes() != null) {
            GenericsType genericsType = placeholders.get(type.getGenericsTypes()[0].getName());
            if (genericsType != null) {
                return genericsType.getType();
            }
        } else if (type.isArray()) {
            return StaticTypeCheckingVisitor.fullyResolveType(type.getComponentType(), placeholders).makeArray();
        }
        return type;
    }

    private boolean typeCheckMethodArgumentWithGenerics(ClassNode parameterType, ClassNode argumentType, boolean lastArg) {
        if (StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE == argumentType) {
            return true;
        }
        if (!StaticTypeCheckingSupport.isAssignableTo(argumentType, parameterType) && !lastArg) {
            return false;
        }
        if (!StaticTypeCheckingSupport.isAssignableTo(argumentType, parameterType) && lastArg && parameterType.isArray() && !StaticTypeCheckingSupport.isAssignableTo(argumentType, parameterType.getComponentType())) {
            return false;
        }
        if (parameterType.isUsingGenerics() && argumentType.isUsingGenerics()) {
            GenericsType gt = GenericsUtils.buildWildcardType(parameterType);
            if (!gt.isCompatibleWith(argumentType)) {
                return false;
            }
        } else if (parameterType.isArray() && argumentType.isArray()) {
            this.typeCheckMethodArgumentWithGenerics(parameterType.getComponentType(), argumentType.getComponentType(), lastArg);
        } else if (lastArg && parameterType.isArray()) {
            this.typeCheckMethodArgumentWithGenerics(parameterType.getComponentType(), argumentType, lastArg);
        }
        return true;
    }

    private void typeCheckMethodsWithGenerics(ClassNode receiver, ClassNode[] arguments, MethodNode candidateMethod, Expression location) {
        if (ClassHelper.CLASS_Type.equals(receiver) && receiver.isUsingGenerics() && candidateMethod.getDeclaringClass() != receiver && !(candidateMethod instanceof ExtensionMethodNode)) {
            this.typeCheckMethodsWithGenerics(receiver.getGenericsTypes()[0].getType(), arguments, candidateMethod, location);
            return;
        }
        boolean failure = false;
        Parameter[] parameters = candidateMethod.getParameters();
        GenericsType[] genericsTypes = candidateMethod.getGenericsTypes();
        boolean methodUsesGenerics = genericsTypes != null && genericsTypes.length > 0;
        boolean isExtensionMethod = candidateMethod instanceof ExtensionMethodNode;
        if (isExtensionMethod && methodUsesGenerics) {
            ClassNode[] dgmArgs = new ClassNode[arguments.length + 1];
            dgmArgs[0] = receiver;
            System.arraycopy(arguments, 0, dgmArgs, 1, arguments.length);
            MethodNode extensionMethodNode = ((ExtensionMethodNode)candidateMethod).getExtensionMethodNode();
            Parameter[] dgmMethodArgs = extensionMethodNode.getParameters();
            ClassNode dgmMethodFirstArgType = dgmMethodArgs[0].getType();
            if (dgmMethodFirstArgType.isUsingGenerics() && dgmMethodFirstArgType.isInterface()) {
                ClassNode firstArgType = GenericsUtils.parameterizeType(receiver, dgmMethodFirstArgType);
                HashMap<String, GenericsType> placeholders = new HashMap<String, GenericsType>();
                GenericsType[] gts = dgmMethodFirstArgType.getGenericsTypes();
                int i = 0;
                while (gts != null && i < gts.length) {
                    GenericsType gt = gts[i];
                    if (gt.isPlaceholder()) {
                        placeholders.put(gt.getName(), firstArgType.getGenericsTypes()[i]);
                    }
                    ++i;
                }
                Parameter[] dgmMethodArgsWithPlaceholdersReplaced = new Parameter[dgmMethodArgs.length];
                dgmMethodArgsWithPlaceholdersReplaced[0] = new Parameter(firstArgType, "self");
                int i2 = 1;
                while (i2 < dgmMethodArgsWithPlaceholdersReplaced.length) {
                    ClassNode substitute = dgmMethodArgs[i2].getType();
                    substitute = StaticTypeCheckingVisitor.fullyResolveType(substitute, placeholders);
                    dgmMethodArgsWithPlaceholdersReplaced[i2] = new Parameter(substitute, "arg" + i2);
                    ++i2;
                }
                MethodNode vdgm = new MethodNode(extensionMethodNode.getName(), extensionMethodNode.getModifiers(), extensionMethodNode.getReturnType(), dgmMethodArgsWithPlaceholdersReplaced, extensionMethodNode.getExceptions(), EmptyStatement.INSTANCE);
                this.typeCheckMethodsWithGenerics(extensionMethodNode.getDeclaringClass(), dgmArgs, vdgm, location);
                return;
            }
        }
        Map<String, GenericsType> classGTs = GenericsUtils.extractPlaceholders(receiver);
        if (parameters.length > arguments.length) {
            return;
        }
        HashMap<String, ClassNode> resolvedMethodGenerics = new HashMap<String, ClassNode>();
        ClassNode[] ptypes = new ClassNode[candidateMethod.getParameters().length];
        GenericsType[] methodNodeGenericsTypes = candidateMethod.getGenericsTypes();
        boolean shouldCheckMethodGenericTypes = methodNodeGenericsTypes != null && methodNodeGenericsTypes.length > 0;
        int i = 0;
        while (i < arguments.length) {
            int pindex = Math.min(i, parameters.length - 1);
            ClassNode type = parameters[pindex].getType();
            ptypes[pindex] = type = StaticTypeCheckingVisitor.fullyResolveType(type, classGTs);
            if (shouldCheckMethodGenericTypes && !(failure |= !this.typeCheckMethodArgumentWithGenerics(type, arguments[i], i >= parameters.length - 1))) {
                GenericsType[] typeGenericsTypes = type.getGenericsTypes();
                if (type.isUsingGenerics() && typeGenericsTypes != null) {
                    int gtIndex = 0;
                    int typeGenericsTypesLength = typeGenericsTypes.length;
                    while (gtIndex < typeGenericsTypesLength) {
                        GenericsType typeGenericsType = typeGenericsTypes[gtIndex];
                        if (typeGenericsType.isPlaceholder()) {
                            GenericsType[] genericsTypeArray = methodNodeGenericsTypes;
                            int n = methodNodeGenericsTypes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                GenericsType methodNodeGenericsType = genericsTypeArray[n2];
                                String placeholderName = methodNodeGenericsType.getName();
                                if (methodNodeGenericsType.isPlaceholder() && placeholderName.equals(typeGenericsType.getName())) {
                                    ClassNode parameterized = GenericsUtils.parameterizeType(arguments[i], type);
                                    if (type.isGenericsPlaceHolder()) {
                                        String name = type.getGenericsTypes()[0].getName();
                                        if (name.equals(placeholderName)) {
                                            if (resolvedMethodGenerics.containsKey(name)) {
                                                failure |= !((ClassNode)resolvedMethodGenerics.get(name)).equals(parameterized);
                                            } else {
                                                resolvedMethodGenerics.put(name, parameterized);
                                            }
                                        }
                                    } else if (type.isUsingGenerics() && type.getGenericsTypes() != null) {
                                        GenericsType[] gtInParameter = type.getGenericsTypes();
                                        GenericsType[] gtInArgument = parameterized.getGenericsTypes();
                                        if (gtInArgument != null && gtInArgument.length == gtInParameter.length) {
                                            int j = 0;
                                            while (j < gtInParameter.length) {
                                                GenericsType genericsType = gtInParameter[j];
                                                if (genericsType.getName().equals(placeholderName)) {
                                                    ClassNode actualType = gtInArgument[j].getType();
                                                    if (gtInArgument[j].isPlaceholder() && gtInArgument[j].getName().equals(placeholderName) && resolvedMethodGenerics.containsKey(placeholderName)) {
                                                        actualType = (ClassNode)resolvedMethodGenerics.get(placeholderName);
                                                    }
                                                    if (resolvedMethodGenerics.containsKey(placeholderName)) {
                                                        failure |= !((ClassNode)resolvedMethodGenerics.get(placeholderName)).equals(actualType);
                                                    } else {
                                                        resolvedMethodGenerics.put(placeholderName, actualType);
                                                    }
                                                }
                                                ++j;
                                            }
                                        }
                                    }
                                }
                                ++n2;
                            }
                        }
                        ++gtIndex;
                    }
                }
            }
            ++i;
        }
        if (failure) {
            this.addStaticTypeError("Cannot call " + receiver.getName() + "#" + StaticTypeCheckingSupport.toMethodParametersString(candidateMethod.getName(), ptypes) + " with arguments " + StaticTypeCheckingVisitor.formatArgumentList(arguments), location);
        }
    }

    private static String formatArgumentList(ClassNode[] nodes) {
        if (nodes == null) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(24 * nodes.length);
        sb.append("[");
        ClassNode[] classNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode node = classNodeArray[n2];
            sb.append(StaticTypeCheckingSupport.prettyPrintType(node));
            sb.append(", ");
            ++n2;
        }
        if (sb.length() > 1) {
            sb.setCharAt(sb.length() - 2, ']');
        }
        return sb.toString();
    }

    @Override
    protected void addError(String msg, ASTNode expr) {
        Long err = (long)expr.getLineNumber() << 16 + expr.getColumnNumber();
        if (!this.reportedErrors.contains(err)) {
            this.errorCollector.addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(String.valueOf(msg) + '\n', expr.getLineNumber(), expr.getColumnNumber(), expr.getLastLineNumber(), expr.getLastColumnNumber()), this.source));
            this.reportedErrors.add(err);
        }
    }

    protected void addStaticTypeError(String msg, ASTNode expr) {
        if (expr.getColumnNumber() > 0 && expr.getLineNumber() > 0) {
            this.addError("[Static type checking] - " + msg, expr);
        }
    }

    public void setMethodsToBeVisited(Set<MethodNode> methodsToBeVisited) {
        this.methodsToBeVisited = methodsToBeVisited;
    }

    public void performSecondPass() {
        for (SecondPassExpression wrapper : this.secondPassExpressions) {
            VariableExpression var;
            List<ClassNode> classNodes;
            Variable target;
            MethodCallExpression call;
            Expression objectExpression;
            Expression expression = wrapper.getExpression();
            if (expression instanceof BinaryExpression) {
                List<MethodNode> method;
                VariableExpression var2;
                List<ClassNode> classNodes2;
                Variable target2;
                Expression left = ((BinaryExpression)expression).getLeftExpression();
                if (!(left instanceof VariableExpression) || !((target2 = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)left)) instanceof VariableExpression) || (classNodes2 = this.closureSharedVariablesAssignmentTypes.get(var2 = (VariableExpression)target2)) == null || classNodes2.size() <= 1) continue;
                ClassNode lub = WideningCategories.lowestUpperBound(classNodes2);
                String message = StaticTypeCheckingSupport.getOperationName(((BinaryExpression)expression).getOperation().getType());
                if (message == null || !(method = this.findMethod(lub, message, this.getType(((BinaryExpression)expression).getRightExpression()))).isEmpty()) continue;
                this.addStaticTypeError("A closure shared variable [" + target2.getName() + "] has been assigned with various types and the method" + " [" + StaticTypeCheckingSupport.toMethodParametersString(message, this.getType(((BinaryExpression)expression).getRightExpression())) + "]" + " does not exist in the lowest upper bound of those types: [" + lub.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot" + " determine safely what is the type of the variable at the moment of the call in a multithreaded context.", expression);
                continue;
            }
            if (!(expression instanceof MethodCallExpression) || !((objectExpression = (call = (MethodCallExpression)expression).getObjectExpression()) instanceof VariableExpression) || !((target = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression)) instanceof VariableExpression) || (classNodes = this.closureSharedVariablesAssignmentTypes.get(var = (VariableExpression)target)) == null || classNodes.size() <= 1) continue;
            ClassNode lub = WideningCategories.lowestUpperBound(classNodes);
            MethodNode methodNode = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            Parameter[] parameters = methodNode.getParameters();
            ClassNode[] params = StaticTypeCheckingVisitor.extractTypesFromParameters(parameters);
            ClassNode[] argTypes = (ClassNode[])wrapper.getData();
            List<MethodNode> method = this.findMethod(lub, methodNode.getName(), argTypes);
            if (method.size() == 1) continue;
            this.addStaticTypeError("A closure shared variable [" + target.getName() + "] has been assigned with various types and the method" + " [" + StaticTypeCheckingSupport.toMethodParametersString(methodNode.getName(), params) + "]" + " does not exist in the lowest upper bound of those types: [" + lub.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot" + " determine safely what is the type of the variable at the moment of the call in a multithreaded context.", call);
        }
    }

    private static ClassNode[] extractTypesFromParameters(Parameter[] parameters) {
        ClassNode[] params = new ClassNode[parameters.length];
        int i = 0;
        while (i < params.length) {
            params[i] = parameters[i].getType();
            ++i;
        }
        return params;
    }

    private static ClassNode wrapTypeIfNecessary(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type)) {
            return ClassHelper.getWrapper(type);
        }
        return type;
    }

    private static boolean isClassInnerClassOrEqualTo(ClassNode toBeChecked, ClassNode start) {
        if (start == toBeChecked) {
            return true;
        }
        if (start instanceof InnerClassNode) {
            return StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(toBeChecked, start.getOuterClass());
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyLookupVisitor
    extends ClassCodeVisitorSupport {
        private final AtomicReference<ClassNode> result;

        public PropertyLookupVisitor(AtomicReference<ClassNode> result) {
            this.result = result;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return null;
        }

        @Override
        public void visitMethod(MethodNode node) {
            this.result.set(node.getReturnType());
        }

        @Override
        public void visitProperty(PropertyNode node) {
            this.result.set(node.getType());
        }

        @Override
        public void visitField(FieldNode field) {
            this.result.set(field.getType());
        }
    }

    protected static interface SignatureCodec {
        public String encode(ClassNode var1);

        public ClassNode decode(String var1);
    }

    protected static class SignatureCodecFactory {
        protected SignatureCodecFactory() {
        }

        static SignatureCodec getCodec(int version) {
            switch (version) {
                case 1: {
                    return new SignatureCodecVersion1();
                }
            }
            return null;
        }
    }

    private static class SignatureCodecVersion1
    implements SignatureCodec {
        private SignatureCodecVersion1() {
        }

        private void doEncode(ClassNode node, DataOutputStream dos) throws IOException {
            dos.writeUTF(node.getClass().getSimpleName());
            if (node instanceof UnionTypeClassNode) {
                UnionTypeClassNode union = (UnionTypeClassNode)node;
                ClassNode[] delegates = union.getDelegates();
                dos.writeInt(delegates.length);
                ClassNode[] classNodeArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode delegate = classNodeArray[n2];
                    this.doEncode(delegate, dos);
                    ++n2;
                }
                return;
            }
            if (node instanceof WideningCategories.LowestUpperBoundClassNode) {
                WideningCategories.LowestUpperBoundClassNode lub = (WideningCategories.LowestUpperBoundClassNode)node;
                dos.writeUTF(lub.getLubName());
                this.doEncode(lub.getUnresolvedSuperClass(), dos);
                ClassNode[] interfaces = lub.getInterfaces();
                if (interfaces == null) {
                    dos.writeInt(-1);
                } else {
                    dos.writeInt(interfaces.length);
                    ClassNode[] classNodeArray = interfaces;
                    int n = interfaces.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ClassNode anInterface = classNodeArray[n3];
                        this.doEncode(anInterface, dos);
                        ++n3;
                    }
                }
                return;
            }
            if (node.isArray()) {
                dos.writeBoolean(true);
                this.doEncode(node.getComponentType(), dos);
            } else {
                dos.writeBoolean(false);
                dos.writeUTF(BytecodeHelper.getTypeDescription(node));
                dos.writeBoolean(node.isUsingGenerics());
                GenericsType[] genericsTypes = node.getGenericsTypes();
                if (genericsTypes == null) {
                    dos.writeInt(-1);
                } else {
                    dos.writeInt(genericsTypes.length);
                    GenericsType[] genericsTypeArray = genericsTypes;
                    int n = genericsTypes.length;
                    int n4 = 0;
                    while (n4 < n) {
                        GenericsType type = genericsTypeArray[n4];
                        dos.writeBoolean(type.isPlaceholder());
                        dos.writeBoolean(type.isWildcard());
                        this.doEncode(type.getType(), dos);
                        ClassNode lb = type.getLowerBound();
                        if (lb == null) {
                            dos.writeBoolean(false);
                        } else {
                            dos.writeBoolean(true);
                            this.doEncode(lb, dos);
                        }
                        ClassNode[] upperBounds = type.getUpperBounds();
                        if (upperBounds == null) {
                            dos.writeInt(-1);
                        } else {
                            dos.writeInt(upperBounds.length);
                            ClassNode[] classNodeArray = upperBounds;
                            int n5 = upperBounds.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                ClassNode bound = classNodeArray[n6];
                                this.doEncode(bound, dos);
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
            }
        }

        public String encode(ClassNode node) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
            DataOutputStream dos = new DataOutputStream(baos);
            StringWriter wrt = new StringWriter();
            String encoded = null;
            try {
                this.doEncode(node, dos);
                EncodingGroovyMethods.encodeBase64(baos.toByteArray()).writeTo(wrt);
                encoded = wrt.toString();
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("Unable to serialize type information", e);
            }
            return encoded;
        }

        private ClassNode doDecode(DataInputStream dis) throws IOException {
            String classNodeType = dis.readUTF();
            if (UnionTypeClassNode.class.getSimpleName().equals(classNodeType)) {
                int len = dis.readInt();
                ClassNode[] delegates = new ClassNode[len];
                int i = 0;
                while (i < len) {
                    delegates[i] = this.doDecode(dis);
                    ++i;
                }
                return new UnionTypeClassNode(delegates);
            }
            if (WideningCategories.LowestUpperBoundClassNode.class.getSimpleName().equals(classNodeType)) {
                String name = dis.readUTF();
                ClassNode upper = this.doDecode(dis);
                int len = dis.readInt();
                ClassNode[] interfaces = null;
                if (len >= 0) {
                    interfaces = new ClassNode[len];
                    int i = 0;
                    while (i < len) {
                        interfaces[i] = this.doDecode(dis);
                        ++i;
                    }
                }
                return new WideningCategories.LowestUpperBoundClassNode(name, upper, interfaces);
            }
            boolean makeArray = dis.readBoolean();
            if (makeArray) {
                return this.doDecode(dis).makeArray();
            }
            String typedesc = dis.readUTF();
            char typeCode = typedesc.charAt(0);
            ClassNode result = ClassHelper.OBJECT_TYPE;
            if (typeCode == 'L') {
                String className = typedesc.replace('/', '.').substring(1, typedesc.length() - 1);
                try {
                    result = ClassHelper.make(Class.forName(className)).getPlainNodeReference();
                }
                catch (ClassNotFoundException e) {
                    result = ClassHelper.make(className);
                }
                result.setUsingGenerics(dis.readBoolean());
                int len = dis.readInt();
                if (len >= 0) {
                    GenericsType[] gts = new GenericsType[len];
                    int i = 0;
                    while (i < len) {
                        boolean placeholder = dis.readBoolean();
                        boolean wildcard = dis.readBoolean();
                        ClassNode type = this.doDecode(dis);
                        boolean low = dis.readBoolean();
                        ClassNode lb = null;
                        if (low) {
                            lb = this.doDecode(dis);
                        }
                        int upc = dis.readInt();
                        ClassNode[] ups = null;
                        if (upc >= 0) {
                            ups = new ClassNode[upc];
                            int j = 0;
                            while (j < upc) {
                                ups[j] = this.doDecode(dis);
                                ++j;
                            }
                        }
                        GenericsType gt = new GenericsType(type, ups, lb);
                        gt.setPlaceholder(placeholder);
                        gt.setWildcard(wildcard);
                        gts[i] = gt;
                        ++i;
                    }
                    result.setGenericsTypes(gts);
                }
            } else {
                switch (typeCode) {
                    case 'I': {
                        result = ClassHelper.int_TYPE;
                        break;
                    }
                    case 'Z': {
                        result = ClassHelper.boolean_TYPE;
                        break;
                    }
                    case 'B': {
                        result = ClassHelper.byte_TYPE;
                        break;
                    }
                    case 'C': {
                        result = ClassHelper.char_TYPE;
                        break;
                    }
                    case 'S': {
                        result = ClassHelper.short_TYPE;
                        break;
                    }
                    case 'D': {
                        result = ClassHelper.double_TYPE;
                        break;
                    }
                    case 'F': {
                        result = ClassHelper.float_TYPE;
                        break;
                    }
                    case 'J': {
                        result = ClassHelper.long_TYPE;
                        break;
                    }
                    case 'V': {
                        result = ClassHelper.VOID_TYPE;
                    }
                }
            }
            return result;
        }

        public ClassNode decode(String signature) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(EncodingGroovyMethods.decodeBase64(signature)));
            try {
                return this.doDecode(dis);
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("Unable to read type information", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VariableExpressionTypeMemoizer
    extends ClassCodeVisitorSupport {
        private final Map<VariableExpression, ClassNode> varOrigType;

        public VariableExpressionTypeMemoizer(Map<VariableExpression, ClassNode> varOrigType) {
            this.varOrigType = varOrigType;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return StaticTypeCheckingVisitor.this.source;
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            super.visitVariableExpression(expression);
            Variable var = StaticTypeCheckingSupport.findTargetVariable(expression);
            if (var instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)var;
                this.varOrigType.put(ve, (ClassNode)ve.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE));
            }
        }
    }
}

