/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc;

import groovy.transform.CompileStatic;
import groovy.transform.TypeChecked;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.classgen.asm.TypeChooser;
import org.codehaus.groovy.classgen.asm.WriterControllerFactory;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesTypeChooser;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.groovy.transform.stc.TypeCheckerPluginFactory;

public class StaticCompilationVisitor
extends StaticTypeCheckingVisitor {
    private static final ClassNode TYPECHECKED_CLASSNODE = ClassHelper.make(TypeChecked.class);
    private static final ClassNode COMPILESTATIC_CLASSNODE = ClassHelper.make(CompileStatic.class);
    private static final ClassNode[] TYPECHECKED_ANNOTATIONS = new ClassNode[]{TYPECHECKED_CLASSNODE, COMPILESTATIC_CLASSNODE};
    public static final ClassNode ARRAYLIST_CLASSNODE = ClassHelper.make(ArrayList.class);
    public static final MethodNode ARRAYLIST_CONSTRUCTOR;
    public static final MethodNode ARRAYLIST_ADD_METHOD;
    private final TypeChooser typeChooser = new StaticTypesTypeChooser();
    private ClassNode classNode;

    static {
        ARRAYLIST_ADD_METHOD = ARRAYLIST_CLASSNODE.getMethod("add", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "o")});
        ARRAYLIST_CONSTRUCTOR = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
        ARRAYLIST_CONSTRUCTOR.setDeclaringClass(ARRAYLIST_CLASSNODE);
    }

    public StaticCompilationVisitor(SourceUnit unit, ClassNode node, TypeCheckerPluginFactory pluginFactory) {
        super(unit, node, pluginFactory);
    }

    protected ClassNode[] getTypeCheckingAnnotations() {
        return TYPECHECKED_ANNOTATIONS;
    }

    public static boolean isStaticallyCompiled(AnnotatedNode node) {
        if (node.getNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE) != null) {
            return (Boolean)node.getNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE);
        }
        if (node instanceof MethodNode) {
            return StaticCompilationVisitor.isStaticallyCompiled(node.getDeclaringClass());
        }
        if (node instanceof InnerClassNode) {
            return StaticCompilationVisitor.isStaticallyCompiled(((InnerClassNode)node).getOuterClass());
        }
        return false;
    }

    public void visitClass(ClassNode node) {
        boolean skip = this.shouldSkipClassNode(node);
        ClassNode oldCN = this.classNode;
        this.classNode = node;
        Iterator<InnerClassNode> innerClasses = this.classNode.getInnerClasses();
        if (innerClasses.hasNext()) {
            this.addPrivateBridgeMethods(this.classNode);
            this.addPrivateFieldsAccessors(this.classNode);
        }
        while (innerClasses.hasNext()) {
            InnerClassNode innerClassNode = innerClasses.next();
            innerClassNode.putNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE, !skip);
            innerClassNode.putNodeMetaData(WriterControllerFactory.class, node.getNodeMetaData(WriterControllerFactory.class));
            this.addPrivateBridgeMethods(innerClassNode);
            this.addPrivateFieldsAccessors(innerClassNode);
        }
        super.visitClass(node);
        this.classNode = oldCN;
    }

    public void visitMethod(MethodNode node) {
        if (this.isSkipMode(node)) {
            node.putNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE, false);
        }
        super.visitMethod(node);
    }

    private void addPrivateFieldsAccessors(ClassNode node) {
        HashMap<String, MethodNode> privateConstantAccessors = (HashMap<String, MethodNode>)node.getNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_FIELDS_ACCESSORS);
        if (privateConstantAccessors != null) {
            return;
        }
        int acc = -1;
        privateConstantAccessors = new HashMap<String, MethodNode>();
        for (FieldNode fieldNode : node.getFields()) {
            int access = fieldNode.getModifiers();
            if (!Modifier.isPrivate(fieldNode.getModifiers()) || (access & 0x1000) != 0) continue;
            Parameter param = new Parameter(node.getPlainNodeReference(), "$that");
            Expression receiver = fieldNode.isStatic() ? new ClassExpression(node) : new VariableExpression(param);
            ExpressionStatement stmt = new ExpressionStatement(new PropertyExpression(receiver, fieldNode.getName()));
            MethodNode accessor = node.addMethod("pfaccess$" + ++acc, 4105, fieldNode.getOriginType(), new Parameter[]{param}, ClassNode.EMPTY_ARRAY, stmt);
            privateConstantAccessors.put(fieldNode.getName(), accessor);
        }
        node.setNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_FIELDS_ACCESSORS, privateConstantAccessors);
    }

    private void addPrivateBridgeMethods(ClassNode node) {
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>(node.getMethods());
        HashMap<MethodNode, MethodNode> privateBridgeMethods = (HashMap<MethodNode, MethodNode>)node.getNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_BRIDGE_METHODS);
        if (privateBridgeMethods != null) {
            return;
        }
        privateBridgeMethods = new HashMap<MethodNode, MethodNode>();
        int i = -1;
        for (MethodNode method : methods) {
            ArgumentListExpression arguments;
            int access = method.getModifiers();
            if (!method.isPrivate() || (access & 0x1000) != 0) continue;
            ++i;
            Parameter[] methodParameters = method.getParameters();
            Parameter[] newParams = new Parameter[methodParameters.length + 1];
            System.arraycopy(methodParameters, 0, newParams, 1, methodParameters.length);
            newParams[0] = new Parameter(node.getPlainNodeReference(), "$that");
            if (method.getParameters() == null || method.getParameters().length == 0) {
                arguments = ArgumentListExpression.EMPTY_ARGUMENTS;
            } else {
                LinkedList<Expression> args = new LinkedList<Expression>();
                Parameter[] parameterArray = methodParameters;
                int n = methodParameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter parameter = parameterArray[n2];
                    args.add(new VariableExpression(parameter));
                    ++n2;
                }
                arguments = new ArgumentListExpression(args);
            }
            Expression receiver = method.isStatic() ? new ClassExpression(node) : new VariableExpression(newParams[0]);
            MethodCallExpression mce = new MethodCallExpression(receiver, method.getName(), (Expression)arguments);
            mce.setMethodTarget(method);
            ExpressionStatement returnStatement = new ExpressionStatement(mce);
            MethodNode bridge = node.addMethod("access$" + i, 4105, method.getReturnType(), newParams, method.getExceptions(), returnStatement);
            privateBridgeMethods.put(method, bridge);
            bridge.addAnnotation(new AnnotationNode(COMPILESTATIC_CLASSNODE));
        }
        node.setNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_BRIDGE_METHODS, privateBridgeMethods);
    }

    private void memorizeInitialExpressions(MethodNode node) {
        if (node.getParameters() != null) {
            Parameter[] parameterArray = node.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                parameter.putNodeMetaData((Object)StaticTypesMarker.INITIAL_EXPRESSION, parameter.getInitialExpression());
                ++n2;
            }
        }
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        throw new UnsupportedOperationException("The spread operator cannot be used with static compilation because the number of arguments cannot be determined at compile time");
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        super.visitMethodCallExpression(call);
        MethodNode target = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (target != null) {
            call.setMethodTarget(target);
            this.memorizeInitialExpressions(target);
        }
        if (call.getMethodTarget() == null && call.getLineNumber() > 0) {
            this.addError("Target method for method call expression hasn't been set", call);
        }
        if (StaticTypeCheckingSupport.isWithCall(call.getMethodAsString(), call.getArguments())) {
            ClosureExpression closure = (ClosureExpression)((ArgumentListExpression)call.getArguments()).getExpression(0);
            closure.putNodeMetaData((Object)StaticCompilationMetadataKeys.WITH_CLOSURE, Boolean.TRUE);
        }
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        super.visitConstructorCallExpression(call);
        MethodNode target = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (target == null && call.getLineNumber() > 0) {
            this.addError("Target constructor for constructor call expression hasn't been set", call);
        } else if (target == null) {
            ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(call.getArguments());
            List<Expression> expressions = argumentListExpression.getExpressions();
            ClassNode[] args = new ClassNode[expressions.size()];
            int i = 0;
            while (i < args.length) {
                args[i] = this.typeChooser.resolveType(expressions.get(i), this.classNode);
                ++i;
            }
            MethodNode constructor = this.findMethodOrFail(call, call.isSuperCall() ? this.classNode.getSuperClass() : this.classNode, "<init>", args);
            call.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, constructor);
            target = constructor;
        }
        if (target != null) {
            this.memorizeInitialExpressions(target);
        }
    }

    public void visitForLoop(ForStatement forLoop) {
        super.visitForLoop(forLoop);
        Expression collectionExpression = forLoop.getCollectionExpression();
        if (!(collectionExpression instanceof ClosureListExpression)) {
            ClassNode collectionType = this.getType(forLoop.getCollectionExpression());
            ClassNode componentType = StaticCompilationVisitor.inferLoopElementType(collectionType);
            forLoop.getVariable().setType(componentType);
        }
    }

    protected MethodNode findMethodOrFail(Expression expr, ClassNode receiver, String name, ClassNode ... args) {
        MethodNode methodNode = super.findMethodOrFail(expr, receiver, name, args);
        if (expr instanceof BinaryExpression && methodNode != null) {
            expr.putNodeMetaData((Object)StaticCompilationMetadataKeys.BINARY_EXP_TARGET, new Object[]{methodNode, name});
        }
        return methodNode;
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly, ClassCodeVisitorSupport visitor) {
        Expression objectExpression;
        ClassNode objectExpressionType;
        boolean exists = super.existsProperty(pexp, checkForReadOnly, visitor);
        if (exists && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(objectExpressionType = this.getType(objectExpression = pexp.getObjectExpression()), ClassHelper.LIST_TYPE)) {
            objectExpression.putNodeMetaData((Object)StaticCompilationMetadataKeys.COMPONENT_TYPE, this.inferComponentType(objectExpressionType, ClassHelper.int_TYPE));
        }
        return exists;
    }
}

