/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.classgen.AnnotationVisitor;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.PreciseSyntaxException;
import org.codehaus.groovy.syntax.SyntaxException;

public class ExtendedVerifier
implements GroovyClassVisitor {
    public static final String JVM_ERROR_MESSAGE = "Please make sure you are running on a JVM >= 1.5";
    private SourceUnit source;
    private ClassNode currentClass;

    public ExtendedVerifier(SourceUnit sourceUnit) {
        this.source = sourceUnit;
    }

    public void visitClass(ClassNode node) {
        this.currentClass = node;
        if (node.isAnnotationDefinition()) {
            this.visitAnnotations(node, 64);
        } else {
            this.visitAnnotations(node, 1);
        }
        PackageNode packageNode = node.getPackage();
        if (packageNode != null) {
            this.visitAnnotations(packageNode, 128);
        }
        node.visitContents(this);
    }

    public void visitField(FieldNode node) {
        this.visitAnnotations(node, 8);
    }

    public void visitConstructor(ConstructorNode node) {
        this.visitConstructorOrMethod(node, 2);
    }

    public void visitMethod(MethodNode node) {
        this.visitConstructorOrMethod(node, 4);
    }

    private void visitConstructorOrMethod(MethodNode node, int methodTarget) {
        this.visitAnnotations(node, methodTarget);
        int i = 0;
        while (i < node.getParameters().length) {
            Parameter parameter = node.getParameters()[i];
            this.visitAnnotations(parameter, 16);
            ++i;
        }
        if (this.currentClass.isAnnotationDefinition() && !node.isStaticConstructor()) {
            Statement code;
            ErrorCollector errorCollector = new ErrorCollector(this.source.getConfiguration());
            AnnotationVisitor visitor = new AnnotationVisitor(this.source, errorCollector);
            visitor.setReportClass(this.currentClass);
            visitor.checkReturnType(node.getReturnType(), node);
            if (node.getParameters().length > 0) {
                this.addError("Annotation members may not have parameters.", node.getParameters()[0]);
            }
            if (node.getExceptions().length > 0) {
                this.addError("Annotation members may not have a throws clause.", node.getExceptions()[0]);
            }
            if ((code = node.getCode()) != null && code instanceof ReturnStatement) {
                visitor.visitExpression(node.getName(), ((ReturnStatement)code).getExpression(), node.getReturnType());
                visitor.checkCircularReference(this.currentClass, node.getReturnType(), ((ReturnStatement)code).getExpression());
            }
            this.source.getErrorCollector().addCollectorContents(errorCollector);
        }
    }

    public void visitProperty(PropertyNode node) {
    }

    protected void visitAnnotations(AnnotatedNode node, int target) {
        if (node.getAnnotations().isEmpty()) {
            return;
        }
        this.currentClass.setAnnotated(true);
        if (!this.isAnnotationCompatible()) {
            this.addError("Annotations are not supported in the current runtime. Please make sure you are running on a JVM >= 1.5", node);
            return;
        }
        for (AnnotationNode unvisited : node.getAnnotations()) {
            boolean isTargetAnnotation;
            AnnotationNode visited = this.visitAnnotation(unvisited);
            boolean bl = isTargetAnnotation = visited.getClassNode().isResolved() && visited.getClassNode().getName().equals("java.lang.annotation.Target");
            if (!isTargetAnnotation && !visited.isTargetAllowed(target)) {
                this.addError("Annotation @" + visited.getClassNode().getName() + " is not allowed on element " + AnnotationNode.targetToName(target), visited);
            }
            this.visitDeprecation(node, visited);
            this.visitOverride(node, visited);
        }
    }

    private void visitDeprecation(AnnotatedNode node, AnnotationNode visited) {
        if (visited.getClassNode().isResolved() && visited.getClassNode().getName().equals("java.lang.Deprecated")) {
            if (node instanceof MethodNode) {
                MethodNode mn = (MethodNode)node;
                mn.setModifiers(mn.getModifiers() | 0x20000);
            } else if (node instanceof FieldNode) {
                FieldNode fn = (FieldNode)node;
                fn.setModifiers(fn.getModifiers() | 0x20000);
            } else if (node instanceof ClassNode) {
                ClassNode cn = (ClassNode)node;
                cn.setModifiers(cn.getModifiers() | 0x20000);
            }
        }
    }

    private void visitOverride(AnnotatedNode node, AnnotationNode visited) {
        ClassNode annotationClassNode = visited.getClassNode();
        if (annotationClassNode.isResolved() && annotationClassNode.getName().equals("java.lang.Override") && node instanceof MethodNode) {
            ClassNode cNode;
            MethodNode origMethod = (MethodNode)node;
            ClassNode next = cNode = node.getDeclaringClass();
            block0: while (next != null) {
                ClassNode correctedNext;
                MethodNode found;
                Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(next);
                MethodNode mn = GenericsUtils.correctToGenericsSpec(genericsSpec, origMethod);
                if (next != cNode && (found = this.getDeclaredMethodCorrected(genericsSpec, mn, correctedNext = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, next))) != null) break;
                ArrayList<ClassNode> ifaces = new ArrayList<ClassNode>();
                ifaces.addAll(Arrays.asList(next.getInterfaces()));
                Map<String, ClassNode> updatedGenericsSpec = new HashMap<String, ClassNode>(genericsSpec);
                while (!ifaces.isEmpty()) {
                    ClassNode iNode;
                    ClassNode origInterface = (ClassNode)ifaces.remove(0);
                    if (origInterface.equals(ClassHelper.OBJECT_TYPE)) continue;
                    MethodNode found2 = this.getDeclaredMethodCorrected(updatedGenericsSpec = GenericsUtils.createGenericsSpec(origInterface, updatedGenericsSpec), mn, iNode = GenericsUtils.correctToGenericsSpecRecurse(updatedGenericsSpec, origInterface));
                    if (found2 != null) break block0;
                    ifaces.addAll(Arrays.asList(iNode.getInterfaces()));
                }
                ClassNode superClass = next.getUnresolvedSuperClass();
                next = superClass != null ? GenericsUtils.correctToGenericsSpecRecurse(updatedGenericsSpec, superClass) : null;
            }
            if (next == null) {
                this.addError("Method '" + origMethod.getName() + "' from class '" + cNode.getName() + "' does not override " + "method from its superclass or interfaces but is annotated with @Override.", visited);
            }
        }
    }

    private MethodNode getDeclaredMethodCorrected(Map genericsSpec, MethodNode mn, ClassNode correctedNext) {
        for (MethodNode orig : correctedNext.getDeclaredMethods(mn.getName())) {
            MethodNode method = GenericsUtils.correctToGenericsSpec((Map<String, ClassNode>)genericsSpec, orig);
            if (!ExtendedVerifier.parametersEqual(method.getParameters(), mn.getParameters())) continue;
            return method;
        }
        return null;
    }

    private static boolean parametersEqual(Parameter[] a, Parameter[] b) {
        if (a.length == b.length) {
            boolean answer = true;
            int i = 0;
            while (i < a.length) {
                if (!a[i].getType().equals(b[i].getType())) {
                    answer = false;
                    break;
                }
                ++i;
            }
            return answer;
        }
        return false;
    }

    private AnnotationNode visitAnnotation(AnnotationNode unvisited) {
        ErrorCollector errorCollector = new ErrorCollector(this.source.getConfiguration());
        AnnotationVisitor visitor = new AnnotationVisitor(this.source, errorCollector);
        AnnotationNode visited = visitor.visit(unvisited);
        this.source.getErrorCollector().addCollectorContents(errorCollector);
        return visited;
    }

    protected boolean isAnnotationCompatible() {
        return "1.5".equals(this.source.getConfiguration().getTargetBytecode());
    }

    protected void addError(String msg, ASTNode expr) {
        if (expr instanceof AnnotationNode) {
            AnnotationNode aNode = (AnnotationNode)expr;
            this.source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new PreciseSyntaxException(String.valueOf(msg) + '\n', expr.getLineNumber(), expr.getColumnNumber(), aNode.getStart(), aNode.getEnd()), this.source));
        } else {
            this.source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(String.valueOf(msg) + '\n', expr.getLineNumber(), expr.getColumnNumber(), expr.getLastLineNumber(), expr.getLastColumnNumber()), this.source));
        }
    }

    public void visitGenericType(GenericsType genericsType) {
    }
}

