/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.activator;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GroovyActivator
extends Plugin {
    public static final String PLUGIN_ID = "org.codehaus.groovy";
    public static final String GROOVY_ALL_JAR = "lib/groovy-all-2.0.8.jar";
    public static URL GROOVY_ALL_JAR_URL;
    private static GroovyActivator DEFAULT;

    public GroovyActivator() {
        DEFAULT = this;
    }

    public static GroovyActivator getDefault() {
        return DEFAULT;
    }

    public void start(BundleContext context) throws Exception {
        if (Boolean.parseBoolean(System.getProperty("greclipse.debug.trace_compiler_start", "false"))) {
            System.out.println("------------");
            System.out.println("GRECLIPSE-1642: stack trace and other info as Groovy-compiler starts");
            this.printBundleState("org.codehaus.groovy.eclipse.compilerResolver");
            this.printBundleState("org.eclipse.jdt.core");
            new Exception().printStackTrace();
            System.out.println("------------");
        }
        super.start(context);
        try {
            GroovyActivator.initialize();
        }
        catch (Exception e) {
            this.getLog().log(new Status(4, PLUGIN_ID, "Error starting groovy plugin", e));
        }
    }

    private void printBundleState(String id) {
        Bundle resolverBundle = Platform.getBundle(id);
        if (resolverBundle != null) {
            String stateString;
            int state = resolverBundle.getState();
            switch (state) {
                case 32: {
                    stateString = "ACTIVE";
                    break;
                }
                case 2: {
                    stateString = "INSTALLED";
                    break;
                }
                case 4: {
                    stateString = "RESOLVED";
                    break;
                }
                case 16: {
                    stateString = "STOPPING";
                    break;
                }
                case 1: {
                    stateString = "UNINSTALLED";
                    break;
                }
                default: {
                    stateString = "UNKNOWN";
                }
            }
            System.out.println(String.valueOf(id) + " state: " + stateString);
        } else {
            System.out.println(String.valueOf(id) + " is not installed");
        }
    }

    public static void initialize() throws IOException {
        Bundle bundle = GroovyActivator.getDefault().getBundle();
        URL entry = bundle.getEntry(GROOVY_ALL_JAR);
        if (entry == null) {
            throw new RuntimeException("Couldn't find 'lib/groovy-all-2.0.8.jar' in bundle " + bundle.getSymbolicName() + " " + bundle.getVersion());
        }
        GROOVY_ALL_JAR_URL = FileLocator.resolve(entry);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }
}

