/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import groovy.lang.Tuple;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImmutableClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.runtime.DateGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.SwingGroovyMethods;
import org.codehaus.groovy.runtime.XmlGroovyMethods;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.GenericsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableScope
implements Iterable<VariableInfo> {
    public static final ClassNode OBJECT_CLASS_NODE = ClassHelper.OBJECT_TYPE;
    public static final ClassNode GROOVY_OBJECT_CLASS_NODE = ClassHelper.GROOVY_OBJECT_TYPE;
    public static final ClassNode NULL_TYPE = new ImmutableClassNode(Object.class);
    public static final ClassNode VOID_CLASS_NODE = ClassHelper.make(Void.TYPE);
    public static final ClassNode VOID_WRAPPER_CLASS_NODE = ClassHelper.void_WRAPPER_TYPE;
    public static final ClassNode LIST_CLASS_NODE = ClassHelper.LIST_TYPE;
    public static final ClassNode MAP_CLASS_NODE = ClassHelper.MAP_TYPE;
    public static final ClassNode RANGE_CLASS_NODE = ClassHelper.RANGE_TYPE;
    public static final ClassNode TUPLE_CLASS_NODE = ClassHelper.make(Tuple.class);
    public static final ClassNode PATTERN_CLASS_NODE = ClassHelper.PATTERN_TYPE;
    public static final ClassNode MATCHER_CLASS_NODE = ClassHelper.make(Matcher.class);
    public static final ClassNode STRING_CLASS_NODE = ClassHelper.STRING_TYPE;
    public static final ClassNode GSTRING_CLASS_NODE = ClassHelper.GSTRING_TYPE;
    public static final ClassNode CLOSURE_CLASS_NODE = ClassHelper.CLOSURE_TYPE;
    public static final ClassNode NUMBER_CLASS_NODE = ClassHelper.make(Number.class);
    public static final ClassNode ITERATOR_CLASS = ClassHelper.make(Iterator.class);
    public static final ClassNode ENUMERATION_CLASS = ClassHelper.make(Enumeration.class);
    public static final ClassNode INPUT_STREAM_CLASS = ClassHelper.make(InputStream.class);
    public static final ClassNode OUTPUT_STREAM_CLASS = ClassHelper.make(OutputStream.class);
    public static final ClassNode DATA_INPUT_STREAM_CLASS = ClassHelper.make(DataInputStream.class);
    public static final ClassNode DATA_OUTPUT_STREAM_CLASS = ClassHelper.make(DataOutputStream.class);
    public static final ClassNode OBJECT_OUTPUT_STREAM = ClassHelper.make(ObjectOutputStream.class);
    public static final ClassNode OBJECT_INPUT_STREAM = ClassHelper.make(ObjectInputStream.class);
    public static final ClassNode FILE_CLASS_NODE = ClassHelper.make(File.class);
    public static final ClassNode BUFFERED_READER_CLASS_NODE = ClassHelper.make(BufferedReader.class);
    public static final ClassNode BUFFERED_WRITER_CLASS_NODE = ClassHelper.make(BufferedWriter.class);
    public static final ClassNode PRINT_WRITER_CLASS_NODE = ClassHelper.make(PrintWriter.class);
    public static final ClassNode DGM_CLASS_NODE = ClassHelper.make(DefaultGroovyMethods.class);
    public static final ClassNode EGM_CLASS_NODE = ClassHelper.make(EncodingGroovyMethods.class);
    public static final ClassNode PGM_CLASS_NODE = ClassHelper.make(ProcessGroovyMethods.class);
    public static final ClassNode SGM_CLASS_NODE = ClassHelper.make(SwingGroovyMethods.class);
    public static final ClassNode XGM_CLASS_NODE = ClassHelper.make(XmlGroovyMethods.class);
    public static final ClassNode DGSM_CLASS_NODE = ClassHelper.make(DefaultGroovyStaticMethods.class);
    public static final ClassNode DATE_GM_CLASS_NODE = ClassHelper.make(DateGroovyMethods.class);
    public static ClassNode RESOURCE_GROOVY_METHODS;
    public static ClassNode STRING_GROOVY_METHODS;
    public static ClassNode IO_GROOVY_METHODS;
    public static ClassNode DELEGATES_TO;
    public static Set<ClassNode> ALL_DEFAULT_CATEGORIES;
    public static final ClassNode CLASS_CLASS_NODE;
    public static final ClassNode CLASS_ARRAY_CLASS_NODE;
    public static final ClassNode BOOLEAN_CLASS_NODE;
    public static final ClassNode CHARACTER_CLASS_NODE;
    public static final ClassNode BYTE_CLASS_NODE;
    public static final ClassNode INTEGER_CLASS_NODE;
    public static final ClassNode SHORT_CLASS_NODE;
    public static final ClassNode LONG_CLASS_NODE;
    public static final ClassNode FLOAT_CLASS_NODE;
    public static final ClassNode DOUBLE_CLASS_NODE;
    private VariableScope parent;
    private SharedState shared;
    private ASTNode scopeNode;
    private boolean isPrimaryNode;
    private final boolean isStaticScope;
    private ClassNode categoryBeingDeclared;
    private List<ClassNode> methodCallArgumentTypes;
    private GenericsType[] methodCallGenericsTypes;
    private final Map<String, VariableInfo> nameVariableMap = new HashMap<String, VariableInfo>();

    static {
        try {
            RESOURCE_GROOVY_METHODS = ClassHelper.make(Class.forName("org.codehaus.groovy.runtime.ResourceGroovyMethods"));
            STRING_GROOVY_METHODS = ClassHelper.make(Class.forName("org.codehaus.groovy.runtime.StringGroovyMethods"));
            IO_GROOVY_METHODS = ClassHelper.make(Class.forName("org.codehaus.groovy.runtime.IOGroovyMethods"));
        }
        catch (ClassNotFoundException e) {
            RESOURCE_GROOVY_METHODS = null;
            STRING_GROOVY_METHODS = null;
            IO_GROOVY_METHODS = null;
        }
        try {
            DELEGATES_TO = ClassHelper.make(Class.forName("groovy.lang.DelegatesTo"));
        }
        catch (ClassNotFoundException e) {
            DELEGATES_TO = null;
        }
        ArrayList<ClassNode> dgm_classes = new ArrayList<ClassNode>(10);
        if (STRING_GROOVY_METHODS != null) {
            dgm_classes.add(STRING_GROOVY_METHODS);
        }
        if (RESOURCE_GROOVY_METHODS != null) {
            dgm_classes.add(RESOURCE_GROOVY_METHODS);
        }
        if (IO_GROOVY_METHODS != null) {
            dgm_classes.add(IO_GROOVY_METHODS);
        }
        dgm_classes.add(EGM_CLASS_NODE);
        dgm_classes.add(PGM_CLASS_NODE);
        dgm_classes.add(SGM_CLASS_NODE);
        dgm_classes.add(XGM_CLASS_NODE);
        dgm_classes.add(DATE_GM_CLASS_NODE);
        dgm_classes.add(DGSM_CLASS_NODE);
        dgm_classes.add(DGM_CLASS_NODE);
        ALL_DEFAULT_CATEGORIES = Collections.unmodifiableSet(new LinkedHashSet(dgm_classes));
        CLASS_CLASS_NODE = ClassHelper.makeWithoutCaching(Class.class);
        VariableScope.initializeProperties(CLASS_CLASS_NODE);
        CLASS_ARRAY_CLASS_NODE = CLASS_CLASS_NODE.makeArray();
        BOOLEAN_CLASS_NODE = ClassHelper.Boolean_TYPE;
        CHARACTER_CLASS_NODE = ClassHelper.Character_TYPE;
        BYTE_CLASS_NODE = ClassHelper.Byte_TYPE;
        INTEGER_CLASS_NODE = ClassHelper.Integer_TYPE;
        SHORT_CLASS_NODE = ClassHelper.Short_TYPE;
        LONG_CLASS_NODE = ClassHelper.Long_TYPE;
        FLOAT_CLASS_NODE = ClassHelper.Float_TYPE;
        DOUBLE_CLASS_NODE = ClassHelper.Double_TYPE;
    }

    public VariableScope(VariableScope parent, ASTNode enclosingNode, boolean isStatic) {
        this.parent = parent;
        this.scopeNode = enclosingNode;
        this.shared = parent != null ? parent.shared : new SharedState();
        boolean bl = this.isStaticScope = (isStatic || parent != null && parent.isStaticScope) && this.getEnclosingClosure() == null;
        if (enclosingNode instanceof MethodNode) {
            this.shared.isRunMethod = ((MethodNode)enclosingNode).isScriptBody();
        } else if (enclosingNode instanceof FieldNode || enclosingNode instanceof ClassNode) {
            this.shared.isRunMethod = false;
        }
    }

    public Map<String, Object> getWormhole() {
        return this.shared.wormhole;
    }

    public ASTNode getEnclosingNode() {
        int n = this.shared.nodeStack.size();
        if (n > 1) {
            return this.shared.nodeStack.get(n - 2);
        }
        return null;
    }

    public void setPrimaryNode(boolean isPrimaryNode) {
        this.isPrimaryNode = isPrimaryNode;
    }

    public void setCurrentNode(ASTNode currentNode) {
        this.shared.nodeStack.add(currentNode);
    }

    public void forgetCurrentNode() {
        if (!this.shared.nodeStack.isEmpty()) {
            this.shared.nodeStack.removeLast();
        }
    }

    public ASTNode getCurrentNode() {
        if (!this.shared.nodeStack.isEmpty()) {
            return this.shared.nodeStack.getLast();
        }
        return null;
    }

    public Set<ClassNode> getCategoryNames() {
        if (this.parent != null) {
            Set<ClassNode> categories = this.parent.getCategoryNames();
            if (this.parent.isCategoryBeingDeclared()) {
                categories.add(this.parent.categoryBeingDeclared);
            }
            return categories;
        }
        return new LinkedHashSet<ClassNode>(ALL_DEFAULT_CATEGORIES);
    }

    private boolean isCategoryBeingDeclared() {
        return this.categoryBeingDeclared != null;
    }

    public void setCategoryBeingDeclared(ClassNode categoryBeingDeclared) {
        this.categoryBeingDeclared = categoryBeingDeclared;
    }

    public VariableInfo lookupName(String name) {
        ClassNode type;
        if ("super".equals(name) && (type = this.getDelegateOrThis()) != null) {
            ClassNode superType = type.getSuperClass();
            superType = superType == null ? OBJECT_CLASS_NODE : superType;
            return new VariableInfo(name, superType, superType);
        }
        VariableInfo var = this.lookupNameInCurrentScope(name);
        if (var == null && this.parent != null) {
            var = this.parent.lookupName(name);
        }
        return var;
    }

    public VariableInfo lookupNameInCurrentScope(String name) {
        VariableInfo info = this.nameVariableMap.get(name);
        if (info != null) {
            info = new VariableInfo(info, this.scopeNode);
        }
        return info;
    }

    public ClassNode getThis() {
        VariableInfo thiz = this.lookupName("this");
        return thiz != null ? thiz.type : null;
    }

    public ClassNode getDelegate() {
        VariableInfo delegate = this.lookupName("delegate");
        return delegate != null ? delegate.type : null;
    }

    public VariableInfo getDelegateOrThisInfo() {
        VariableInfo info = this.lookupName("delegate");
        if (info != null) {
            return info;
        }
        info = this.lookupName("this");
        return info;
    }

    public ClassNode getDelegateOrThis() {
        VariableInfo info = this.getDelegateOrThisInfo();
        return info != null ? info.type : null;
    }

    public void addVariable(String name, ClassNode type, ClassNode declaringType) {
        this.nameVariableMap.put(name, new VariableInfo(name, type, declaringType != null ? declaringType : OBJECT_CLASS_NODE));
    }

    public void addVariable(Variable var) {
        this.addVariable(var.getName(), var.getType(), var.getOriginType());
    }

    public ModuleNode getEnclosingModuleNode() {
        if (this.scopeNode instanceof ModuleNode) {
            return (ModuleNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingModuleNode();
        }
        return null;
    }

    public ClassNode getEnclosingTypeDeclaration() {
        if (this.scopeNode instanceof ClassNode) {
            return (ClassNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingTypeDeclaration();
        }
        return null;
    }

    public FieldNode getEnclosingFieldDeclaration() {
        if (this.scopeNode instanceof FieldNode) {
            return (FieldNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingFieldDeclaration();
        }
        return null;
    }

    public MethodNode getEnclosingMethodDeclaration() {
        if (this.scopeNode instanceof MethodNode) {
            return (MethodNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingMethodDeclaration();
        }
        return null;
    }

    public ClosureExpression getEnclosingClosure() {
        if (this.scopeNode instanceof ClosureExpression) {
            return (ClosureExpression)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingClosure();
        }
        return null;
    }

    private static PropertyNode createPropertyNodeForMethodNode(MethodNode methodNode) {
        ClassNode propertyType = methodNode.getReturnType();
        String methodName = methodNode.getName();
        StringBuffer propertyName = new StringBuffer();
        propertyName.append(Character.toLowerCase(methodName.charAt(3)));
        if (methodName.length() > 4) {
            propertyName.append(methodName.substring(4));
        }
        int mods = methodNode.getModifiers();
        ClassNode declaringClass = methodNode.getDeclaringClass();
        PropertyNode property = new PropertyNode(propertyName.toString(), mods, propertyType, declaringClass, null, null, null);
        property.setDeclaringClass(declaringClass);
        property.getField().setDeclaringClass(declaringClass);
        return property;
    }

    private static void initializeProperties(ClassNode node) {
        for (MethodNode methodNode : node.getMethods()) {
            if (!AccessorSupport.isGetter(methodNode)) continue;
            node.addProperty(VariableScope.createPropertyNodeForMethodNode(methodNode));
        }
    }

    public void updateOrAddVariable(String name, ClassNode type, ClassNode declaringType) {
        if (!this.internalUpdateVariable(name, type, declaringType)) {
            this.addVariable(name, type, declaringType);
        }
    }

    public boolean updateVariable(String name, ClassNode type, ClassNode declaringType) {
        return this.internalUpdateVariable(name, type, declaringType);
    }

    private boolean internalUpdateVariable(String name, ClassNode type, ClassNode declaringType) {
        VariableInfo info = this.lookupNameInCurrentScope(name);
        if (info != null) {
            this.nameVariableMap.put(name, new VariableInfo(name, type, declaringType == null ? info.declaringType : declaringType));
            return true;
        }
        if (this.parent != null) {
            return this.parent.internalUpdateVariable(name, type, declaringType);
        }
        return false;
    }

    public static ClassNode resolveTypeParameterization(GenericsMapper mapper, ClassNode type) {
        GenericsType[] parameterizedTypes;
        if (mapper.hasGenerics() && (parameterizedTypes = GroovyUtils.getGenericsTypes(type)).length > 0) {
            int i = 0;
            int n = parameterizedTypes.length;
            while (i < n) {
                GenericsType parameterizedType = parameterizedTypes[i];
                ClassNode maybe = VariableScope.resolveTypeParameterization(mapper, parameterizedType, type);
                if (maybe != type) {
                    assert (n == 1);
                    type = maybe;
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    /*
     * Unable to fully structure code
     */
    public static ClassNode resolveTypeParameterization(GenericsMapper mapper, GenericsType generic, ClassNode unresolved) {
        block6: {
            block5: {
                if (generic.isWildcard()) break block5;
                VariableScope.resolveTypeParameterization(mapper, generic.getType());
                toParameterizeName = generic.getName();
                resolved = mapper.findParameter(toParameterizeName, generic.getType());
                if (!VariableScope.typeParameterExistsInRedirected(unresolved, toParameterizeName)) ** GOTO lbl19
                Assert.isLegal(unresolved.redirect() != unresolved, "Error: trying to resolve type parameters of a type declaration: " + unresolved);
                generic.setLowerBound(null);
                generic.setUpperBounds(null);
                generic.setPlaceholder(false);
                generic.setWildcard(false);
                generic.setResolved(true);
                generic.setType(resolved);
                generic.setName(generic.getType().getName());
                break block6;
lbl-1000:
                // 1 sources

                {
                    unresolved = unresolved.getComponentType();
                    resolved = resolved.makeArray();
lbl19:
                    // 2 sources

                    ** while (unresolved.isArray())
                }
lbl20:
                // 1 sources

                return resolved;
            }
            if (generic.getLowerBound() != null) {
                resolved = VariableScope.resolveTypeParameterization(mapper, generic.getLowerBound());
                generic.setLowerBound(resolved);
                generic.setResolved(true);
            } else if (generic.getUpperBounds() != null) {
                parameterizedTypeUpperBounds = generic.getUpperBounds();
                j = 0;
                k = parameterizedTypeUpperBounds.length;
                while (j < k) {
                    parameterizedTypeUpperBounds[j] = resolved = VariableScope.resolveTypeParameterization(mapper, parameterizedTypeUpperBounds[j]);
                    ++j;
                }
                generic.setResolved(true);
            }
        }
        return unresolved;
    }

    public static MethodNode resolveTypeParameterization(GenericsMapper mapper, MethodNode method) {
        if (mapper.hasGenerics() && (GroovyUtils.getGenericsTypes(method).length > 0 || GroovyUtils.getGenericsTypes(method.getDeclaringClass()).length > 0)) {
            MethodNode resolved;
            ClassNode returnType = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(method.getReturnType()));
            Parameter[] parameters = method.getParameters();
            if (parameters != null && parameters.length > 0) {
                int n = parameters.length;
                parameters = new Parameter[n];
                int i = 0;
                while (i < n) {
                    Parameter original = method.getParameters()[i];
                    ClassNode parameterType = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(original.getType()));
                    parameters[i] = new Parameter(parameterType, original.getName(), original.getInitialExpression());
                    parameters[i].addAnnotations(original.getAnnotations());
                    parameters[i].setClosureSharedVariable(original.isClosureSharedVariable());
                    parameters[i].setDeclaringClass(original.getDeclaringClass());
                    parameters[i].setHasNoRealSourcePosition(original.hasNoRealSourcePosition());
                    parameters[i].setInStaticContext(original.isInStaticContext());
                    parameters[i].setModifiers(original.getModifiers());
                    parameters[i].copyNodeMetaData(original);
                    parameters[i].setOriginType(original.getOriginType());
                    parameters[i].setSourcePosition(original);
                    parameters[i].setSynthetic(original.isSynthetic());
                    ++i;
                }
            }
            if (method instanceof JDTMethodNode) {
                resolved = new JDTMethodNode(((JDTMethodNode)method).getMethodBinding(), ((JDTMethodNode)method).getResolver(), method.getName(), method.getModifiers(), returnType, parameters, method.getExceptions(), method.getCode());
            } else {
                resolved = new MethodNode(method.getName(), method.getModifiers(), returnType, parameters, method.getExceptions(), method.getCode());
                resolved.addAnnotations(method.getAnnotations());
            }
            resolved.setAnnotationDefault(method.hasAnnotationDefault());
            resolved.setDeclaringClass(VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(method.getDeclaringClass())));
            resolved.setGenericsTypes(method.getGenericsTypes());
            resolved.setHasNoRealSourcePosition(method.hasNoRealSourcePosition());
            resolved.copyNodeMetaData(method);
            resolved.setOriginal(method.getOriginal());
            resolved.setSourcePosition(method);
            resolved.setSynthetic(method.isSynthetic());
            resolved.setSyntheticPublic(method.isSyntheticPublic());
            resolved.setVariableScope(method.getVariableScope());
            method = resolved;
        }
        return method;
    }

    private static boolean typeParameterExistsInRedirected(ClassNode type, String toParameterizeName) {
        ClassNode redirect = type.redirect();
        GenericsType[] genericsTypes = redirect.getGenericsTypes();
        return genericsTypes != null;
    }

    public static ClassNode clone(ClassNode type) {
        return VariableScope.cloneInternal(type, 0);
    }

    public static ClassNode clonedMap() {
        ClassNode clone = VariableScope.clone(MAP_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[1]);
        return clone;
    }

    public static ClassNode clonedList() {
        ClassNode clone = VariableScope.clone(LIST_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        return clone;
    }

    public static ClassNode clonedRange() {
        ClassNode clone = VariableScope.clone(RANGE_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        return clone;
    }

    private static void cleanGenerics(GenericsType gt) {
        gt.getType().setGenericsTypes(null);
        gt.setName("java.lang.Object");
        gt.setPlaceholder(false);
        gt.setWildcard(false);
        gt.setResolved(true);
        gt.setUpperBounds(null);
        gt.setLowerBound(null);
    }

    private static ClassNode cloneInternal(ClassNode type, int depth) {
        GenericsType[] generics;
        if (type == null || type.isPrimitive()) {
            return type;
        }
        ClassNode newType = type.getPlainNodeReference();
        newType.setSourcePosition(type);
        newType.setGenericsPlaceHolder(type.isGenericsPlaceHolder());
        ReflectionUtils.setPrivateField(ClassNode.class, "componentType", newType, VariableScope.cloneInternal(type.getComponentType(), depth + 1));
        if (depth < 11 && (generics = type.getGenericsTypes()) != null) {
            int n = generics.length;
            GenericsType[] clones = new GenericsType[n];
            int i = 0;
            while (i < n) {
                clones[i] = VariableScope.clone(generics[i], depth);
                ++i;
            }
            newType.setGenericsTypes(clones);
        }
        return newType;
    }

    public static GenericsType clone(GenericsType origgt, int depth) {
        GenericsType newgt = new GenericsType();
        newgt.setType(VariableScope.cloneInternal(origgt.getType(), depth + 1));
        newgt.setLowerBound(VariableScope.cloneInternal(origgt.getLowerBound(), depth + 1));
        ClassNode[] oldUpperBounds = origgt.getUpperBounds();
        if (oldUpperBounds != null) {
            int n = oldUpperBounds.length;
            ClassNode[] newUpperBounds = new ClassNode[n];
            int i = 0;
            while (i < n) {
                newUpperBounds[i] = VariableScope.cloneInternal(oldUpperBounds[i], depth + 1);
                ++i;
            }
            newgt.setUpperBounds(newUpperBounds);
        }
        newgt.setName(origgt.getName());
        newgt.setPlaceholder(origgt.isPlaceholder());
        newgt.setWildcard(origgt.isWildcard());
        newgt.setResolved(origgt.isResolved());
        newgt.setSourcePosition(origgt);
        return newgt;
    }

    public boolean isStatic() {
        return this.isStaticScope;
    }

    public boolean isPrimaryNode() {
        return this.isPrimaryNode;
    }

    public List<CallAndType> getAllEnclosingMethodCallExpressions() {
        return this.shared.enclosingCallStack;
    }

    public CallAndType getEnclosingMethodCallExpression() {
        if (this.shared.enclosingCallStack.isEmpty()) {
            return null;
        }
        return this.shared.enclosingCallStack.getLast();
    }

    public void addEnclosingMethodCall(CallAndType enclosingMethodCall) {
        this.shared.enclosingCallStack.add(enclosingMethodCall);
    }

    public void forgetEnclosingMethodCall() {
        this.shared.enclosingCallStack.removeLast();
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public boolean containsInThisScope(String name) {
        return this.nameVariableMap.containsKey(name);
    }

    void setMethodCallArgumentTypes(List<ClassNode> methodCallArgumentTypes) {
        this.methodCallArgumentTypes = methodCallArgumentTypes;
    }

    public List<ClassNode> getMethodCallArgumentTypes() {
        return this.methodCallArgumentTypes;
    }

    void setMethodCallGenericsTypes(GenericsType[] methodCallGenericsTypes) {
        this.methodCallGenericsTypes = methodCallGenericsTypes;
    }

    public GenericsType[] getMethodCallGenericsTypes() {
        return this.methodCallGenericsTypes;
    }

    int getMethodCallNumberOfArguments() {
        return this.isMethodCall() ? this.methodCallArgumentTypes.size() : 0;
    }

    public boolean isMethodCall() {
        return this.methodCallArgumentTypes != null;
    }

    @Override
    public Iterator<VariableInfo> iterator() {
        return new Iterator<VariableInfo>(){
            VariableScope currentScope;
            Iterator<VariableInfo> currentIter;
            {
                this.currentScope = VariableScope.this;
                this.currentIter = this.currentScope.nameVariableMap.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentIter == null) {
                    return false;
                }
                if (!this.currentIter.hasNext()) {
                    this.currentScope = this.currentScope.parent;
                    Iterator<Object> iterator = this.currentIter = this.currentScope == null ? null : this.currentScope.nameVariableMap.values().iterator();
                }
                return this.currentIter != null && this.currentIter.hasNext();
            }

            @Override
            public VariableInfo next() {
                return new VariableInfo(this.currentIter.next(), this.currentScope.scopeNode);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void findAllInterfaces(ClassNode type, LinkedHashSet<ClassNode> allInterfaces, boolean useResolved) {
        boolean isInterface;
        if (!useResolved) {
            type = type.redirect();
        }
        if (!(isInterface = type.isInterface()) || !allInterfaces.contains(type)) {
            ClassNode superType;
            ClassNode[] faces;
            if (isInterface) {
                allInterfaces.add(type);
            }
            ClassNode[] classNodeArray = faces = !useResolved ? type.getInterfaces() : type.getUnresolvedInterfaces();
            if (faces != null) {
                ClassNode[] classNodeArray2 = faces;
                int n = faces.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode face = classNodeArray2[n2];
                    VariableScope.findAllInterfaces(face, allInterfaces, useResolved);
                    ++n2;
                }
            }
            if (!isInterface && (superType = type.getSuperClass()) != null && !OBJECT_CLASS_NODE.equals(superType)) {
                VariableScope.findAllInterfaces(superType, allInterfaces, useResolved);
            }
        }
    }

    public static void createTypeHierarchy(ClassNode type, LinkedHashSet<ClassNode> allClasses, boolean useResolved) {
        if (!useResolved) {
            type = type.redirect();
        }
        if (!allClasses.contains(type)) {
            if (!type.isInterface()) {
                allClasses.add(type);
                ClassNode superClass = useResolved ? type.getUnresolvedSuperClass() : type.getSuperClass();
                if (superClass != null) {
                    VariableScope.createTypeHierarchy(superClass, allClasses, useResolved);
                }
            }
            VariableScope.findAllInterfaces(type, allClasses, useResolved);
        }
    }

    public static ClassNode extractElementType(ClassNode collectionType) {
        if (collectionType.isArray()) {
            return collectionType.getComponentType();
        }
        MethodNode iterator = collectionType.getMethod("iterator", Parameter.EMPTY_ARRAY);
        ClassNode typeToResolve = null;
        if (iterator == null && collectionType.isInterface()) {
            MethodNode entrySetMethod;
            if (collectionType.implementsInterface(LIST_CLASS_NODE) && collectionType.getGenericsTypes() != null && collectionType.getGenericsTypes().length == 1) {
                typeToResolve = collectionType;
            } else if (collectionType.declaresInterface(ITERATOR_CLASS) || collectionType.equals(ITERATOR_CLASS) || collectionType.declaresInterface(ENUMERATION_CLASS) || collectionType.equals(ENUMERATION_CLASS)) {
                typeToResolve = collectionType;
            } else if ((collectionType.declaresInterface(MAP_CLASS_NODE) || collectionType.equals(MAP_CLASS_NODE)) && (entrySetMethod = collectionType.getMethod("entrySet", Parameter.EMPTY_ARRAY)) != null) {
                typeToResolve = entrySetMethod.getReturnType();
            }
        } else if (iterator != null) {
            typeToResolve = iterator.getReturnType();
        }
        if (typeToResolve != null) {
            typeToResolve = VariableScope.clone(typeToResolve);
            ClassNode unresolvedCollectionType = collectionType.redirect();
            GenericsMapper mapper = GenericsMapper.gatherGenerics(collectionType, unresolvedCollectionType);
            ClassNode resolved = VariableScope.resolveTypeParameterization(mapper, typeToResolve);
            GenericsType[] resolvedReturnGenerics = resolved.getGenericsTypes();
            if (resolvedReturnGenerics != null && resolvedReturnGenerics.length > 0) {
                return resolvedReturnGenerics[0].getType();
            }
        }
        if (collectionType.declaresInterface(INPUT_STREAM_CLASS) || collectionType.declaresInterface(DATA_INPUT_STREAM_CLASS) || collectionType.equals(INPUT_STREAM_CLASS) || collectionType.equals(DATA_INPUT_STREAM_CLASS)) {
            return BYTE_CLASS_NODE;
        }
        return collectionType;
    }

    public boolean inScriptRunMethod() {
        return this.shared.isRunMethod;
    }

    public static boolean isPlainClosure(ClassNode type) {
        return CLOSURE_CLASS_NODE.equals(type) && !type.isUsingGenerics();
    }

    public static boolean isParameterizedClosure(ClassNode type) {
        return CLOSURE_CLASS_NODE.equals(type) && type.isUsingGenerics();
    }

    public static boolean isThisOrSuper(Variable var) {
        return var.getName().equals("this") || var.getName().equals("super");
    }

    public static boolean isVoidOrObject(ClassNode type) {
        return type != null && (type.getName().equals(VOID_CLASS_NODE.getName()) || type.getName().equals(VOID_WRAPPER_CLASS_NODE.getName()) || type.getName().equals(OBJECT_CLASS_NODE.getName()));
    }

    public static class CallAndType {
        public final ASTNode declaration;
        public final MethodCallExpression call;
        public final ClassNode declaringType;
        public Map<ClosureExpression, ClassNode> delegatesToClosures;

        public CallAndType(MethodCallExpression call, ClassNode declaringType, ASTNode declaration) {
            MethodNode methodDecl;
            this.call = call;
            this.declaringType = declaringType;
            this.declaration = declaration;
            if (DELEGATES_TO != null && declaration instanceof MethodNode && (methodDecl = (MethodNode)declaration).getParameters() != null) {
                Expression argsExpr = call.getArguments();
                List<Expression> args = null;
                if (argsExpr instanceof TupleExpression) {
                    args = ((TupleExpression)argsExpr).getExpressions();
                }
                if (args != null) {
                    Parameter[] parameters = methodDecl.getParameters();
                    int i = 0;
                    while (i < parameters.length) {
                        Parameter p = parameters[i];
                        List<AnnotationNode> annotations = p.getAnnotations();
                        if (annotations != null) {
                            for (AnnotationNode annotation : annotations) {
                                if (!annotation.getClassNode().getName().equals(DELEGATES_TO.getName()) || args.size() <= i || !(args.get(i) instanceof ClosureExpression) || !(annotation.getMember("value") instanceof ClassExpression)) continue;
                                this.delegatesToClosures = Collections.singletonMap((ClosureExpression)args.get(i), annotation.getMember("value").getType());
                            }
                        }
                        ++i;
                    }
                }
            }
            if (this.delegatesToClosures == null) {
                this.delegatesToClosures = Collections.emptyMap();
            }
        }
    }

    private class SharedState {
        final Map<String, Object> wormhole = new HashMap<String, Object>();
        final LinkedList<CallAndType> enclosingCallStack = new LinkedList();
        final LinkedList<ASTNode> nodeStack = new LinkedList();
        boolean isRunMethod;

        private SharedState() {
        }
    }

    public static class VariableInfo {
        public ASTNode scopeNode;
        public final String name;
        public final ClassNode type;
        public final ClassNode declaringType;

        public VariableInfo(String name, ClassNode type, ClassNode declaringType) {
            this.name = name;
            this.type = type;
            this.declaringType = declaringType;
        }

        private VariableInfo(VariableInfo info, ASTNode node) {
            this(info.name, info.type, info.declaringType);
            this.scopeNode = node;
        }

        public String getTypeSignature() {
            return GroovyUtils.getTypeSignature(this.type, true, false);
        }
    }
}

