/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.VariableScope;

public class TypeLookupResult {
    public final TypeConfidence confidence;
    public final ClassNode declaringType;
    public final ClassNode type;
    public final ASTNode declaration;
    public final VariableScope scope;
    public final String extraDoc;
    public boolean isGroovy;
    public AnnotationNode enclosingAnnotation;
    public BinaryExpression enclosingAssignment;

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope) {
        this(type, declaringType, declaration, confidence, scope, null);
    }

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope, String extraDoc) {
        this.confidence = confidence;
        this.type = type;
        this.declaringType = declaringType;
        this.declaration = declaration;
        this.scope = scope;
        this.extraDoc = extraDoc;
    }

    public TypeLookupResult resolveTypeParameterization(ClassNode objExprType, boolean isStatic) {
        if (this.declaringType != null && (this.declaration instanceof FieldNode || this.declaration instanceof PropertyNode || this.declaration instanceof MethodNode && !(this.declaration instanceof ConstructorNode))) {
            ClassNode targetType = objExprType;
            if (targetType == null) {
                targetType = this.isGroovy || !isStatic ? this.scope.getDelegateOrThis() : this.declaringType;
            }
            targetType = GroovyUtils.getWrapperTypeIfPrimitive(targetType);
            if (!(this.declaration instanceof MethodNode)) {
                GenericsMapper mapper = GenericsMapper.gatherGenerics(targetType, this.declaringType.redirect());
                ClassNode maybe = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(this.type));
                if (!maybe.toString(false).equals(this.type.toString(false))) {
                    TypeLookupResult result = new TypeLookupResult(maybe, this.declaringType, this.declaration, this.confidence, this.scope, this.extraDoc);
                    result.enclosingAnnotation = this.enclosingAnnotation;
                    result.enclosingAssignment = this.enclosingAssignment;
                    result.isGroovy = this.isGroovy;
                    return result;
                }
            } else {
                List<ClassNode> argumentTypes = this.scope.getMethodCallArgumentTypes();
                if (this.isGroovy) {
                    argumentTypes = new ArrayList<ClassNode>();
                    argumentTypes.add(targetType);
                    if (this.scope.getMethodCallArgumentTypes() != null) {
                        argumentTypes.addAll(this.scope.getMethodCallArgumentTypes());
                    }
                }
                MethodNode method = (MethodNode)this.declaration;
                if (!isStatic && method.getName().equals("getClass") && method.getParameters().length == 0) {
                    ClassNode classType = VariableScope.clone(method.getReturnType());
                    classType.getGenericsTypes()[0].setUpperBounds(new ClassNode[]{targetType});
                    return new TypeLookupResult(classType, method.getDeclaringClass(), method, this.confidence, this.scope, this.extraDoc);
                }
                GenericsMapper mapper = GenericsMapper.gatherGenerics(argumentTypes, targetType, method, this.scope.getMethodCallGenericsTypes());
                if ((method = VariableScope.resolveTypeParameterization(mapper, method)) != this.declaration) {
                    TypeLookupResult result = new TypeLookupResult(method.getReturnType(), method.getDeclaringClass(), method, this.confidence, this.scope, this.extraDoc);
                    result.enclosingAnnotation = this.enclosingAnnotation;
                    result.enclosingAssignment = this.enclosingAssignment;
                    result.isGroovy = this.isGroovy;
                    return result;
                }
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeConfidence {
        EXACT,
        POTENTIAL,
        INFERRED,
        LOOSELY_INFERRED,
        UNKNOWN;


        public static TypeConfidence findLessPrecise(TypeConfidence left, TypeConfidence right) {
            return left.isLessThan(right) ? left : right;
        }

        public boolean isLessThan(TypeConfidence that) {
            return this.ordinal() > that.ordinal();
        }

        public boolean isAtLeast(TypeConfidence that) {
            return this.ordinal() <= that.ordinal();
        }
    }
}

