/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;

public class GroovyCompilationUnitScope
extends CompilationUnitScope {
    private static final char[][] javaLang = CharOperation.splitOn('.', "java.lang".toCharArray());
    private static final char[][] javaIo = CharOperation.splitOn('.', "java.io".toCharArray());
    private static final char[][] javaNet = CharOperation.splitOn('.', "java.net".toCharArray());
    private static final char[][] javaUtil = CharOperation.splitOn('.', "java.util".toCharArray());
    private static final char[][] groovyLang = CharOperation.splitOn('.', "groovy.lang".toCharArray());
    private static final char[][] groovyUtil = CharOperation.splitOn('.', "groovy.util".toCharArray());
    private static final char[][] javaMathBigDecimal = CharOperation.splitOn('.', "java.math.BigDecimal".toCharArray());
    private static final char[][] javaMathBigInteger = CharOperation.splitOn('.', "java.math.BigInteger".toCharArray());
    private static final char[][] GROOVY_LANG_GROOVYOBJECT = CharOperation.splitOn('.', "groovy.lang.GroovyObject".toCharArray());
    private boolean isScript;
    private ImportBinding[] defaultGroovyImports;

    public GroovyCompilationUnitScope(GroovyCompilationUnitDeclaration compilationUnitDeclaration, LookupEnvironment lookupEnvironment) {
        super(compilationUnitDeclaration, lookupEnvironment);
        if (lookupEnvironment.nameEnvironment instanceof NameEnvironment) {
            ((NameEnvironment)lookupEnvironment.nameEnvironment).avoidAdditionalGroovyAnswers = true;
        }
    }

    public boolean isScript() {
        return this.isScript;
    }

    public void setIsScript(boolean isScript) {
        this.isScript = isScript;
    }

    protected ImportBinding[] getDefaultImports() {
        if (this.defaultGroovyImports != null) {
            return this.defaultGroovyImports;
        }
        ArrayList<ImportBinding> importBindings = new ArrayList<ImportBinding>();
        Collections.addAll(importBindings, super.getDefaultImports());
        importBindings.add(new ImportBinding(javaIo, true, this.environment.createPackage(javaIo), null));
        importBindings.add(new ImportBinding(javaNet, true, this.environment.createPackage(javaNet), null));
        importBindings.add(new ImportBinding(javaUtil, true, this.environment.createPackage(javaUtil), null));
        importBindings.add(new ImportBinding(groovyLang, true, this.environment.createPackage(groovyLang), null));
        importBindings.add(new ImportBinding(groovyUtil, true, this.environment.createPackage(groovyUtil), null));
        importBindings.add(new ImportBinding(javaMathBigDecimal, false, this.createTypeRef(javaMathBigDecimal), null));
        importBindings.add(new ImportBinding(javaMathBigInteger, false, this.createTypeRef(javaMathBigInteger), null));
        String extraImports = this.compilerOptions().groovyExtraImports;
        if (extraImports != null) {
            try {
                String filename = new String(this.referenceContext.getFileName());
                StringTokenizer st = new StringTokenizer(extraImports, ";");
                while (st.hasMoreTokens()) {
                    String onesuffix = st.nextToken();
                    int equals = onesuffix.indexOf(61);
                    boolean shouldApply = false;
                    String imports = null;
                    if (equals == -1) {
                        shouldApply = true;
                        imports = onesuffix;
                    } else {
                        String suffix = onesuffix.substring(0, equals);
                        shouldApply = filename.endsWith(suffix);
                        imports = onesuffix.substring(equals + 1);
                    }
                    StringTokenizer st2 = new StringTokenizer(imports, ",");
                    while (st2.hasMoreTokens()) {
                        String nextElement = st2.nextToken();
                        if (nextElement.endsWith(".*")) {
                            char[] withoutDotStar = nextElement.substring(0, nextElement.length() - 2).toCharArray();
                            char[][] cs = CharOperation.splitOn('.', withoutDotStar);
                            importBindings.add(new ImportBinding(cs, true, this.environment.createPackage(cs), null));
                            continue;
                        }
                        int asIndex = nextElement.indexOf(" as ");
                        String asName = null;
                        if (asIndex != -1) {
                            asName = nextElement.substring(asIndex + 4).trim();
                            nextElement = nextElement.substring(0, asIndex).trim();
                        }
                        char[] type = nextElement.toCharArray();
                        char[][] cs = CharOperation.splitOn('.', type);
                        importBindings.add(new ImportBinding(cs, false, this.createTypeRef(cs), null));
                        if (asName == null) continue;
                        char[] asNameChars = asName.toCharArray();
                        char[][] cs2 = new char[][]{asNameChars};
                        importBindings.add(new ImportBinding(cs2, false, this.createTypeRef(cs), null));
                    }
                }
            }
            catch (Exception e) {
                new RuntimeException("Problem processing extraImports: " + extraImports, e).printStackTrace();
            }
        }
        this.defaultGroovyImports = importBindings.toArray(new ImportBinding[importBindings.size()]);
        return this.defaultGroovyImports;
    }

    private ReferenceBinding createTypeRef(char[][] compoundName) {
        return this.environment.getType(compoundName);
    }

    protected ClassScope buildClassScope(Scope parent, TypeDeclaration typeDecl) {
        return new GroovyClassScope(parent, typeDecl);
    }

    public void augmentTypeHierarchy() {
        SourceTypeBinding[] sourceTypeBindingArray = this.topLevelTypes;
        int n = this.topLevelTypes.length;
        int n2 = 0;
        while (n2 < n) {
            SourceTypeBinding topLevelType = sourceTypeBindingArray[n2];
            this.augmentTypeHierarchy(topLevelType);
            ++n2;
        }
    }

    private void augmentTypeHierarchy(SourceTypeBinding typeBinding) {
        if (!typeBinding.isAnnotationType() && !typeBinding.isInterface() && typeBinding.superInterfaces != null) {
            CompilationUnitScope unitScope = this.compilationUnitScope();
            unitScope.recordQualifiedReference(GROOVY_LANG_GROOVYOBJECT);
            ReferenceBinding groovyLangObjectBinding = unitScope.environment.getResolvedType(GROOVY_LANG_GROOVYOBJECT, this);
            if (!typeBinding.implementsInterface(groovyLangObjectBinding, true)) {
                typeBinding.superInterfaces = (ReferenceBinding[])ArrayUtils.add(typeBinding.superInterfaces, groovyLangObjectBinding);
            }
        }
    }

    protected void buildTypeBindings(AccessRestriction accessRestriction) {
        TypeDeclaration[] types = this.referenceContext.types;
        if (types != null) {
            TypeDeclaration[] typeDeclarationArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration type = typeDeclarationArray[n2];
                if (type instanceof GroovyTypeDeclaration) {
                    ((GroovyTypeDeclaration)type).fixAnonymousTypeBinding(this);
                }
                ++n2;
            }
        }
        super.buildTypeBindings(accessRestriction);
    }

    public ReferenceBinding findMemberType(char[] typeName, ReferenceBinding enclosingType) {
        ReferenceBinding type = super.findMemberType(typeName, enclosingType);
        return type;
    }

    public ClassNode lookupClassNodeForSource(String typename, JDTResolver jdtResolver) {
        ProblemReferenceBinding prBinding;
        char[][] compoundName = CharOperation.splitOn('.', typename.toCharArray());
        TypeBinding jdtBinding = null;
        try {
            jdtBinding = this.getType(compoundName, compoundName.length);
        }
        catch (AbortCompilation t) {
            if (t.silentException instanceof AbortIncrementalBuildException) {
                jdtBinding = null;
            }
            throw t;
        }
        if (jdtBinding instanceof SourceTypeBinding || jdtBinding instanceof BinaryTypeBinding) {
            return jdtResolver.convertToClassNode(jdtBinding);
        }
        if (jdtBinding instanceof ProblemReferenceBinding && (prBinding = (ProblemReferenceBinding)jdtBinding).problemId() == 4 && ((jdtBinding = prBinding.closestMatch()) instanceof SourceTypeBinding || jdtBinding instanceof BinaryTypeBinding)) {
            return jdtResolver.convertToClassNode(jdtBinding);
        }
        return null;
    }

    public ClassNode lookupClassNodeForBinary(String typename, JDTResolver jdtResolver) {
        ProblemReferenceBinding prBinding;
        char[][] compoundName = CharOperation.splitOn('.', typename.toCharArray());
        TypeBinding jdtBinding = this.getType(compoundName, compoundName.length);
        if (jdtBinding instanceof BinaryTypeBinding) {
            return jdtResolver.convertToClassNode(jdtBinding);
        }
        if (jdtBinding instanceof ProblemReferenceBinding && (prBinding = (ProblemReferenceBinding)jdtBinding).problemId() == 4 && (jdtBinding = prBinding.closestMatch()) instanceof BinaryTypeBinding) {
            return jdtResolver.convertToClassNode(jdtBinding);
        }
        return null;
    }

    protected void checkPublicTypeNameMatchesFilename(TypeDeclaration typeDecl) {
    }

    protected void recordImportProblem(ImportReference importReference, Binding importBinding) {
    }

    protected boolean reportPackageIsNotExpectedPackage(CompilationUnitDeclaration compUnitDecl) {
        if (!this.isScript && compUnitDecl != null && compUnitDecl.compilationResult != null && compUnitDecl.compilationResult.compilationUnit != null) {
            String actuallyIs;
            char[][] packageName = compUnitDecl.compilationResult.compilationUnit.getPackageName();
            String shouldBe = packageName == null ? "" : CharOperation.toString(packageName);
            String string = actuallyIs = compUnitDecl.currentPackage == null ? "" : CharOperation.toString(compUnitDecl.currentPackage.tokens);
            if (actuallyIs.length() > 0 && !shouldBe.equals(actuallyIs)) {
                this.problemReporter().packageIsNotExpectedPackage(compUnitDecl);
                return true;
            }
        }
        return false;
    }

    protected void checkParameterizedTypes() {
    }

    public boolean reportInvalidType(TypeReference typeReference, TypeBinding resolvedType) {
        ProblemReferenceBinding problemRefBinding;
        return resolvedType instanceof ProblemReferenceBinding && (problemRefBinding = (ProblemReferenceBinding)resolvedType).problemId() == 3;
    }

    protected void reportImportProblem(ImportReference importReference, Binding importBinding) {
        ProblemReferenceBinding problemRefBinding;
        if (importBinding instanceof ProblemReferenceBinding && (problemRefBinding = (ProblemReferenceBinding)importBinding).problemId() == 1) {
            return;
        }
        this.problemReporter().importProblem(importReference, importBinding);
    }

    public boolean canSeeEverything() {
        return true;
    }

    public boolean checkTargetCompatibility() {
        return false;
    }

    protected boolean canBeSeenBy(ReferenceBinding type, PackageBinding fPackage) {
        return true;
    }

    public boolean scannerAvailable() {
        return false;
    }

    public ReferenceBinding selectBinding(ReferenceBinding newlyFound, ReferenceBinding originallyFound, boolean isDeclaredImport) {
        if (isDeclaredImport && originallyFound.fPackage != null) {
            char[][] packageName = originallyFound.fPackage.compoundName;
            if (CharOperation.equals(javaLang, packageName) || CharOperation.equals(javaIo, packageName) || CharOperation.equals(javaNet, packageName) || CharOperation.equals(javaUtil, packageName) || CharOperation.equals(groovyLang, packageName) || CharOperation.equals(groovyUtil, packageName)) {
                return newlyFound;
            }
            return originallyFound;
        }
        return null;
    }
}

