/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;

public abstract class StaticTypeCheckingSupport {
    static final ClassNode UNKNOWN_PARAMETER_TYPE = ClassHelper.make("<unknown parameter type>");

    public static boolean isBeingCompiled(ClassNode node) {
        return node.getCompileUnit() != null;
    }

    public static boolean implementsInterfaceOrIsSubclassOf(ClassNode type, ClassNode superOrInterface) {
        boolean result;
        boolean bl = result = type.equals(superOrInterface) || type.isDerivedFrom(superOrInterface) || type.implementsInterface(superOrInterface) || type == UNKNOWN_PARAMETER_TYPE;
        if (result) {
            return true;
        }
        if (superOrInterface instanceof WideningCategories.LowestUpperBoundClassNode) {
            WideningCategories.LowestUpperBoundClassNode cn = (WideningCategories.LowestUpperBoundClassNode)superOrInterface;
            result = StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, cn.getSuperClass());
            if (result) {
                ClassNode[] classNodeArray = cn.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode interfaceNode = classNodeArray[n2];
                    result = type.implementsInterface(interfaceNode);
                    if (!result) break;
                    ++n2;
                }
            }
            if (result) {
                return true;
            }
        } else if (superOrInterface instanceof UnionTypeClassNode) {
            UnionTypeClassNode union = (UnionTypeClassNode)superOrInterface;
            ClassNode[] classNodeArray = union.getDelegates();
            int n = classNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                ClassNode delegate = classNodeArray[n3];
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, delegate)) {
                    return true;
                }
                ++n3;
            }
        }
        if (type.isArray() && superOrInterface.isArray()) {
            return StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type.getComponentType(), superOrInterface.getComponentType());
        }
        return ClassHelper.GROOVY_OBJECT_TYPE.equals(superOrInterface) && !type.isInterface() && StaticTypeCheckingSupport.isBeingCompiled(type);
    }
}

