/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.objectweb.asm.Opcodes;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class LazyASTTransformation
implements ASTTransformation,
Opcodes {
    private static final ClassNode SOFT_REF = ClassHelper.make(SoftReference.class);
    private static final Expression NULL_EXPR = ConstantExpression.NULL;
    private static final ClassNode OBJECT_TYPE = new ClassNode(Object.class);
    private static final Token ASSIGN = Token.newSymbol("=", -1, -1);
    private static final Token COMPARE_NOT_EQUAL = Token.newSymbol("!=", -1, -1);

    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (parent instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)parent;
            Expression member = node.getMember("soft");
            Expression init = this.getInitExpr(fieldNode);
            fieldNode.rename("$" + fieldNode.getName());
            fieldNode.setModifiers(2 | fieldNode.getModifiers() & 0xFFFFFFFA);
            if (member instanceof ConstantExpression && ((ConstantExpression)member).getValue().equals(true)) {
                this.createSoft(fieldNode, init);
            } else {
                this.create(fieldNode, init);
                if (ClassHelper.isPrimitiveType(fieldNode.getType())) {
                    fieldNode.setType(ClassHelper.getWrapper(fieldNode.getType()));
                }
            }
        }
    }

    private void create(FieldNode fieldNode, Expression initExpr) {
        BlockStatement body = new BlockStatement();
        if (fieldNode.isStatic()) {
            this.addHolderClassIdiomBody(body, fieldNode, initExpr);
        } else if (this.isVolatile(fieldNode)) {
            this.addNonThreadSafeBody(body, fieldNode, initExpr);
        } else {
            this.addDoubleCheckedLockingBody(body, fieldNode, initExpr);
        }
        this.addMethod(fieldNode, body, fieldNode.getType());
    }

    private void addHolderClassIdiomBody(BlockStatement body, FieldNode fieldNode, Expression initExpr) {
        ClassNode declaringClass = fieldNode.getDeclaringClass();
        ClassNode fieldType = fieldNode.getType();
        int visibility = 10;
        String fullName = declaringClass.getName() + "$" + fieldType.getNameWithoutPackage() + "Holder_" + fieldNode.getName().substring(1);
        InnerClassNode holderClass = new InnerClassNode(declaringClass, fullName, 10, OBJECT_TYPE);
        String innerFieldName = "INSTANCE";
        holderClass.addField("INSTANCE", 26, fieldType, initExpr);
        PropertyExpression innerField = new PropertyExpression((Expression)new ClassExpression(holderClass), "INSTANCE");
        declaringClass.getModule().addClass(holderClass);
        body.addStatement(new ReturnStatement(innerField));
    }

    private void addDoubleCheckedLockingBody(BlockStatement body, FieldNode fieldNode, Expression initExpr) {
        FieldExpression fieldExpr = new FieldExpression(fieldNode);
        VariableExpression localVar = new VariableExpression(fieldNode.getName() + "_local", fieldNode.getType());
        body.addStatement(new ExpressionStatement(new DeclarationExpression(localVar, ASSIGN, (Expression)fieldExpr)));
        body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(localVar, COMPARE_NOT_EQUAL, NULL_EXPR)), new ReturnStatement(localVar), new SynchronizedStatement(this.synchTarget(fieldNode), new IfStatement(new BooleanExpression(new BinaryExpression(fieldExpr, COMPARE_NOT_EQUAL, NULL_EXPR)), new ReturnStatement(fieldExpr), new ReturnStatement(new BinaryExpression(fieldExpr, ASSIGN, initExpr))))));
    }

    private void addNonThreadSafeBody(BlockStatement body, FieldNode fieldNode, Expression initExpr) {
        FieldExpression fieldExpr = new FieldExpression(fieldNode);
        body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(fieldExpr, COMPARE_NOT_EQUAL, NULL_EXPR)), new ExpressionStatement(fieldExpr), new ExpressionStatement(new BinaryExpression(fieldExpr, ASSIGN, initExpr))));
    }

    private void addMethod(FieldNode fieldNode, BlockStatement body, ClassNode type) {
        int visibility = 1;
        if (fieldNode.isStatic()) {
            visibility |= 8;
        }
        String name = "get" + MetaClassHelper.capitalize(fieldNode.getName().substring(1));
        fieldNode.getDeclaringClass().addMethod(name, visibility, type, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body);
    }

    private void createSoft(FieldNode fieldNode, Expression initExpr) {
        ClassNode type = fieldNode.getType();
        fieldNode.setType(SOFT_REF);
        this.createSoftGetter(fieldNode, initExpr, type);
        this.createSoftSetter(fieldNode, type);
    }

    private void createSoftGetter(FieldNode fieldNode, Expression initExpr, ClassNode type) {
        BlockStatement body = new BlockStatement();
        FieldExpression fieldExpr = new FieldExpression(fieldNode);
        VariableExpression resExpr = new VariableExpression("res", type);
        MethodCallExpression callExpression = new MethodCallExpression((Expression)new FieldExpression(fieldNode), "get", (Expression)new ArgumentListExpression());
        callExpression.setSafe(true);
        body.addStatement(new ExpressionStatement(new DeclarationExpression((Expression)resExpr, ASSIGN, (Expression)callExpression)));
        BlockStatement elseBlock = new BlockStatement();
        elseBlock.addStatement(new ExpressionStatement(new BinaryExpression(resExpr, ASSIGN, initExpr)));
        elseBlock.addStatement(new ExpressionStatement(new BinaryExpression(fieldExpr, ASSIGN, new ConstructorCallExpression(SOFT_REF, resExpr))));
        elseBlock.addStatement(new ExpressionStatement(resExpr));
        IfStatement mainIf = new IfStatement(new BooleanExpression(new BinaryExpression(resExpr, COMPARE_NOT_EQUAL, NULL_EXPR)), new ExpressionStatement(resExpr), elseBlock);
        if (this.isVolatile(fieldNode)) {
            body.addStatement(mainIf);
        } else {
            body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(resExpr, COMPARE_NOT_EQUAL, NULL_EXPR)), new ExpressionStatement(resExpr), new SynchronizedStatement(this.synchTarget(fieldNode), mainIf)));
        }
        this.addMethod(fieldNode, body, type);
    }

    private void createSoftSetter(FieldNode fieldNode, ClassNode type) {
        BlockStatement body = new BlockStatement();
        FieldExpression fieldExpr = new FieldExpression(fieldNode);
        String name = "set" + MetaClassHelper.capitalize(fieldNode.getName().substring(1));
        Parameter parameter = new Parameter(type, "value");
        VariableExpression paramExpr = new VariableExpression(parameter);
        body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(paramExpr, COMPARE_NOT_EQUAL, NULL_EXPR)), new ExpressionStatement(new BinaryExpression(fieldExpr, ASSIGN, new ConstructorCallExpression(SOFT_REF, paramExpr))), new ExpressionStatement(new BinaryExpression(fieldExpr, ASSIGN, NULL_EXPR))));
        int visibility = 1;
        if (fieldNode.isStatic()) {
            visibility |= 8;
        }
        fieldNode.getDeclaringClass().addMethod(name, visibility, ClassHelper.VOID_TYPE, new Parameter[]{parameter}, ClassNode.EMPTY_ARRAY, body);
    }

    private Expression synchTarget(FieldNode fieldNode) {
        return fieldNode.isStatic() ? new ClassExpression(fieldNode.getDeclaringClass()) : VariableExpression.THIS_EXPRESSION;
    }

    private boolean isVolatile(FieldNode fieldNode) {
        return (fieldNode.getModifiers() & 0x40) == 0;
    }

    private Expression getInitExpr(FieldNode fieldNode) {
        Expression initExpr = fieldNode.getInitialValueExpression();
        fieldNode.setInitialValueExpression(null);
        if (initExpr == null) {
            initExpr = new ConstructorCallExpression(fieldNode.getType(), new ArgumentListExpression());
        }
        return initExpr;
    }
}

