/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.codehaus.groovy.reflection.ComplexKeyHashMap;

public class WeakDoubleKeyHashMap
extends ComplexKeyHashMap {
    private final ReferenceQueue queue = new ReferenceQueue();

    private void expungeStaleEntries() {
        Ref r;
        block0: while ((r = (Ref)this.queue.poll()) != null) {
            Entry prev;
            Entry e = r.entry;
            if (e == null) continue;
            r.entry = null;
            e.key2 = null;
            e.key1 = null;
            int h = e.hash;
            int i = h & this.table.length - 1;
            Entry p = prev = (Entry)this.table[i];
            while (p != null) {
                Entry next = (Entry)p.next;
                if (p == e) {
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.next = next;
                    }
                    e.next = null;
                    e.value = null;
                    --this.size;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    public final Object get(Object key1, Object key2) {
        int h = WeakDoubleKeyHashMap.hash(31 * key1.hashCode() + key2.hashCode());
        ComplexKeyHashMap.Entry e = this.table[h & this.table.length - 1];
        while (e != null) {
            if (e.hash == h && this.checkEquals((Entry)e, key1, key2)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public boolean checkEquals(ComplexKeyHashMap.Entry e, Object key1, Object key2) {
        Entry ee = (Entry)e;
        return ee.key1.get() == key1 && ee.key2.get() == key2;
    }

    public Entry getOrPut(Object key1, Object key2) {
        ComplexKeyHashMap.Entry entry;
        int h = WeakDoubleKeyHashMap.hash(31 * key1.hashCode() + key2.hashCode());
        int index = h & this.table.length - 1;
        ComplexKeyHashMap.Entry e = this.table[index];
        while (e != null) {
            if (e.hash == h && this.checkEquals(e, key1, key2)) {
                return (Entry)e;
            }
            e = e.next;
        }
        this.table[index] = entry = this.createEntry(key1, key2, h, index);
        if (++this.size == this.threshold) {
            this.resize(2 * this.table.length);
        }
        return (Entry)entry;
    }

    private ComplexKeyHashMap.Entry createEntry(Object key1, Object key2, int h, int index) {
        Entry entry = this.createEntry();
        entry.next = this.table[index];
        entry.hash = h;
        entry.key1 = new Ref(key1, this.queue, entry);
        entry.key2 = new Ref(key2, this.queue, entry);
        return entry;
    }

    public Entry createEntry() {
        return new Entry();
    }

    public int size() {
        this.expungeStaleEntries();
        return super.size();
    }

    public final ComplexKeyHashMap.Entry remove(Object key1, Object key2) {
        this.expungeStaleEntries();
        int h = WeakDoubleKeyHashMap.hash(31 * key1.hashCode() + key2.hashCode());
        int index = h & this.table.length - 1;
        ComplexKeyHashMap.Entry e = this.table[index];
        ComplexKeyHashMap.Entry prev = null;
        while (e != null) {
            if (e.hash == h && this.checkEquals((Entry)e, key1, key2)) {
                if (prev == null) {
                    this.table[index] = e.next;
                } else {
                    prev.next = e.next;
                }
                --this.size;
                e.next = null;
                return e;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public static class Entry
    extends ComplexKeyHashMap.Entry {
        public Ref key1;
        public Ref key2;
    }

    private static class Ref
    extends WeakReference {
        Entry entry;

        public Ref(Object referent, ReferenceQueue q, Entry entry) {
            super(referent, q);
            this.entry = entry;
        }
    }
}

