/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import [Ljava.lang.Object;;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.TripleKeyHashMap;
import org.codehaus.groovy.reflection.WeakDoubleKeyHashMap;

public class ReflectionCache {
    private static Map primitiveTypesMap = new HashMap();
    static TripleKeyHashMap mopNames;
    static final Map CACHED_CLASS_MAP;
    static WeakDoubleKeyHashMap assignableMap;
    public static final CachedClass OBJECT_CLASS;
    public static final CachedClass OBJECT_ARRAY_CLASS;

    public static Class autoboxType(Class type) {
        Class res = (Class)primitiveTypesMap.get(type);
        return res == null ? type : res;
    }

    public static String getMOPMethodName(CachedClass declaringClass, String name, boolean useThis) {
        TripleKeyHashMap.Entry mopNameEntry = mopNames.getOrPut(declaringClass, name, useThis);
        if (mopNameEntry.value == null) {
            mopNameEntry.value = (useThis ? "this$" : "super$") + declaringClass.getSuperClassDistance() + "$" + name;
        }
        return (String)mopNameEntry.value;
    }

    public static boolean isArray(Class klazz) {
        CachedClass cachedClass = ReflectionCache.getCachedClass(klazz);
        return cachedClass.isArray;
    }

    public static boolean isAssignableFrom(Class klazz, Class aClass) {
        if (klazz == aClass) {
            return true;
        }
        return klazz.isAssignableFrom(aClass);
    }

    static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedClass getCachedClass(Class klazz) {
        CachedClass cachedClass;
        if (klazz == null) {
            return null;
        }
        if (klazz == Object.class) {
            return OBJECT_CLASS;
        }
        Map map = CACHED_CLASS_MAP;
        synchronized (map) {
            SoftReference ref = (SoftReference)CACHED_CLASS_MAP.get(klazz);
            if (ref == null || (cachedClass = (CachedClass)ref.get()) == null) {
                cachedClass = new CachedClass(klazz);
                CACHED_CLASS_MAP.put(klazz, new SoftReference<CachedClass>(cachedClass));
            }
        }
        return cachedClass;
    }

    static {
        primitiveTypesMap.put(Byte.TYPE, Byte.class);
        primitiveTypesMap.put(Boolean.TYPE, Boolean.class);
        primitiveTypesMap.put(Character.TYPE, Character.class);
        primitiveTypesMap.put(Double.TYPE, Double.class);
        primitiveTypesMap.put(Float.TYPE, Float.class);
        primitiveTypesMap.put(Integer.TYPE, Integer.class);
        primitiveTypesMap.put(Long.TYPE, Long.class);
        primitiveTypesMap.put(Short.TYPE, Short.class);
        mopNames = new TripleKeyHashMap();
        CACHED_CLASS_MAP = new WeakHashMap();
        assignableMap = new WeakDoubleKeyHashMap();
        OBJECT_CLASS = new CachedClass(Object.class){

            public synchronized CachedClass getCachedSuperClass() {
                return null;
            }
        };
        OBJECT_ARRAY_CLASS = ReflectionCache.getCachedClass(Object;.class);
    }
}

