/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.javafx.controller;

import griffon.core.artifact.GriffonController;
import griffon.core.controller.ActionManager;
import griffon.core.editors.PropertyEditorResolver;
import griffon.core.threading.UIThreadManager;
import griffon.javafx.support.JavaFXAction;
import griffon.util.GriffonNameUtils;
import griffon.util.TypeUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.util.Objects;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.griffon.runtime.core.controller.AbstractAction;

public class JavaFXGriffonControllerAction
extends AbstractAction {
    public static final String KEY_DESCRIPTION = "description";
    public static final String KEY_ICON = "icon";
    public static final String KEY_IMAGE = "image";
    public static final String KEY_GRAPHIC = "graphic";
    public static final String KEY_SELECTED = "selected";
    public static final String KEY_VISIBLE = "visible";
    public static final String KEY_ACCELERATOR = "accelerator";
    public static final String KEY_STYLECLASS = "styleClass";
    private final JavaFXAction toolkitAction;
    private String description;
    private String icon;
    private String image;
    private Node graphic;
    private String accelerator;
    private String styleClass;
    private boolean selected;
    private boolean visible = true;

    public JavaFXGriffonControllerAction(@Nonnull UIThreadManager uiThreadManager, @Nonnull ActionManager actionManager, @Nonnull GriffonController controller, @Nonnull String actionName) {
        super(actionManager, controller, actionName);
        Objects.requireNonNull(uiThreadManager, "Argument 'uiThreadManager' must not be null");
        this.toolkitAction = this.createAction(actionManager, controller, actionName);
        this.toolkitAction.setOnAction((EventHandler<ActionEvent>)((EventHandler)actionEvent -> actionManager.invokeAction(controller, actionName, new Object[]{actionEvent})));
        this.addPropertyChangeListener(evt -> uiThreadManager.runInsideUIAsync(() -> this.handlePropertyChange(evt)));
    }

    protected JavaFXAction createAction(@Nonnull ActionManager actionManager, @Nonnull GriffonController controller, @Nonnull String actionName) {
        return new JavaFXAction();
    }

    protected void handlePropertyChange(@Nonnull PropertyChangeEvent evt) {
        Node graphic;
        if ("name".equals(evt.getPropertyName())) {
            this.toolkitAction.setName(String.valueOf(evt.getNewValue()));
        } else if (KEY_DESCRIPTION.equals(evt.getPropertyName())) {
            this.toolkitAction.setDescription(String.valueOf(evt.getNewValue()));
        } else if ("enabled".equals(evt.getPropertyName())) {
            this.toolkitAction.setEnabled(TypeUtils.castToBoolean((Object)evt.getNewValue()));
        } else if (KEY_SELECTED.equals(evt.getPropertyName())) {
            this.toolkitAction.setSelected(TypeUtils.castToBoolean((Object)evt.getNewValue()));
        } else if (KEY_VISIBLE.equals(evt.getPropertyName())) {
            this.toolkitAction.setVisible(TypeUtils.castToBoolean((Object)evt.getNewValue()));
        } else if (KEY_ACCELERATOR.equals(evt.getPropertyName())) {
            String accelerator = (String)evt.getNewValue();
            if (!GriffonNameUtils.isBlank((String)accelerator)) {
                this.toolkitAction.setAccelerator(accelerator);
            }
        } else if (KEY_STYLECLASS.equals(evt.getPropertyName())) {
            String styleClass = (String)evt.getNewValue();
            if (!GriffonNameUtils.isBlank((String)styleClass)) {
                this.toolkitAction.setStyleClass(styleClass);
            }
        } else if (KEY_ICON.equals(evt.getPropertyName())) {
            String icon = (String)evt.getNewValue();
            if (!GriffonNameUtils.isBlank((String)icon)) {
                this.toolkitAction.setIcon(icon);
            }
        } else if (KEY_IMAGE.equals(evt.getPropertyName())) {
            Image image = (Image)evt.getNewValue();
            if (null != image) {
                this.toolkitAction.setImage(image);
            }
        } else if (KEY_GRAPHIC.equals(evt.getPropertyName()) && null != (graphic = (Node)evt.getNewValue())) {
            this.toolkitAction.setGraphic(graphic);
        }
    }

    @Nullable
    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(@Nullable String styleClass) {
        this.styleClass = styleClass;
        this.firePropertyChange(KEY_STYLECLASS, this.styleClass, this.styleClass);
    }

    @Nullable
    public String getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(@Nullable String accelerator) {
        this.accelerator = accelerator;
        this.firePropertyChange(KEY_ACCELERATOR, this.accelerator, this.accelerator);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.firePropertyChange(KEY_SELECTED, this.selected, this.selected);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropertyChange(KEY_SELECTED, this.visible, this.visible);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
        this.firePropertyChange(KEY_DESCRIPTION, this.description, this.description);
    }

    @Nullable
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable String icon) {
        this.icon = icon;
        this.firePropertyChange(KEY_ICON, this.icon, this.icon);
    }

    @Nullable
    public Image getImage() {
        PropertyEditor editor = PropertyEditorResolver.findEditor(Image.class);
        editor.setValue(this.image);
        return (Image)editor.getValue();
    }

    public void setImage(@Nullable String image) {
        this.image = image;
        this.firePropertyChange(KEY_IMAGE, this.image, this.image);
    }

    @Nullable
    public Node getGraphic() {
        return this.graphic;
    }

    public void setGraphic(@Nullable Node graphic) {
        this.graphic = graphic;
        this.firePropertyChange(KEY_ICON, this.graphic, this.graphic);
    }

    @Nonnull
    public Object getToolkitAction() {
        return this.toolkitAction;
    }

    protected void doExecute(Object ... args) {
        ActionEvent event = null;
        if (args != null && args.length == 1 && args[0] instanceof ActionEvent) {
            event = (ActionEvent)args[0];
        }
        ((EventHandler)this.toolkitAction.onActionProperty().get()).handle(event);
    }

    protected void doInitialize() {
        String icon;
        this.toolkitAction.setName(this.getName());
        this.toolkitAction.setDescription(this.getDescription());
        this.toolkitAction.setEnabled(this.isEnabled());
        this.toolkitAction.setSelected(this.isSelected());
        this.toolkitAction.setVisible(this.isVisible());
        String accelerator = this.getAccelerator();
        if (!GriffonNameUtils.isBlank((String)accelerator)) {
            this.toolkitAction.setAccelerator(accelerator);
        }
        if (!GriffonNameUtils.isBlank((String)this.styleClass)) {
            this.toolkitAction.setStyleClass(this.styleClass);
        }
        if (!GriffonNameUtils.isBlank((String)(icon = this.getIcon()))) {
            this.toolkitAction.setIcon(icon);
        }
        if (null != this.getImage()) {
            this.toolkitAction.setImage(this.getImage());
        }
        if (null != this.getGraphic()) {
            this.toolkitAction.setGraphic(this.getGraphic());
        }
    }
}

