/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.javafx.controller;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.core.controller.ActionManager;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonNameUtils;
import griffon.util.TypeUtils;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.controller.AbstractActionManager;
import org.codehaus.griffon.runtime.javafx.controller.JavaFXGriffonControllerAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFXActionManager
extends AbstractActionManager {
    private static final Logger LOG = LoggerFactory.getLogger(JavaFXActionManager.class);

    @Inject
    public JavaFXActionManager(@Nonnull GriffonApplication application) {
        super(application);
    }

    @Nonnull
    protected Action createControllerAction(@Nonnull GriffonController controller, @Nonnull String actionName) {
        return new JavaFXGriffonControllerAction(this.getUiThreadManager(), (ActionManager)this, controller, actionName);
    }

    protected void doConfigureAction(@Nonnull Action action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsStyleClass;
        String rsVisible;
        String rsSelected;
        String rsEnabled;
        String rsImage;
        String rsIcon;
        String rsDescription;
        JavaFXGriffonControllerAction javafxAction = (JavaFXGriffonControllerAction)action;
        String rsAccelerator = this.msg(keyPrefix, normalizeNamed, "accelerator", "");
        if (!GriffonNameUtils.isBlank((String)rsAccelerator)) {
            if (!GriffonApplicationUtils.isMacOSX() && rsAccelerator.contains("meta") && !rsAccelerator.contains("ctrl")) {
                rsAccelerator = rsAccelerator.replace("meta", "ctrl");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".accelerator = " + rsAccelerator);
            }
            javafxAction.setAccelerator(rsAccelerator);
        }
        if (!GriffonNameUtils.isBlank((String)(rsDescription = this.msg(keyPrefix, normalizeNamed, "description", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".description = " + rsDescription);
            }
            javafxAction.setDescription(rsDescription);
        }
        if (!GriffonNameUtils.isBlank((String)(rsIcon = this.msg(keyPrefix, normalizeNamed, "icon", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".icon = " + rsIcon);
            }
            javafxAction.setIcon(rsIcon);
        }
        if (!GriffonNameUtils.isBlank((String)(rsImage = this.msg(keyPrefix, normalizeNamed, "image", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".image = " + rsImage);
            }
            javafxAction.setImage(rsImage);
        }
        if (!GriffonNameUtils.isBlank((String)(rsEnabled = this.msg(keyPrefix, normalizeNamed, "enabled", "true")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".enabled = " + rsEnabled);
            }
            javafxAction.setEnabled(TypeUtils.castToBoolean((Object)rsEnabled));
        }
        if (!GriffonNameUtils.isBlank((String)(rsSelected = this.msg(keyPrefix, normalizeNamed, "selected", "false")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".selected = " + rsSelected);
            }
            javafxAction.setSelected(TypeUtils.castToBoolean((Object)rsSelected));
        }
        if (!GriffonNameUtils.isBlank((String)(rsVisible = this.msg(keyPrefix, normalizeNamed, "visible", "true")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".visible = " + rsVisible);
            }
            javafxAction.setVisible(TypeUtils.castToBoolean((Object)rsVisible));
        }
        if (!GriffonNameUtils.isBlank((String)(rsStyleClass = this.msg(keyPrefix, normalizeNamed, "styleclass", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".styleclass = " + rsStyleClass);
            }
            javafxAction.setStyleClass(rsStyleClass);
        }
    }
}

