/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.javafx.artifact;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonClass;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.exceptions.GriffonException;
import griffon.javafx.support.JavaFXAction;
import griffon.javafx.support.JavaFXUtils;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.BuilderFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.artifact.AbstractGriffonView;

public abstract class AbstractJavaFXGriffonView
extends AbstractGriffonView {
    private static final String FXML_SUFFIX = ".fxml";

    public AbstractJavaFXGriffonView() {
    }

    @Inject
    @Deprecated
    public AbstractJavaFXGriffonView(@Nonnull GriffonApplication application) {
        super(application);
    }

    @Nullable
    protected Node loadFromFXML() {
        return this.loadFromFXML(this.resolveBasename());
    }

    @Nullable
    protected Node loadFromFXML(@Nonnull String baseName) {
        GriffonNameUtils.requireNonBlank((String)baseName, (String)"Argument 'baseName' must not be blank");
        if (baseName.endsWith(FXML_SUFFIX)) {
            baseName = ConfigUtils.stripFilenameExtension((String)baseName);
        }
        baseName = baseName.replace('.', '/');
        String viewName = baseName + FXML_SUFFIX;
        String styleName = baseName + ".css";
        URL viewResource = this.getResourceAsURL(viewName);
        if (viewResource == null) {
            return null;
        }
        FXMLLoader fxmlLoader = new FXMLLoader(viewResource);
        fxmlLoader.setResources(this.getApplication().getMessageSource().asResourceBundle());
        fxmlLoader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory(this.getApplication().getApplicationClassLoader().get()));
        fxmlLoader.setClassLoader(this.getApplication().getApplicationClassLoader().get());
        fxmlLoader.setControllerFactory(klass -> this.getMvcGroup().getView());
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            throw new GriffonException((Throwable)e);
        }
        Parent node = (Parent)fxmlLoader.getRoot();
        URL cssResource = this.getResourceAsURL(styleName);
        if (cssResource != null) {
            String uriToCss = cssResource.toExternalForm();
            node.getStylesheets().add((Object)uriToCss);
        }
        return node;
    }

    @Nonnull
    protected String resolveBasename() {
        GriffonClass griffonClass = this.getGriffonClass();
        String packageName = griffonClass.getPackageName();
        String baseName = griffonClass.getLogicalPropertyName();
        if (!GriffonNameUtils.isBlank((String)packageName)) {
            baseName = packageName + "." + baseName;
        }
        return baseName;
    }

    protected void connectActions(@Nonnull Object node, @Nonnull GriffonController controller) {
        JavaFXUtils.connectActions(node, controller);
    }

    @Nullable
    protected JavaFXAction toolkitActionFor(@Nonnull GriffonController controller, @Nonnull String actionName) {
        Action action = this.actionFor(controller, actionName);
        return action != null ? (JavaFXAction)action.getToolkitAction() : null;
    }
}

