/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.support;

import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.core.controller.ActionManager;
import griffon.core.editors.ValueConversionException;
import griffon.exceptions.InstanceMethodInvocationException;
import griffon.javafx.support.DelegatingObservableList;
import griffon.javafx.support.JavaFXAction;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JavaFXUtils {
    private static final String ERROR_NODE_NULL = "Argument 'node' must not be null";
    private static final String ERROR_CONTROL_NULL = "Argument 'control' must not be null";
    private static final String ERROR_ACTION_NULL = "Argument 'action' must not be null";
    private static final String ERROR_ICON_BLANK = "Argument 'iconUrl' must not be blank";
    private static final String ERROR_ID_BLANK = "Argument 'id' must not be blank";
    private static final String ERROR_URL_BLANK = "Argument 'url' must not be blank";
    private static final String ERROR_ROOT_NULL = "Argument 'root' must not be null";
    private static final String ERROR_CONTROLLER_NULL = "Argument 'controller' must not be null";
    private static final String ACTION_TARGET_SUFFIX = "ActionTarget";
    private static final String PROPERTY_SUFFIX = "Property";

    private JavaFXUtils() {
    }

    @Nonnull
    public static <E> ObservableList<E> createJavaFXThreadProxyList(@Nonnull ObservableList<E> source) {
        Objects.requireNonNull(source, "Argument 'source' must not be null");
        return new JavaFXThreadProxyObservableList<E>(source);
    }

    @Nonnull
    public static <B> Property<?> extractProperty(@Nonnull B bean, @Nonnull String propertyName) {
        Objects.requireNonNull(bean, "Argument 'bean' must not be null");
        GriffonNameUtils.requireNonBlank((String)propertyName, (String)"Argument 'propertyName' must not be null");
        if (!propertyName.endsWith(PROPERTY_SUFFIX)) {
            propertyName = propertyName + PROPERTY_SUFFIX;
        }
        try {
            return (Property)GriffonClassUtils.invokeExactInstanceMethod(bean, (String)propertyName);
        }
        catch (InstanceMethodInvocationException e) {
            InstanceMethodInvocationException imie = e;
            try {
                return (Property)GriffonClassUtils.invokeExactInstanceMethod(bean, (String)GriffonClassUtils.getGetterName((String)propertyName));
            }
            catch (InstanceMethodInvocationException e2) {
                throw imie;
            }
        }
    }

    public static void connectActions(@Nonnull Object node, @Nonnull GriffonController controller) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        Objects.requireNonNull(controller, ERROR_CONTROLLER_NULL);
        ActionManager actionManager = controller.getApplication().getActionManager();
        for (Map.Entry e : actionManager.actionsFor(controller).entrySet()) {
            String actionTargetName = actionManager.normalizeName((String)e.getKey()) + ACTION_TARGET_SUFFIX;
            Object control = JavaFXUtils.findElement(node, actionTargetName);
            if (control == null) continue;
            JavaFXAction action = (JavaFXAction)((Action)e.getValue()).getToolkitAction();
            if (control instanceof ButtonBase) {
                JavaFXUtils.configure((ButtonBase)control, action);
                continue;
            }
            if (control instanceof MenuItem) {
                JavaFXUtils.configure((MenuItem)control, action);
                continue;
            }
            if (control instanceof Node) {
                ((Node)control).addEventHandler(ActionEvent.ACTION, action.getOnAction());
                continue;
            }
            try {
                GriffonClassUtils.invokeInstanceMethod((Object)control, (String)"setOnAction", action.getOnAction());
            }
            catch (InstanceMethodInvocationException instanceMethodInvocationException) {}
        }
    }

    private static void runInsideUIThread(@Nonnull Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static void configure(@Nonnull ToggleButton control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((ButtonBase)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull CheckBox control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((ButtonBase)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull RadioButton control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((ButtonBase)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull ButtonBase control, @Nonnull JavaFXAction action) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        Objects.requireNonNull(action, ERROR_ACTION_NULL);
        action.onActionProperty().addListener((v, o, n) -> control.setOnAction(n));
        control.setOnAction(action.getOnAction());
        action.nameProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setText(n)));
        JavaFXUtils.runInsideUIThread(() -> control.setText(action.getName()));
        action.descriptionProperty().addListener((v, o, n) -> JavaFXUtils.setTooltip((Control)control, n));
        JavaFXUtils.setTooltip((Control)control, action.getDescription());
        action.iconProperty().addListener((v, o, n) -> JavaFXUtils.setIcon((Labeled)control, n));
        if (!GriffonNameUtils.isBlank((String)action.getIcon())) {
            JavaFXUtils.setIcon((Labeled)control, action.getIcon());
        }
        action.imageProperty().addListener((v, o, n) -> JavaFXUtils.setGraphic((Labeled)control, n));
        if (null != action.getImage()) {
            JavaFXUtils.setGraphic((Labeled)control, action.getImage());
        }
        action.graphicProperty().addListener((v, o, n) -> JavaFXUtils.setGraphic((Labeled)control, n));
        if (null != action.getGraphic()) {
            JavaFXUtils.setGraphic((Labeled)control, action.getGraphic());
        }
        action.enabledProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setDisable(n == false)));
        JavaFXUtils.runInsideUIThread(() -> control.setDisable(!action.isEnabled()));
        action.visibleProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setVisible(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setVisible(action.isVisible()));
        action.styleClassProperty().addListener((v, o, n) -> {
            JavaFXUtils.setStyleClass((Node)control, o, true);
            JavaFXUtils.setStyleClass((Node)control, n);
        });
        JavaFXUtils.setStyleClass((Node)control, action.getStyleClass());
    }

    public static void configure(@Nonnull CheckMenuItem control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((MenuItem)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull RadioMenuItem control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((MenuItem)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull MenuItem control, @Nonnull JavaFXAction action) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        Objects.requireNonNull(action, ERROR_ACTION_NULL);
        action.onActionProperty().addListener((v, o, n) -> control.setOnAction(n));
        control.setOnAction(action.getOnAction());
        action.nameProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setText(n)));
        JavaFXUtils.runInsideUIThread(() -> control.setText(action.getName()));
        action.iconProperty().addListener((v, o, n) -> JavaFXUtils.setIcon(control, n));
        if (!GriffonNameUtils.isBlank((String)action.getIcon())) {
            JavaFXUtils.setIcon(control, action.getIcon());
        }
        action.imageProperty().addListener((v, o, n) -> JavaFXUtils.setGraphic(control, n));
        if (null != action.getImage()) {
            JavaFXUtils.setGraphic(control, action.getImage());
        }
        action.graphicProperty().addListener((v, o, n) -> JavaFXUtils.setGraphic(control, n));
        if (null != action.getGraphic()) {
            JavaFXUtils.setGraphic(control, action.getGraphic());
        }
        action.enabledProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setDisable(n == false)));
        JavaFXUtils.runInsideUIThread(() -> control.setDisable(!action.getEnabled()));
        action.acceleratorProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setAccelerator(n)));
        JavaFXUtils.runInsideUIThread(() -> control.setAccelerator(action.getAccelerator()));
        action.visibleProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setVisible(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setVisible(action.isVisible()));
        action.styleClassProperty().addListener((v, o, n) -> {
            JavaFXUtils.setStyleClass(control, o, true);
            JavaFXUtils.setStyleClass(control, n);
        });
        JavaFXUtils.setStyleClass(control, action.getStyleClass());
    }

    public static void setStyleClass(@Nonnull Node node, @Nonnull String styleClass) {
        JavaFXUtils.setStyleClass(node, styleClass, false);
    }

    public static void setStyleClass(@Nonnull Node node, @Nonnull String styleClass, boolean remove) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)styleClass)) {
            return;
        }
        ObservableList styleClasses = node.getStyleClass();
        JavaFXUtils.applyStyleClass(styleClass, (ObservableList<String>)styleClasses, remove);
    }

    public static void setStyleClass(@Nonnull MenuItem node, @Nonnull String styleClass) {
        JavaFXUtils.setStyleClass(node, styleClass, false);
    }

    public static void setStyleClass(@Nonnull MenuItem node, @Nonnull String styleClass, boolean remove) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)styleClass)) {
            return;
        }
        ObservableList styleClasses = node.getStyleClass();
        JavaFXUtils.applyStyleClass(styleClass, (ObservableList<String>)styleClasses, remove);
    }

    private static void applyStyleClass(String styleClass, ObservableList<String> styleClasses, boolean remove) {
        JavaFXUtils.runInsideUIThread(() -> {
            Object[] strings = styleClass.split("[,\\ ]");
            if (remove) {
                styleClasses.removeAll(strings);
            } else {
                LinkedHashSet<String> classes = new LinkedHashSet<String>((Collection<String>)styleClasses);
                for (Object s : strings) {
                    if (GriffonNameUtils.isBlank((String)s)) continue;
                    classes.add(((String)s).trim());
                }
                styleClasses.setAll(classes);
            }
        });
    }

    public static void setTooltip(@Nonnull Control control, @Nullable String text) {
        JavaFXUtils.runInsideUIThread(() -> {
            if (GriffonNameUtils.isBlank((String)text)) {
                return;
            }
            Objects.requireNonNull(control, ERROR_CONTROL_NULL);
            Tooltip tooltip = (Tooltip)control.tooltipProperty().get();
            if (tooltip == null) {
                tooltip = new Tooltip();
                control.tooltipProperty().set((Object)tooltip);
            }
            tooltip.setText(text);
        });
    }

    public static void setIcon(@Nonnull Labeled control, @Nonnull String iconUrl) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        GriffonNameUtils.requireNonBlank((String)iconUrl, (String)ERROR_ICON_BLANK);
        Node graphicNode = JavaFXUtils.resolveIcon(iconUrl);
        if (graphicNode != null) {
            JavaFXUtils.runInsideUIThread(() -> control.graphicProperty().set((Object)graphicNode));
        }
    }

    public static void setIcon(@Nonnull MenuItem control, @Nonnull String iconUrl) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        GriffonNameUtils.requireNonBlank((String)iconUrl, (String)ERROR_ICON_BLANK);
        Node graphicNode = JavaFXUtils.resolveIcon(iconUrl);
        if (graphicNode != null) {
            JavaFXUtils.runInsideUIThread(() -> control.graphicProperty().set((Object)graphicNode));
        }
    }

    public static void setGraphic(@Nonnull Labeled control, @Nullable Image graphic) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        JavaFXUtils.runInsideUIThread(() -> {
            if (graphic != null) {
                ImageView graphicNode = new ImageView(graphic);
                control.graphicProperty().set((Object)graphicNode);
            } else {
                control.graphicProperty().set(null);
            }
        });
    }

    public static void setGraphic(@Nonnull MenuItem control, @Nullable Image graphic) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        JavaFXUtils.runInsideUIThread(() -> {
            if (graphic != null) {
                ImageView graphicNode = new ImageView(graphic);
                control.graphicProperty().set((Object)graphicNode);
            } else {
                control.graphicProperty().set(null);
            }
        });
    }

    public static void setGraphic(@Nonnull Labeled control, @Nullable Node graphic) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        JavaFXUtils.runInsideUIThread(() -> {
            if (graphic != null) {
                control.graphicProperty().set((Object)graphic);
            } else {
                control.graphicProperty().set(null);
            }
        });
    }

    public static void setGraphic(@Nonnull MenuItem control, @Nullable Node graphic) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        JavaFXUtils.runInsideUIThread(() -> {
            if (graphic != null) {
                control.graphicProperty().set((Object)graphic);
            } else {
                control.graphicProperty().set(null);
            }
        });
    }

    @Nullable
    public static Node resolveIcon(@Nonnull String iconUrl) {
        GriffonNameUtils.requireNonBlank((String)iconUrl, (String)ERROR_URL_BLANK);
        if (iconUrl.contains("|")) {
            return JavaFXUtils.handleAsClassWithArg(iconUrl);
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource(iconUrl);
        if (resource != null) {
            return new ImageView(new Image(resource.toString()));
        }
        return null;
    }

    private static Node handleAsClassWithArg(String str) {
        String[] args = str.split("\\|");
        if (args.length == 2) {
            Class<?> iconClass = null;
            try {
                iconClass = JavaFXUtils.class.getClassLoader().loadClass(args[0]);
            }
            catch (ClassNotFoundException e) {
                throw JavaFXUtils.illegalValue(str, Node.class, e);
            }
            Constructor<?> constructor = null;
            try {
                constructor = iconClass.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw JavaFXUtils.illegalValue(str, Node.class, e);
            }
            try {
                Object o = constructor.newInstance(args[1]);
                if (o instanceof Node) {
                    return (Node)o;
                }
                if (o instanceof Image) {
                    return new ImageView((Image)o);
                }
                throw JavaFXUtils.illegalValue(str, Node.class);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw JavaFXUtils.illegalValue(str, Node.class, e);
            }
        }
        throw JavaFXUtils.illegalValue(str, Node.class);
    }

    @Nullable
    public static Node findNode(@Nonnull Node root, @Nonnull String id) {
        block9: {
            block14: {
                block13: {
                    Node found;
                    block12: {
                        block11: {
                            block10: {
                                Node found2;
                                block8: {
                                    Objects.requireNonNull(root, ERROR_ROOT_NULL);
                                    GriffonNameUtils.requireNonBlank((String)id, (String)ERROR_ID_BLANK);
                                    if (id.equals(root.getId())) {
                                        return root;
                                    }
                                    if (!(root instanceof TabPane)) break block8;
                                    TabPane parent = (TabPane)root;
                                    for (Tab child : parent.getTabs()) {
                                        Node found3;
                                        if (child.getContent() == null || (found3 = JavaFXUtils.findNode(child.getContent(), id)) == null) continue;
                                        return found3;
                                    }
                                    break block9;
                                }
                                if (!(root instanceof TitledPane)) break block10;
                                TitledPane parent = (TitledPane)root;
                                if (parent.getContent() != null && (found2 = JavaFXUtils.findNode(parent.getContent(), id)) != null) {
                                    return found2;
                                }
                                break block9;
                            }
                            if (!(root instanceof Accordion)) break block11;
                            Accordion parent = (Accordion)root;
                            for (TitledPane child : parent.getPanes()) {
                                Node found4 = JavaFXUtils.findNode((Node)child, id);
                                if (found4 == null) continue;
                                return found4;
                            }
                            break block9;
                        }
                        if (!(root instanceof SplitPane)) break block12;
                        SplitPane parent = (SplitPane)root;
                        for (Node child : parent.getItems()) {
                            Node found5 = JavaFXUtils.findNode(child, id);
                            if (found5 == null) continue;
                            return found5;
                        }
                        break block9;
                    }
                    if (!(root instanceof ScrollPane)) break block13;
                    ScrollPane scrollPane = (ScrollPane)root;
                    if (scrollPane.getContent() != null && (found = JavaFXUtils.findNode(scrollPane.getContent(), id)) != null) {
                        return found;
                    }
                    break block9;
                }
                if (!(root instanceof ToolBar)) break block14;
                ToolBar toolBar = (ToolBar)root;
                for (Node child : toolBar.getItems()) {
                    Node found = JavaFXUtils.findNode(child, id);
                    if (found == null) continue;
                    return found;
                }
                break block9;
            }
            if (!(root instanceof Parent)) break block9;
            Parent parent = (Parent)root;
            for (Node child : parent.getChildrenUnmodifiable()) {
                Node found = JavaFXUtils.findNode(child, id);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    @Nullable
    public static Object findElement(@Nonnull Object root, @Nonnull String id) {
        block14: {
            TitledPane parent;
            Object found;
            block22: {
                block21: {
                    Object found2;
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block13: {
                                                Objects.requireNonNull(root, ERROR_ROOT_NULL);
                                                GriffonNameUtils.requireNonBlank((String)id, (String)ERROR_ID_BLANK);
                                                if (id.equals(GriffonClassUtils.getPropertyValue((Object)root, (String)"id"))) {
                                                    return root;
                                                }
                                                if (root instanceof MenuBar) {
                                                    MenuBar menuBar = (MenuBar)root;
                                                    for (Menu child : menuBar.getMenus()) {
                                                        found = JavaFXUtils.findElement(child, id);
                                                        if (found == null) continue;
                                                        return found;
                                                    }
                                                }
                                                if (!(root instanceof ContextMenu)) break block13;
                                                ContextMenu contextMenu = (ContextMenu)root;
                                                for (Menu child : contextMenu.getItems()) {
                                                    found = JavaFXUtils.findElement(child, id);
                                                    if (found == null) continue;
                                                    return found;
                                                }
                                                break block14;
                                            }
                                            if (!(root instanceof Menu)) break block15;
                                            Menu menu = (Menu)root;
                                            for (Menu child : menu.getItems()) {
                                                found = JavaFXUtils.findElement(child, id);
                                                if (found == null) continue;
                                                return found;
                                            }
                                            break block14;
                                        }
                                        if (!(root instanceof TabPane)) break block16;
                                        TabPane tabPane = (TabPane)root;
                                        for (Menu child : tabPane.getTabs()) {
                                            found = JavaFXUtils.findElement(child, id);
                                            if (found == null) continue;
                                            return found;
                                        }
                                        break block14;
                                    }
                                    if (!(root instanceof Tab)) break block17;
                                    Tab tab = (Tab)root;
                                    if (tab.getContent() != null && (found2 = JavaFXUtils.findElement(tab.getContent(), id)) != null) {
                                        return found2;
                                    }
                                    break block14;
                                }
                                if (!(root instanceof TitledPane)) break block18;
                                parent = (TitledPane)root;
                                if (parent.getContent() != null && (found2 = JavaFXUtils.findElement(parent.getContent(), id)) != null) {
                                    return found2;
                                }
                                break block14;
                            }
                            if (!(root instanceof Accordion)) break block19;
                            parent = (Accordion)root;
                            for (Menu child : parent.getPanes()) {
                                found = JavaFXUtils.findElement(child, id);
                                if (found == null) continue;
                                return found;
                            }
                            break block14;
                        }
                        if (!(root instanceof SplitPane)) break block20;
                        parent = (SplitPane)root;
                        for (Menu child : parent.getItems()) {
                            found = JavaFXUtils.findElement(child, id);
                            if (found == null) continue;
                            return found;
                        }
                        break block14;
                    }
                    if (!(root instanceof ScrollPane)) break block21;
                    ScrollPane scrollPane = (ScrollPane)root;
                    if (scrollPane.getContent() != null && (found2 = JavaFXUtils.findElement(scrollPane.getContent(), id)) != null) {
                        return found2;
                    }
                    break block14;
                }
                if (!(root instanceof ToolBar)) break block22;
                ToolBar toolBar = (ToolBar)root;
                for (Menu child : toolBar.getItems()) {
                    found = JavaFXUtils.findNode((Node)child, id);
                    if (found == null) continue;
                    return found;
                }
                break block14;
            }
            if (!(root instanceof Parent)) break block14;
            parent = (Parent)root;
            for (Menu child : parent.getChildrenUnmodifiable()) {
                found = JavaFXUtils.findElement(child, id);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    @Nullable
    public static Window getWindowAncestor(@Nonnull Object node) {
        TabPane tabPane;
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        if (node instanceof Window) {
            return (Window)node;
        }
        if (node instanceof Scene) {
            return ((Scene)node).getWindow();
        }
        if (node instanceof Node) {
            Scene scene = ((Node)node).getScene();
            if (scene != null) {
                return scene.getWindow();
            }
        } else if (node instanceof Tab && (tabPane = ((Tab)node).getTabPane()) != null) {
            return JavaFXUtils.getWindowAncestor(tabPane);
        }
        return null;
    }

    private static ValueConversionException illegalValue(Object value, Class<?> klass) {
        throw new ValueConversionException(value, klass);
    }

    private static ValueConversionException illegalValue(Object value, Class<?> klass, Exception e) {
        throw new ValueConversionException(value, klass, e);
    }

    private static class JavaFXThreadProxyObservableList<E>
    extends DelegatingObservableList<E> {
        protected JavaFXThreadProxyObservableList(ObservableList<E> delegate) {
            super(delegate);
        }

        @Override
        protected void sourceChanged(@Nonnull ListChangeListener.Change<? extends E> c) {
            if (Platform.isFxApplicationThread()) {
                this.fireChange(c);
            } else {
                Platform.runLater(() -> this.fireChange(c));
            }
        }
    }
}

