/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ColorFormatter
extends AbstractFormatter<Color> {
    public static final String PATTERN_SHORT = "#RGB";
    public static final String PATTERN_SHORT_WITH_ALPHA = "#RGBA";
    public static final String PATTERN_LONG = "#RRGGBB";
    public static final String PATTERN_LONG_WITH_ALPHA = "#RRGGBBAA";
    public static final String DEFAULT_PATTERN = "#RRGGBB";
    private static final String[] PATTERNS = new String[]{"#RRGGBB", "#RRGGBBAA", "#RGB", "#RGBA"};
    public static final ColorFormatter SHORT = new ColorFormatter("#RGB");
    public static final ColorFormatter SHORT_WITH_ALPHA = new ColorFormatter("#RGBA");
    public static final ColorFormatter LONG = new ColorFormatter("#RRGGBB");
    public static final ColorFormatter LONG_WITH_ALPHA = new ColorFormatter("#RRGGBBAA");
    private final ColorFormatterDelegate delegate;

    @Nonnull
    public static ColorFormatter getInstance(@Nonnull String pattern) {
        return new ColorFormatter(pattern);
    }

    protected ColorFormatter(@Nullable String pattern) {
        if (PATTERN_SHORT.equals(pattern)) {
            this.delegate = new ShortColorFormatterDelegate();
        } else if (PATTERN_SHORT_WITH_ALPHA.equals(pattern)) {
            this.delegate = new ShortWithAlphaColorFormatterDelegate();
        } else if ("#RRGGBB".equals(pattern)) {
            this.delegate = new LongColorFormatterDelegate();
        } else if (PATTERN_LONG_WITH_ALPHA.equals(pattern)) {
            this.delegate = new LongWithAlphaColorFormatterDelegate();
        } else if (GriffonNameUtils.isBlank((String)pattern)) {
            this.delegate = new LongColorFormatterDelegate();
        } else {
            throw new IllegalArgumentException("Invalid pattern '" + pattern + "'. Valid patterns are " + Arrays.toString(PATTERNS));
        }
    }

    @Nullable
    public String format(@Nullable Color color) {
        return color == null ? null : this.delegate.format(color);
    }

    @Nullable
    public Color parse(@Nullable String str) throws ParseException {
        return GriffonNameUtils.isBlank((String)str) ? null : this.delegate.parse(str);
    }

    @Nonnull
    public String getPattern() {
        return this.delegate.getPattern();
    }

    @Nonnull
    public static Color parseColor(@Nonnull String str) throws ParseException {
        if (str.startsWith("#")) {
            switch (str.length()) {
                case 4: {
                    return SHORT.parse(str);
                }
                case 5: {
                    return SHORT_WITH_ALPHA.parse(str);
                }
                case 7: {
                    return LONG.parse(str);
                }
                case 9: {
                    return LONG_WITH_ALPHA.parse(str);
                }
            }
            throw ColorFormatter.parseError((Object)str, Color.class);
        }
        try {
            String colorFieldName = str.toUpperCase();
            Field field = Color.class.getField(colorFieldName);
            return (Color)field.get(null);
        }
        catch (Exception e) {
            throw ColorFormatter.parseError((Object)str, Color.class, (Exception)e);
        }
    }

    private static int red(Color color) {
        return ColorFormatter.toIntColor(color.getRed());
    }

    private static int green(Color color) {
        return ColorFormatter.toIntColor(color.getGreen());
    }

    private static int blue(Color color) {
        return ColorFormatter.toIntColor(color.getBlue());
    }

    private static int alpha(Color color) {
        return ColorFormatter.toIntColor(color.getOpacity());
    }

    private static int toIntColor(double c) {
        return new Double(c * 255.0).intValue();
    }

    private static String padLeft(String self, String padding) {
        return 2 <= self.length() ? self : padding + self;
    }

    private static class LongWithAlphaColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private LongWithAlphaColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_LONG_WITH_ALPHA);
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + ColorFormatter.padLeft(Integer.toHexString(ColorFormatter.red(color)), "0") + ColorFormatter.padLeft(Integer.toHexString(ColorFormatter.green(color)), "0") + ColorFormatter.padLeft(Integer.toHexString(ColorFormatter.blue(color)), "0") + ColorFormatter.padLeft(Integer.toHexString(ColorFormatter.alpha(color)), "0");
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String str) throws ParseException {
            if (!str.startsWith("#") || str.length() != 9) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(4)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(5) + str.charAt(6)).toUpperCase(), (Class)Color.class);
            int a = ColorFormatter.parseHexInt((String)("" + str.charAt(7) + str.charAt(8)).toUpperCase(), (Class)Color.class);
            return Color.rgb((int)r, (int)g, (int)b, (double)((double)a / 255.0));
        }
    }

    private static class LongColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private LongColorFormatterDelegate() {
            super("#RRGGBB");
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + ColorFormatter.padLeft(Integer.toHexString(ColorFormatter.red(color)), "0") + ColorFormatter.padLeft(Integer.toHexString(ColorFormatter.green(color)), "0") + ColorFormatter.padLeft(Integer.toHexString(ColorFormatter.blue(color)), "0");
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String str) throws ParseException {
            if (!str.startsWith("#") || str.length() != 7) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(4)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(5) + str.charAt(6)).toUpperCase(), (Class)Color.class);
            return Color.rgb((int)r, (int)g, (int)b);
        }
    }

    private static class ShortWithAlphaColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private ShortWithAlphaColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_SHORT_WITH_ALPHA);
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + Integer.toHexString(ColorFormatter.red(color)).charAt(0) + Integer.toHexString(ColorFormatter.green(color)).charAt(0) + Integer.toHexString(ColorFormatter.blue(color)).charAt(0) + Integer.toHexString(ColorFormatter.alpha(color)).charAt(0);
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String str) throws ParseException {
            if (!str.startsWith("#") || str.length() != 5) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(1)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(2) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(3)).toUpperCase(), (Class)Color.class);
            int a = ColorFormatter.parseHexInt((String)("" + str.charAt(4) + str.charAt(4)).toUpperCase(), (Class)Color.class);
            return Color.rgb((int)r, (int)g, (int)b, (double)((double)a / 255.0));
        }
    }

    private static class ShortColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private ShortColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_SHORT);
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + Integer.toHexString(ColorFormatter.red(color)).charAt(0) + Integer.toHexString(ColorFormatter.green(color)).charAt(0) + Integer.toHexString(ColorFormatter.blue(color)).charAt(0);
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String str) throws ParseException {
            if (!str.startsWith("#") || str.length() != 4) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(1)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(2) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(3)).toUpperCase(), (Class)Color.class);
            return Color.rgb((int)r, (int)g, (int)b);
        }
    }

    private static abstract class AbstractColorFormatterDelegate
    implements ColorFormatterDelegate {
        private final String pattern;

        private AbstractColorFormatterDelegate(@Nonnull String pattern) {
            this.pattern = pattern;
        }

        @Override
        @Nonnull
        public String getPattern() {
            return this.pattern;
        }
    }

    private static interface ColorFormatterDelegate {
        @Nonnull
        public String getPattern();

        @Nonnull
        public String format(@Nonnull Color var1);

        @Nonnull
        public Color parse(@Nonnull String var1) throws ParseException;
    }
}

