/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ImagePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof File) {
            this.handleAsFile((File)value);
        } else if (value instanceof URL) {
            this.handleAsURL((URL)value);
        } else if (value instanceof URI) {
            this.handleAsURI((URI)value);
        } else if (value instanceof InputStream) {
            this.handleAsInputStream((InputStream)value);
        } else if (value instanceof Image) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Image.class);
        }
    }

    protected void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
        } else if (str.contains("|")) {
            this.handleAsClassWithArg(str);
        } else {
            this.handleAsURL(((Object)((Object)this)).getClass().getClassLoader().getResource(str));
        }
    }

    protected void handleAsFile(File file) {
        try {
            this.handleAsURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(file, URL.class, e);
        }
    }

    protected void handleAsURL(URL url) {
        try {
            super.setValueInternal((Object)new Image(url.toString()));
        }
        catch (Exception e) {
            throw this.illegalValue(url, URL.class, e);
        }
    }

    protected void handleAsURI(URI uri) {
        try {
            this.handleAsURL(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(uri, URL.class, e);
        }
    }

    protected void handleAsInputStream(InputStream stream) {
        try {
            super.setValueInternal((Object)new Image(stream));
        }
        catch (Exception e) {
            throw this.illegalValue(stream, URL.class, e);
        }
    }

    protected void handleAsClassWithArg(String str) {
        String[] args = str.split("\\|");
        if (args.length == 2) {
            Class<?> iconClass = null;
            try {
                iconClass = ImagePropertyEditor.class.getClassLoader().loadClass(args[0]);
            }
            catch (ClassNotFoundException e) {
                throw this.illegalValue(str, Image.class, e);
            }
            Constructor<?> constructor = null;
            try {
                constructor = iconClass.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw this.illegalValue(str, Image.class, e);
            }
            try {
                Object o = constructor.newInstance(args[1]);
                if (o instanceof Image) {
                    super.setValueInternal(o);
                }
                if (o instanceof ImageView) {
                    super.setValueInternal((Object)((ImageView)o).getImage());
                }
                throw this.illegalValue(str, Image.class);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw this.illegalValue(str, Image.class, e);
            }
        } else {
            throw this.illegalValue(str, Image.class);
        }
    }
}

