/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.javafx.editors.ImagePropertyEditor;
import griffon.util.GriffonNameUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class GraphicPropertyEditor
extends AbstractPropertyEditor {
    protected final ImagePropertyEditor imagePropertyEditor = new ImagePropertyEditor();

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else {
            this.handleWithImagePropertyEditor(value);
        }
    }

    protected void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
        } else if (str.contains("|")) {
            this.handleAsClassWithArg(str);
        } else {
            this.handleWithImagePropertyEditor(str);
        }
    }

    protected void handleWithImagePropertyEditor(Object value) {
        try {
            this.imagePropertyEditor.setValueInternal(value);
            Image image = (Image)this.imagePropertyEditor.getValue();
            if (image != null) {
                super.setValueInternal((Object)new ImageView(image));
            } else {
                super.setValueInternal(null);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalValue(value, Node.class, iae);
        }
    }

    protected void handleAsClassWithArg(String str) {
        String[] args = str.split("\\|");
        if (args.length == 2) {
            Class<?> iconClass = null;
            try {
                iconClass = GraphicPropertyEditor.class.getClassLoader().loadClass(args[0]);
            }
            catch (ClassNotFoundException e) {
                throw this.illegalValue(str, Node.class, e);
            }
            Constructor<?> constructor = null;
            try {
                constructor = iconClass.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw this.illegalValue(str, Node.class, e);
            }
            try {
                Object o = constructor.newInstance(args[1]);
                if (o instanceof Node) {
                    super.setValueInternal(o);
                }
                if (o instanceof Image) {
                    super.setValueInternal((Object)new ImageView((Image)o));
                }
                throw this.illegalValue(str, Node.class);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw this.illegalValue(str, Node.class, e);
            }
        } else {
            throw this.illegalValue(str, Node.class);
        }
    }
}

