/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx;

import griffon.core.ApplicationClassLoader;
import griffon.core.ApplicationConfigurer;
import griffon.core.ApplicationEvent;
import griffon.core.Configuration;
import griffon.core.Context;
import griffon.core.ExecutorServiceManager;
import griffon.core.GriffonApplication;
import griffon.core.ShutdownHandler;
import griffon.core.addon.AddonManager;
import griffon.core.addon.GriffonAddon;
import griffon.core.artifact.ArtifactManager;
import griffon.core.controller.ActionManager;
import griffon.core.env.ApplicationPhase;
import griffon.core.env.Lifecycle;
import griffon.core.event.EventRouter;
import griffon.core.i18n.MessageSource;
import griffon.core.injection.Injector;
import griffon.core.mvc.MVCGroupManager;
import griffon.core.resources.ResourceHandler;
import griffon.core.resources.ResourceInjector;
import griffon.core.resources.ResourceResolver;
import griffon.core.threading.UIThreadManager;
import griffon.core.view.WindowManager;
import griffon.util.AnnotationUtils;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import javafx.application.Application;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.griffon.runtime.core.MVCGroupExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaFXGriffonApplication
extends Application
implements GriffonApplication {
    public static final String[] EMPTY_ARGS = new String[0];
    private static final String ERROR_SHUTDOWN_HANDLER_NULL = "Argument 'shutdownHandler' must not be null";
    protected final Object[] lock = new Object[0];
    protected final PropertyChangeSupport pcs;
    private final List<ShutdownHandler> shutdownHandlers = new ArrayList<ShutdownHandler>();
    private final Object shutdownLock = new Object();
    private final Logger log;
    private Locale locale = Locale.getDefault();
    private ApplicationPhase phase = ApplicationPhase.INITIALIZE;
    private String[] startupArgs;
    private Injector<?> injector;

    public AbstractJavaFXGriffonApplication() {
        this(EMPTY_ARGS);
    }

    public AbstractJavaFXGriffonApplication(@Nonnull String[] args) {
        Objects.requireNonNull(args, "Argument 'args' must not be null");
        this.pcs = new PropertyChangeSupport((Object)this);
        this.startupArgs = Arrays.copyOf(args, args.length);
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    public void start(Stage stage) throws Exception {
        stage.setOnHidden(t -> this.shutdown());
    }

    public void stop() throws Exception {
        this.shutdown();
    }

    public void addPropertyChangeListener(@Nullable PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(@Nullable String propertyName, @Nullable PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(@Nullable PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@Nullable String propertyName, @Nullable PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    @Nonnull
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    @Nonnull
    public PropertyChangeListener[] getPropertyChangeListeners(@Nullable String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(@Nonnull PropertyChangeEvent event) {
        this.pcs.firePropertyChange(Objects.requireNonNull(event, "Argument 'event' must not be null"));
    }

    protected void firePropertyChange(@Nonnull String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
        this.pcs.firePropertyChange(GriffonNameUtils.requireNonBlank((String)propertyName, (String)"Argument 'propertyName' must not be blank"), oldValue, newValue);
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(@Nonnull Locale locale) {
        Locale oldValue = this.locale;
        this.locale = locale;
        Locale.setDefault(locale);
        this.firePropertyChange("locale", oldValue, locale);
    }

    @Nonnull
    public String[] getStartupArgs() {
        return this.startupArgs;
    }

    @Nonnull
    public Logger getLog() {
        return this.log;
    }

    public void setLocaleAsString(@Nullable String locale) {
        this.setLocale(GriffonApplicationUtils.parseLocale((String)locale));
    }

    public void addShutdownHandler(@Nonnull ShutdownHandler handler) {
        Objects.requireNonNull(handler, ERROR_SHUTDOWN_HANDLER_NULL);
        if (!this.shutdownHandlers.contains(handler)) {
            this.shutdownHandlers.add(handler);
        }
    }

    public void removeShutdownHandler(@Nonnull ShutdownHandler handler) {
        Objects.requireNonNull(handler, ERROR_SHUTDOWN_HANDLER_NULL);
        this.shutdownHandlers.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ApplicationPhase getPhase() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.phase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPhase(@Nonnull ApplicationPhase phase) {
        Objects.requireNonNull(phase, "Argument 'phase' must not be null");
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.phase = phase;
            this.firePropertyChange("phase", this.phase, this.phase);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Nonnull
    public ApplicationClassLoader getApplicationClassLoader() {
        return (ApplicationClassLoader)this.injector.getInstance(ApplicationClassLoader.class);
    }

    @Nonnull
    public Context getContext() {
        return (Context)this.injector.getInstance(Context.class, (Annotation)AnnotationUtils.named((String)"applicationContext"));
    }

    @Nonnull
    public Configuration getConfiguration() {
        return (Configuration)this.injector.getInstance(Configuration.class);
    }

    @Nonnull
    public UIThreadManager getUIThreadManager() {
        return (UIThreadManager)this.injector.getInstance(UIThreadManager.class);
    }

    @Nonnull
    public EventRouter getEventRouter() {
        return (EventRouter)this.injector.getInstance(EventRouter.class, (Annotation)AnnotationUtils.named((String)"applicationEventRouter"));
    }

    @Nonnull
    public ArtifactManager getArtifactManager() {
        return (ArtifactManager)this.injector.getInstance(ArtifactManager.class);
    }

    @Nonnull
    public ActionManager getActionManager() {
        return (ActionManager)this.injector.getInstance(ActionManager.class);
    }

    @Nonnull
    public AddonManager getAddonManager() {
        return (AddonManager)this.injector.getInstance(AddonManager.class);
    }

    @Nonnull
    public MVCGroupManager getMvcGroupManager() {
        return (MVCGroupManager)this.injector.getInstance(MVCGroupManager.class);
    }

    @Nonnull
    public MessageSource getMessageSource() {
        return (MessageSource)this.injector.getInstance(MessageSource.class, (Annotation)AnnotationUtils.named((String)"applicationMessageSource"));
    }

    @Nonnull
    public ResourceResolver getResourceResolver() {
        return (ResourceResolver)this.injector.getInstance(ResourceResolver.class, (Annotation)AnnotationUtils.named((String)"applicationResourceResolver"));
    }

    @Nonnull
    public ResourceHandler getResourceHandler() {
        return (ResourceHandler)this.injector.getInstance(ResourceHandler.class);
    }

    @Nonnull
    public ResourceInjector getResourceInjector() {
        return (ResourceInjector)this.injector.getInstance(ResourceInjector.class, (Annotation)AnnotationUtils.named((String)"applicationResourceInjector"));
    }

    @Nonnull
    public Injector<?> getInjector() {
        return this.injector;
    }

    public void setInjector(@Nonnull Injector<?> injector) {
        this.injector = Objects.requireNonNull(injector, "Argument 'injector' cannot be null");
        this.injector.injectMembers((Object)this);
        this.addShutdownHandler((ShutdownHandler)this.getWindowManager());
        MVCGroupExceptionHandler.registerWith((GriffonApplication)this);
    }

    @Nonnull
    public <W> WindowManager<W> getWindowManager() {
        return (WindowManager)this.injector.getInstance(WindowManager.class);
    }

    protected ApplicationConfigurer getApplicationConfigurer() {
        return (ApplicationConfigurer)this.injector.getInstance(ApplicationConfigurer.class);
    }

    public void initialize() {
        if (this.getPhase() == ApplicationPhase.INITIALIZE) {
            Application.Parameters parameters = this.getParameters();
            if (parameters != null && parameters.getRaw().size() > 0) {
                int length = parameters.getRaw().size();
                this.startupArgs = new String[length];
                System.arraycopy(parameters.getRaw().toArray(), 0, this.startupArgs, 0, length);
            }
            this.getApplicationConfigurer().init();
        }
    }

    public void ready() {
        if (this.getPhase() != ApplicationPhase.STARTUP) {
            return;
        }
        this.showStartingWindow();
        this.setPhase(ApplicationPhase.READY);
        this.event(ApplicationEvent.READY_START, Arrays.asList(this));
        this.getApplicationConfigurer().runLifecycleHandler(Lifecycle.READY);
        this.event(ApplicationEvent.READY_END, Arrays.asList(this));
        this.setPhase(ApplicationPhase.MAIN);
    }

    protected void showStartingWindow() {
        Object startingWindow = this.getWindowManager().getStartingWindow();
        if (startingWindow != null) {
            this.getWindowManager().show(startingWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canShutdown() {
        this.event(ApplicationEvent.SHUTDOWN_REQUESTED, Arrays.asList(this));
        Object object = this.shutdownLock;
        synchronized (object) {
            for (ShutdownHandler handler : this.shutdownHandlers) {
                if (handler.canShutdown((GriffonApplication)this)) continue;
                this.event(ApplicationEvent.SHUTDOWN_ABORTED, Arrays.asList(this));
                if (this.log.isDebugEnabled()) {
                    try {
                        this.log.debug("Shutdown aborted by " + handler);
                    }
                    catch (UnsupportedOperationException uoe) {
                        this.log.debug("Shutdown aborted by a handler");
                    }
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        Object latch;
        if (this.getPhase() == ApplicationPhase.SHUTDOWN) {
            return false;
        }
        if (!this.canShutdown()) {
            return false;
        }
        this.log.info("Shutdown is in process");
        this.setPhase(ApplicationPhase.SHUTDOWN);
        this.log.debug("Shutdown stage 1: notify all event listeners");
        if (this.getEventRouter().isEventPublishingEnabled()) {
            latch = new CountDownLatch(this.getUIThreadManager().isUIThread() ? 1 : 0);
            this.getEventRouter().addEventListener(ApplicationEvent.SHUTDOWN_START.getName(), arg_0 -> AbstractJavaFXGriffonApplication.lambda$shutdown$1((CountDownLatch)latch, arg_0));
            this.event(ApplicationEvent.SHUTDOWN_START, Arrays.asList(this));
            try {
                ((CountDownLatch)latch).await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.log.debug("Shutdown stage 2: notify all shutdown handlers");
        latch = this.shutdownLock;
        synchronized (latch) {
            for (ShutdownHandler handler : this.shutdownHandlers) {
                handler.onShutdown((GriffonApplication)this);
            }
        }
        this.log.debug("Shutdown stage 3: destroy all MVC groups");
        ArrayList mvcIds = new ArrayList();
        mvcIds.addAll(this.getMvcGroupManager().getGroups().keySet());
        for (String id : mvcIds) {
            this.getMvcGroupManager().destroyMVCGroup(id);
        }
        this.log.debug("Shutdown stage 4: execute Shutdown script");
        this.getApplicationConfigurer().runLifecycleHandler(Lifecycle.SHUTDOWN);
        ((ExecutorServiceManager)this.injector.getInstance(ExecutorServiceManager.class)).shutdownAll();
        this.injector.close();
        return true;
    }

    public void startup() {
        Object[] groups;
        if (this.getPhase() != ApplicationPhase.INITIALIZE) {
            return;
        }
        this.setPhase(ApplicationPhase.STARTUP);
        this.event(ApplicationEvent.STARTUP_START, Arrays.asList(this));
        Object startupGroups = this.getConfiguration().get("application.startupGroups", null);
        if (startupGroups instanceof List) {
            this.log.info("Initializing all startup groups: {}", startupGroups);
            for (String string : (List)startupGroups) {
                this.getMvcGroupManager().createMVC(string.trim());
            }
        } else if (startupGroups != null && startupGroups.getClass().isArray()) {
            groups = (Object[])startupGroups;
            this.log.info("Initializing all startup groups: {}", (Object)Arrays.toString(groups));
            for (Object groupName : groups) {
                this.getMvcGroupManager().createMVC(String.valueOf(groupName).trim());
            }
        } else if (startupGroups != null && startupGroups instanceof String) {
            groups = ((String)startupGroups).split(",");
            this.log.info("Initializing all startup groups: {}", (Object)Arrays.toString(groups));
            for (Object groupName : groups) {
                this.getMvcGroupManager().createMVC(((String)groupName).trim());
            }
        }
        for (Map.Entry entry : this.getAddonManager().getAddons().entrySet()) {
            List groups2 = ((GriffonAddon)entry.getValue()).getStartupGroups();
            if (groups2.isEmpty()) continue;
            this.log.info("Initializing all {} startup groups: {}", entry.getKey(), (Object)groups2);
            Map mvcGroups = ((GriffonAddon)entry.getValue()).getMvcGroups();
            for (String groupName : groups2) {
                if (!mvcGroups.containsKey(groupName)) continue;
                this.getMvcGroupManager().createMVC(groupName.trim());
            }
        }
        this.getApplicationConfigurer().runLifecycleHandler(Lifecycle.STARTUP);
        this.event(ApplicationEvent.STARTUP_END, Arrays.asList(this));
    }

    protected void event(@Nonnull ApplicationEvent event, @Nullable List<?> args) {
        this.getEventRouter().publishEvent(event.getName(), args);
    }

    private static /* synthetic */ void lambda$shutdown$1(CountDownLatch latch, Object[] args) {
        latch.countDown();
    }
}

