/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.loader.realm;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.gmaven.feature.Provider;
import org.codehaus.gmaven.runtime.loader.realm.RealmManager;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.ClassWorldException;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRealmManager
implements RealmManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClassWorld classWorld = new ClassWorld();
    private Map providerRealms = new HashMap();
    private int uniqueCounter = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassRealm createProviderRealm(String key, URL[] classPath, ClassLoader parent) throws ClassWorldException {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classPath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        String id = Provider.class.getName() + "[" + key + "]";
        this.log.debug("Creating provider realm: {}", (Object)id);
        ClassRealm realm = this.classWorld.newRealm(id, parent);
        for (int i = 0; i < classPath.length; ++i) {
            realm.addURL(classPath[i]);
            this.log.debug("    {}", (Object)classPath[i]);
        }
        this.providerRealms.put(key, realm);
        return realm;
    }

    private synchronized String uniqueId() {
        return System.currentTimeMillis() + ":" + this.uniqueCounter++;
    }

    public ClassRealm createComponentRealm(Provider provider, URL[] classPath) throws ClassWorldException {
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classPath == null) {
            throw new AssertionError();
        }
        String id = Provider.class.getName() + "#component[" + this.uniqueId() + "]";
        this.log.debug("Creating component realm: " + id);
        ClassRealm providerRealm = (ClassRealm)this.providerRealms.get(provider.key());
        if (providerRealm == null) {
            throw new Error("No realm for provider: " + provider);
        }
        this.log.debug("Provider realm: {}", (Object)providerRealm.getId());
        ClassRealm realm = providerRealm.createChildRealm(id);
        for (int i = 0; i < classPath.length; ++i) {
            realm.addURL(classPath[i]);
            this.log.debug("    {}", (Object)classPath[i]);
        }
        return realm;
    }

    public void releaseComponentRealm(ClassRealm realm) throws NoSuchRealmException {
        if (!$assertionsDisabled && realm == null) {
            throw new AssertionError();
        }
        this.log.debug("Releasing component realm: " + realm.getId());
        this.classWorld.disposeRealm(realm.getId());
    }

    static {
        $assertionsDisabled = !DefaultRealmManager.class.desiredAssertionStatus();
    }
}

