/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ContainerHelper.class)
public class ContainerHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private PlexusContainer container;

    public ContainerHelper() {
    }

    @VisibleForTesting
    public ContainerHelper(PlexusContainer container) {
        this.container = (PlexusContainer)Preconditions.checkNotNull((Object)container);
    }

    public Object lookup(Class type) throws Exception {
        Preconditions.checkNotNull((Object)type);
        this.log.trace("Lookup; class: {}", (Object)type);
        Object component = this.container.lookup(type);
        this.log.trace("Component: {}", component);
        return component;
    }

    public Object lookup(String typeName) throws Exception {
        Preconditions.checkNotNull((Object)typeName);
        this.log.trace("Lookup; class-name: {}", (Object)typeName);
        Object component = this.container.lookup(typeName);
        this.log.trace("Component: {}", component);
        return component;
    }

    public Object lookup(Class type, String name) throws Exception {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)name);
        this.log.trace("Lookup; class: {}, name: {}", (Object)type, (Object)name);
        Object component = this.container.lookup(type, name);
        this.log.trace("Component: {}", component);
        return component;
    }

    public Object lookup(String typeName, String name) throws Exception {
        Preconditions.checkNotNull((Object)typeName);
        Preconditions.checkNotNull((Object)name);
        this.log.trace("Lookup; class-name: {}, name: {}", (Object)typeName, (Object)name);
        Object component = this.container.lookup(typeName, name);
        this.log.trace("Component: {}", component);
        return component;
    }
}

