/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.configuration;

import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;

public class Deployer {
    private String type;
    private String implementation;

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public org.codehaus.cargo.container.deployer.Deployer createDeployer(Container container) throws MojoExecutionException {
        org.codehaus.cargo.container.deployer.Deployer deployer;
        DefaultDeployerFactory factory = new DefaultDeployerFactory();
        if (this.getType() == null) {
            if (this.getImplementation() != null) {
                throw new MojoExecutionException("As you have specified a deployer implementation to register you need to specify a deployer type in the deployer configuration in the POM.");
            }
            deployer = factory.createDeployer(container);
        } else {
            DeployerType type = DeployerType.toType((String)this.getType());
            if (this.getImplementation() != null) {
                try {
                    Class<?> deployerClass = Class.forName(this.getImplementation(), true, this.getClass().getClassLoader());
                    factory.registerDeployer(container.getId(), type, deployerClass);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MojoExecutionException("Custom deployer implementation [" + this.getImplementation() + "] cannot be loaded", (Exception)cnfe);
                }
            }
            deployer = factory.createDeployer(container, type);
        }
        return deployer;
    }
}

