/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

public final class SizeUtils {
    private static final double BYTE = 1.0;
    private static final double KIBI = 1024.0;
    private static final double MIBI = 1048576.0;
    private static final double GIBI = 1.073741824E9;

    public static String asIbi(long size) {
        if ((double)size > 1.073741824E9) {
            return String.format("%.1f GiB", (double)size / 1.073741824E9);
        }
        if ((double)size > 1048576.0) {
            return String.format("%.1f MiB", (double)size / 1048576.0);
        }
        if ((double)size > 1024.0) {
            return String.format("%.1f KiB", (double)size / 1024.0);
        }
        return String.format("%d B", size);
    }
}

