/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.operations.useradmin._OrganizationUsers;

public final class OrganizationUsers
extends _OrganizationUsers {
    private final List<String> auditors;
    private final List<String> billingManagers;
    private final List<String> managers;

    private OrganizationUsers(Builder builder) {
        this.auditors = OrganizationUsers.createUnmodifiableList(true, builder.auditors);
        this.billingManagers = OrganizationUsers.createUnmodifiableList(true, builder.billingManagers);
        this.managers = OrganizationUsers.createUnmodifiableList(true, builder.managers);
    }

    @Override
    public List<String> getAuditors() {
        return this.auditors;
    }

    @Override
    public List<String> getBillingManagers() {
        return this.billingManagers;
    }

    @Override
    public List<String> getManagers() {
        return this.managers;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OrganizationUsers && this.equalTo((OrganizationUsers)another);
    }

    private boolean equalTo(OrganizationUsers another) {
        return this.auditors.equals(another.auditors) && this.billingManagers.equals(another.billingManagers) && this.managers.equals(another.managers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.auditors.hashCode();
        h += (h << 5) + this.billingManagers.hashCode();
        h += (h << 5) + this.managers.hashCode();
        return h;
    }

    public String toString() {
        return "OrganizationUsers{auditors=" + this.auditors + ", billingManagers=" + this.billingManagers + ", managers=" + this.managers + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> auditors = new ArrayList<String>();
        private List<String> billingManagers = new ArrayList<String>();
        private List<String> managers = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(OrganizationUsers instance) {
            return this.from((_OrganizationUsers)instance);
        }

        final Builder from(_OrganizationUsers instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAuditors(instance.getAuditors());
            this.addAllBillingManagers(instance.getBillingManagers());
            this.addAllManagers(instance.getManagers());
            return this;
        }

        public final Builder auditor(String element) {
            this.auditors.add(Objects.requireNonNull(element, "auditors element"));
            return this;
        }

        public final Builder auditor(String ... elements) {
            for (String element : elements) {
                this.auditors.add(Objects.requireNonNull(element, "auditors element"));
            }
            return this;
        }

        public final Builder auditors(Iterable<String> elements) {
            this.auditors.clear();
            return this.addAllAuditors(elements);
        }

        public final Builder addAllAuditors(Iterable<String> elements) {
            for (String element : elements) {
                this.auditors.add(Objects.requireNonNull(element, "auditors element"));
            }
            return this;
        }

        public final Builder billingManager(String element) {
            this.billingManagers.add(Objects.requireNonNull(element, "billingManagers element"));
            return this;
        }

        public final Builder billingManager(String ... elements) {
            for (String element : elements) {
                this.billingManagers.add(Objects.requireNonNull(element, "billingManagers element"));
            }
            return this;
        }

        public final Builder billingManagers(Iterable<String> elements) {
            this.billingManagers.clear();
            return this.addAllBillingManagers(elements);
        }

        public final Builder addAllBillingManagers(Iterable<String> elements) {
            for (String element : elements) {
                this.billingManagers.add(Objects.requireNonNull(element, "billingManagers element"));
            }
            return this;
        }

        public final Builder manager(String element) {
            this.managers.add(Objects.requireNonNull(element, "managers element"));
            return this;
        }

        public final Builder manager(String ... elements) {
            for (String element : elements) {
                this.managers.add(Objects.requireNonNull(element, "managers element"));
            }
            return this;
        }

        public final Builder managers(Iterable<String> elements) {
            this.managers.clear();
            return this.addAllManagers(elements);
        }

        public final Builder addAllManagers(Iterable<String> elements) {
            for (String element : elements) {
                this.managers.add(Objects.requireNonNull(element, "managers element"));
            }
            return this;
        }

        public OrganizationUsers build() {
            return new OrganizationUsers(this);
        }
    }
}

