/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.routes.Destination;
import org.cloudfoundry.client.v3.routes.Protocol;
import org.cloudfoundry.client.v3.routes.Route;
import org.cloudfoundry.client.v3.routes.RouteRelationships;
import org.cloudfoundry.client.v3.routes._UpdateRouteResponse;
import org.immutables.value.Generated;

@Generated(from="_UpdateRouteResponse", generator="Immutables")
public final class UpdateRouteResponse
extends _UpdateRouteResponse {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    @Nullable
    private final List<Destination> destinations;
    private final String host;
    @Nullable
    private final Metadata metadata;
    private final String path;
    @Nullable
    private final Integer port;
    @Nullable
    private final Protocol protocol;
    private final RouteRelationships relationships;
    private final String url;

    private UpdateRouteResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = UpdateRouteResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.destinations = builder.destinations == null ? null : UpdateRouteResponse.createUnmodifiableList(true, builder.destinations);
        this.host = builder.host;
        this.metadata = builder.metadata;
        this.path = builder.path;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.relationships = builder.relationships;
        this.url = builder.url;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="destinations")
    @Nullable
    public List<Destination> getDestinations() {
        return this.destinations;
    }

    @Override
    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @Override
    @JsonProperty(value="port")
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="protocol")
    @Nullable
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    @JsonProperty(value="relationships")
    public RouteRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateRouteResponse && this.equalTo((UpdateRouteResponse)another);
    }

    private boolean equalTo(UpdateRouteResponse another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.destinations, another.destinations) && this.host.equals(another.host) && Objects.equals(this.metadata, another.metadata) && this.path.equals(another.path) && Objects.equals(this.port, another.port) && Objects.equals((Object)this.protocol, (Object)another.protocol) && this.relationships.equals(another.relationships) && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.destinations);
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode((Object)this.protocol);
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateRouteResponse{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", destinations=" + this.destinations + ", host=" + this.host + ", metadata=" + this.metadata + ", path=" + this.path + ", port=" + this.port + ", protocol=" + (Object)((Object)this.protocol) + ", relationships=" + this.relationships + ", url=" + this.url + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateRouteResponse fromJson(Json json) {
        Builder builder = UpdateRouteResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.destinations != null) {
            builder.addAllDestinations(json.destinations);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.protocol != null) {
            builder.protocol(json.protocol);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_UpdateRouteResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_HOST = 4L;
        private static final long INIT_BIT_PATH = 8L;
        private static final long INIT_BIT_RELATIONSHIPS = 16L;
        private static final long INIT_BIT_URL = 32L;
        private long initBits = 63L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private List<Destination> destinations = null;
        private String host;
        private Metadata metadata;
        private String path;
        private Integer port;
        private Protocol protocol;
        private RouteRelationships relationships;
        private String url;

        private Builder() {
        }

        public final Builder from(Route instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateRouteResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_UpdateRouteResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof Route) {
                List<Destination> destinationsValue;
                Integer portValue;
                Protocol protocolValue;
                instance = (Route)object;
                this.path(((Route)instance).getPath());
                this.relationships(((Route)instance).getRelationships());
                Metadata metadataValue = ((Route)instance).getMetadata();
                if (metadataValue != null) {
                    this.metadata(metadataValue);
                }
                if ((protocolValue = ((Route)instance).getProtocol()) != null) {
                    this.protocol(protocolValue);
                }
                if ((portValue = ((Route)instance).getPort()) != null) {
                    this.port(portValue);
                }
                if ((destinationsValue = ((Route)instance).getDestinations()) != null) {
                    this.addAllDestinations(destinationsValue);
                }
                this.host(((Route)instance).getHost());
                this.url(((Route)instance).getUrl());
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Builder destination(Destination element) {
            if (this.destinations == null) {
                this.destinations = new ArrayList<Destination>();
            }
            this.destinations.add(Objects.requireNonNull(element, "destinations element"));
            return this;
        }

        public final Builder destinations(Destination ... elements) {
            if (this.destinations == null) {
                this.destinations = new ArrayList<Destination>();
            }
            for (Destination element : elements) {
                this.destinations.add(Objects.requireNonNull(element, "destinations element"));
            }
            return this;
        }

        @JsonProperty(value="destinations")
        public final Builder destinations(@Nullable Iterable<? extends Destination> elements) {
            if (elements == null) {
                this.destinations = null;
                return this;
            }
            this.destinations = new ArrayList<Destination>();
            return this.addAllDestinations(elements);
        }

        public final Builder addAllDestinations(Iterable<? extends Destination> elements) {
            Objects.requireNonNull(elements, "destinations element");
            if (this.destinations == null) {
                this.destinations = new ArrayList<Destination>();
            }
            for (Destination destination : elements) {
                this.destinations.add(Objects.requireNonNull(destination, "destinations element"));
            }
            return this;
        }

        @JsonProperty(value="host")
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="path")
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="port")
        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="protocol")
        public final Builder protocol(@Nullable Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(RouteRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="url")
        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public UpdateRouteResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateRouteResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build UpdateRouteResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UpdateRouteResponse", generator="Immutables")
    static final class Json
    extends _UpdateRouteResponse {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        List<Destination> destinations = null;
        String host;
        Metadata metadata;
        String path;
        Integer port;
        Protocol protocol;
        RouteRelationships relationships;
        String url;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="destinations")
        public void setDestinations(@Nullable List<Destination> destinations) {
            this.destinations = destinations;
        }

        @JsonProperty(value="host")
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="path")
        public void setPath(String path) {
            this.path = path;
        }

        @JsonProperty(value="port")
        public void setPort(@Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="protocol")
        public void setProtocol(@Nullable Protocol protocol) {
            this.protocol = protocol;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(RouteRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="url")
        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Destination> getDestinations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Protocol getProtocol() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RouteRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

