/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum DropletState {
    COPYING("COPYING"),
    EXPIRED("EXPIRED"),
    FAILED("FAILED"),
    STAGED("STAGED");

    private final String value;

    private DropletState(String value) {
        this.value = value;
    }

    @JsonCreator
    public static DropletState from(String s) {
        switch (s.toLowerCase()) {
            case "copying": {
                return COPYING;
            }
            case "expired": {
                return EXPIRED;
            }
            case "failed": {
                return FAILED;
            }
            case "staged": {
                return STAGED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown droplet state: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

