/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum DeploymentStatusValue {
    ACTIVE("ACTIVE"),
    CANCELING("CANCELING"),
    DEPLOYING("DEPLOYING"),
    FINALIZED("FINALIZED");

    private final String value;

    private DeploymentStatusValue(String value) {
        this.value = value;
    }

    @JsonCreator
    public static DeploymentStatusValue from(String s) {
        switch (s.toLowerCase()) {
            case "active": {
                return ACTIVE;
            }
            case "deploying": {
                return DEPLOYING;
            }
            case "canceling": {
                return CANCELING;
            }
            case "finalized": {
                return FINALIZED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown deployment status value: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

