/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicekeys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.servicekeys._ListServiceKeysRequest;
import org.immutables.value.Generated;

@Generated(from="_ListServiceKeysRequest", generator="Immutables")
public final class ListServiceKeysRequest
extends _ListServiceKeysRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    @Nullable
    private final List<String> names;
    @Nullable
    private final List<String> serviceInstanceIds;

    private ListServiceKeysRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.names = builder.names == null ? null : ListServiceKeysRequest.createUnmodifiableList(true, builder.names);
        this.serviceInstanceIds = builder.serviceInstanceIds == null ? null : ListServiceKeysRequest.createUnmodifiableList(true, builder.serviceInstanceIds);
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServiceKeysRequest && this.equalTo((ListServiceKeysRequest)another);
    }

    private boolean equalTo(ListServiceKeysRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && Objects.equals(this.names, another.names) && Objects.equals(this.serviceInstanceIds, another.serviceInstanceIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + Objects.hashCode(this.serviceInstanceIds);
        return h;
    }

    public String toString() {
        return "ListServiceKeysRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", serviceInstanceIds=" + this.serviceInstanceIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListServiceKeysRequest", generator="Immutables")
    public static final class Builder {
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private List<String> names = null;
        private List<String> serviceInstanceIds = null;

        private Builder() {
        }

        public final Builder from(ListServiceKeysRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListServiceKeysRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListServiceKeysRequest) {
                List<String> serviceInstanceIdsValue;
                instance = (_ListServiceKeysRequest)object;
                List<String> namesValue = ((_ListServiceKeysRequest)instance).getNames();
                if (namesValue != null) {
                    this.addAllNames(namesValue);
                }
                if ((serviceInstanceIdsValue = ((_ListServiceKeysRequest)instance).getServiceInstanceIds()) != null) {
                    this.addAllServiceInstanceIds(serviceInstanceIdsValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder serviceInstanceId(String element) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList<String>();
            }
            this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            return this;
        }

        public final Builder serviceInstanceIds(String ... elements) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceInstanceIds = null;
                return this;
            }
            this.serviceInstanceIds = new ArrayList<String>();
            return this.addAllServiceInstanceIds(elements);
        }

        public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceInstanceIds element");
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public ListServiceKeysRequest build() {
            return new ListServiceKeysRequest(this);
        }
    }
}

