/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.securitygroups.RuleEntity;
import org.cloudfoundry.client.v2.securitygroups._SecurityGroupEntity;
import org.immutables.value.Generated;

@Generated(from="_SecurityGroupEntity", generator="Immutables")
public final class SecurityGroupEntity
extends _SecurityGroupEntity {
    @Nullable
    private final String name;
    @Nullable
    private final List<RuleEntity> rules;
    @Nullable
    private final Boolean runningDefault;
    @Nullable
    private final String spacesUrl;
    @Nullable
    private final Boolean stagingDefault;
    @Nullable
    private final String stagingSpacesUrl;

    private SecurityGroupEntity(Builder builder) {
        this.name = builder.name;
        this.rules = builder.rules == null ? null : SecurityGroupEntity.createUnmodifiableList(true, builder.rules);
        this.runningDefault = builder.runningDefault;
        this.spacesUrl = builder.spacesUrl;
        this.stagingDefault = builder.stagingDefault;
        this.stagingSpacesUrl = builder.stagingSpacesUrl;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="rules")
    @Nullable
    public List<RuleEntity> getRules() {
        return this.rules;
    }

    @Override
    @JsonProperty(value="running_default")
    @Nullable
    public Boolean getRunningDefault() {
        return this.runningDefault;
    }

    @Override
    @JsonProperty(value="spaces_url")
    @Nullable
    public String getSpacesUrl() {
        return this.spacesUrl;
    }

    @Override
    @JsonProperty(value="staging_default")
    @Nullable
    public Boolean getStagingDefault() {
        return this.stagingDefault;
    }

    @Override
    @JsonProperty(value="staging_spaces_url")
    @Nullable
    public String getStagingSpacesUrl() {
        return this.stagingSpacesUrl;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SecurityGroupEntity && this.equalTo((SecurityGroupEntity)another);
    }

    private boolean equalTo(SecurityGroupEntity another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.rules, another.rules) && Objects.equals(this.runningDefault, another.runningDefault) && Objects.equals(this.spacesUrl, another.spacesUrl) && Objects.equals(this.stagingDefault, another.stagingDefault) && Objects.equals(this.stagingSpacesUrl, another.stagingSpacesUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.rules);
        h += (h << 5) + Objects.hashCode(this.runningDefault);
        h += (h << 5) + Objects.hashCode(this.spacesUrl);
        h += (h << 5) + Objects.hashCode(this.stagingDefault);
        h += (h << 5) + Objects.hashCode(this.stagingSpacesUrl);
        return h;
    }

    public String toString() {
        return "SecurityGroupEntity{name=" + this.name + ", rules=" + this.rules + ", runningDefault=" + this.runningDefault + ", spacesUrl=" + this.spacesUrl + ", stagingDefault=" + this.stagingDefault + ", stagingSpacesUrl=" + this.stagingSpacesUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SecurityGroupEntity fromJson(Json json) {
        Builder builder = SecurityGroupEntity.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.rules != null) {
            builder.addAllRules(json.rules);
        }
        if (json.runningDefault != null) {
            builder.runningDefault(json.runningDefault);
        }
        if (json.spacesUrl != null) {
            builder.spacesUrl(json.spacesUrl);
        }
        if (json.stagingDefault != null) {
            builder.stagingDefault(json.stagingDefault);
        }
        if (json.stagingSpacesUrl != null) {
            builder.stagingSpacesUrl(json.stagingSpacesUrl);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_SecurityGroupEntity", generator="Immutables")
    public static final class Builder {
        private String name;
        private List<RuleEntity> rules = null;
        private Boolean runningDefault;
        private String spacesUrl;
        private Boolean stagingDefault;
        private String stagingSpacesUrl;

        private Builder() {
        }

        public final Builder from(SecurityGroupEntity instance) {
            return this.from((_SecurityGroupEntity)instance);
        }

        final Builder from(_SecurityGroupEntity instance) {
            String stagingSpacesUrlValue;
            Boolean stagingDefaultValue;
            String spacesUrlValue;
            Boolean runningDefaultValue;
            List<RuleEntity> rulesValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.getName();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((rulesValue = instance.getRules()) != null) {
                this.addAllRules(rulesValue);
            }
            if ((runningDefaultValue = instance.getRunningDefault()) != null) {
                this.runningDefault(runningDefaultValue);
            }
            if ((spacesUrlValue = instance.getSpacesUrl()) != null) {
                this.spacesUrl(spacesUrlValue);
            }
            if ((stagingDefaultValue = instance.getStagingDefault()) != null) {
                this.stagingDefault(stagingDefaultValue);
            }
            if ((stagingSpacesUrlValue = instance.getStagingSpacesUrl()) != null) {
                this.stagingSpacesUrl(stagingSpacesUrlValue);
            }
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder rule(RuleEntity element) {
            if (this.rules == null) {
                this.rules = new ArrayList<RuleEntity>();
            }
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder rules(RuleEntity ... elements) {
            if (this.rules == null) {
                this.rules = new ArrayList<RuleEntity>();
            }
            for (RuleEntity element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        @JsonProperty(value="rules")
        public final Builder rules(@Nullable Iterable<? extends RuleEntity> elements) {
            if (elements == null) {
                this.rules = null;
                return this;
            }
            this.rules = new ArrayList<RuleEntity>();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends RuleEntity> elements) {
            Objects.requireNonNull(elements, "rules element");
            if (this.rules == null) {
                this.rules = new ArrayList<RuleEntity>();
            }
            for (RuleEntity ruleEntity : elements) {
                this.rules.add(Objects.requireNonNull(ruleEntity, "rules element"));
            }
            return this;
        }

        @JsonProperty(value="running_default")
        public final Builder runningDefault(@Nullable Boolean runningDefault) {
            this.runningDefault = runningDefault;
            return this;
        }

        @JsonProperty(value="spaces_url")
        public final Builder spacesUrl(@Nullable String spacesUrl) {
            this.spacesUrl = spacesUrl;
            return this;
        }

        @JsonProperty(value="staging_default")
        public final Builder stagingDefault(@Nullable Boolean stagingDefault) {
            this.stagingDefault = stagingDefault;
            return this;
        }

        @JsonProperty(value="staging_spaces_url")
        public final Builder stagingSpacesUrl(@Nullable String stagingSpacesUrl) {
            this.stagingSpacesUrl = stagingSpacesUrl;
            return this;
        }

        public SecurityGroupEntity build() {
            return new SecurityGroupEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_SecurityGroupEntity", generator="Immutables")
    static final class Json
    extends _SecurityGroupEntity {
        String name;
        List<RuleEntity> rules = null;
        Boolean runningDefault;
        String spacesUrl;
        Boolean stagingDefault;
        String stagingSpacesUrl;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="rules")
        public void setRules(@Nullable List<RuleEntity> rules) {
            this.rules = rules;
        }

        @JsonProperty(value="running_default")
        public void setRunningDefault(@Nullable Boolean runningDefault) {
            this.runningDefault = runningDefault;
        }

        @JsonProperty(value="spaces_url")
        public void setSpacesUrl(@Nullable String spacesUrl) {
            this.spacesUrl = spacesUrl;
        }

        @JsonProperty(value="staging_default")
        public void setStagingDefault(@Nullable Boolean stagingDefault) {
            this.stagingDefault = stagingDefault;
        }

        @JsonProperty(value="staging_spaces_url")
        public void setStagingSpacesUrl(@Nullable String stagingSpacesUrl) {
            this.stagingSpacesUrl = stagingSpacesUrl;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<RuleEntity> getRules() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getRunningDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpacesUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getStagingDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStagingSpacesUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

