/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityzones._Key;

public final class Key
extends _Key {
    @Nullable
    private final String certificate;
    @Nullable
    private final String key;
    @Nullable
    private final String passphrase;

    private Key(Builder builder) {
        this.certificate = builder.certificate;
        this.key = builder.key;
        this.passphrase = builder.passphrase;
    }

    @Override
    @JsonProperty(value="certificate")
    @Nullable
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    @JsonProperty(value="key")
    @Nullable
    public String getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="passphrase")
    @Nullable
    public String getPassphrase() {
        return this.passphrase;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Key && this.equalTo((Key)another);
    }

    private boolean equalTo(Key another) {
        return Objects.equals(this.certificate, another.certificate) && Objects.equals(this.key, another.key) && Objects.equals(this.passphrase, another.passphrase);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.certificate);
        h += (h << 5) + Objects.hashCode(this.key);
        h += (h << 5) + Objects.hashCode(this.passphrase);
        return h;
    }

    public String toString() {
        return "Key{certificate=" + this.certificate + ", key=" + this.key + ", passphrase=" + this.passphrase + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Key fromJson(Json json) {
        Builder builder = Key.builder();
        if (json.certificate != null) {
            builder.certificate(json.certificate);
        }
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.passphrase != null) {
            builder.passphrase(json.passphrase);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String certificate;
        private String key;
        private String passphrase;

        private Builder() {
        }

        public final Builder from(Key instance) {
            return this.from((_Key)instance);
        }

        final Builder from(_Key instance) {
            String passphraseValue;
            String keyValue;
            Objects.requireNonNull(instance, "instance");
            String certificateValue = instance.getCertificate();
            if (certificateValue != null) {
                this.certificate(certificateValue);
            }
            if ((keyValue = instance.getKey()) != null) {
                this.key(keyValue);
            }
            if ((passphraseValue = instance.getPassphrase()) != null) {
                this.passphrase(passphraseValue);
            }
            return this;
        }

        @JsonProperty(value="certificate")
        public final Builder certificate(@Nullable String certificate) {
            this.certificate = certificate;
            return this;
        }

        @JsonProperty(value="key")
        public final Builder key(@Nullable String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="passphrase")
        public final Builder passphrase(@Nullable String passphrase) {
            this.passphrase = passphrase;
            return this;
        }

        public Key build() {
            return new Key(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Key {
        String certificate;
        String key;
        String passphrase;

        Json() {
        }

        @JsonProperty(value="certificate")
        public void setCertificate(@Nullable String certificate) {
            this.certificate = certificate;
        }

        @JsonProperty(value="key")
        public void setKey(@Nullable String key) {
            this.key = key;
        }

        @JsonProperty(value="passphrase")
        public void setPassphrase(@Nullable String passphrase) {
            this.passphrase = passphrase;
        }

        @Override
        public String getCertificate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPassphrase() {
            throw new UnsupportedOperationException();
        }
    }
}

