/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum LdapGroupFile {
    GROUPS_AS_SCOPES("ldap/ldap-groups-as-scopes.xml"),
    GROUPS_MAP_TO_SCOPES("ldap/ldap-groups-map-to-scopes.xml"),
    NO_GROUP("ldap/ldap-groups-null.xml");

    private final String value;

    private LdapGroupFile(String value) {
        this.value = value;
    }

    @JsonCreator
    public static LdapGroupFile from(String s) {
        switch (s.toLowerCase()) {
            case "ldap/ldap-groups-as-scopes.xml": {
                return GROUPS_AS_SCOPES;
            }
            case "ldap/ldap-groups-map-to-scopes.xml": {
                return GROUPS_MAP_TO_SCOPES;
            }
            case "ldap/ldap-groups-null.xml": {
                return NO_GROUP;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown ldap group file: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

