/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.groups.AbstractExternalGroupResource;
import org.cloudfoundry.uaa.groups._ExternalGroupResource;

public final class ExternalGroupResource
extends _ExternalGroupResource {
    private final String displayName;
    private final String externalGroup;
    private final String groupId;
    private final String origin;

    private ExternalGroupResource(Builder builder) {
        this.displayName = builder.displayName;
        this.externalGroup = builder.externalGroup;
        this.groupId = builder.groupId;
        this.origin = builder.origin;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="externalGroup")
    public String getExternalGroup() {
        return this.externalGroup;
    }

    @Override
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="origin")
    public String getOrigin() {
        return this.origin;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ExternalGroupResource && this.equalTo((ExternalGroupResource)another);
    }

    private boolean equalTo(ExternalGroupResource another) {
        return this.displayName.equals(another.displayName) && this.externalGroup.equals(another.externalGroup) && this.groupId.equals(another.groupId) && this.origin.equals(another.origin);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.displayName.hashCode();
        h += (h << 5) + this.externalGroup.hashCode();
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.origin.hashCode();
        return h;
    }

    public String toString() {
        return "ExternalGroupResource{displayName=" + this.displayName + ", externalGroup=" + this.externalGroup + ", groupId=" + this.groupId + ", origin=" + this.origin + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ExternalGroupResource fromJson(Json json) {
        Builder builder = ExternalGroupResource.builder();
        if (json.displayName != null) {
            builder.displayName(json.displayName);
        }
        if (json.externalGroup != null) {
            builder.externalGroup(json.externalGroup);
        }
        if (json.groupId != null) {
            builder.groupId(json.groupId);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DISPLAY_NAME = 1L;
        private static final long INIT_BIT_EXTERNAL_GROUP = 2L;
        private static final long INIT_BIT_GROUP_ID = 4L;
        private static final long INIT_BIT_ORIGIN = 8L;
        private long initBits = 15L;
        private String displayName;
        private String externalGroup;
        private String groupId;
        private String origin;

        private Builder() {
        }

        public final Builder from(AbstractExternalGroupResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExternalGroupResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ExternalGroupResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractExternalGroupResource) {
                AbstractExternalGroupResource instance = (AbstractExternalGroupResource)object;
                this.displayName(instance.getDisplayName());
                this.externalGroup(instance.getExternalGroup());
                this.groupId(instance.getGroupId());
                this.origin(instance.getOrigin());
            }
        }

        @JsonProperty(value="displayName")
        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="externalGroup")
        public final Builder externalGroup(String externalGroup) {
            this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="groupId")
        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="origin")
        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ExternalGroupResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ExternalGroupResource(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("displayName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("externalGroup");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("origin");
            }
            return "Cannot build ExternalGroupResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ExternalGroupResource {
        String displayName;
        String externalGroup;
        String groupId;
        String origin;

        Json() {
        }

        @JsonProperty(value="displayName")
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @JsonProperty(value="externalGroup")
        public void setExternalGroup(String externalGroup) {
            this.externalGroup = externalGroup;
        }

        @JsonProperty(value="groupId")
        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @JsonProperty(value="origin")
        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExternalGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrigin() {
            throw new UnsupportedOperationException();
        }
    }
}

