/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.networking.v1.policies;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.networking.v1.policies._Source;

public final class Source
extends _Source {
    private final String id;

    private Source(Builder builder) {
        this.id = builder.id;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Source && this.equalTo((Source)another);
    }

    private boolean equalTo(Source another) {
        return this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "Source{id=" + this.id + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Source fromJson(Json json) {
        Builder builder = Source.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        private String id;

        private Builder() {
        }

        public final Builder from(Source instance) {
            return this.from((_Source)instance);
        }

        final Builder from(_Source instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Source build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Source(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Source, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Source {
        String id;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }
    }
}

