/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.isolationsegments._UpdateIsolationSegmentRequest;

public final class UpdateIsolationSegmentRequest
extends _UpdateIsolationSegmentRequest {
    private final String isolationSegmentId;
    private final String name;

    private UpdateIsolationSegmentRequest(Builder builder) {
        this.isolationSegmentId = builder.isolationSegmentId;
        this.name = builder.name;
    }

    @Override
    public String getIsolationSegmentId() {
        return this.isolationSegmentId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateIsolationSegmentRequest && this.equalTo((UpdateIsolationSegmentRequest)another);
    }

    private boolean equalTo(UpdateIsolationSegmentRequest another) {
        return this.isolationSegmentId.equals(another.isolationSegmentId) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.isolationSegmentId.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateIsolationSegmentRequest{isolationSegmentId=" + this.isolationSegmentId + ", name=" + this.name + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ISOLATION_SEGMENT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private String isolationSegmentId;
        private String name;

        private Builder() {
        }

        public final Builder from(UpdateIsolationSegmentRequest instance) {
            return this.from((_UpdateIsolationSegmentRequest)instance);
        }

        final Builder from(_UpdateIsolationSegmentRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.isolationSegmentId(instance.getIsolationSegmentId());
            this.name(instance.getName());
            return this;
        }

        public final Builder isolationSegmentId(String isolationSegmentId) {
            this.isolationSegmentId = Objects.requireNonNull(isolationSegmentId, "isolationSegmentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public UpdateIsolationSegmentRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateIsolationSegmentRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isolationSegmentId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build UpdateIsolationSegmentRequest, some of required attributes are not set " + attributes;
        }
    }
}

