/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.applications.ApplicationRelationships;
import org.cloudfoundry.client.v3.applications._CreateApplicationRequest;

public final class CreateApplicationRequest
extends _CreateApplicationRequest {
    @Nullable
    private final Map<String, String> environmentVariables;
    @Nullable
    private final Lifecycle lifecycle;
    private final String name;
    private final ApplicationRelationships relationships;

    private CreateApplicationRequest(Builder builder) {
        this.environmentVariables = builder.environmentVariables == null ? null : CreateApplicationRequest.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.lifecycle = builder.lifecycle;
        this.name = builder.name;
        this.relationships = builder.relationships;
    }

    @Override
    @Nullable
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @Nullable
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ApplicationRelationships getRelationships() {
        return this.relationships;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateApplicationRequest && this.equalTo((CreateApplicationRequest)another);
    }

    private boolean equalTo(CreateApplicationRequest another) {
        return Objects.equals(this.environmentVariables, another.environmentVariables) && Objects.equals(this.lifecycle, another.lifecycle) && this.name.equals(another.name) && this.relationships.equals(another.relationships);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.environmentVariables);
        h += (h << 5) + Objects.hashCode(this.lifecycle);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        return h;
    }

    public String toString() {
        return "CreateApplicationRequest{environmentVariables=" + this.environmentVariables + ", lifecycle=" + this.lifecycle + ", name=" + this.name + ", relationships=" + this.relationships + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_RELATIONSHIPS = 2L;
        private long initBits = 3L;
        private Map<String, String> environmentVariables = null;
        private Lifecycle lifecycle;
        private String name;
        private ApplicationRelationships relationships;

        private Builder() {
        }

        public final Builder from(CreateApplicationRequest instance) {
            return this.from((_CreateApplicationRequest)instance);
        }

        final Builder from(_CreateApplicationRequest instance) {
            Lifecycle lifecycleValue;
            Objects.requireNonNull(instance, "instance");
            Map<String, String> environmentVariablesValue = instance.getEnvironmentVariables();
            if (environmentVariablesValue != null) {
                this.putAllEnvironmentVariables(environmentVariablesValue);
            }
            if ((lifecycleValue = instance.getLifecycle()) != null) {
                this.lifecycle(lifecycleValue);
            }
            this.name(instance.getName());
            this.relationships(instance.getRelationships());
            return this;
        }

        public final Builder environmentVariable(String key, String value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            this.environmentVariables.put(key, value);
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.environmentVariables.put(k, v);
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends String> environmentVariables) {
            if (environmentVariables == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, String>();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends String> environmentVariables) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.environmentVariables.put(k, v);
            }
            return this;
        }

        public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationships(ApplicationRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationships");
            }
            return "Cannot build CreateApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

