/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.users.UserOrganizationResource;
import org.cloudfoundry.client.v2.users.UserSpaceResource;
import org.cloudfoundry.client.v2.users._UserSummaryEntity;

public final class UserSummaryEntity
extends _UserSummaryEntity {
    @Nullable
    private final List<UserOrganizationResource> auditedOrganizations;
    @Nullable
    private final List<UserSpaceResource> auditedSpaces;
    @Nullable
    private final List<UserOrganizationResource> billingManagedOrganizations;
    @Nullable
    private final List<UserOrganizationResource> managedOrganizations;
    @Nullable
    private final List<UserSpaceResource> managedSpaces;
    @Nullable
    private final List<UserOrganizationResource> organizations;
    @Nullable
    private final List<UserSpaceResource> spaces;

    private UserSummaryEntity(Builder builder) {
        this.auditedOrganizations = builder.auditedOrganizations == null ? null : UserSummaryEntity.createUnmodifiableList(true, builder.auditedOrganizations);
        this.auditedSpaces = builder.auditedSpaces == null ? null : UserSummaryEntity.createUnmodifiableList(true, builder.auditedSpaces);
        this.billingManagedOrganizations = builder.billingManagedOrganizations == null ? null : UserSummaryEntity.createUnmodifiableList(true, builder.billingManagedOrganizations);
        this.managedOrganizations = builder.managedOrganizations == null ? null : UserSummaryEntity.createUnmodifiableList(true, builder.managedOrganizations);
        this.managedSpaces = builder.managedSpaces == null ? null : UserSummaryEntity.createUnmodifiableList(true, builder.managedSpaces);
        this.organizations = builder.organizations == null ? null : UserSummaryEntity.createUnmodifiableList(true, builder.organizations);
        this.spaces = builder.spaces == null ? null : UserSummaryEntity.createUnmodifiableList(true, builder.spaces);
    }

    @Override
    @JsonProperty(value="audited_organizations")
    @Nullable
    public List<UserOrganizationResource> getAuditedOrganizations() {
        return this.auditedOrganizations;
    }

    @Override
    @JsonProperty(value="audited_spaces")
    @Nullable
    public List<UserSpaceResource> getAuditedSpaces() {
        return this.auditedSpaces;
    }

    @Override
    @JsonProperty(value="billing_managed_organizations")
    @Nullable
    public List<UserOrganizationResource> getBillingManagedOrganizations() {
        return this.billingManagedOrganizations;
    }

    @Override
    @JsonProperty(value="managed_organizations")
    @Nullable
    public List<UserOrganizationResource> getManagedOrganizations() {
        return this.managedOrganizations;
    }

    @Override
    @JsonProperty(value="managed_spaces")
    @Nullable
    public List<UserSpaceResource> getManagedSpaces() {
        return this.managedSpaces;
    }

    @Override
    @JsonProperty(value="organizations")
    @Nullable
    public List<UserOrganizationResource> getOrganizations() {
        return this.organizations;
    }

    @Override
    @JsonProperty(value="spaces")
    @Nullable
    public List<UserSpaceResource> getSpaces() {
        return this.spaces;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UserSummaryEntity && this.equalTo((UserSummaryEntity)another);
    }

    private boolean equalTo(UserSummaryEntity another) {
        return Objects.equals(this.auditedOrganizations, another.auditedOrganizations) && Objects.equals(this.auditedSpaces, another.auditedSpaces) && Objects.equals(this.billingManagedOrganizations, another.billingManagedOrganizations) && Objects.equals(this.managedOrganizations, another.managedOrganizations) && Objects.equals(this.managedSpaces, another.managedSpaces) && Objects.equals(this.organizations, another.organizations) && Objects.equals(this.spaces, another.spaces);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.auditedOrganizations);
        h += (h << 5) + Objects.hashCode(this.auditedSpaces);
        h += (h << 5) + Objects.hashCode(this.billingManagedOrganizations);
        h += (h << 5) + Objects.hashCode(this.managedOrganizations);
        h += (h << 5) + Objects.hashCode(this.managedSpaces);
        h += (h << 5) + Objects.hashCode(this.organizations);
        h += (h << 5) + Objects.hashCode(this.spaces);
        return h;
    }

    public String toString() {
        return "UserSummaryEntity{auditedOrganizations=" + this.auditedOrganizations + ", auditedSpaces=" + this.auditedSpaces + ", billingManagedOrganizations=" + this.billingManagedOrganizations + ", managedOrganizations=" + this.managedOrganizations + ", managedSpaces=" + this.managedSpaces + ", organizations=" + this.organizations + ", spaces=" + this.spaces + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UserSummaryEntity fromJson(Json json) {
        Builder builder = UserSummaryEntity.builder();
        if (json.auditedOrganizations != null) {
            builder.addAllAuditedOrganizations(json.auditedOrganizations);
        }
        if (json.auditedSpaces != null) {
            builder.addAllAuditedSpaces(json.auditedSpaces);
        }
        if (json.billingManagedOrganizations != null) {
            builder.addAllBillingManagedOrganizations(json.billingManagedOrganizations);
        }
        if (json.managedOrganizations != null) {
            builder.addAllManagedOrganizations(json.managedOrganizations);
        }
        if (json.managedSpaces != null) {
            builder.addAllManagedSpaces(json.managedSpaces);
        }
        if (json.organizations != null) {
            builder.addAllOrganizations(json.organizations);
        }
        if (json.spaces != null) {
            builder.addAllSpaces(json.spaces);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<UserOrganizationResource> auditedOrganizations = null;
        private List<UserSpaceResource> auditedSpaces = null;
        private List<UserOrganizationResource> billingManagedOrganizations = null;
        private List<UserOrganizationResource> managedOrganizations = null;
        private List<UserSpaceResource> managedSpaces = null;
        private List<UserOrganizationResource> organizations = null;
        private List<UserSpaceResource> spaces = null;

        private Builder() {
        }

        public final Builder from(UserSummaryEntity instance) {
            return this.from((_UserSummaryEntity)instance);
        }

        final Builder from(_UserSummaryEntity instance) {
            List<UserSpaceResource> spacesValue;
            List<UserOrganizationResource> organizationsValue;
            List<UserSpaceResource> managedSpacesValue;
            List<UserOrganizationResource> managedOrganizationsValue;
            List<UserOrganizationResource> billingManagedOrganizationsValue;
            List<UserSpaceResource> auditedSpacesValue;
            Objects.requireNonNull(instance, "instance");
            List<UserOrganizationResource> auditedOrganizationsValue = instance.getAuditedOrganizations();
            if (auditedOrganizationsValue != null) {
                this.addAllAuditedOrganizations(auditedOrganizationsValue);
            }
            if ((auditedSpacesValue = instance.getAuditedSpaces()) != null) {
                this.addAllAuditedSpaces(auditedSpacesValue);
            }
            if ((billingManagedOrganizationsValue = instance.getBillingManagedOrganizations()) != null) {
                this.addAllBillingManagedOrganizations(billingManagedOrganizationsValue);
            }
            if ((managedOrganizationsValue = instance.getManagedOrganizations()) != null) {
                this.addAllManagedOrganizations(managedOrganizationsValue);
            }
            if ((managedSpacesValue = instance.getManagedSpaces()) != null) {
                this.addAllManagedSpaces(managedSpacesValue);
            }
            if ((organizationsValue = instance.getOrganizations()) != null) {
                this.addAllOrganizations(organizationsValue);
            }
            if ((spacesValue = instance.getSpaces()) != null) {
                this.addAllSpaces(spacesValue);
            }
            return this;
        }

        public final Builder auditedOrganization(UserOrganizationResource element) {
            if (this.auditedOrganizations == null) {
                this.auditedOrganizations = new ArrayList<UserOrganizationResource>();
            }
            this.auditedOrganizations.add(Objects.requireNonNull(element, "auditedOrganizations element"));
            return this;
        }

        public final Builder auditedOrganization(UserOrganizationResource ... elements) {
            if (this.auditedOrganizations == null) {
                this.auditedOrganizations = new ArrayList<UserOrganizationResource>();
            }
            for (UserOrganizationResource element : elements) {
                this.auditedOrganizations.add(Objects.requireNonNull(element, "auditedOrganizations element"));
            }
            return this;
        }

        @JsonProperty(value="audited_organizations")
        public final Builder auditedOrganizations(@Nullable Iterable<? extends UserOrganizationResource> elements) {
            if (elements == null) {
                this.auditedOrganizations = null;
                return this;
            }
            this.auditedOrganizations = new ArrayList<UserOrganizationResource>();
            return this.addAllAuditedOrganizations(elements);
        }

        public final Builder addAllAuditedOrganizations(Iterable<? extends UserOrganizationResource> elements) {
            Objects.requireNonNull(elements, "auditedOrganizations element");
            if (this.auditedOrganizations == null) {
                this.auditedOrganizations = new ArrayList<UserOrganizationResource>();
            }
            for (UserOrganizationResource userOrganizationResource : elements) {
                this.auditedOrganizations.add(Objects.requireNonNull(userOrganizationResource, "auditedOrganizations element"));
            }
            return this;
        }

        public final Builder auditedSpace(UserSpaceResource element) {
            if (this.auditedSpaces == null) {
                this.auditedSpaces = new ArrayList<UserSpaceResource>();
            }
            this.auditedSpaces.add(Objects.requireNonNull(element, "auditedSpaces element"));
            return this;
        }

        public final Builder auditedSpace(UserSpaceResource ... elements) {
            if (this.auditedSpaces == null) {
                this.auditedSpaces = new ArrayList<UserSpaceResource>();
            }
            for (UserSpaceResource element : elements) {
                this.auditedSpaces.add(Objects.requireNonNull(element, "auditedSpaces element"));
            }
            return this;
        }

        @JsonProperty(value="audited_spaces")
        public final Builder auditedSpaces(@Nullable Iterable<? extends UserSpaceResource> elements) {
            if (elements == null) {
                this.auditedSpaces = null;
                return this;
            }
            this.auditedSpaces = new ArrayList<UserSpaceResource>();
            return this.addAllAuditedSpaces(elements);
        }

        public final Builder addAllAuditedSpaces(Iterable<? extends UserSpaceResource> elements) {
            Objects.requireNonNull(elements, "auditedSpaces element");
            if (this.auditedSpaces == null) {
                this.auditedSpaces = new ArrayList<UserSpaceResource>();
            }
            for (UserSpaceResource userSpaceResource : elements) {
                this.auditedSpaces.add(Objects.requireNonNull(userSpaceResource, "auditedSpaces element"));
            }
            return this;
        }

        public final Builder billingManagedOrganization(UserOrganizationResource element) {
            if (this.billingManagedOrganizations == null) {
                this.billingManagedOrganizations = new ArrayList<UserOrganizationResource>();
            }
            this.billingManagedOrganizations.add(Objects.requireNonNull(element, "billingManagedOrganizations element"));
            return this;
        }

        public final Builder billingManagedOrganization(UserOrganizationResource ... elements) {
            if (this.billingManagedOrganizations == null) {
                this.billingManagedOrganizations = new ArrayList<UserOrganizationResource>();
            }
            for (UserOrganizationResource element : elements) {
                this.billingManagedOrganizations.add(Objects.requireNonNull(element, "billingManagedOrganizations element"));
            }
            return this;
        }

        @JsonProperty(value="billing_managed_organizations")
        public final Builder billingManagedOrganizations(@Nullable Iterable<? extends UserOrganizationResource> elements) {
            if (elements == null) {
                this.billingManagedOrganizations = null;
                return this;
            }
            this.billingManagedOrganizations = new ArrayList<UserOrganizationResource>();
            return this.addAllBillingManagedOrganizations(elements);
        }

        public final Builder addAllBillingManagedOrganizations(Iterable<? extends UserOrganizationResource> elements) {
            Objects.requireNonNull(elements, "billingManagedOrganizations element");
            if (this.billingManagedOrganizations == null) {
                this.billingManagedOrganizations = new ArrayList<UserOrganizationResource>();
            }
            for (UserOrganizationResource userOrganizationResource : elements) {
                this.billingManagedOrganizations.add(Objects.requireNonNull(userOrganizationResource, "billingManagedOrganizations element"));
            }
            return this;
        }

        public final Builder managedOrganization(UserOrganizationResource element) {
            if (this.managedOrganizations == null) {
                this.managedOrganizations = new ArrayList<UserOrganizationResource>();
            }
            this.managedOrganizations.add(Objects.requireNonNull(element, "managedOrganizations element"));
            return this;
        }

        public final Builder managedOrganization(UserOrganizationResource ... elements) {
            if (this.managedOrganizations == null) {
                this.managedOrganizations = new ArrayList<UserOrganizationResource>();
            }
            for (UserOrganizationResource element : elements) {
                this.managedOrganizations.add(Objects.requireNonNull(element, "managedOrganizations element"));
            }
            return this;
        }

        @JsonProperty(value="managed_organizations")
        public final Builder managedOrganizations(@Nullable Iterable<? extends UserOrganizationResource> elements) {
            if (elements == null) {
                this.managedOrganizations = null;
                return this;
            }
            this.managedOrganizations = new ArrayList<UserOrganizationResource>();
            return this.addAllManagedOrganizations(elements);
        }

        public final Builder addAllManagedOrganizations(Iterable<? extends UserOrganizationResource> elements) {
            Objects.requireNonNull(elements, "managedOrganizations element");
            if (this.managedOrganizations == null) {
                this.managedOrganizations = new ArrayList<UserOrganizationResource>();
            }
            for (UserOrganizationResource userOrganizationResource : elements) {
                this.managedOrganizations.add(Objects.requireNonNull(userOrganizationResource, "managedOrganizations element"));
            }
            return this;
        }

        public final Builder managedSpace(UserSpaceResource element) {
            if (this.managedSpaces == null) {
                this.managedSpaces = new ArrayList<UserSpaceResource>();
            }
            this.managedSpaces.add(Objects.requireNonNull(element, "managedSpaces element"));
            return this;
        }

        public final Builder managedSpace(UserSpaceResource ... elements) {
            if (this.managedSpaces == null) {
                this.managedSpaces = new ArrayList<UserSpaceResource>();
            }
            for (UserSpaceResource element : elements) {
                this.managedSpaces.add(Objects.requireNonNull(element, "managedSpaces element"));
            }
            return this;
        }

        @JsonProperty(value="managed_spaces")
        public final Builder managedSpaces(@Nullable Iterable<? extends UserSpaceResource> elements) {
            if (elements == null) {
                this.managedSpaces = null;
                return this;
            }
            this.managedSpaces = new ArrayList<UserSpaceResource>();
            return this.addAllManagedSpaces(elements);
        }

        public final Builder addAllManagedSpaces(Iterable<? extends UserSpaceResource> elements) {
            Objects.requireNonNull(elements, "managedSpaces element");
            if (this.managedSpaces == null) {
                this.managedSpaces = new ArrayList<UserSpaceResource>();
            }
            for (UserSpaceResource userSpaceResource : elements) {
                this.managedSpaces.add(Objects.requireNonNull(userSpaceResource, "managedSpaces element"));
            }
            return this;
        }

        public final Builder organization(UserOrganizationResource element) {
            if (this.organizations == null) {
                this.organizations = new ArrayList<UserOrganizationResource>();
            }
            this.organizations.add(Objects.requireNonNull(element, "organizations element"));
            return this;
        }

        public final Builder organization(UserOrganizationResource ... elements) {
            if (this.organizations == null) {
                this.organizations = new ArrayList<UserOrganizationResource>();
            }
            for (UserOrganizationResource element : elements) {
                this.organizations.add(Objects.requireNonNull(element, "organizations element"));
            }
            return this;
        }

        @JsonProperty(value="organizations")
        public final Builder organizations(@Nullable Iterable<? extends UserOrganizationResource> elements) {
            if (elements == null) {
                this.organizations = null;
                return this;
            }
            this.organizations = new ArrayList<UserOrganizationResource>();
            return this.addAllOrganizations(elements);
        }

        public final Builder addAllOrganizations(Iterable<? extends UserOrganizationResource> elements) {
            Objects.requireNonNull(elements, "organizations element");
            if (this.organizations == null) {
                this.organizations = new ArrayList<UserOrganizationResource>();
            }
            for (UserOrganizationResource userOrganizationResource : elements) {
                this.organizations.add(Objects.requireNonNull(userOrganizationResource, "organizations element"));
            }
            return this;
        }

        public final Builder space(UserSpaceResource element) {
            if (this.spaces == null) {
                this.spaces = new ArrayList<UserSpaceResource>();
            }
            this.spaces.add(Objects.requireNonNull(element, "spaces element"));
            return this;
        }

        public final Builder space(UserSpaceResource ... elements) {
            if (this.spaces == null) {
                this.spaces = new ArrayList<UserSpaceResource>();
            }
            for (UserSpaceResource element : elements) {
                this.spaces.add(Objects.requireNonNull(element, "spaces element"));
            }
            return this;
        }

        @JsonProperty(value="spaces")
        public final Builder spaces(@Nullable Iterable<? extends UserSpaceResource> elements) {
            if (elements == null) {
                this.spaces = null;
                return this;
            }
            this.spaces = new ArrayList<UserSpaceResource>();
            return this.addAllSpaces(elements);
        }

        public final Builder addAllSpaces(Iterable<? extends UserSpaceResource> elements) {
            Objects.requireNonNull(elements, "spaces element");
            if (this.spaces == null) {
                this.spaces = new ArrayList<UserSpaceResource>();
            }
            for (UserSpaceResource userSpaceResource : elements) {
                this.spaces.add(Objects.requireNonNull(userSpaceResource, "spaces element"));
            }
            return this;
        }

        public UserSummaryEntity build() {
            return new UserSummaryEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _UserSummaryEntity {
        List<UserOrganizationResource> auditedOrganizations = null;
        List<UserSpaceResource> auditedSpaces = null;
        List<UserOrganizationResource> billingManagedOrganizations = null;
        List<UserOrganizationResource> managedOrganizations = null;
        List<UserSpaceResource> managedSpaces = null;
        List<UserOrganizationResource> organizations = null;
        List<UserSpaceResource> spaces = null;

        Json() {
        }

        @JsonProperty(value="audited_organizations")
        public void setAuditedOrganizations(@Nullable List<UserOrganizationResource> auditedOrganizations) {
            this.auditedOrganizations = auditedOrganizations;
        }

        @JsonProperty(value="audited_spaces")
        public void setAuditedSpaces(@Nullable List<UserSpaceResource> auditedSpaces) {
            this.auditedSpaces = auditedSpaces;
        }

        @JsonProperty(value="billing_managed_organizations")
        public void setBillingManagedOrganizations(@Nullable List<UserOrganizationResource> billingManagedOrganizations) {
            this.billingManagedOrganizations = billingManagedOrganizations;
        }

        @JsonProperty(value="managed_organizations")
        public void setManagedOrganizations(@Nullable List<UserOrganizationResource> managedOrganizations) {
            this.managedOrganizations = managedOrganizations;
        }

        @JsonProperty(value="managed_spaces")
        public void setManagedSpaces(@Nullable List<UserSpaceResource> managedSpaces) {
            this.managedSpaces = managedSpaces;
        }

        @JsonProperty(value="organizations")
        public void setOrganizations(@Nullable List<UserOrganizationResource> organizations) {
            this.organizations = organizations;
        }

        @JsonProperty(value="spaces")
        public void setSpaces(@Nullable List<UserSpaceResource> spaces) {
            this.spaces = spaces;
        }

        @Override
        public List<UserOrganizationResource> getAuditedOrganizations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserSpaceResource> getAuditedSpaces() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserOrganizationResource> getBillingManagedOrganizations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserOrganizationResource> getManagedOrganizations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserSpaceResource> getManagedSpaces() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserOrganizationResource> getOrganizations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserSpaceResource> getSpaces() {
            throw new UnsupportedOperationException();
        }
    }
}

