/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spacequotadefinitions;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.spacequotadefinitions._UpdateSpaceQuotaDefinitionRequest;

public final class UpdateSpaceQuotaDefinitionRequest
extends _UpdateSpaceQuotaDefinitionRequest {
    @Nullable
    private final Integer applicationInstanceLimit;
    @Nullable
    private final Integer applicationTaskLimit;
    @Nullable
    private final Integer instanceMemoryLimit;
    @Nullable
    private final Integer memoryLimit;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean nonBasicServicesAllowed;
    @Nullable
    private final String organizationId;
    private final String spaceQuotaDefinitionId;
    @Nullable
    private final Integer totalReservedRoutePorts;
    @Nullable
    private final Integer totalRoutes;
    @Nullable
    private final Integer totalServiceKeys;
    @Nullable
    private final Integer totalServices;

    private UpdateSpaceQuotaDefinitionRequest(Builder builder) {
        this.applicationInstanceLimit = builder.applicationInstanceLimit;
        this.applicationTaskLimit = builder.applicationTaskLimit;
        this.instanceMemoryLimit = builder.instanceMemoryLimit;
        this.memoryLimit = builder.memoryLimit;
        this.name = builder.name;
        this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
        this.organizationId = builder.organizationId;
        this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
        this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
        this.totalRoutes = builder.totalRoutes;
        this.totalServiceKeys = builder.totalServiceKeys;
        this.totalServices = builder.totalServices;
    }

    @Override
    @Nullable
    public Integer getApplicationInstanceLimit() {
        return this.applicationInstanceLimit;
    }

    @Override
    @Nullable
    public Integer getApplicationTaskLimit() {
        return this.applicationTaskLimit;
    }

    @Override
    @Nullable
    public Integer getInstanceMemoryLimit() {
        return this.instanceMemoryLimit;
    }

    @Override
    @Nullable
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean getNonBasicServicesAllowed() {
        return this.nonBasicServicesAllowed;
    }

    @Override
    @Nullable
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public String getSpaceQuotaDefinitionId() {
        return this.spaceQuotaDefinitionId;
    }

    @Override
    @Nullable
    public Integer getTotalReservedRoutePorts() {
        return this.totalReservedRoutePorts;
    }

    @Override
    @Nullable
    public Integer getTotalRoutes() {
        return this.totalRoutes;
    }

    @Override
    @Nullable
    public Integer getTotalServiceKeys() {
        return this.totalServiceKeys;
    }

    @Override
    @Nullable
    public Integer getTotalServices() {
        return this.totalServices;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateSpaceQuotaDefinitionRequest && this.equalTo((UpdateSpaceQuotaDefinitionRequest)another);
    }

    private boolean equalTo(UpdateSpaceQuotaDefinitionRequest another) {
        return Objects.equals(this.applicationInstanceLimit, another.applicationInstanceLimit) && Objects.equals(this.applicationTaskLimit, another.applicationTaskLimit) && Objects.equals(this.instanceMemoryLimit, another.instanceMemoryLimit) && Objects.equals(this.memoryLimit, another.memoryLimit) && Objects.equals(this.name, another.name) && Objects.equals(this.nonBasicServicesAllowed, another.nonBasicServicesAllowed) && Objects.equals(this.organizationId, another.organizationId) && this.spaceQuotaDefinitionId.equals(another.spaceQuotaDefinitionId) && Objects.equals(this.totalReservedRoutePorts, another.totalReservedRoutePorts) && Objects.equals(this.totalRoutes, another.totalRoutes) && Objects.equals(this.totalServiceKeys, another.totalServiceKeys) && Objects.equals(this.totalServices, another.totalServices);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationInstanceLimit);
        h += (h << 5) + Objects.hashCode(this.applicationTaskLimit);
        h += (h << 5) + Objects.hashCode(this.instanceMemoryLimit);
        h += (h << 5) + Objects.hashCode(this.memoryLimit);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.nonBasicServicesAllowed);
        h += (h << 5) + Objects.hashCode(this.organizationId);
        h += (h << 5) + this.spaceQuotaDefinitionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.totalReservedRoutePorts);
        h += (h << 5) + Objects.hashCode(this.totalRoutes);
        h += (h << 5) + Objects.hashCode(this.totalServiceKeys);
        h += (h << 5) + Objects.hashCode(this.totalServices);
        return h;
    }

    public String toString() {
        return "UpdateSpaceQuotaDefinitionRequest{applicationInstanceLimit=" + this.applicationInstanceLimit + ", applicationTaskLimit=" + this.applicationTaskLimit + ", instanceMemoryLimit=" + this.instanceMemoryLimit + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", nonBasicServicesAllowed=" + this.nonBasicServicesAllowed + ", organizationId=" + this.organizationId + ", spaceQuotaDefinitionId=" + this.spaceQuotaDefinitionId + ", totalReservedRoutePorts=" + this.totalReservedRoutePorts + ", totalRoutes=" + this.totalRoutes + ", totalServiceKeys=" + this.totalServiceKeys + ", totalServices=" + this.totalServices + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SPACE_QUOTA_DEFINITION_ID = 1L;
        private long initBits = 1L;
        private Integer applicationInstanceLimit;
        private Integer applicationTaskLimit;
        private Integer instanceMemoryLimit;
        private Integer memoryLimit;
        private String name;
        private Boolean nonBasicServicesAllowed;
        private String organizationId;
        private String spaceQuotaDefinitionId;
        private Integer totalReservedRoutePorts;
        private Integer totalRoutes;
        private Integer totalServiceKeys;
        private Integer totalServices;

        private Builder() {
        }

        public final Builder from(UpdateSpaceQuotaDefinitionRequest instance) {
            return this.from((_UpdateSpaceQuotaDefinitionRequest)instance);
        }

        final Builder from(_UpdateSpaceQuotaDefinitionRequest instance) {
            Integer totalServicesValue;
            Integer totalServiceKeysValue;
            Integer totalRoutesValue;
            String organizationIdValue;
            Boolean nonBasicServicesAllowedValue;
            String nameValue;
            Integer memoryLimitValue;
            Integer instanceMemoryLimitValue;
            Integer applicationTaskLimitValue;
            Objects.requireNonNull(instance, "instance");
            Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
            if (applicationInstanceLimitValue != null) {
                this.applicationInstanceLimit(applicationInstanceLimitValue);
            }
            if ((applicationTaskLimitValue = instance.getApplicationTaskLimit()) != null) {
                this.applicationTaskLimit(applicationTaskLimitValue);
            }
            if ((instanceMemoryLimitValue = instance.getInstanceMemoryLimit()) != null) {
                this.instanceMemoryLimit(instanceMemoryLimitValue);
            }
            if ((memoryLimitValue = instance.getMemoryLimit()) != null) {
                this.memoryLimit(memoryLimitValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((nonBasicServicesAllowedValue = instance.getNonBasicServicesAllowed()) != null) {
                this.nonBasicServicesAllowed(nonBasicServicesAllowedValue);
            }
            if ((organizationIdValue = instance.getOrganizationId()) != null) {
                this.organizationId(organizationIdValue);
            }
            this.spaceQuotaDefinitionId(instance.getSpaceQuotaDefinitionId());
            Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
            if (totalReservedRoutePortsValue != null) {
                this.totalReservedRoutePorts(totalReservedRoutePortsValue);
            }
            if ((totalRoutesValue = instance.getTotalRoutes()) != null) {
                this.totalRoutes(totalRoutesValue);
            }
            if ((totalServiceKeysValue = instance.getTotalServiceKeys()) != null) {
                this.totalServiceKeys(totalServiceKeysValue);
            }
            if ((totalServicesValue = instance.getTotalServices()) != null) {
                this.totalServices(totalServicesValue);
            }
            return this;
        }

        public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
            this.applicationInstanceLimit = applicationInstanceLimit;
            return this;
        }

        public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
            this.applicationTaskLimit = applicationTaskLimit;
            return this;
        }

        public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
            this.instanceMemoryLimit = instanceMemoryLimit;
            return this;
        }

        public final Builder memoryLimit(@Nullable Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder nonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
            this.nonBasicServicesAllowed = nonBasicServicesAllowed;
            return this;
        }

        public final Builder organizationId(@Nullable String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final Builder spaceQuotaDefinitionId(String spaceQuotaDefinitionId) {
            this.spaceQuotaDefinitionId = Objects.requireNonNull(spaceQuotaDefinitionId, "spaceQuotaDefinitionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
            this.totalReservedRoutePorts = totalReservedRoutePorts;
            return this;
        }

        public final Builder totalRoutes(@Nullable Integer totalRoutes) {
            this.totalRoutes = totalRoutes;
            return this;
        }

        public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
            this.totalServiceKeys = totalServiceKeys;
            return this;
        }

        public final Builder totalServices(@Nullable Integer totalServices) {
            this.totalServices = totalServices;
            return this;
        }

        public UpdateSpaceQuotaDefinitionRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateSpaceQuotaDefinitionRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spaceQuotaDefinitionId");
            }
            return "Cannot build UpdateSpaceQuotaDefinitionRequest, some of required attributes are not set " + attributes;
        }
    }
}

