/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.shareddomains;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.shareddomains._DeleteSharedDomainRequest;

public final class DeleteSharedDomainRequest
extends _DeleteSharedDomainRequest {
    @Nullable
    private final Boolean async;
    private final String sharedDomainId;

    private DeleteSharedDomainRequest(Builder builder) {
        this.async = builder.async;
        this.sharedDomainId = builder.sharedDomainId;
    }

    @Override
    @Nullable
    public Boolean getAsync() {
        return this.async;
    }

    @Override
    public String getSharedDomainId() {
        return this.sharedDomainId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteSharedDomainRequest && this.equalTo((DeleteSharedDomainRequest)another);
    }

    private boolean equalTo(DeleteSharedDomainRequest another) {
        return Objects.equals(this.async, another.async) && this.sharedDomainId.equals(another.sharedDomainId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.async);
        h += (h << 5) + this.sharedDomainId.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteSharedDomainRequest{async=" + this.async + ", sharedDomainId=" + this.sharedDomainId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SHARED_DOMAIN_ID = 1L;
        private long initBits = 1L;
        private Boolean async;
        private String sharedDomainId;

        private Builder() {
        }

        public final Builder from(DeleteSharedDomainRequest instance) {
            return this.from((_DeleteSharedDomainRequest)instance);
        }

        final Builder from(_DeleteSharedDomainRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Boolean asyncValue = instance.getAsync();
            if (asyncValue != null) {
                this.async(asyncValue);
            }
            this.sharedDomainId(instance.getSharedDomainId());
            return this;
        }

        public final Builder async(@Nullable Boolean async) {
            this.async = async;
            return this;
        }

        public final Builder sharedDomainId(String sharedDomainId) {
            this.sharedDomainId = Objects.requireNonNull(sharedDomainId, "sharedDomainId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public DeleteSharedDomainRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteSharedDomainRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sharedDomainId");
            }
            return "Cannot build DeleteSharedDomainRequest, some of required attributes are not set " + attributes;
        }
    }
}

