/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.environmentvariablegroups;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.environmentvariablegroups._UpdateStagingEnvironmentVariablesRequest;

public final class UpdateStagingEnvironmentVariablesRequest
extends _UpdateStagingEnvironmentVariablesRequest {
    @Nullable
    private final Map<String, Object> environmentVariables;

    private UpdateStagingEnvironmentVariablesRequest(Builder builder) {
        this.environmentVariables = builder.environmentVariables == null ? null : UpdateStagingEnvironmentVariablesRequest.createUnmodifiableMap(false, false, builder.environmentVariables);
    }

    @Override
    @Nullable
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateStagingEnvironmentVariablesRequest && this.equalTo((UpdateStagingEnvironmentVariablesRequest)another);
    }

    private boolean equalTo(UpdateStagingEnvironmentVariablesRequest another) {
        return Objects.equals(this.environmentVariables, another.environmentVariables);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.environmentVariables);
        return h;
    }

    public String toString() {
        return "UpdateStagingEnvironmentVariablesRequest{environmentVariables=" + this.environmentVariables + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Map<String, Object> environmentVariables = null;

        private Builder() {
        }

        public final Builder from(UpdateStagingEnvironmentVariablesRequest instance) {
            return this.from((_UpdateStagingEnvironmentVariablesRequest)instance);
        }

        final Builder from(_UpdateStagingEnvironmentVariablesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
            if (environmentVariablesValue != null) {
                this.putAllEnvironmentVariables(environmentVariablesValue);
            }
            return this;
        }

        public final Builder environmentVariable(String key, Object value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            this.environmentVariables.put(key, value);
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentVariables.put(k, v);
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends Object> environmentVariables) {
            if (environmentVariables == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, Object>();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.environmentVariables.put(k, v);
            }
            return this;
        }

        public UpdateStagingEnvironmentVariablesRequest build() {
            return new UpdateStagingEnvironmentVariablesRequest(this);
        }
    }
}

