/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.PassesValueOf;
import org.simpleframework.xml.Root;

@Root(name="passes-value-of")
public class PassesValueOfConstraint
extends Constraint {
    private Class<?> clazz;

    PassesValueOfConstraint() {
    }

    @Override
    protected boolean isMet(Object value) {
        if (value != null && value instanceof String) {
            String valueOfClassSimple = value.getClass().getSimpleName();
            String valueOfName = "valueOf(" + valueOfClassSimple + ")";
            try {
                Method m = this.clazz.getMethod("valueOf", value.getClass());
                if (!Modifier.isStatic(m.getModifiers())) {
                    throw new NoSuchMethodError(valueOfName + " not static.");
                }
                m.invoke(null, value);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No " + valueOfName + " method in class: " + this.clazz);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Illegal access to " + valueOfName + " in class: " + this.clazz);
            }
            catch (InvocationTargetException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void populateCustom(Annotation annotation) {
        this.clazz = ((PassesValueOf)annotation).valueOfClass();
    }
}

