// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_objdetect;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_objdetect.*;


@Namespace("cv") @Properties(inherit = org.bytedeco.opencv.presets.opencv_objdetect.class)
public class QRCodeDetectorAruco extends GraphicalCodeDetector {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public QRCodeDetectorAruco(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public QRCodeDetectorAruco(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public QRCodeDetectorAruco position(long position) {
        return (QRCodeDetectorAruco)super.position(position);
    }
    @Override public QRCodeDetectorAruco getPointer(long i) {
        return new QRCodeDetectorAruco((Pointer)this).offsetAddress(i);
    }

    public QRCodeDetectorAruco() { super((Pointer)null); allocate(); }
    private native void allocate();

    @NoOffset public static class Params extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Params(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Params(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Params position(long position) {
            return (Params)super.position(position);
        }
        @Override public Params getPointer(long i) {
            return new Params((Pointer)this).offsetAddress(i);
        }
    
        public Params() { super((Pointer)null); allocate(); }
        private native void allocate();

        /** \brief The minimum allowed pixel size of a QR module in the smallest image in the image pyramid, default 4.f */
        public native float minModuleSizeInPyramid(); public native Params minModuleSizeInPyramid(float setter);

        /** \brief The maximum allowed relative rotation for finder patterns in the same QR code, default pi/12 */
        public native float maxRotation(); public native Params maxRotation(float setter);

        /** \brief The maximum allowed relative mismatch in module sizes for finder patterns in the same QR code, default 1.75f */
        public native float maxModuleSizeMismatch(); public native Params maxModuleSizeMismatch(float setter);

        /** \brief The maximum allowed module relative mismatch for timing pattern module, default 2.f
         *
         * If relative mismatch of timing pattern module more this value, penalty points will be added.
         * If a lot of penalty points are added, QR code will be rejected. */
        public native float maxTimingPatternMismatch(); public native Params maxTimingPatternMismatch(float setter);

        /** \brief The maximum allowed percentage of penalty points out of total pins in timing pattern, default 0.4f */
        public native float maxPenalties(); public native Params maxPenalties(float setter);

        /** \brief The maximum allowed relative color mismatch in the timing pattern, default 0.2f*/
        public native float maxColorsMismatch(); public native Params maxColorsMismatch(float setter);

        /** \brief The algorithm find QR codes with almost minimum timing pattern score and minimum size, default 0.9f
         *
         * The QR code with the minimum "timing pattern score" and minimum "size" is selected as the best QR code.
         * If for the current QR code "timing pattern score" * scaleTimingPatternScore < "previous timing pattern score" and "size" < "previous size", then
         * current QR code set as the best QR code. */
        public native float scaleTimingPatternScore(); public native Params scaleTimingPatternScore(float setter);
    }

    /** \brief QR code detector constructor for Aruco-based algorithm. See cv::QRCodeDetectorAruco::Params */
    public QRCodeDetectorAruco(@Const @ByRef Params params) { super((Pointer)null); allocate(params); }
    private native void allocate(@Const @ByRef Params params);

    /** \brief Detector parameters getter. See cv::QRCodeDetectorAruco::Params */
    public native @Const @ByRef Params getDetectorParameters();

    /** \brief Detector parameters setter. See cv::QRCodeDetectorAruco::Params */
    public native @ByRef QRCodeDetectorAruco setDetectorParameters(@Const @ByRef Params params);

    /** \brief Aruco detector parameters are used to search for the finder patterns. */
    public native @ByVal DetectorParameters getArucoParameters();

    /** \brief Aruco detector parameters are used to search for the finder patterns. */
    public native void setArucoParameters(@Const @ByRef DetectorParameters params);
}
