/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.reporting.renderer;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.bsc.reporting.renderer.CalculateRuleForSinceTagName;
import org.bsc.reporting.renderer.ParsedVersion;
import org.codehaus.plexus.util.StringUtils;

public class VersionUtil {
    public static String calculateVersionTagNamePart(String version, CalculateRuleForSinceTagName calculateRuleForSinceTagName) {
        if (calculateRuleForSinceTagName.equals((Object)CalculateRuleForSinceTagName.NO_RULE)) {
            return null;
        }
        ArtifactVersion artifactVersion = VersionUtil.parseArtifactVersion(version);
        int major = artifactVersion.getMajorVersion();
        int minor = artifactVersion.getMinorVersion();
        int patch = artifactVersion.getIncrementalVersion();
        switch (calculateRuleForSinceTagName) {
            case CURRENT_MAJOR_VERSION: {
                minor = 0;
                patch = 0;
                break;
            }
            case CURRENT_MINOR_VERSION: {
                patch = 0;
                break;
            }
            case LATEST_RELEASE_VERSION: {
                patch = patch == 0 ? 0 : patch - 1;
                break;
            }
            default: {
                throw new RuntimeException("cannot parse " + calculateRuleForSinceTagName);
            }
        }
        return major + "." + minor + "." + patch;
    }

    protected static ArtifactVersion parseArtifactVersion(String version) {
        version = version.replaceAll("\\s", "");
        version = VersionUtil.removeNonDigitPrefix(version);
        version = VersionUtil.addSuffixDelimeterIfNeeded(version);
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
        if (ArtifactUtils.isSnapshot((String)version)) {
            artifactVersion = new DefaultArtifactVersion(StringUtils.substring((String)version, (int)0, (int)(version.length() - "SNAPSHOT".length() - 1)));
        }
        return artifactVersion;
    }

    protected static String addSuffixDelimeterIfNeeded(String version) {
        String endVer;
        int i;
        if (version.contains("-")) {
            return version;
        }
        for (i = 0; i < version.length() && (Character.isDigit(version.charAt(i)) || version.charAt(i) == '.'); ++i) {
        }
        if (i > 0 && !(endVer = version.substring(i)).isEmpty()) {
            return (version.charAt(i - 1) == '.' ? version.substring(0, i - 1) : version.substring(0, i)) + "-" + endVer;
        }
        return version;
    }

    protected static String removeNonDigitPrefix(String version) {
        if (version != null && !version.isEmpty() && !Character.isDigit(version.charAt(0))) {
            Matcher matcher = Pattern.compile("\\d+").matcher(version);
            int i = 0;
            if (matcher.find()) {
                i = matcher.start();
            }
            if (i > 0) {
                version = StringUtils.substring((String)version, (int)i, (int)version.length());
            }
        }
        return version;
    }

    public static Collection<String> filterTagNamesByTagNamePart(Collection<String> tagNames, String versionTagNamePart) {
        return tagNames.stream().filter(tagName -> tagName.contains(versionTagNamePart)).collect(Collectors.toList());
    }

    public static Optional<String> findNearestVersionTagsBefore(Collection<String> versionTagList, String versionTagNamePart) {
        ParsedVersion currentVersion = new ParsedVersion(versionTagNamePart);
        Predicate<ParsedVersion> compare = v -> v.string.startsWith(currentVersion.string) || currentVersion.compareTo((ParsedVersion)v) >= 0;
        return versionTagList.stream().map(ParsedVersion::new).sorted(Comparator.reverseOrder()).filter(compare).findFirst().map(v -> v.string);
    }

    public static Collection<String> removeTagWithVersion(Collection<String> versionTagList, String versionTagNamePart) {
        Map map = versionTagList.stream().collect(Collectors.toMap(VersionUtil::parseArtifactVersion, Function.identity()));
        ArtifactVersion currentVersion = VersionUtil.parseArtifactVersion(versionTagNamePart);
        map.remove(currentVersion);
        return map.values();
    }

    public static LinkedList<String> sortAndFilter(Collection<String> versionNameList, String start, String end) {
        ArtifactVersion endVersion;
        ArtifactVersion startVersion = VersionUtil.parseArtifactVersion(start);
        ArtifactVersion artifactVersion2 = endVersion = end != null && !end.isEmpty() ? VersionUtil.parseArtifactVersion(end) : null;
        if (endVersion != null && startVersion.compareTo((Object)endVersion) > 0) {
            throw new IllegalArgumentException(String.format("startVersion %s must be less or equals to endVersion %s", startVersion, endVersion));
        }
        Map map = versionNameList.stream().collect(Collectors.toMap(VersionUtil::parseArtifactVersion, Function.identity()));
        return map.keySet().stream().filter(current -> endVersion != null ? startVersion.compareTo(current) <= 0 && endVersion.compareTo(current) >= 0 : startVersion.compareTo(current) <= 0).sorted().map(artifactVersion -> (String)map.get(artifactVersion)).collect(Collectors.toCollection(() -> new LinkedList()));
    }
}

