/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsCryptoParameters cryptoParams;
    protected TlsStreamCipherImpl encryptCipher;
    protected TlsStreamCipherImpl decryptCipher;
    protected TlsSuiteMac writeMac;
    protected TlsSuiteMac readMac;
    protected boolean usesNonce;

    public TlsStreamCipher(TlsCryptoParameters tlsCryptoParameters, TlsStreamCipherImpl tlsStreamCipherImpl, TlsStreamCipherImpl tlsStreamCipherImpl2, TlsHMAC tlsHMAC, TlsHMAC tlsHMAC2, int n, boolean bl) throws IOException {
        byte[] byArray;
        byte[] byArray2;
        boolean bl2 = tlsCryptoParameters.isServer();
        this.cryptoParams = tlsCryptoParameters;
        this.usesNonce = bl;
        this.encryptCipher = tlsStreamCipherImpl;
        this.decryptCipher = tlsStreamCipherImpl2;
        int n2 = 2 * n + tlsHMAC.getMacLength() + tlsHMAC2.getMacLength();
        byte[] byArray3 = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n2);
        int n3 = 0;
        TlsSuiteHMac tlsSuiteHMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
        tlsSuiteHMac.setKey(Arrays.copyOfRange((byte[])byArray3, (int)n3, (int)(n3 + tlsHMAC.getMacLength())));
        TlsSuiteHMac tlsSuiteHMac2 = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
        tlsSuiteHMac2.setKey(Arrays.copyOfRange((byte[])byArray3, (int)(n3 += tlsHMAC.getMacLength()), (int)(n3 + tlsHMAC2.getMacLength())));
        byte[] byArray4 = Arrays.copyOfRange((byte[])byArray3, (int)(n3 += tlsHMAC2.getMacLength()), (int)(n3 + n));
        byte[] byArray5 = Arrays.copyOfRange((byte[])byArray3, (int)(n3 += n), (int)(n3 + n));
        if ((n3 += n) != n2) {
            throw new TlsFatalAlert(80);
        }
        if (bl2) {
            this.writeMac = tlsSuiteHMac2;
            this.readMac = tlsSuiteHMac;
            byArray2 = byArray5;
            byArray = byArray4;
        } else {
            this.writeMac = tlsSuiteHMac;
            this.readMac = tlsSuiteHMac2;
            byArray2 = byArray4;
            byArray = byArray5;
        }
        this.encryptCipher.setKey(byArray2);
        this.decryptCipher.setKey(byArray);
        if (bl) {
            byte[] byArray6 = new byte[8];
            this.encryptCipher.init(byArray6);
            this.decryptCipher.init(byArray6);
        } else {
            this.encryptCipher.init(null);
            this.decryptCipher.init(null);
        }
    }

    public int getPlaintextLimit(int n) {
        return n - this.writeMac.getSize();
    }

    public byte[] encodePlaintext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        if (this.usesNonce) {
            this.updateIV(this.encryptCipher, true, l);
        }
        byte[] byArray2 = new byte[n2 + this.writeMac.getSize()];
        byte[] byArray3 = this.writeMac.calculateMac(l, s, byArray, n, n2);
        System.arraycopy(byArray, n, byArray2, 0, n2);
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        this.encryptCipher.doFinal(byArray2, 0, byArray2.length, byArray2, 0);
        return byArray2;
    }

    public byte[] decodeCiphertext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.usesNonce) {
            this.updateIV(this.decryptCipher, false, l);
        }
        if (n2 < (n3 = this.readMac.getSize())) {
            throw new TlsFatalAlert(50);
        }
        int n4 = n2 - n3;
        byte[] byArray2 = new byte[n2];
        this.decryptCipher.doFinal(byArray, n, n2, byArray2, 0);
        this.checkMAC(l, s, byArray2, n4, n2, byArray2, 0, n4);
        return Arrays.copyOfRange((byte[])byArray2, (int)0, (int)n4);
    }

    protected void checkMAC(long l, short s, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws IOException {
        byte[] byArray3;
        byte[] byArray4 = Arrays.copyOfRange((byte[])byArray, (int)n, (int)n2);
        if (!Arrays.constantTimeAreEqual((byte[])byArray4, (byte[])(byArray3 = this.readMac.calculateMac(l, s, byArray2, n3, n4)))) {
            throw new TlsFatalAlert(20);
        }
    }

    protected void updateIV(TlsStreamCipherImpl tlsStreamCipherImpl, boolean bl, long l) throws IOException {
        byte[] byArray = new byte[8];
        TlsUtils.writeUint64(l, byArray, 0);
        tlsStreamCipherImpl.init(byArray);
    }
}

